<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class MasterprogressController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/masterprogresslist[/{ID}]", [PermissionMiddleware::class], "list.masterprogress")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprogressList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/masterprogressadd[/{ID}]", [PermissionMiddleware::class], "add.masterprogress")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprogressAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/masterprogressaddopt", [PermissionMiddleware::class], "addopt.masterprogress")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprogressAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/masterprogressview[/{ID}]", [PermissionMiddleware::class], "view.masterprogress")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprogressView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/masterprogressedit[/{ID}]", [PermissionMiddleware::class], "edit.masterprogress")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprogressEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/masterprogressupdate", [PermissionMiddleware::class], "update.masterprogress")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprogressUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/masterprogressdelete[/{ID}]", [PermissionMiddleware::class], "delete.masterprogress")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprogressDelete");
    }
}
