<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

/**
 * PerformanceReport controller
 */
class PerformanceReportController extends ControllerBase
{
    // summary
    #[Map(["GET", "POST", "OPTIONS"], "/performancereport", [PermissionMiddleware::class], "summary.PerformanceReport")]
    public function summary(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PerformanceReportSummary");
    }

    // PerformanceReport (chart)
    #[Map(["GET", "POST", "OPTIONS"], "/performancereport/PerformanceReport", [PermissionMiddleware::class], "summary.PerformanceReport.PerformanceReport")]
    public function PerformanceReport(Request $request, Response $response, array $args): Response
    {
        return $this->runChart($request, $response, $args, "PerformanceReportSummary", "PerformanceReport");
    }

    // TotalTask (chart)
    #[Map(["GET", "POST", "OPTIONS"], "/performancereport/TotalTask", [PermissionMiddleware::class], "summary.PerformanceReport.TotalTask")]
    public function TotalTask(Request $request, Response $response, array $args): Response
    {
        return $this->runChart($request, $response, $args, "PerformanceReportSummary", "TotalTask");
    }
}
