<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ProjecttaskController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/projecttasklist[/{TaskID}]", [PermissionMiddleware::class], "list.projecttask")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttaskList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/projecttaskadd[/{TaskID}]", [PermissionMiddleware::class], "add.projecttask")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttaskAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/projecttaskview[/{TaskID}]", [PermissionMiddleware::class], "view.projecttask")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttaskView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/projecttaskedit[/{TaskID}]", [PermissionMiddleware::class], "edit.projecttask")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttaskEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/projecttaskupdate", [PermissionMiddleware::class], "update.projecttask")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttaskUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/projecttaskdelete[/{TaskID}]", [PermissionMiddleware::class], "delete.projecttask")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttaskDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/projecttasksearch", [PermissionMiddleware::class], "search.projecttask")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttaskSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/projecttaskquery", [PermissionMiddleware::class], "query.projecttask")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttaskSearch", "ProjecttaskQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/projecttaskpreview", [PermissionMiddleware::class], "preview.projecttask")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttaskPreview", null, false);
    }
}
