<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ProjecttemplatepaymentprocessController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatepaymentprocesslist[/{PaymentProcessID}]", [PermissionMiddleware::class], "list.projecttemplatepaymentprocess")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplatepaymentprocessList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatepaymentprocessadd[/{PaymentProcessID}]", [PermissionMiddleware::class], "add.projecttemplatepaymentprocess")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplatepaymentprocessAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatepaymentprocessview[/{PaymentProcessID}]", [PermissionMiddleware::class], "view.projecttemplatepaymentprocess")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplatepaymentprocessView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatepaymentprocessedit[/{PaymentProcessID}]", [PermissionMiddleware::class], "edit.projecttemplatepaymentprocess")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplatepaymentprocessEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatepaymentprocessupdate", [PermissionMiddleware::class], "update.projecttemplatepaymentprocess")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplatepaymentprocessUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatepaymentprocessdelete[/{PaymentProcessID}]", [PermissionMiddleware::class], "delete.projecttemplatepaymentprocess")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplatepaymentprocessDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatepaymentprocesssearch", [PermissionMiddleware::class], "search.projecttemplatepaymentprocess")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplatepaymentprocessSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatepaymentprocessquery", [PermissionMiddleware::class], "query.projecttemplatepaymentprocess")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplatepaymentprocessSearch", "ProjecttemplatepaymentprocessQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/projecttemplatepaymentprocesspreview", [PermissionMiddleware::class], "preview.projecttemplatepaymentprocess")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplatepaymentprocessPreview", null, false);
    }
}
