<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ProjecttemplateresultController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateresultlist[/{ResultID}]", [PermissionMiddleware::class], "list.projecttemplateresult")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateresultList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateresultadd[/{ResultID}]", [PermissionMiddleware::class], "add.projecttemplateresult")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateresultAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateresultview[/{ResultID}]", [PermissionMiddleware::class], "view.projecttemplateresult")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateresultView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateresultedit[/{ResultID}]", [PermissionMiddleware::class], "edit.projecttemplateresult")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateresultEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateresultupdate", [PermissionMiddleware::class], "update.projecttemplateresult")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateresultUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateresultdelete[/{ResultID}]", [PermissionMiddleware::class], "delete.projecttemplateresult")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateresultDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateresultsearch", [PermissionMiddleware::class], "search.projecttemplateresult")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateresultSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateresultquery", [PermissionMiddleware::class], "query.projecttemplateresult")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateresultSearch", "ProjecttemplateresultQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/projecttemplateresultpreview", [PermissionMiddleware::class], "preview.projecttemplateresult")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateresultPreview", null, false);
    }
}
