<?php

namespace ProjectManagement\prjProjectManagement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for masterproject
 */
class Masterproject extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $_ProjectID;
    public $ProjectName;
    public $PlanStart;
    public $PlanEnd;
    public $StartDate;
    public $EndDate;
    public $WarrantyEnd;
    public $Status;
    public $Progress;
    public $Target;
    public $Track;
    public $PaymentProgress;
    public $PaymentDate;
    public $PaymentComplete;
    public $AgingPayment;
    public $ClientID;
    public $ManagerID;
    public $ProjectTemplateID;
    public $Priority;
    public $Description;
    public $ProjectValue;
    public $ProjectDebt;
    public $PONumber;
    public $PaymentLink;
    public $ClearingDate;
    public $ClearingAging;
    public $Active;
    public $Created_Date;
    public $Created_By;
    public $Last_Updated_Date;
    public $Last_Updated_By;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "masterproject";
        $this->TableName = 'masterproject';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "masterproject";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = true; // Allow detail view
        $this->ShowMultipleDetails = true; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // ProjectID
        $this->_ProjectID = new DbField(
            $this, // Table
            'x__ProjectID', // Variable name
            'ProjectID', // Name
            '`ProjectID`', // Expression
            '`ProjectID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProjectID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->_ProjectID->InputTextType = "text";
        $this->_ProjectID->Raw = true;
        $this->_ProjectID->IsAutoIncrement = true; // Autoincrement field
        $this->_ProjectID->IsPrimaryKey = true; // Primary key field
        $this->_ProjectID->IsForeignKey = true; // Foreign key field
        $this->_ProjectID->Nullable = false; // NOT NULL field
        $this->_ProjectID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_ProjectID->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ProjectID'] = &$this->_ProjectID;

        // ProjectName
        $this->ProjectName = new DbField(
            $this, // Table
            'x_ProjectName', // Variable name
            'ProjectName', // Name
            '`ProjectName`', // Expression
            '`ProjectName`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProjectName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ProjectName->InputTextType = "text";
        $this->ProjectName->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->ProjectName->Lookup = new Lookup($this->ProjectName, 'masterproject', true, 'ProjectName', ["ProjectName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->ProjectName->Lookup = new Lookup($this->ProjectName, 'masterproject', true, 'ProjectName', ["ProjectName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->ProjectName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ProjectName'] = &$this->ProjectName;

        // PlanStart
        $this->PlanStart = new DbField(
            $this, // Table
            'x_PlanStart', // Variable name
            'PlanStart', // Name
            '`PlanStart`', // Expression
            CastDateFieldForLike("`PlanStart`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`PlanStart`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PlanStart->addMethod("getDefault", fn() => CurrentDate());
        $this->PlanStart->InputTextType = "text";
        $this->PlanStart->Raw = true;
        $this->PlanStart->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->PlanStart->Lookup = new Lookup($this->PlanStart, 'masterproject', true, 'PlanStart', ["PlanStart","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->PlanStart->Lookup = new Lookup($this->PlanStart, 'masterproject', true, 'PlanStart', ["PlanStart","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->PlanStart->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->PlanStart->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PlanStart'] = &$this->PlanStart;

        // PlanEnd
        $this->PlanEnd = new DbField(
            $this, // Table
            'x_PlanEnd', // Variable name
            'PlanEnd', // Name
            '`PlanEnd`', // Expression
            CastDateFieldForLike("`PlanEnd`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`PlanEnd`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PlanEnd->InputTextType = "text";
        $this->PlanEnd->Raw = true;
        $this->PlanEnd->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->PlanEnd->Lookup = new Lookup($this->PlanEnd, 'masterproject', true, 'PlanEnd', ["PlanEnd","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->PlanEnd->Lookup = new Lookup($this->PlanEnd, 'masterproject', true, 'PlanEnd', ["PlanEnd","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->PlanEnd->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->PlanEnd->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PlanEnd'] = &$this->PlanEnd;

        // StartDate
        $this->StartDate = new DbField(
            $this, // Table
            'x_StartDate', // Variable name
            'StartDate', // Name
            '`StartDate`', // Expression
            CastDateFieldForLike("`StartDate`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`StartDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->StartDate->addMethod("getDefault", fn() => CurrentDate());
        $this->StartDate->InputTextType = "text";
        $this->StartDate->Raw = true;
        $this->StartDate->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->StartDate->Lookup = new Lookup($this->StartDate, 'masterproject', true, 'StartDate', ["StartDate","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->StartDate->Lookup = new Lookup($this->StartDate, 'masterproject', true, 'StartDate', ["StartDate","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->StartDate->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->StartDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['StartDate'] = &$this->StartDate;

        // EndDate
        $this->EndDate = new DbField(
            $this, // Table
            'x_EndDate', // Variable name
            'EndDate', // Name
            '`EndDate`', // Expression
            CastDateFieldForLike("`EndDate`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`EndDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->EndDate->InputTextType = "text";
        $this->EndDate->Raw = true;
        $this->EndDate->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->EndDate->Lookup = new Lookup($this->EndDate, 'masterproject', true, 'EndDate', ["EndDate","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->EndDate->Lookup = new Lookup($this->EndDate, 'masterproject', true, 'EndDate', ["EndDate","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->EndDate->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->EndDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['EndDate'] = &$this->EndDate;

        // WarrantyEnd
        $this->WarrantyEnd = new DbField(
            $this, // Table
            'x_WarrantyEnd', // Variable name
            'WarrantyEnd', // Name
            '`WarrantyEnd`', // Expression
            CastDateFieldForLike("`WarrantyEnd`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`WarrantyEnd`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->WarrantyEnd->InputTextType = "text";
        $this->WarrantyEnd->Raw = true;
        $this->WarrantyEnd->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->WarrantyEnd->Lookup = new Lookup($this->WarrantyEnd, 'masterproject', true, 'WarrantyEnd', ["WarrantyEnd","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->WarrantyEnd->Lookup = new Lookup($this->WarrantyEnd, 'masterproject', true, 'WarrantyEnd', ["WarrantyEnd","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->WarrantyEnd->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->WarrantyEnd->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['WarrantyEnd'] = &$this->WarrantyEnd;

        // Status
        $this->Status = new DbField(
            $this, // Table
            'x_Status', // Variable name
            'Status', // Name
            '`Status`', // Expression
            '`Status`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Status->addMethod("getDefault", fn() => "Not Started");
        $this->Status->InputTextType = "text";
        $this->Status->setSelectMultiple(false); // Select one
        $this->Status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->Status->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Status->Lookup = new Lookup($this->Status, 'masterprogress', true, 'Status', ["Status","","",""], '', '', [], [], [], [], [], [], false, '', '', "`Status`");
                break;
            default:
                $this->Status->Lookup = new Lookup($this->Status, 'masterprogress', true, 'Status', ["Status","","",""], '', '', [], [], [], [], [], [], false, '', '', "`Status`");
                break;
        }
        $this->Status->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Status'] = &$this->Status;

        // Progress
        $this->Progress = new DbField(
            $this, // Table
            'x_Progress', // Variable name
            'Progress', // Name
            '`Progress`', // Expression
            '`Progress`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Progress`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Progress->addMethod("getDefault", fn() => 0);
        $this->Progress->InputTextType = "text";
        $this->Progress->Raw = true;
        $this->Progress->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Progress->Lookup = new Lookup($this->Progress, 'masterproject', true, 'Progress', ["Progress","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Progress->Lookup = new Lookup($this->Progress, 'masterproject', true, 'Progress', ["Progress","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Progress->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Progress->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Progress'] = &$this->Progress;

        // Target
        $this->Target = new DbField(
            $this, // Table
            'x_Target', // Variable name
            'Target', // Name
            'CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END', // Expression
            'CASE
                WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
                ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
            END', // Basic search expression
            5, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            'CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Target->InputTextType = "text";
        $this->Target->Raw = true;
        $this->Target->IsCustom = true; // Custom field
        $this->Target->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Target->Lookup = new Lookup($this->Target, 'masterproject', true, 'Target', ["Target","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Target->Lookup = new Lookup($this->Target, 'masterproject', true, 'Target', ["Target","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Target->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Target->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Target'] = &$this->Target;

        // Track
        $this->Track = new DbField(
            $this, // Table
            'x_Track', // Variable name
            'Track', // Name
            'CASE WHEN Progress<1 AND CURDATE()>PlanEnd THEN \'Late\'
        WHEN Progress<CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE GREATEST(1, DATEDIFF(CURDATE(), PlanStart) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END THEN \'Warning\'
        ELSE \'On Track\'
    END', // Expression
            'CASE WHEN Progress<1 AND CURDATE()>PlanEnd THEN \'Late\'
                    WHEN Progress<CASE
                WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
                ELSE GREATEST(1, DATEDIFF(CURDATE(), PlanStart) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
            END THEN \'Warning\'
                    ELSE \'On Track\'
                END', // Basic search expression
            200, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            'CASE WHEN Progress<1 AND CURDATE()>PlanEnd THEN \'Late\'
        WHEN Progress<CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE GREATEST(1, DATEDIFF(CURDATE(), PlanStart) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END THEN \'Warning\'
        ELSE \'On Track\'
    END', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Track->InputTextType = "text";
        $this->Track->IsCustom = true; // Custom field
        $this->Track->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Track->Lookup = new Lookup($this->Track, 'masterproject', true, 'Track', ["Track","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Track->Lookup = new Lookup($this->Track, 'masterproject', true, 'Track', ["Track","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Track->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Track'] = &$this->Track;

        // PaymentProgress
        $this->PaymentProgress = new DbField(
            $this, // Table
            'x_PaymentProgress', // Variable name
            'PaymentProgress', // Name
            '`PaymentProgress`', // Expression
            '`PaymentProgress`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PaymentProgress`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PaymentProgress->addMethod("getDefault", fn() => 0);
        $this->PaymentProgress->InputTextType = "text";
        $this->PaymentProgress->Raw = true;
        $this->PaymentProgress->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->PaymentProgress->Lookup = new Lookup($this->PaymentProgress, 'masterproject', true, 'PaymentProgress', ["PaymentProgress","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->PaymentProgress->Lookup = new Lookup($this->PaymentProgress, 'masterproject', true, 'PaymentProgress', ["PaymentProgress","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->PaymentProgress->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->PaymentProgress->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PaymentProgress'] = &$this->PaymentProgress;

        // PaymentDate
        $this->PaymentDate = new DbField(
            $this, // Table
            'x_PaymentDate', // Variable name
            'PaymentDate', // Name
            '`PaymentDate`', // Expression
            CastDateFieldForLike("`PaymentDate`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`PaymentDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PaymentDate->InputTextType = "text";
        $this->PaymentDate->Raw = true;
        $this->PaymentDate->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->PaymentDate->Lookup = new Lookup($this->PaymentDate, 'masterproject', true, 'PaymentDate', ["PaymentDate","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->PaymentDate->Lookup = new Lookup($this->PaymentDate, 'masterproject', true, 'PaymentDate', ["PaymentDate","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->PaymentDate->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->PaymentDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PaymentDate'] = &$this->PaymentDate;

        // PaymentComplete
        $this->PaymentComplete = new DbField(
            $this, // Table
            'x_PaymentComplete', // Variable name
            'PaymentComplete', // Name
            'IF(PaymentDate is not null,\'Paid\',\'Not Paid\')', // Expression
            'IF(PaymentDate is not null,\'Paid\',\'Not Paid\')', // Basic search expression
            200, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            'IF(PaymentDate is not null,\'Paid\',\'Not Paid\')', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PaymentComplete->InputTextType = "text";
        $this->PaymentComplete->IsCustom = true; // Custom field
        $this->PaymentComplete->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->PaymentComplete->Lookup = new Lookup($this->PaymentComplete, 'masterproject', true, 'PaymentComplete', ["PaymentComplete","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->PaymentComplete->Lookup = new Lookup($this->PaymentComplete, 'masterproject', true, 'PaymentComplete', ["PaymentComplete","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->PaymentComplete->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['PaymentComplete'] = &$this->PaymentComplete;

        // AgingPayment
        $this->AgingPayment = new DbField(
            $this, // Table
            'x_AgingPayment', // Variable name
            'AgingPayment', // Name
            'CASE
        WHEN EndDate IS NULL THEN 0
        ELSE DATEDIFF(COALESCE(PaymentDate, CURDATE()),COALESCE(EndDate, CURDATE()))
    END', // Expression
            'CASE
                    WHEN EndDate IS NULL THEN 0
                    ELSE DATEDIFF(COALESCE(PaymentDate, CURDATE()),COALESCE(EndDate, CURDATE()))
                END', // Basic search expression
            3, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            'CASE
        WHEN EndDate IS NULL THEN 0
        ELSE DATEDIFF(COALESCE(PaymentDate, CURDATE()),COALESCE(EndDate, CURDATE()))
    END', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->AgingPayment->InputTextType = "text";
        $this->AgingPayment->Raw = true;
        $this->AgingPayment->IsCustom = true; // Custom field
        $this->AgingPayment->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->AgingPayment->Lookup = new Lookup($this->AgingPayment, 'masterproject', true, 'AgingPayment', ["AgingPayment","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->AgingPayment->Lookup = new Lookup($this->AgingPayment, 'masterproject', true, 'AgingPayment', ["AgingPayment","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->AgingPayment->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->AgingPayment->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['AgingPayment'] = &$this->AgingPayment;

        // ClientID
        $this->ClientID = new DbField(
            $this, // Table
            'x_ClientID', // Variable name
            'ClientID', // Name
            '`ClientID`', // Expression
            '`ClientID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ClientID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ClientID->addMethod("getSelectFilter", fn() => "`Active`=1");
        $this->ClientID->InputTextType = "text";
        $this->ClientID->Raw = true;
        $this->ClientID->setSelectMultiple(false); // Select one
        $this->ClientID->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ClientID->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ClientID->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->ClientID->Lookup = new Lookup($this->ClientID, 'masterclient', true, 'ClientID', ["CompanyName","","",""], '', '', [], [], [], [], [], [], false, '', '', "`CompanyName`");
                break;
            default:
                $this->ClientID->Lookup = new Lookup($this->ClientID, 'masterclient', true, 'ClientID', ["CompanyName","","",""], '', '', [], [], [], [], [], [], false, '', '', "`CompanyName`");
                break;
        }
        $this->ClientID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ClientID->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ClientID'] = &$this->ClientID;

        // ManagerID
        $this->ManagerID = new DbField(
            $this, // Table
            'x_ManagerID', // Variable name
            'ManagerID', // Name
            '`ManagerID`', // Expression
            '`ManagerID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ManagerID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ManagerID->addMethod("getSelectFilter", fn() => "`Active`=1");
        $this->ManagerID->InputTextType = "text";
        $this->ManagerID->Raw = true;
        $this->ManagerID->setSelectMultiple(false); // Select one
        $this->ManagerID->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ManagerID->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ManagerID->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->ManagerID->Lookup = new Lookup($this->ManagerID, 'masteruser', true, 'EmployeeID', ["FullName","","",""], '', '', [], [], [], [], [], [], false, '', '', "CONCAT(FirstName, ' ', LastName)");
                break;
            default:
                $this->ManagerID->Lookup = new Lookup($this->ManagerID, 'masteruser', true, 'EmployeeID', ["FullName","","",""], '', '', [], [], [], [], [], [], false, '', '', "CONCAT(FirstName, ' ', LastName)");
                break;
        }
        $this->ManagerID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ManagerID->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ManagerID'] = &$this->ManagerID;

        // ProjectTemplateID
        $this->ProjectTemplateID = new DbField(
            $this, // Table
            'x_ProjectTemplateID', // Variable name
            'ProjectTemplateID', // Name
            '`ProjectTemplateID`', // Expression
            '`ProjectTemplateID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProjectTemplateID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ProjectTemplateID->addMethod("getSelectFilter", fn() => "`Active`=1");
        $this->ProjectTemplateID->InputTextType = "text";
        $this->ProjectTemplateID->Raw = true;
        $this->ProjectTemplateID->Nullable = false; // NOT NULL field
        $this->ProjectTemplateID->Required = true; // Required field
        $this->ProjectTemplateID->setSelectMultiple(false); // Select one
        $this->ProjectTemplateID->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ProjectTemplateID->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ProjectTemplateID->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->ProjectTemplateID->Lookup = new Lookup($this->ProjectTemplateID, 'projecttemplate', true, 'ID', ["template_name","","",""], '', '', [], [], [], [], [], [], false, '', '', "`template_name`");
                break;
            default:
                $this->ProjectTemplateID->Lookup = new Lookup($this->ProjectTemplateID, 'projecttemplate', true, 'ID', ["template_name","","",""], '', '', [], [], [], [], [], [], false, '', '', "`template_name`");
                break;
        }
        $this->ProjectTemplateID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ProjectTemplateID->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ProjectTemplateID'] = &$this->ProjectTemplateID;

        // Priority
        $this->Priority = new DbField(
            $this, // Table
            'x_Priority', // Variable name
            'Priority', // Name
            '`Priority`', // Expression
            '`Priority`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Priority`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Priority->addMethod("getDefault", fn() => 1);
        $this->Priority->InputTextType = "text";
        $this->Priority->Raw = true;
        $this->Priority->setSelectMultiple(false); // Select one
        $this->Priority->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Priority->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->Priority->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Priority->Lookup = new Lookup($this->Priority, 'masterproject', true, 'Priority', ["Priority","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Priority->Lookup = new Lookup($this->Priority, 'masterproject', true, 'Priority', ["Priority","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Priority->OptionCount = 3;
        $this->Priority->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Priority->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Priority'] = &$this->Priority;

        // Description
        $this->Description = new DbField(
            $this, // Table
            'x_Description', // Variable name
            'Description', // Name
            '`Description`', // Expression
            '`Description`', // Basic search expression
            200, // Type
            2000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Description`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->Description->InputTextType = "text";
        $this->Description->Sortable = false; // Allow sort
        $this->Description->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Description'] = &$this->Description;

        // ProjectValue
        $this->ProjectValue = new DbField(
            $this, // Table
            'x_ProjectValue', // Variable name
            'ProjectValue', // Name
            '`ProjectValue`', // Expression
            '`ProjectValue`', // Basic search expression
            131, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProjectValue`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ProjectValue->InputTextType = "text";
        $this->ProjectValue->Raw = true;
        $this->ProjectValue->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->ProjectValue->Lookup = new Lookup($this->ProjectValue, 'masterproject', true, 'ProjectValue', ["ProjectValue","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->ProjectValue->Lookup = new Lookup($this->ProjectValue, 'masterproject', true, 'ProjectValue', ["ProjectValue","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->ProjectValue->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ProjectValue->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ProjectValue'] = &$this->ProjectValue;

        // ProjectDebt
        $this->ProjectDebt = new DbField(
            $this, // Table
            'x_ProjectDebt', // Variable name
            'ProjectDebt', // Name
            '`ProjectDebt`', // Expression
            '`ProjectDebt`', // Basic search expression
            131, // Type
            20, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProjectDebt`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ProjectDebt->InputTextType = "text";
        $this->ProjectDebt->Raw = true;
        $this->ProjectDebt->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->ProjectDebt->Lookup = new Lookup($this->ProjectDebt, 'masterproject', true, 'ProjectDebt', ["ProjectDebt","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->ProjectDebt->Lookup = new Lookup($this->ProjectDebt, 'masterproject', true, 'ProjectDebt', ["ProjectDebt","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->ProjectDebt->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ProjectDebt->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ProjectDebt'] = &$this->ProjectDebt;

        // PONumber
        $this->PONumber = new DbField(
            $this, // Table
            'x_PONumber', // Variable name
            'PONumber', // Name
            '`PONumber`', // Expression
            '`PONumber`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PONumber`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PONumber->InputTextType = "text";
        $this->PONumber->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->PONumber->Lookup = new Lookup($this->PONumber, 'masterproject', true, 'PONumber', ["PONumber","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->PONumber->Lookup = new Lookup($this->PONumber, 'masterproject', true, 'PONumber', ["PONumber","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->PONumber->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['PONumber'] = &$this->PONumber;

        // PaymentLink
        $this->PaymentLink = new DbField(
            $this, // Table
            'x_PaymentLink', // Variable name
            'PaymentLink', // Name
            '`PaymentLink`', // Expression
            '`PaymentLink`', // Basic search expression
            200, // Type
            65535, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PaymentLink`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->PaymentLink->InputTextType = "text";
        $this->PaymentLink->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['PaymentLink'] = &$this->PaymentLink;

        // ClearingDate
        $this->ClearingDate = new DbField(
            $this, // Table
            'x_ClearingDate', // Variable name
            'ClearingDate', // Name
            '`ClearingDate`', // Expression
            CastDateFieldForLike("`ClearingDate`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`ClearingDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ClearingDate->InputTextType = "text";
        $this->ClearingDate->Raw = true;
        $this->ClearingDate->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->ClearingDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ClearingDate'] = &$this->ClearingDate;

        // ClearingAging
        $this->ClearingAging = new DbField(
            $this, // Table
            'x_ClearingAging', // Variable name
            'ClearingAging', // Name
            '(CASE
        WHEN EndDate IS NULL THEN 0
        ELSE DATEDIFF(COALESCE(ClearingDate, CURDATE()),COALESCE(EndDate, CURDATE()))
    END)', // Expression
            '(CASE
                    WHEN EndDate IS NULL THEN 0
                    ELSE DATEDIFF(COALESCE(ClearingDate, CURDATE()),COALESCE(EndDate, CURDATE()))
                END)', // Basic search expression
            3, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '(CASE
        WHEN EndDate IS NULL THEN 0
        ELSE DATEDIFF(COALESCE(ClearingDate, CURDATE()),COALESCE(EndDate, CURDATE()))
    END)', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ClearingAging->InputTextType = "text";
        $this->ClearingAging->Raw = true;
        $this->ClearingAging->IsCustom = true; // Custom field
        $this->ClearingAging->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ClearingAging->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ClearingAging'] = &$this->ClearingAging;

        // Active
        $this->Active = new DbField(
            $this, // Table
            'x_Active', // Variable name
            'Active', // Name
            '`Active`', // Expression
            '`Active`', // Basic search expression
            200, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Active`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->Active->addMethod("getDefault", fn() => 1);
        $this->Active->InputTextType = "text";
        $this->Active->Raw = true;
        $this->Active->setDataType(DataType::BIT);
        $this->Active->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Active->Lookup = new Lookup($this->Active, 'masterproject', true, 'Active', ["Active","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Active->Lookup = new Lookup($this->Active, 'masterproject', true, 'Active', ["Active","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Active->OptionCount = 2;
        $this->Active->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Active->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Active'] = &$this->Active;

        // Created_Date
        $this->Created_Date = new DbField(
            $this, // Table
            'x_Created_Date', // Variable name
            'Created_Date', // Name
            '`Created_Date`', // Expression
            CastDateFieldForLike("`Created_Date`", 9, "DB"), // Basic search expression
            135, // Type
            19, // Size
            9, // Date/Time format
            false, // Is upload field
            '`Created_Date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Created_Date->addMethod("getDefault", fn() => CurrentDateTime());
        $this->Created_Date->InputTextType = "text";
        $this->Created_Date->Raw = true;
        $this->Created_Date->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Created_Date->Lookup = new Lookup($this->Created_Date, 'masterproject', true, 'Created_Date', ["Created_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Created_Date->Lookup = new Lookup($this->Created_Date, 'masterproject', true, 'Created_Date', ["Created_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Created_Date->DefaultErrorMessage = str_replace("%s", DateFormat(9), $Language->phrase("IncorrectDate"));
        $this->Created_Date->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Created_Date'] = &$this->Created_Date;

        // Created_By
        $this->Created_By = new DbField(
            $this, // Table
            'x_Created_By', // Variable name
            'Created_By', // Name
            '`Created_By`', // Expression
            '`Created_By`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Created_By`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Created_By->addMethod("getDefault", fn() => CurrentUserName());
        $this->Created_By->InputTextType = "text";
        $this->Created_By->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Created_By->Lookup = new Lookup($this->Created_By, 'masterproject', true, 'Created_By', ["Created_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Created_By->Lookup = new Lookup($this->Created_By, 'masterproject', true, 'Created_By', ["Created_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Created_By->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Created_By'] = &$this->Created_By;

        // Last_Updated_Date
        $this->Last_Updated_Date = new DbField(
            $this, // Table
            'x_Last_Updated_Date', // Variable name
            'Last_Updated_Date', // Name
            '`Last_Updated_Date`', // Expression
            CastDateFieldForLike("`Last_Updated_Date`", 15, "DB"), // Basic search expression
            135, // Type
            19, // Size
            15, // Date/Time format
            false, // Is upload field
            '`Last_Updated_Date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Last_Updated_Date->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->Last_Updated_Date->addMethod("getDefault", fn() => CurrentDateTime());
        $this->Last_Updated_Date->InputTextType = "text";
        $this->Last_Updated_Date->Raw = true;
        $this->Last_Updated_Date->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Last_Updated_Date->Lookup = new Lookup($this->Last_Updated_Date, 'masterproject', true, 'Last_Updated_Date', ["Last_Updated_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Last_Updated_Date->Lookup = new Lookup($this->Last_Updated_Date, 'masterproject', true, 'Last_Updated_Date', ["Last_Updated_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Last_Updated_Date->DefaultErrorMessage = str_replace("%s", DateFormat(15), $Language->phrase("IncorrectDate"));
        $this->Last_Updated_Date->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Last_Updated_Date'] = &$this->Last_Updated_Date;

        // Last_Updated_By
        $this->Last_Updated_By = new DbField(
            $this, // Table
            'x_Last_Updated_By', // Variable name
            'Last_Updated_By', // Name
            '`Last_Updated_By`', // Expression
            '`Last_Updated_By`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Last_Updated_By`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Last_Updated_By->addMethod("getAutoUpdateValue", fn() => CurrentUserName());
        $this->Last_Updated_By->addMethod("getDefault", fn() => CurrentUserName());
        $this->Last_Updated_By->InputTextType = "text";
        $this->Last_Updated_By->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Last_Updated_By->Lookup = new Lookup($this->Last_Updated_By, 'masterproject', true, 'Last_Updated_By', ["Last_Updated_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Last_Updated_By->Lookup = new Lookup($this->Last_Updated_By, 'masterproject', true, 'Last_Updated_By', ["Last_Updated_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Last_Updated_By->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Last_Updated_By'] = &$this->Last_Updated_By;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")) ?? "";
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "projectmember") {
            $detailUrl = Container("projectmember")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "projecttask") {
            $detailUrl = Container("projecttask")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "projectresult") {
            $detailUrl = Container("projectresult")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "projectmom") {
            $detailUrl = Container("projectmom")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "projectdocuments") {
            $detailUrl = Container("projectdocuments")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "projectpaymentprocess") {
            $detailUrl = Container("projectpaymentprocess")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "projectproblems") {
            $detailUrl = Container("projectproblems")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "masterprojectlist";
        }
        return $detailUrl;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "masterproject";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        return "*, CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END AS `Target`, CASE WHEN Progress<1 AND CURDATE()>PlanEnd THEN 'Late'
        WHEN Progress<CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE GREATEST(1, DATEDIFF(CURDATE(), PlanStart) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END THEN 'Warning'
        ELSE 'On Track'
    END AS `Track`, IF(PaymentDate is not null,'Paid','Not Paid') AS `PaymentComplete`, CASE
        WHEN EndDate IS NULL THEN 0
        ELSE DATEDIFF(COALESCE(PaymentDate, CURDATE()),COALESCE(EndDate, CURDATE()))
    END AS `AgingPayment`, (CASE
        WHEN EndDate IS NULL THEN 0
        ELSE DATEDIFF(COALESCE(ClearingDate, CURDATE()),COALESCE(EndDate, CURDATE()))
    END) AS `ClearingAging`";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->_ProjectID->setDbValue($conn->lastInsertId());
            $rs['ProjectID'] = $this->_ProjectID->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['ProjectID']) && !EmptyValue($this->_ProjectID->CurrentValue)) {
                $rs['ProjectID'] = $this->_ProjectID->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('ProjectID', $rs)) {
                AddFilter($where, QuotedName('ProjectID', $this->Dbid) . '=' . QuotedValue($rs['ProjectID'], $this->_ProjectID->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;

        // Cascade delete detail table 'projectmember'
        $dtlrows = Container("projectmember")->loadRs("`ProjectID` = " . QuotedValue($rs['ProjectID'], DataType::NUMBER, "DB"))->fetchAllAssociative();
        // Call Row Deleting event
        foreach ($dtlrows as $dtlrow) {
            $success = Container("projectmember")->rowDeleting($dtlrow);
            if (!$success) {
                break;
            }
        }
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                $success = Container("projectmember")->delete($dtlrow); // Delete
                if (!$success) {
                    break;
                }
            }
        }
        // Call Row Deleted event
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                Container("projectmember")->rowDeleted($dtlrow);
            }
        }

        // Cascade delete detail table 'projecttask'
        $dtlrows = Container("projecttask")->loadRs("`ProjectID` = " . QuotedValue($rs['ProjectID'], DataType::NUMBER, "DB"))->fetchAllAssociative();
        // Call Row Deleting event
        foreach ($dtlrows as $dtlrow) {
            $success = Container("projecttask")->rowDeleting($dtlrow);
            if (!$success) {
                break;
            }
        }
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                $success = Container("projecttask")->delete($dtlrow); // Delete
                if (!$success) {
                    break;
                }
            }
        }
        // Call Row Deleted event
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                Container("projecttask")->rowDeleted($dtlrow);
            }
        }

        // Cascade delete detail table 'projectresult'
        $dtlrows = Container("projectresult")->loadRs("`ProjectID` = " . QuotedValue($rs['ProjectID'], DataType::NUMBER, "DB"))->fetchAllAssociative();
        // Call Row Deleting event
        foreach ($dtlrows as $dtlrow) {
            $success = Container("projectresult")->rowDeleting($dtlrow);
            if (!$success) {
                break;
            }
        }
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                $success = Container("projectresult")->delete($dtlrow); // Delete
                if (!$success) {
                    break;
                }
            }
        }
        // Call Row Deleted event
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                Container("projectresult")->rowDeleted($dtlrow);
            }
        }

        // Cascade delete detail table 'projectmom'
        $dtlrows = Container("projectmom")->loadRs("`ProjectID` = " . QuotedValue($rs['ProjectID'], DataType::NUMBER, "DB"))->fetchAllAssociative();
        // Call Row Deleting event
        foreach ($dtlrows as $dtlrow) {
            $success = Container("projectmom")->rowDeleting($dtlrow);
            if (!$success) {
                break;
            }
        }
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                $success = Container("projectmom")->delete($dtlrow); // Delete
                if (!$success) {
                    break;
                }
            }
        }
        // Call Row Deleted event
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                Container("projectmom")->rowDeleted($dtlrow);
            }
        }

        // Cascade delete detail table 'projectdocuments'
        $dtlrows = Container("projectdocuments")->loadRs("`ProjectID` = " . QuotedValue($rs['ProjectID'], DataType::NUMBER, "DB"))->fetchAllAssociative();
        // Call Row Deleting event
        foreach ($dtlrows as $dtlrow) {
            $success = Container("projectdocuments")->rowDeleting($dtlrow);
            if (!$success) {
                break;
            }
        }
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                $success = Container("projectdocuments")->delete($dtlrow); // Delete
                if (!$success) {
                    break;
                }
            }
        }
        // Call Row Deleted event
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                Container("projectdocuments")->rowDeleted($dtlrow);
            }
        }

        // Cascade delete detail table 'projectpaymentprocess'
        $dtlrows = Container("projectpaymentprocess")->loadRs("`ProjectID` = " . QuotedValue($rs['ProjectID'], DataType::NUMBER, "DB"))->fetchAllAssociative();
        // Call Row Deleting event
        foreach ($dtlrows as $dtlrow) {
            $success = Container("projectpaymentprocess")->rowDeleting($dtlrow);
            if (!$success) {
                break;
            }
        }
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                $success = Container("projectpaymentprocess")->delete($dtlrow); // Delete
                if (!$success) {
                    break;
                }
            }
        }
        // Call Row Deleted event
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                Container("projectpaymentprocess")->rowDeleted($dtlrow);
            }
        }

        // Cascade delete detail table 'projectproblems'
        $dtlrows = Container("projectproblems")->loadRs("`ProjectID` = " . QuotedValue($rs['ProjectID'], DataType::NUMBER, "DB"))->fetchAllAssociative();
        // Call Row Deleting event
        foreach ($dtlrows as $dtlrow) {
            $success = Container("projectproblems")->rowDeleting($dtlrow);
            if (!$success) {
                break;
            }
        }
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                $success = Container("projectproblems")->delete($dtlrow); // Delete
                if (!$success) {
                    break;
                }
            }
        }
        // Call Row Deleted event
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                Container("projectproblems")->rowDeleted($dtlrow);
            }
        }
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->_ProjectID->DbValue = $row['ProjectID'];
        $this->ProjectName->DbValue = $row['ProjectName'];
        $this->PlanStart->DbValue = $row['PlanStart'];
        $this->PlanEnd->DbValue = $row['PlanEnd'];
        $this->StartDate->DbValue = $row['StartDate'];
        $this->EndDate->DbValue = $row['EndDate'];
        $this->WarrantyEnd->DbValue = $row['WarrantyEnd'];
        $this->Status->DbValue = $row['Status'];
        $this->Progress->DbValue = $row['Progress'];
        $this->Target->DbValue = $row['Target'];
        $this->Track->DbValue = $row['Track'];
        $this->PaymentProgress->DbValue = $row['PaymentProgress'];
        $this->PaymentDate->DbValue = $row['PaymentDate'];
        $this->PaymentComplete->DbValue = $row['PaymentComplete'];
        $this->AgingPayment->DbValue = $row['AgingPayment'];
        $this->ClientID->DbValue = $row['ClientID'];
        $this->ManagerID->DbValue = $row['ManagerID'];
        $this->ProjectTemplateID->DbValue = $row['ProjectTemplateID'];
        $this->Priority->DbValue = $row['Priority'];
        $this->Description->DbValue = $row['Description'];
        $this->ProjectValue->DbValue = $row['ProjectValue'];
        $this->ProjectDebt->DbValue = $row['ProjectDebt'];
        $this->PONumber->DbValue = $row['PONumber'];
        $this->PaymentLink->DbValue = $row['PaymentLink'];
        $this->ClearingDate->DbValue = $row['ClearingDate'];
        $this->ClearingAging->DbValue = $row['ClearingAging'];
        $this->Active->DbValue = $row['Active'];
        $this->Created_Date->DbValue = $row['Created_Date'];
        $this->Created_By->DbValue = $row['Created_By'];
        $this->Last_Updated_Date->DbValue = $row['Last_Updated_Date'];
        $this->Last_Updated_By->DbValue = $row['Last_Updated_By'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`ProjectID` = @_ProjectID@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->_ProjectID->CurrentValue : $this->_ProjectID->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->_ProjectID->CurrentValue = $keys[0];
            } else {
                $this->_ProjectID->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('ProjectID', $row) ? $row['ProjectID'] : null;
        } else {
            $val = !EmptyValue($this->_ProjectID->OldValue) && !$current ? $this->_ProjectID->OldValue : $this->_ProjectID->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@_ProjectID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("masterprojectlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "masterprojectview" => $Language->phrase("View"),
            "masterprojectedit" => $Language->phrase("Edit"),
            "masterprojectadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "masterprojectlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "MasterprojectView",
            Config("API_ADD_ACTION") => "MasterprojectAdd",
            Config("API_EDIT_ACTION") => "MasterprojectEdit",
            Config("API_DELETE_ACTION") => "MasterprojectDelete",
            Config("API_LIST_ACTION") => "MasterprojectList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "masterprojectlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("masterprojectview", $parm);
        } else {
            $url = $this->keyUrl("masterprojectview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "masterprojectadd?" . $parm;
        } else {
            $url = "masterprojectadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("masterprojectedit", $parm);
        } else {
            $url = $this->keyUrl("masterprojectedit", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("masterprojectlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("masterprojectadd", $parm);
        } else {
            $url = $this->keyUrl("masterprojectadd", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("masterprojectlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("masterprojectdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"_ProjectID\":" . VarToJson($this->_ProjectID->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->_ProjectID->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->_ProjectID->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("_ProjectID") ?? Route("_ProjectID")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->_ProjectID->CurrentValue = $key;
            } else {
                $this->_ProjectID->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->_ProjectID->setDbValue($row['ProjectID']);
        $this->ProjectName->setDbValue($row['ProjectName']);
        $this->PlanStart->setDbValue($row['PlanStart']);
        $this->PlanEnd->setDbValue($row['PlanEnd']);
        $this->StartDate->setDbValue($row['StartDate']);
        $this->EndDate->setDbValue($row['EndDate']);
        $this->WarrantyEnd->setDbValue($row['WarrantyEnd']);
        $this->Status->setDbValue($row['Status']);
        $this->Progress->setDbValue($row['Progress']);
        $this->Target->setDbValue($row['Target']);
        $this->Track->setDbValue($row['Track']);
        $this->PaymentProgress->setDbValue($row['PaymentProgress']);
        $this->PaymentDate->setDbValue($row['PaymentDate']);
        $this->PaymentComplete->setDbValue($row['PaymentComplete']);
        $this->AgingPayment->setDbValue($row['AgingPayment']);
        $this->ClientID->setDbValue($row['ClientID']);
        $this->ManagerID->setDbValue($row['ManagerID']);
        $this->ProjectTemplateID->setDbValue($row['ProjectTemplateID']);
        $this->Priority->setDbValue($row['Priority']);
        $this->Description->setDbValue($row['Description']);
        $this->ProjectValue->setDbValue($row['ProjectValue']);
        $this->ProjectDebt->setDbValue($row['ProjectDebt']);
        $this->PONumber->setDbValue($row['PONumber']);
        $this->PaymentLink->setDbValue($row['PaymentLink']);
        $this->ClearingDate->setDbValue($row['ClearingDate']);
        $this->ClearingAging->setDbValue($row['ClearingAging']);
        $this->Active->setDbValue($row['Active']);
        $this->Created_Date->setDbValue($row['Created_Date']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->Last_Updated_Date->setDbValue($row['Last_Updated_Date']);
        $this->Last_Updated_By->setDbValue($row['Last_Updated_By']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "MasterprojectList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ProjectID

        // ProjectName
        $this->ProjectName->CellCssStyle = "white-space: nowrap;";

        // PlanStart
        $this->PlanStart->CellCssStyle = "white-space: nowrap;";

        // PlanEnd
        $this->PlanEnd->CellCssStyle = "white-space: nowrap;";

        // StartDate
        $this->StartDate->CellCssStyle = "white-space: nowrap;";

        // EndDate
        $this->EndDate->CellCssStyle = "white-space: nowrap;";

        // WarrantyEnd
        $this->WarrantyEnd->CellCssStyle = "white-space: nowrap;";

        // Status
        $this->Status->CellCssStyle = "white-space: nowrap;";

        // Progress
        $this->Progress->CellCssStyle = "white-space: nowrap;";

        // Target
        $this->Target->CellCssStyle = "white-space: nowrap;";

        // Track
        $this->Track->CellCssStyle = "white-space: nowrap;";

        // PaymentProgress
        $this->PaymentProgress->CellCssStyle = "white-space: nowrap;";

        // PaymentDate
        $this->PaymentDate->CellCssStyle = "white-space: nowrap;";

        // PaymentComplete
        $this->PaymentComplete->CellCssStyle = "white-space: nowrap;";

        // AgingPayment
        $this->AgingPayment->CellCssStyle = "white-space: nowrap;";

        // ClientID
        $this->ClientID->CellCssStyle = "white-space: nowrap;";

        // ManagerID
        $this->ManagerID->CellCssStyle = "white-space: nowrap;";

        // ProjectTemplateID
        $this->ProjectTemplateID->CellCssStyle = "white-space: nowrap;";

        // Priority
        $this->Priority->CellCssStyle = "white-space: nowrap;";

        // Description
        $this->Description->CellCssStyle = "white-space: nowrap;";

        // ProjectValue
        $this->ProjectValue->CellCssStyle = "white-space: nowrap;";

        // ProjectDebt
        $this->ProjectDebt->CellCssStyle = "white-space: nowrap;";

        // PONumber
        $this->PONumber->CellCssStyle = "white-space: nowrap;";

        // PaymentLink

        // ClearingDate

        // ClearingAging

        // Active
        $this->Active->CellCssStyle = "white-space: nowrap;";

        // Created_Date
        $this->Created_Date->CellCssStyle = "white-space: nowrap;";

        // Created_By
        $this->Created_By->CellCssStyle = "white-space: nowrap;";

        // Last_Updated_Date
        $this->Last_Updated_Date->CellCssStyle = "white-space: nowrap;";

        // Last_Updated_By
        $this->Last_Updated_By->CellCssStyle = "white-space: nowrap;";

        // ProjectID
        $this->_ProjectID->ViewValue = $this->_ProjectID->CurrentValue;

        // ProjectName
        $this->ProjectName->ViewValue = $this->ProjectName->CurrentValue;

        // PlanStart
        $this->PlanStart->ViewValue = $this->PlanStart->CurrentValue;
        $this->PlanStart->ViewValue = FormatDateTime($this->PlanStart->ViewValue, $this->PlanStart->formatPattern());

        // PlanEnd
        $this->PlanEnd->ViewValue = $this->PlanEnd->CurrentValue;
        $this->PlanEnd->ViewValue = FormatDateTime($this->PlanEnd->ViewValue, $this->PlanEnd->formatPattern());

        // StartDate
        $this->StartDate->ViewValue = $this->StartDate->CurrentValue;
        $this->StartDate->ViewValue = FormatDateTime($this->StartDate->ViewValue, $this->StartDate->formatPattern());

        // EndDate
        $this->EndDate->ViewValue = $this->EndDate->CurrentValue;
        $this->EndDate->ViewValue = FormatDateTime($this->EndDate->ViewValue, $this->EndDate->formatPattern());

        // WarrantyEnd
        $this->WarrantyEnd->ViewValue = $this->WarrantyEnd->CurrentValue;
        $this->WarrantyEnd->ViewValue = FormatDateTime($this->WarrantyEnd->ViewValue, $this->WarrantyEnd->formatPattern());

        // Status
        $curVal = strval($this->Status->CurrentValue);
        if ($curVal != "") {
            $this->Status->ViewValue = $this->Status->lookupCacheOption($curVal);
            if ($this->Status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->Status->Lookup->getTable()->Fields["Status"]->searchExpression(), "=", $curVal, $this->Status->Lookup->getTable()->Fields["Status"]->searchDataType(), "");
                $sqlWrk = $this->Status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Status->Lookup->renderViewRow($rswrk[0]);
                    $this->Status->ViewValue = $this->Status->displayValue($arwrk);
                } else {
                    $this->Status->ViewValue = $this->Status->CurrentValue;
                }
            }
        } else {
            $this->Status->ViewValue = null;
        }

        // Progress
        $this->Progress->ViewValue = $this->Progress->CurrentValue;
        $this->Progress->ViewValue = FormatPercent($this->Progress->ViewValue, $this->Progress->formatPattern());
        $this->Progress->CellCssStyle .= "text-align: right;";

        // Target
        $this->Target->ViewValue = $this->Target->CurrentValue;
        $this->Target->ViewValue = FormatPercent($this->Target->ViewValue, $this->Target->formatPattern());
        $this->Target->CellCssStyle .= "text-align: right;";

        // Track
        $this->Track->ViewValue = $this->Track->CurrentValue;
        $this->Track->CellCssStyle .= "text-align: right;";

        // PaymentProgress
        $this->PaymentProgress->ViewValue = $this->PaymentProgress->CurrentValue;
        $this->PaymentProgress->ViewValue = FormatPercent($this->PaymentProgress->ViewValue, $this->PaymentProgress->formatPattern());
        $this->PaymentProgress->CellCssStyle .= "text-align: right;";

        // PaymentDate
        $this->PaymentDate->ViewValue = $this->PaymentDate->CurrentValue;
        $this->PaymentDate->ViewValue = FormatDateTime($this->PaymentDate->ViewValue, $this->PaymentDate->formatPattern());

        // PaymentComplete
        $this->PaymentComplete->ViewValue = $this->PaymentComplete->CurrentValue;

        // AgingPayment
        $this->AgingPayment->ViewValue = $this->AgingPayment->CurrentValue;
        $this->AgingPayment->ViewValue = FormatNumber($this->AgingPayment->ViewValue, $this->AgingPayment->formatPattern());
        $this->AgingPayment->CellCssStyle .= "text-align: right;";

        // ClientID
        $curVal = strval($this->ClientID->CurrentValue);
        if ($curVal != "") {
            $this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
            if ($this->ClientID->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ClientID->Lookup->getTable()->Fields["ClientID"]->searchExpression(), "=", $curVal, $this->ClientID->Lookup->getTable()->Fields["ClientID"]->searchDataType(), "");
                $lookupFilter = $this->ClientID->getSelectFilter($this); // PHP
                $sqlWrk = $this->ClientID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ClientID->Lookup->renderViewRow($rswrk[0]);
                    $this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
                } else {
                    $this->ClientID->ViewValue = FormatNumber($this->ClientID->CurrentValue, $this->ClientID->formatPattern());
                }
            }
        } else {
            $this->ClientID->ViewValue = null;
        }

        // ManagerID
        $curVal = strval($this->ManagerID->CurrentValue);
        if ($curVal != "") {
            $this->ManagerID->ViewValue = $this->ManagerID->lookupCacheOption($curVal);
            if ($this->ManagerID->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ManagerID->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $curVal, $this->ManagerID->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                $lookupFilter = $this->ManagerID->getSelectFilter($this); // PHP
                $sqlWrk = $this->ManagerID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ManagerID->Lookup->renderViewRow($rswrk[0]);
                    $this->ManagerID->ViewValue = $this->ManagerID->displayValue($arwrk);
                } else {
                    $this->ManagerID->ViewValue = FormatNumber($this->ManagerID->CurrentValue, $this->ManagerID->formatPattern());
                }
            }
        } else {
            $this->ManagerID->ViewValue = null;
        }

        // ProjectTemplateID
        $curVal = strval($this->ProjectTemplateID->CurrentValue);
        if ($curVal != "") {
            $this->ProjectTemplateID->ViewValue = $this->ProjectTemplateID->lookupCacheOption($curVal);
            if ($this->ProjectTemplateID->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ProjectTemplateID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->ProjectTemplateID->Lookup->getTable()->Fields["ID"]->searchDataType(), "");
                $lookupFilter = $this->ProjectTemplateID->getSelectFilter($this); // PHP
                $sqlWrk = $this->ProjectTemplateID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ProjectTemplateID->Lookup->renderViewRow($rswrk[0]);
                    $this->ProjectTemplateID->ViewValue = $this->ProjectTemplateID->displayValue($arwrk);
                } else {
                    $this->ProjectTemplateID->ViewValue = FormatNumber($this->ProjectTemplateID->CurrentValue, $this->ProjectTemplateID->formatPattern());
                }
            }
        } else {
            $this->ProjectTemplateID->ViewValue = null;
        }

        // Priority
        if (strval($this->Priority->CurrentValue) != "") {
            $this->Priority->ViewValue = $this->Priority->optionCaption($this->Priority->CurrentValue);
        } else {
            $this->Priority->ViewValue = null;
        }

        // Description
        $this->Description->ViewValue = $this->Description->CurrentValue;

        // ProjectValue
        $this->ProjectValue->ViewValue = $this->ProjectValue->CurrentValue;
        $this->ProjectValue->ViewValue = FormatNumber($this->ProjectValue->ViewValue, $this->ProjectValue->formatPattern());
        $this->ProjectValue->CellCssStyle .= "text-align: right;";

        // ProjectDebt
        $this->ProjectDebt->ViewValue = $this->ProjectDebt->CurrentValue;
        $this->ProjectDebt->ViewValue = FormatNumber($this->ProjectDebt->ViewValue, $this->ProjectDebt->formatPattern());
        $this->ProjectDebt->CellCssStyle .= "text-align: right;";

        // PONumber
        $this->PONumber->ViewValue = $this->PONumber->CurrentValue;

        // PaymentLink
        $this->PaymentLink->ViewValue = $this->PaymentLink->CurrentValue;

        // ClearingDate
        $this->ClearingDate->ViewValue = $this->ClearingDate->CurrentValue;
        $this->ClearingDate->ViewValue = FormatDateTime($this->ClearingDate->ViewValue, $this->ClearingDate->formatPattern());

        // ClearingAging
        $this->ClearingAging->ViewValue = $this->ClearingAging->CurrentValue;
        $this->ClearingAging->ViewValue = FormatNumber($this->ClearingAging->ViewValue, $this->ClearingAging->formatPattern());
        $this->ClearingAging->CellCssStyle .= "text-align: right;";

        // Active
        if (ConvertToBool($this->Active->CurrentValue)) {
            $this->Active->ViewValue = $this->Active->tagCaption(1) != "" ? $this->Active->tagCaption(1) : "Yes";
        } else {
            $this->Active->ViewValue = $this->Active->tagCaption(2) != "" ? $this->Active->tagCaption(2) : "No";
        }
        $this->Active->CellCssStyle .= "text-align: center;";

        // Created_Date
        $this->Created_Date->ViewValue = $this->Created_Date->CurrentValue;
        $this->Created_Date->ViewValue = FormatDateTime($this->Created_Date->ViewValue, $this->Created_Date->formatPattern());

        // Created_By
        $this->Created_By->ViewValue = $this->Created_By->CurrentValue;

        // Last_Updated_Date
        $this->Last_Updated_Date->ViewValue = $this->Last_Updated_Date->CurrentValue;
        $this->Last_Updated_Date->ViewValue = FormatDateTime($this->Last_Updated_Date->ViewValue, $this->Last_Updated_Date->formatPattern());

        // Last_Updated_By
        $this->Last_Updated_By->ViewValue = $this->Last_Updated_By->CurrentValue;

        // ProjectID
        $this->_ProjectID->HrefValue = "";
        $this->_ProjectID->TooltipValue = "";

        // ProjectName
        $this->ProjectName->HrefValue = "";
        $this->ProjectName->TooltipValue = "";

        // PlanStart
        $this->PlanStart->HrefValue = "";
        $this->PlanStart->TooltipValue = "";

        // PlanEnd
        $this->PlanEnd->HrefValue = "";
        $this->PlanEnd->TooltipValue = "";

        // StartDate
        $this->StartDate->HrefValue = "";
        $this->StartDate->TooltipValue = "";

        // EndDate
        $this->EndDate->HrefValue = "";
        $this->EndDate->TooltipValue = "";

        // WarrantyEnd
        $this->WarrantyEnd->HrefValue = "";
        $this->WarrantyEnd->TooltipValue = "";

        // Status
        $this->Status->HrefValue = "";
        $this->Status->TooltipValue = "";

        // Progress
        $this->Progress->HrefValue = "";
        $this->Progress->TooltipValue = "";

        // Target
        $this->Target->HrefValue = "";
        $this->Target->TooltipValue = "";

        // Track
        $this->Track->HrefValue = "";
        $this->Track->TooltipValue = "";

        // PaymentProgress
        $this->PaymentProgress->HrefValue = "";
        $this->PaymentProgress->TooltipValue = "";

        // PaymentDate
        $this->PaymentDate->HrefValue = "";
        $this->PaymentDate->TooltipValue = "";

        // PaymentComplete
        $this->PaymentComplete->HrefValue = "";
        $this->PaymentComplete->TooltipValue = "";

        // AgingPayment
        $this->AgingPayment->HrefValue = "";
        $this->AgingPayment->TooltipValue = "";

        // ClientID
        $this->ClientID->HrefValue = "";
        $this->ClientID->TooltipValue = "";

        // ManagerID
        $this->ManagerID->HrefValue = "";
        $this->ManagerID->TooltipValue = "";

        // ProjectTemplateID
        $this->ProjectTemplateID->HrefValue = "";
        $this->ProjectTemplateID->TooltipValue = "";

        // Priority
        $this->Priority->HrefValue = "";
        $this->Priority->TooltipValue = "";

        // Description
        $this->Description->HrefValue = "";
        $this->Description->TooltipValue = "";

        // ProjectValue
        $this->ProjectValue->HrefValue = "";
        $this->ProjectValue->TooltipValue = "";

        // ProjectDebt
        $this->ProjectDebt->HrefValue = "";
        $this->ProjectDebt->TooltipValue = "";

        // PONumber
        $this->PONumber->HrefValue = "";
        $this->PONumber->TooltipValue = "";

        // PaymentLink
        $this->PaymentLink->HrefValue = "";
        $this->PaymentLink->TooltipValue = "";

        // ClearingDate
        $this->ClearingDate->HrefValue = "";
        $this->ClearingDate->TooltipValue = "";

        // ClearingAging
        $this->ClearingAging->HrefValue = "";
        $this->ClearingAging->TooltipValue = "";

        // Active
        $this->Active->HrefValue = "";
        $this->Active->TooltipValue = "";

        // Created_Date
        $this->Created_Date->HrefValue = "";
        $this->Created_Date->TooltipValue = "";

        // Created_By
        $this->Created_By->HrefValue = "";
        $this->Created_By->TooltipValue = "";

        // Last_Updated_Date
        $this->Last_Updated_Date->HrefValue = "";
        $this->Last_Updated_Date->TooltipValue = "";

        // Last_Updated_By
        $this->Last_Updated_By->HrefValue = "";
        $this->Last_Updated_By->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // ProjectID
        $this->_ProjectID->setupEditAttributes();
        $this->_ProjectID->EditValue = $this->_ProjectID->CurrentValue;

        // ProjectName
        $this->ProjectName->setupEditAttributes();
        if (!$this->ProjectName->Raw) {
            $this->ProjectName->CurrentValue = HtmlDecode($this->ProjectName->CurrentValue);
        }
        $this->ProjectName->EditValue = $this->ProjectName->CurrentValue;
        $this->ProjectName->PlaceHolder = RemoveHtml($this->ProjectName->caption());

        // PlanStart
        $this->PlanStart->setupEditAttributes();
        $this->PlanStart->EditValue = FormatDateTime($this->PlanStart->CurrentValue, $this->PlanStart->formatPattern());
        $this->PlanStart->PlaceHolder = RemoveHtml($this->PlanStart->caption());

        // PlanEnd
        $this->PlanEnd->setupEditAttributes();
        $this->PlanEnd->EditValue = FormatDateTime($this->PlanEnd->CurrentValue, $this->PlanEnd->formatPattern());
        $this->PlanEnd->PlaceHolder = RemoveHtml($this->PlanEnd->caption());

        // StartDate
        $this->StartDate->setupEditAttributes();
        $this->StartDate->EditValue = FormatDateTime($this->StartDate->CurrentValue, $this->StartDate->formatPattern());
        $this->StartDate->PlaceHolder = RemoveHtml($this->StartDate->caption());

        // EndDate
        $this->EndDate->setupEditAttributes();
        $this->EndDate->EditValue = FormatDateTime($this->EndDate->CurrentValue, $this->EndDate->formatPattern());
        $this->EndDate->PlaceHolder = RemoveHtml($this->EndDate->caption());

        // WarrantyEnd
        $this->WarrantyEnd->setupEditAttributes();
        $this->WarrantyEnd->EditValue = FormatDateTime($this->WarrantyEnd->CurrentValue, $this->WarrantyEnd->formatPattern());
        $this->WarrantyEnd->PlaceHolder = RemoveHtml($this->WarrantyEnd->caption());

        // Status
        $this->Status->setupEditAttributes();
        $this->Status->PlaceHolder = RemoveHtml($this->Status->caption());

        // Progress
        $this->Progress->setupEditAttributes();
        $this->Progress->EditValue = $this->Progress->CurrentValue;
        $this->Progress->EditValue = FormatPercent($this->Progress->EditValue, $this->Progress->formatPattern());
        $this->Progress->CellCssStyle .= "text-align: right;";

        // Target
        $this->Target->setupEditAttributes();
        $this->Target->EditValue = $this->Target->CurrentValue;
        $this->Target->PlaceHolder = RemoveHtml($this->Target->caption());
        if (strval($this->Target->EditValue) != "" && is_numeric($this->Target->EditValue)) {
            $this->Target->EditValue = FormatNumber($this->Target->EditValue, null);
        }

        // Track
        $this->Track->setupEditAttributes();
        if (!$this->Track->Raw) {
            $this->Track->CurrentValue = HtmlDecode($this->Track->CurrentValue);
        }
        $this->Track->EditValue = $this->Track->CurrentValue;
        $this->Track->PlaceHolder = RemoveHtml($this->Track->caption());

        // PaymentProgress
        $this->PaymentProgress->setupEditAttributes();
        $this->PaymentProgress->EditValue = $this->PaymentProgress->CurrentValue;
        $this->PaymentProgress->EditValue = FormatPercent($this->PaymentProgress->EditValue, $this->PaymentProgress->formatPattern());
        $this->PaymentProgress->CellCssStyle .= "text-align: right;";

        // PaymentDate
        $this->PaymentDate->setupEditAttributes();
        $this->PaymentDate->EditValue = $this->PaymentDate->CurrentValue;
        $this->PaymentDate->EditValue = FormatDateTime($this->PaymentDate->EditValue, $this->PaymentDate->formatPattern());

        // PaymentComplete
        $this->PaymentComplete->setupEditAttributes();
        if (!$this->PaymentComplete->Raw) {
            $this->PaymentComplete->CurrentValue = HtmlDecode($this->PaymentComplete->CurrentValue);
        }
        $this->PaymentComplete->EditValue = $this->PaymentComplete->CurrentValue;
        $this->PaymentComplete->PlaceHolder = RemoveHtml($this->PaymentComplete->caption());

        // AgingPayment
        $this->AgingPayment->setupEditAttributes();
        $this->AgingPayment->EditValue = $this->AgingPayment->CurrentValue;
        $this->AgingPayment->PlaceHolder = RemoveHtml($this->AgingPayment->caption());
        if (strval($this->AgingPayment->EditValue) != "" && is_numeric($this->AgingPayment->EditValue)) {
            $this->AgingPayment->EditValue = FormatNumber($this->AgingPayment->EditValue, null);
        }

        // ClientID
        $this->ClientID->setupEditAttributes();
        $this->ClientID->PlaceHolder = RemoveHtml($this->ClientID->caption());

        // ManagerID
        $this->ManagerID->setupEditAttributes();
        $this->ManagerID->PlaceHolder = RemoveHtml($this->ManagerID->caption());

        // ProjectTemplateID
        $this->ProjectTemplateID->setupEditAttributes();
        $this->ProjectTemplateID->PlaceHolder = RemoveHtml($this->ProjectTemplateID->caption());

        // Priority
        $this->Priority->setupEditAttributes();
        $this->Priority->EditValue = $this->Priority->options(true);
        $this->Priority->PlaceHolder = RemoveHtml($this->Priority->caption());

        // Description
        $this->Description->setupEditAttributes();
        $this->Description->EditValue = $this->Description->CurrentValue;
        $this->Description->PlaceHolder = RemoveHtml($this->Description->caption());

        // ProjectValue
        $this->ProjectValue->setupEditAttributes();
        $this->ProjectValue->EditValue = $this->ProjectValue->CurrentValue;
        $this->ProjectValue->PlaceHolder = RemoveHtml($this->ProjectValue->caption());
        if (strval($this->ProjectValue->EditValue) != "" && is_numeric($this->ProjectValue->EditValue)) {
            $this->ProjectValue->EditValue = FormatNumber($this->ProjectValue->EditValue, null);
        }

        // ProjectDebt
        $this->ProjectDebt->setupEditAttributes();
        $this->ProjectDebt->EditValue = $this->ProjectDebt->CurrentValue;
        $this->ProjectDebt->PlaceHolder = RemoveHtml($this->ProjectDebt->caption());
        if (strval($this->ProjectDebt->EditValue) != "" && is_numeric($this->ProjectDebt->EditValue)) {
            $this->ProjectDebt->EditValue = FormatNumber($this->ProjectDebt->EditValue, null);
        }

        // PONumber
        $this->PONumber->setupEditAttributes();
        if (!$this->PONumber->Raw) {
            $this->PONumber->CurrentValue = HtmlDecode($this->PONumber->CurrentValue);
        }
        $this->PONumber->EditValue = $this->PONumber->CurrentValue;
        $this->PONumber->PlaceHolder = RemoveHtml($this->PONumber->caption());

        // PaymentLink
        $this->PaymentLink->setupEditAttributes();
        $this->PaymentLink->EditValue = $this->PaymentLink->CurrentValue;
        $this->PaymentLink->PlaceHolder = RemoveHtml($this->PaymentLink->caption());

        // ClearingDate
        $this->ClearingDate->setupEditAttributes();
        $this->ClearingDate->EditValue = FormatDateTime($this->ClearingDate->CurrentValue, $this->ClearingDate->formatPattern());
        $this->ClearingDate->PlaceHolder = RemoveHtml($this->ClearingDate->caption());

        // ClearingAging
        $this->ClearingAging->setupEditAttributes();
        $this->ClearingAging->EditValue = $this->ClearingAging->CurrentValue;
        $this->ClearingAging->PlaceHolder = RemoveHtml($this->ClearingAging->caption());
        if (strval($this->ClearingAging->EditValue) != "" && is_numeric($this->ClearingAging->EditValue)) {
            $this->ClearingAging->EditValue = FormatNumber($this->ClearingAging->EditValue, null);
        }

        // Active
        $this->Active->EditValue = $this->Active->options(false);
        $this->Active->PlaceHolder = RemoveHtml($this->Active->caption());

        // Created_Date
        $this->Created_Date->setupEditAttributes();
        $this->Created_Date->CurrentValue = FormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());

        // Created_By
        $this->Created_By->setupEditAttributes();

        // Last_Updated_Date

        // Last_Updated_By

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->ProjectValue->CurrentValue)) {
                $this->ProjectValue->Total += $this->ProjectValue->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->ProjectDebt->CurrentValue)) {
                $this->ProjectDebt->Total += $this->ProjectDebt->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->ProjectValue->CurrentValue = $this->ProjectValue->Total;
            $this->ProjectValue->ViewValue = $this->ProjectValue->CurrentValue;
            $this->ProjectValue->ViewValue = FormatNumber($this->ProjectValue->ViewValue, $this->ProjectValue->formatPattern());
            $this->ProjectValue->CellCssStyle .= "text-align: right;";
            $this->ProjectValue->HrefValue = ""; // Clear href value
            $this->ProjectDebt->CurrentValue = $this->ProjectDebt->Total;
            $this->ProjectDebt->ViewValue = $this->ProjectDebt->CurrentValue;
            $this->ProjectDebt->ViewValue = FormatNumber($this->ProjectDebt->ViewValue, $this->ProjectDebt->formatPattern());
            $this->ProjectDebt->CellCssStyle .= "text-align: right;";
            $this->ProjectDebt->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->_ProjectID);
                    $doc->exportCaption($this->ProjectName);
                    $doc->exportCaption($this->PlanStart);
                    $doc->exportCaption($this->PlanEnd);
                    $doc->exportCaption($this->StartDate);
                    $doc->exportCaption($this->EndDate);
                    $doc->exportCaption($this->WarrantyEnd);
                    $doc->exportCaption($this->Status);
                    $doc->exportCaption($this->Progress);
                    $doc->exportCaption($this->Target);
                    $doc->exportCaption($this->Track);
                    $doc->exportCaption($this->PaymentProgress);
                    $doc->exportCaption($this->PaymentDate);
                    $doc->exportCaption($this->PaymentComplete);
                    $doc->exportCaption($this->AgingPayment);
                    $doc->exportCaption($this->ClientID);
                    $doc->exportCaption($this->ManagerID);
                    $doc->exportCaption($this->ProjectTemplateID);
                    $doc->exportCaption($this->Priority);
                    $doc->exportCaption($this->Description);
                    $doc->exportCaption($this->ProjectValue);
                    $doc->exportCaption($this->ProjectDebt);
                    $doc->exportCaption($this->PONumber);
                    $doc->exportCaption($this->PaymentLink);
                    $doc->exportCaption($this->ClearingDate);
                    $doc->exportCaption($this->ClearingAging);
                    $doc->exportCaption($this->Active);
                    $doc->exportCaption($this->Created_Date);
                    $doc->exportCaption($this->Created_By);
                    $doc->exportCaption($this->Last_Updated_Date);
                    $doc->exportCaption($this->Last_Updated_By);
                } else {
                    $doc->exportCaption($this->_ProjectID);
                    $doc->exportCaption($this->ProjectName);
                    $doc->exportCaption($this->PlanStart);
                    $doc->exportCaption($this->PlanEnd);
                    $doc->exportCaption($this->StartDate);
                    $doc->exportCaption($this->EndDate);
                    $doc->exportCaption($this->WarrantyEnd);
                    $doc->exportCaption($this->Status);
                    $doc->exportCaption($this->Progress);
                    $doc->exportCaption($this->Target);
                    $doc->exportCaption($this->Track);
                    $doc->exportCaption($this->PaymentProgress);
                    $doc->exportCaption($this->PaymentDate);
                    $doc->exportCaption($this->PaymentComplete);
                    $doc->exportCaption($this->AgingPayment);
                    $doc->exportCaption($this->ClientID);
                    $doc->exportCaption($this->ManagerID);
                    $doc->exportCaption($this->ProjectTemplateID);
                    $doc->exportCaption($this->Priority);
                    $doc->exportCaption($this->Description);
                    $doc->exportCaption($this->ProjectValue);
                    $doc->exportCaption($this->ProjectDebt);
                    $doc->exportCaption($this->PONumber);
                    $doc->exportCaption($this->PaymentLink);
                    $doc->exportCaption($this->ClearingDate);
                    $doc->exportCaption($this->ClearingAging);
                    $doc->exportCaption($this->Active);
                    $doc->exportCaption($this->Created_Date);
                    $doc->exportCaption($this->Created_By);
                    $doc->exportCaption($this->Last_Updated_Date);
                    $doc->exportCaption($this->Last_Updated_By);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->_ProjectID);
                        $doc->exportField($this->ProjectName);
                        $doc->exportField($this->PlanStart);
                        $doc->exportField($this->PlanEnd);
                        $doc->exportField($this->StartDate);
                        $doc->exportField($this->EndDate);
                        $doc->exportField($this->WarrantyEnd);
                        $doc->exportField($this->Status);
                        $doc->exportField($this->Progress);
                        $doc->exportField($this->Target);
                        $doc->exportField($this->Track);
                        $doc->exportField($this->PaymentProgress);
                        $doc->exportField($this->PaymentDate);
                        $doc->exportField($this->PaymentComplete);
                        $doc->exportField($this->AgingPayment);
                        $doc->exportField($this->ClientID);
                        $doc->exportField($this->ManagerID);
                        $doc->exportField($this->ProjectTemplateID);
                        $doc->exportField($this->Priority);
                        $doc->exportField($this->Description);
                        $doc->exportField($this->ProjectValue);
                        $doc->exportField($this->ProjectDebt);
                        $doc->exportField($this->PONumber);
                        $doc->exportField($this->PaymentLink);
                        $doc->exportField($this->ClearingDate);
                        $doc->exportField($this->ClearingAging);
                        $doc->exportField($this->Active);
                        $doc->exportField($this->Created_Date);
                        $doc->exportField($this->Created_By);
                        $doc->exportField($this->Last_Updated_Date);
                        $doc->exportField($this->Last_Updated_By);
                    } else {
                        $doc->exportField($this->_ProjectID);
                        $doc->exportField($this->ProjectName);
                        $doc->exportField($this->PlanStart);
                        $doc->exportField($this->PlanEnd);
                        $doc->exportField($this->StartDate);
                        $doc->exportField($this->EndDate);
                        $doc->exportField($this->WarrantyEnd);
                        $doc->exportField($this->Status);
                        $doc->exportField($this->Progress);
                        $doc->exportField($this->Target);
                        $doc->exportField($this->Track);
                        $doc->exportField($this->PaymentProgress);
                        $doc->exportField($this->PaymentDate);
                        $doc->exportField($this->PaymentComplete);
                        $doc->exportField($this->AgingPayment);
                        $doc->exportField($this->ClientID);
                        $doc->exportField($this->ManagerID);
                        $doc->exportField($this->ProjectTemplateID);
                        $doc->exportField($this->Priority);
                        $doc->exportField($this->Description);
                        $doc->exportField($this->ProjectValue);
                        $doc->exportField($this->ProjectDebt);
                        $doc->exportField($this->PONumber);
                        $doc->exportField($this->PaymentLink);
                        $doc->exportField($this->ClearingDate);
                        $doc->exportField($this->ClearingAging);
                        $doc->exportField($this->Active);
                        $doc->exportField($this->Created_Date);
                        $doc->exportField($this->Created_By);
                        $doc->exportField($this->Last_Updated_Date);
                        $doc->exportField($this->Last_Updated_By);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->_ProjectID, '');
                $doc->exportAggregate($this->ProjectName, '');
                $doc->exportAggregate($this->PlanStart, '');
                $doc->exportAggregate($this->PlanEnd, '');
                $doc->exportAggregate($this->StartDate, '');
                $doc->exportAggregate($this->EndDate, '');
                $doc->exportAggregate($this->WarrantyEnd, '');
                $doc->exportAggregate($this->Status, '');
                $doc->exportAggregate($this->Progress, '');
                $doc->exportAggregate($this->Target, '');
                $doc->exportAggregate($this->Track, '');
                $doc->exportAggregate($this->PaymentProgress, '');
                $doc->exportAggregate($this->PaymentDate, '');
                $doc->exportAggregate($this->PaymentComplete, '');
                $doc->exportAggregate($this->AgingPayment, '');
                $doc->exportAggregate($this->ClientID, '');
                $doc->exportAggregate($this->ManagerID, '');
                $doc->exportAggregate($this->ProjectTemplateID, '');
                $doc->exportAggregate($this->Priority, '');
                $doc->exportAggregate($this->Description, '');
                $doc->exportAggregate($this->ProjectValue, 'TOTAL');
                $doc->exportAggregate($this->ProjectDebt, 'TOTAL');
                $doc->exportAggregate($this->PONumber, '');
                $doc->exportAggregate($this->PaymentLink, '');
                $doc->exportAggregate($this->ClearingDate, '');
                $doc->exportAggregate($this->ClearingAging, '');
                $doc->exportAggregate($this->Active, '');
                $doc->exportAggregate($this->Created_Date, '');
                $doc->exportAggregate($this->Created_By, '');
                $doc->exportAggregate($this->Last_Updated_Date, '');
                $doc->exportAggregate($this->Last_Updated_By, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Masukkan kode Anda di sini
        if (in_array(CurrentUserLevel(), array("4", "5", "6","7","8","9","10"))) {
            $currentUser = CurrentUserName(); // Ambil nama pengguna saat ini
            // Pastikan untuk meng-escape string nama pengguna untuk keamanan
            $currentUser = addslashes($currentUser);

            // Perbarui filter dengan query yang benar
             $existsClause = "(EXISTS (
                    SELECT 1 FROM vprojectid 
                    WHERE vprojectid.projectid = masterproject.projectid 
                    AND vprojectid.UserName = '" . $currentUser . "'
                ) OR Created_By='" .  $currentUser . "')";
            if (strlen($filter) == 0) {
                $filter = $existsClause;
            } else {
                $filter .= ' AND ' . $existsClause;
            }
        }
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Cek apakah "ProjectValue" ada dan lebih besar dari 0
        // dan cek apakah "ProjectDebt" tidak ada atau sama dengan 0
        if (isset($rsnew["ProjectValue"]) && $rsnew["ProjectValue"] > 0 &&
            (!isset($rsnew["ProjectDebt"]) || $rsnew["ProjectDebt"] == 0)) {
            // Set "ProjectDebt" sama dengan "ProjectValue"
            $rsnew["ProjectDebt"] = $rsnew["ProjectValue"];
        }
        $rsnew["Created_Date"] = CurrentDate();
        $rsnew["Created_By"] = CurrentUserName();
        return true;
    }
    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
       $projectIdToUpdate = isset($rsnew["ProjectID"]) ? $rsnew["ProjectID"] : $rsold["ProjectID"];
        $queryCount = "SELECT COUNT(*) as countResult FROM projectresult WHERE ProjectID = " . $projectIdToUpdate;

        // Eksekusi query untuk menghitung jumlah entri
        $countResult = ExecuteRow($queryCount); // Anda perlu mengganti ExecuteQuery dengan fungsi yang sesuai
        if ($countResult && $countResult["countResult"] == 0) {
            // Query untuk memasukkan data ke projectresult jika belum ada entri dengan ProjectID yang sama
                 $queryInsert = "INSERT INTO projectresult (Activities, ProjectID, Status, Progress, Weight,  Category,templateid,Created_Date, Created_By, Last_Updated_Date, Last_Updated_By)
                    SELECT a.Activities, b.ProjectID as ProjectID, 'Not Started' as Status,0 as Progress,Weight,Category,a.ResultID,
                           NOW() as Created_Date, '" . CurrentUserName() . "' as Created_By,
                           NOW() as Last_Updated_Date, '" . CurrentUserName() . "' as Last_Updated_By
                    FROM projecttemplateresult a
                    INNER JOIN masterproject b ON a.templateid = b.ProjectTemplateID
                    WHERE b.ProjectID = " . $projectIdToUpdate;
            // Eksekusi query untuk memasukkan data
            $result = ExecuteQuery($queryInsert); // Anda perlu mengganti ExecuteQuery dengan fungsi yang sesuai
        }
          $queryCountpayment = "SELECT COUNT(*) as countResult FROM projectpaymentprocess WHERE ProjectID = " . $projectIdToUpdate;

        // Eksekusi query untuk menghitung jumlah entri
        $countResultpayment = ExecuteRow($queryCountpayment); // Anda perlu mengganti ExecuteQuery dengan fungsi yang sesuai
        if ($countResultpayment && $countResultpayment["countResult"] == 0) {
            // Query untuk memasukkan data ke projectresult jika belum ada entri dengan ProjectID yang sama
                 $queryInsertpayment = "INSERT INTO projectpaymentprocess (DocumentName, ProjectID, Completed,templateid,Created_Date, Created_By, Last_Updated_Date, Last_Updated_By,PICClient)
                    SELECT a.DocumentName, b.ProjectID as ProjectID, 0 as Completed,a.PaymentProcessID,
                           NOW() as Created_Date, '" . CurrentUserName() . "' as Created_By,
                           NOW() as Last_Updated_Date, '" . CurrentUserName() . "' as Last_Updated_By,a.PICClient
                    FROM projecttemplatepaymentprocess a
                    INNER JOIN masterproject b ON a.templateid = b.ProjectTemplateID
                    WHERE b.ProjectID = " . $projectIdToUpdate;
            // Eksekusi query untuk memasukkan data
            $result = ExecuteQuery($queryInsertpayment); // Anda perlu mengganti ExecuteQuery dengan fungsi yang sesuai
        }
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Cek apakah "ProjectValue" ada dan lebih besar dari 0
        // dan cek apakah "ProjectDebt" tidak ada atau sama dengan 0
        if (isset($rsnew["ProjectValue"]) && $rsnew["ProjectValue"] > 0 &&
            (!isset($rsnew["ProjectDebt"]) || $rsnew["ProjectDebt"] == 0)) {
            // Set "ProjectDebt" sama dengan "ProjectValue"
            $rsnew["ProjectDebt"] = $rsnew["ProjectValue"];
        }
        return true;
    }
    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
       $projectIdToUpdate = isset($rsnew["ProjectID"]) ? $rsnew["ProjectID"] : $rsold["ProjectID"];

            // Query untuk menghitung jumlah entri di tabel projectresult dengan ProjectID yang sama
        $queryCount = "SELECT COUNT(*) as countResult FROM projectresult WHERE ProjectID = " .  $projectIdToUpdate;

        // Eksekusi query untuk menghitung jumlah entri
        $countResult = ExecuteRow($queryCount); // Anda perlu mengganti ExecuteQuery dengan fungsi yang sesuai
        if ($countResult && $countResult["countResult"] == 0) {
                  $queryInsert = "INSERT INTO projectresult (Activities, ProjectID, Status, Progress, Weight, Category,templateid, Created_Date, Created_By, Last_Updated_Date, Last_Updated_By)
                    SELECT a.Activities, b.ProjectID as ProjectID, 'Not Started' as Status,0 as Progress,Weight,Category,a.ResultID,
                           NOW() as Created_Date, '" . CurrentUserName() . "' as Created_By,
                           NOW() as Last_Updated_Date, '" . CurrentUserName() . "' as Last_Updated_By
                    FROM projecttemplateresult a
                    INNER JOIN masterproject b ON a.templateid = b.ProjectTemplateID
                    WHERE b.ProjectID = " .  $projectIdToUpdate ;

            // Eksekusi query untuk memasukkan data
            $result = ExecuteQuery($queryInsert); // Anda perlu mengganti ExecuteQuery dengan fungsi yang sesuai
        }
         $queryCountpayment = "SELECT COUNT(*) as countResult FROM projectpaymentprocess WHERE ProjectID = " . $rsnew["ProjectID"];

        // Eksekusi query untuk menghitung jumlah entri
        $countResultpayment = ExecuteRow($queryCountpayment); // Anda perlu mengganti ExecuteQuery dengan fungsi yang sesuai
        if ($countResultpayment && $countResultpayment["countResult"] == 0) {
            // Query untuk memasukkan data ke projectresult jika belum ada entri dengan ProjectID yang sama
                 $queryInsertpayment = "INSERT INTO projectpaymentprocess (DocumentName, ProjectID, Completed,templateid,Created_Date, Created_By, Last_Updated_Date, Last_Updated_By,PICClient)
                    SELECT a.DocumentName, b.ProjectID as ProjectID, 0 as Completed,a.PaymentProcessID,
                           NOW() as Created_Date, '" . CurrentUserName() . "' as Created_By,
                           NOW() as Last_Updated_Date, '" . CurrentUserName() . "' as Last_Updated_By,a.PICClient
                    FROM projecttemplatepaymentprocess a
                    INNER JOIN masterproject b ON a.templateid = b.ProjectTemplateID
                    WHERE b.ProjectID = " .  $projectIdToUpdate ;
            // Eksekusi query untuk memasukkan data
            $result = ExecuteQuery($queryInsertpayment); // Anda perlu mengganti ExecuteQuery dengan fungsi yang sesuai
        }
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        if ($this->Status->CurrentValue == "Finished") {
            $this->Status->CellAttrs["class"] = "table-bg-success";
        }
        if ($this->PaymentProgress->CurrentValue == 1) {
            $this->PaymentProgress->CellAttrs["class"] = "table-bg-success";
        }
        $progress = floatval($this->Progress->CurrentValue);
        $target = floatval($this->Target->CurrentValue);
        $planStart = $this->PlanStart->CurrentValue;
        $planEnd = $this->PlanEnd->CurrentValue;
        $today = CurrentDate();// Membuat objek DateTime

        // Ganti warna latar belakang kolom Progress sesuai kondisi
        if ($today > $planEnd && $progress < 1) {
            // Warna merah
            $this->Progress->CellAttrs["class"] = "table-bg-danger";
        } else if ($target >= $progress) {
            // Warna kuning
            $this->Progress->CellAttrs["class"] = "table-bg-warning";
        } else {
            // Warna hijau
            $this->Progress->CellAttrs["class"] = "table-bg-success";
        }
       if (in_array(CurrentUserLevel(), array("4", "5", "6","7","8","9","10"))) {
            $this->ProjectValue->Visible = FALSE;
            $this->ProjectDebt->Visible = FALSE;
            $this->PONumber->Visible = FALSE;
            $this->PaymentLink->Visible = FALSE;
            $this->ClearingDate->Visible = FALSE;
            $this->ClearingAging->Visible = FALSE;
        }
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
