<?php

namespace ProjectManagement\prjProjectManagement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for masteruser
 */
class Masteruser extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $EmployeeID;
    public $FirstName;
    public $LastName;
    public $FullName;
    public $_Username;
    public $UserPassword;
    public $Level;
    public $_Email;
    public $Position;
    public $Department;
    public $Employee;
    public $WhatsAppNumber;
    public $Active;
    public $Created_Date;
    public $Created_By;
    public $Last_Updated_Date;
    public $Last_Updated_By;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "masteruser";
        $this->TableName = 'masteruser';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "masteruser";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // EmployeeID
        $this->EmployeeID = new DbField(
            $this, // Table
            'x_EmployeeID', // Variable name
            'EmployeeID', // Name
            '`EmployeeID`', // Expression
            '`EmployeeID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`EmployeeID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->EmployeeID->InputTextType = "text";
        $this->EmployeeID->Raw = true;
        $this->EmployeeID->IsAutoIncrement = true; // Autoincrement field
        $this->EmployeeID->IsPrimaryKey = true; // Primary key field
        $this->EmployeeID->Nullable = false; // NOT NULL field
        $this->EmployeeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->EmployeeID->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['EmployeeID'] = &$this->EmployeeID;

        // FirstName
        $this->FirstName = new DbField(
            $this, // Table
            'x_FirstName', // Variable name
            'FirstName', // Name
            '`FirstName`', // Expression
            '`FirstName`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FirstName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FirstName->InputTextType = "text";
        $this->FirstName->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->FirstName->Lookup = new Lookup($this->FirstName, 'masteruser', true, 'FirstName', ["FirstName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->FirstName->Lookup = new Lookup($this->FirstName, 'masteruser', true, 'FirstName', ["FirstName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->FirstName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['FirstName'] = &$this->FirstName;

        // LastName
        $this->LastName = new DbField(
            $this, // Table
            'x_LastName', // Variable name
            'LastName', // Name
            '`LastName`', // Expression
            '`LastName`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`LastName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->LastName->InputTextType = "text";
        $this->LastName->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->LastName->Lookup = new Lookup($this->LastName, 'masteruser', true, 'LastName', ["LastName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->LastName->Lookup = new Lookup($this->LastName, 'masteruser', true, 'LastName', ["LastName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->LastName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['LastName'] = &$this->LastName;

        // FullName
        $this->FullName = new DbField(
            $this, // Table
            'x_FullName', // Variable name
            'FullName', // Name
            'CONCAT(FirstName, \' \', LastName)', // Expression
            'CONCAT(FirstName, \' \', LastName)', // Basic search expression
            200, // Type
            201, // Size
            -1, // Date/Time format
            false, // Is upload field
            'CONCAT(FirstName, \' \', LastName)', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FullName->InputTextType = "text";
        $this->FullName->IsCustom = true; // Custom field
        $this->FullName->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->FullName->Lookup = new Lookup($this->FullName, 'masteruser', true, 'FullName', ["FullName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->FullName->Lookup = new Lookup($this->FullName, 'masteruser', true, 'FullName', ["FullName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->FullName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['FullName'] = &$this->FullName;

        // Username
        $this->_Username = new DbField(
            $this, // Table
            'x__Username', // Variable name
            'Username', // Name
            '`Username`', // Expression
            '`Username`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Username`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_Username->InputTextType = "text";
        $this->_Username->Raw = true;
        $this->_Username->Nullable = false; // NOT NULL field
        $this->_Username->Required = true; // Required field
        $this->_Username->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->_Username->Lookup = new Lookup($this->_Username, 'masteruser', true, 'Username', ["Username","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->_Username->Lookup = new Lookup($this->_Username, 'masteruser', true, 'Username', ["Username","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->_Username->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Username'] = &$this->_Username;

        // UserPassword
        $this->UserPassword = new DbField(
            $this, // Table
            'x_UserPassword', // Variable name
            'UserPassword', // Name
            '`UserPassword`', // Expression
            '`UserPassword`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`UserPassword`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'PASSWORD' // Edit Tag
        );
        $this->UserPassword->InputTextType = "text";
        $this->UserPassword->Nullable = false; // NOT NULL field
        $this->UserPassword->Required = true; // Required field
        $this->UserPassword->SearchOperators = ["=", "<>"];
        $this->Fields['UserPassword'] = &$this->UserPassword;

        // Level
        $this->Level = new DbField(
            $this, // Table
            'x_Level', // Variable name
            'Level', // Name
            '`Level`', // Expression
            '`Level`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Level`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Level->addMethod("getDefault", fn() => 4);
        $this->Level->InputTextType = "text";
        $this->Level->Raw = true;
        $this->Level->Nullable = false; // NOT NULL field
        $this->Level->Required = true; // Required field
        $this->Level->setSelectMultiple(false); // Select one
        $this->Level->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Level->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->Level->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Level->Lookup = new Lookup($this->Level, 'userlevels', true, 'userlevelid', ["userlevelname","","",""], '', '', [], [], [], [], [], [], false, '', '', "`userlevelname`");
                break;
            default:
                $this->Level->Lookup = new Lookup($this->Level, 'userlevels', true, 'userlevelid', ["userlevelname","","",""], '', '', [], [], [], [], [], [], false, '', '', "`userlevelname`");
                break;
        }
        $this->Level->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Level->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Level'] = &$this->Level;

        // Email
        $this->_Email = new DbField(
            $this, // Table
            'x__Email', // Variable name
            'Email', // Name
            '`Email`', // Expression
            '`Email`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_Email->InputTextType = "text";
        $this->_Email->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->_Email->Lookup = new Lookup($this->_Email, 'masteruser', true, 'Email', ["Email","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->_Email->Lookup = new Lookup($this->_Email, 'masteruser', true, 'Email', ["Email","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->_Email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Email'] = &$this->_Email;

        // Position
        $this->Position = new DbField(
            $this, // Table
            'x_Position', // Variable name
            'Position', // Name
            '`Position`', // Expression
            '`Position`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Position`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Position->InputTextType = "text";
        $this->Position->setSelectMultiple(false); // Select one
        $this->Position->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Position->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->Position->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Position->Lookup = new Lookup($this->Position, 'masteruser', true, 'Position', ["Position","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Position->Lookup = new Lookup($this->Position, 'masteruser', true, 'Position', ["Position","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Position->OptionCount = 7;
        $this->Position->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Position'] = &$this->Position;

        // Department
        $this->Department = new DbField(
            $this, // Table
            'x_Department', // Variable name
            'Department', // Name
            '`Department`', // Expression
            '`Department`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Department`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Department->InputTextType = "text";
        $this->Department->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Department->Lookup = new Lookup($this->Department, 'masteruser', true, 'Department', ["Department","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Department->Lookup = new Lookup($this->Department, 'masteruser', true, 'Department', ["Department","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Department->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Department'] = &$this->Department;

        // Employee
        $this->Employee = new DbField(
            $this, // Table
            'x_Employee', // Variable name
            'Employee', // Name
            '`Employee`', // Expression
            '`Employee`', // Basic search expression
            200, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Employee`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->Employee->addMethod("getDefault", fn() => 1);
        $this->Employee->InputTextType = "text";
        $this->Employee->Raw = true;
        $this->Employee->setDataType(DataType::BIT);
        $this->Employee->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Employee->Lookup = new Lookup($this->Employee, 'masteruser', true, 'Employee', ["Employee","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Employee->Lookup = new Lookup($this->Employee, 'masteruser', true, 'Employee', ["Employee","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Employee->OptionCount = 2;
        $this->Employee->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Employee'] = &$this->Employee;

        // WhatsAppNumber
        $this->WhatsAppNumber = new DbField(
            $this, // Table
            'x_WhatsAppNumber', // Variable name
            'WhatsAppNumber', // Name
            '`WhatsAppNumber`', // Expression
            '`WhatsAppNumber`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`WhatsAppNumber`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->WhatsAppNumber->InputTextType = "text";
        $this->WhatsAppNumber->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->WhatsAppNumber->Lookup = new Lookup($this->WhatsAppNumber, 'masteruser', true, 'WhatsAppNumber', ["WhatsAppNumber","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->WhatsAppNumber->Lookup = new Lookup($this->WhatsAppNumber, 'masteruser', true, 'WhatsAppNumber', ["WhatsAppNumber","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->WhatsAppNumber->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['WhatsAppNumber'] = &$this->WhatsAppNumber;

        // Active
        $this->Active = new DbField(
            $this, // Table
            'x_Active', // Variable name
            'Active', // Name
            '`Active`', // Expression
            '`Active`', // Basic search expression
            200, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Active`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->Active->addMethod("getDefault", fn() => 1);
        $this->Active->InputTextType = "text";
        $this->Active->Raw = true;
        $this->Active->setDataType(DataType::BIT);
        $this->Active->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Active->Lookup = new Lookup($this->Active, 'masteruser', true, 'Active', ["Active","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Active->Lookup = new Lookup($this->Active, 'masteruser', true, 'Active', ["Active","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Active->OptionCount = 2;
        $this->Active->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Active'] = &$this->Active;

        // Created_Date
        $this->Created_Date = new DbField(
            $this, // Table
            'x_Created_Date', // Variable name
            'Created_Date', // Name
            '`Created_Date`', // Expression
            CastDateFieldForLike("`Created_Date`", 109, "DB"), // Basic search expression
            135, // Type
            19, // Size
            109, // Date/Time format
            false, // Is upload field
            '`Created_Date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Created_Date->addMethod("getDefault", fn() => CurrentDateTime());
        $this->Created_Date->InputTextType = "text";
        $this->Created_Date->Raw = true;
        $this->Created_Date->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Created_Date->Lookup = new Lookup($this->Created_Date, 'masteruser', true, 'Created_Date', ["Created_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Created_Date->Lookup = new Lookup($this->Created_Date, 'masteruser', true, 'Created_Date', ["Created_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Created_Date->DefaultErrorMessage = str_replace("%s", DateFormat(109), $Language->phrase("IncorrectDate"));
        $this->Created_Date->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Created_Date'] = &$this->Created_Date;

        // Created_By
        $this->Created_By = new DbField(
            $this, // Table
            'x_Created_By', // Variable name
            'Created_By', // Name
            '`Created_By`', // Expression
            '`Created_By`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Created_By`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Created_By->addMethod("getDefault", fn() => CurrentUserName());
        $this->Created_By->InputTextType = "text";
        $this->Created_By->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Created_By->Lookup = new Lookup($this->Created_By, 'masteruser', true, 'Created_By', ["Created_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Created_By->Lookup = new Lookup($this->Created_By, 'masteruser', true, 'Created_By', ["Created_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Created_By->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Created_By'] = &$this->Created_By;

        // Last_Updated_Date
        $this->Last_Updated_Date = new DbField(
            $this, // Table
            'x_Last_Updated_Date', // Variable name
            'Last_Updated_Date', // Name
            '`Last_Updated_Date`', // Expression
            CastDateFieldForLike("`Last_Updated_Date`", 109, "DB"), // Basic search expression
            135, // Type
            19, // Size
            109, // Date/Time format
            false, // Is upload field
            '`Last_Updated_Date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Last_Updated_Date->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->Last_Updated_Date->addMethod("getDefault", fn() => CurrentDateTime());
        $this->Last_Updated_Date->InputTextType = "text";
        $this->Last_Updated_Date->Raw = true;
        $this->Last_Updated_Date->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Last_Updated_Date->Lookup = new Lookup($this->Last_Updated_Date, 'masteruser', true, 'Last_Updated_Date', ["Last_Updated_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Last_Updated_Date->Lookup = new Lookup($this->Last_Updated_Date, 'masteruser', true, 'Last_Updated_Date', ["Last_Updated_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Last_Updated_Date->DefaultErrorMessage = str_replace("%s", DateFormat(109), $Language->phrase("IncorrectDate"));
        $this->Last_Updated_Date->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Last_Updated_Date'] = &$this->Last_Updated_Date;

        // Last_Updated_By
        $this->Last_Updated_By = new DbField(
            $this, // Table
            'x_Last_Updated_By', // Variable name
            'Last_Updated_By', // Name
            '`Last_Updated_By`', // Expression
            '`Last_Updated_By`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Last_Updated_By`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Last_Updated_By->addMethod("getAutoUpdateValue", fn() => CurrentUserName());
        $this->Last_Updated_By->addMethod("getDefault", fn() => CurrentUserName());
        $this->Last_Updated_By->InputTextType = "text";
        $this->Last_Updated_By->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Last_Updated_By->Lookup = new Lookup($this->Last_Updated_By, 'masteruser', true, 'Last_Updated_By', ["Last_Updated_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Last_Updated_By->Lookup = new Lookup($this->Last_Updated_By, 'masteruser', true, 'Last_Updated_By', ["Last_Updated_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Last_Updated_By->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Last_Updated_By'] = &$this->Last_Updated_By;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "masteruser";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        return "*, CONCAT(FirstName, ' ', LastName) AS `FullName`";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            if (Config("ENCRYPTED_PASSWORD") && $name == Config("LOGIN_PASSWORD_FIELD_NAME")) {
                $value = EncryptPassword(Config("CASE_SENSITIVE_PASSWORD") ? $value : strtolower($value));
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->EmployeeID->setDbValue($conn->lastInsertId());
            $rs['EmployeeID'] = $this->EmployeeID->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            if (Config("ENCRYPTED_PASSWORD") && $name == Config("LOGIN_PASSWORD_FIELD_NAME")) {
                if ($value == $this->Fields[$name]->OldValue) { // No need to update hashed password if not changed
                    continue;
                }
                $value = EncryptPassword(Config("CASE_SENSITIVE_PASSWORD") ? $value : strtolower($value));
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['EmployeeID']) && !EmptyValue($this->EmployeeID->CurrentValue)) {
                $rs['EmployeeID'] = $this->EmployeeID->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('EmployeeID', $rs)) {
                AddFilter($where, QuotedName('EmployeeID', $this->Dbid) . '=' . QuotedValue($rs['EmployeeID'], $this->EmployeeID->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->EmployeeID->DbValue = $row['EmployeeID'];
        $this->FirstName->DbValue = $row['FirstName'];
        $this->LastName->DbValue = $row['LastName'];
        $this->FullName->DbValue = $row['FullName'];
        $this->_Username->DbValue = $row['Username'];
        $this->UserPassword->DbValue = $row['UserPassword'];
        $this->Level->DbValue = $row['Level'];
        $this->_Email->DbValue = $row['Email'];
        $this->Position->DbValue = $row['Position'];
        $this->Department->DbValue = $row['Department'];
        $this->Employee->DbValue = $row['Employee'];
        $this->WhatsAppNumber->DbValue = $row['WhatsAppNumber'];
        $this->Active->DbValue = $row['Active'];
        $this->Created_Date->DbValue = $row['Created_Date'];
        $this->Created_By->DbValue = $row['Created_By'];
        $this->Last_Updated_Date->DbValue = $row['Last_Updated_Date'];
        $this->Last_Updated_By->DbValue = $row['Last_Updated_By'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`EmployeeID` = @EmployeeID@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->EmployeeID->CurrentValue : $this->EmployeeID->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->EmployeeID->CurrentValue = $keys[0];
            } else {
                $this->EmployeeID->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('EmployeeID', $row) ? $row['EmployeeID'] : null;
        } else {
            $val = !EmptyValue($this->EmployeeID->OldValue) && !$current ? $this->EmployeeID->OldValue : $this->EmployeeID->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@EmployeeID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("masteruserlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "masteruserview" => $Language->phrase("View"),
            "masteruseredit" => $Language->phrase("Edit"),
            "masteruseradd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "masteruserlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "MasteruserView",
            Config("API_ADD_ACTION") => "MasteruserAdd",
            Config("API_EDIT_ACTION") => "MasteruserEdit",
            Config("API_DELETE_ACTION") => "MasteruserDelete",
            Config("API_LIST_ACTION") => "MasteruserList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "masteruserlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("masteruserview", $parm);
        } else {
            $url = $this->keyUrl("masteruserview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "masteruseradd?" . $parm;
        } else {
            $url = "masteruseradd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("masteruseredit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("masteruserlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("masteruseradd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("masteruserlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("masteruserdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"EmployeeID\":" . VarToJson($this->EmployeeID->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->EmployeeID->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->EmployeeID->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("EmployeeID") ?? Route("EmployeeID")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->EmployeeID->CurrentValue = $key;
            } else {
                $this->EmployeeID->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->EmployeeID->setDbValue($row['EmployeeID']);
        $this->FirstName->setDbValue($row['FirstName']);
        $this->LastName->setDbValue($row['LastName']);
        $this->FullName->setDbValue($row['FullName']);
        $this->_Username->setDbValue($row['Username']);
        $this->UserPassword->setDbValue($row['UserPassword']);
        $this->Level->setDbValue($row['Level']);
        $this->_Email->setDbValue($row['Email']);
        $this->Position->setDbValue($row['Position']);
        $this->Department->setDbValue($row['Department']);
        $this->Employee->setDbValue($row['Employee']);
        $this->WhatsAppNumber->setDbValue($row['WhatsAppNumber']);
        $this->Active->setDbValue($row['Active']);
        $this->Created_Date->setDbValue($row['Created_Date']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->Last_Updated_Date->setDbValue($row['Last_Updated_Date']);
        $this->Last_Updated_By->setDbValue($row['Last_Updated_By']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "MasteruserList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // EmployeeID

        // FirstName
        $this->FirstName->CellCssStyle = "white-space: nowrap;";

        // LastName
        $this->LastName->CellCssStyle = "white-space: nowrap;";

        // FullName
        $this->FullName->CellCssStyle = "white-space: nowrap;";

        // Username
        $this->_Username->CellCssStyle = "white-space: nowrap;";

        // UserPassword
        $this->UserPassword->CellCssStyle = "white-space: nowrap;";

        // Level
        $this->Level->CellCssStyle = "white-space: nowrap;";

        // Email
        $this->_Email->CellCssStyle = "white-space: nowrap;";

        // Position
        $this->Position->CellCssStyle = "white-space: nowrap;";

        // Department
        $this->Department->CellCssStyle = "white-space: nowrap;";

        // Employee
        $this->Employee->CellCssStyle = "white-space: nowrap;";

        // WhatsAppNumber
        $this->WhatsAppNumber->CellCssStyle = "white-space: nowrap;";

        // Active
        $this->Active->CellCssStyle = "white-space: nowrap;";

        // Created_Date
        $this->Created_Date->CellCssStyle = "white-space: nowrap;";

        // Created_By
        $this->Created_By->CellCssStyle = "white-space: nowrap;";

        // Last_Updated_Date
        $this->Last_Updated_Date->CellCssStyle = "white-space: nowrap;";

        // Last_Updated_By
        $this->Last_Updated_By->CellCssStyle = "white-space: nowrap;";

        // EmployeeID
        $this->EmployeeID->ViewValue = $this->EmployeeID->CurrentValue;

        // FirstName
        $this->FirstName->ViewValue = $this->FirstName->CurrentValue;

        // LastName
        $this->LastName->ViewValue = $this->LastName->CurrentValue;

        // FullName
        $this->FullName->ViewValue = $this->FullName->CurrentValue;

        // Username
        $this->_Username->ViewValue = $this->_Username->CurrentValue;

        // UserPassword
        $this->UserPassword->ViewValue = $Language->phrase("PasswordMask");

        // Level
        if ($Security->canAdmin()) { // System admin
            $curVal = strval($this->Level->CurrentValue);
            if ($curVal != "") {
                $this->Level->ViewValue = $this->Level->lookupCacheOption($curVal);
                if ($this->Level->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Level->Lookup->getTable()->Fields["userlevelid"]->searchExpression(), "=", $curVal, $this->Level->Lookup->getTable()->Fields["userlevelid"]->searchDataType(), "");
                    $sqlWrk = $this->Level->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Level->Lookup->renderViewRow($rswrk[0]);
                        $this->Level->ViewValue = $this->Level->displayValue($arwrk);
                    } else {
                        $this->Level->ViewValue = FormatNumber($this->Level->CurrentValue, $this->Level->formatPattern());
                    }
                }
            } else {
                $this->Level->ViewValue = null;
            }
        } else {
            $this->Level->ViewValue = $Language->phrase("PasswordMask");
        }

        // Email
        $this->_Email->ViewValue = $this->_Email->CurrentValue;

        // Position
        if (strval($this->Position->CurrentValue) != "") {
            $this->Position->ViewValue = $this->Position->optionCaption($this->Position->CurrentValue);
        } else {
            $this->Position->ViewValue = null;
        }

        // Department
        $this->Department->ViewValue = $this->Department->CurrentValue;

        // Employee
        if (ConvertToBool($this->Employee->CurrentValue)) {
            $this->Employee->ViewValue = $this->Employee->tagCaption(1) != "" ? $this->Employee->tagCaption(1) : "Yes";
        } else {
            $this->Employee->ViewValue = $this->Employee->tagCaption(2) != "" ? $this->Employee->tagCaption(2) : "No";
        }
        $this->Employee->CellCssStyle .= "text-align: center;";

        // WhatsAppNumber
        $this->WhatsAppNumber->ViewValue = $this->WhatsAppNumber->CurrentValue;

        // Active
        if (ConvertToBool($this->Active->CurrentValue)) {
            $this->Active->ViewValue = $this->Active->tagCaption(1) != "" ? $this->Active->tagCaption(1) : "Yes";
        } else {
            $this->Active->ViewValue = $this->Active->tagCaption(2) != "" ? $this->Active->tagCaption(2) : "No";
        }
        $this->Active->CellCssStyle .= "text-align: center;";

        // Created_Date
        $this->Created_Date->ViewValue = $this->Created_Date->CurrentValue;
        $this->Created_Date->ViewValue = FormatDateTime($this->Created_Date->ViewValue, $this->Created_Date->formatPattern());

        // Created_By
        $this->Created_By->ViewValue = $this->Created_By->CurrentValue;

        // Last_Updated_Date
        $this->Last_Updated_Date->ViewValue = $this->Last_Updated_Date->CurrentValue;
        $this->Last_Updated_Date->ViewValue = FormatDateTime($this->Last_Updated_Date->ViewValue, $this->Last_Updated_Date->formatPattern());

        // Last_Updated_By
        $this->Last_Updated_By->ViewValue = $this->Last_Updated_By->CurrentValue;

        // EmployeeID
        $this->EmployeeID->HrefValue = "";
        $this->EmployeeID->TooltipValue = "";

        // FirstName
        $this->FirstName->HrefValue = "";
        $this->FirstName->TooltipValue = "";

        // LastName
        $this->LastName->HrefValue = "";
        $this->LastName->TooltipValue = "";

        // FullName
        $this->FullName->HrefValue = "";
        $this->FullName->TooltipValue = "";

        // Username
        $this->_Username->HrefValue = "";
        $this->_Username->TooltipValue = "";

        // UserPassword
        $this->UserPassword->HrefValue = "";
        $this->UserPassword->TooltipValue = "";

        // Level
        $this->Level->HrefValue = "";
        $this->Level->TooltipValue = "";

        // Email
        $this->_Email->HrefValue = "";
        $this->_Email->TooltipValue = "";

        // Position
        $this->Position->HrefValue = "";
        $this->Position->TooltipValue = "";

        // Department
        $this->Department->HrefValue = "";
        $this->Department->TooltipValue = "";

        // Employee
        $this->Employee->HrefValue = "";
        $this->Employee->TooltipValue = "";

        // WhatsAppNumber
        $this->WhatsAppNumber->HrefValue = "";
        $this->WhatsAppNumber->TooltipValue = "";

        // Active
        $this->Active->HrefValue = "";
        $this->Active->TooltipValue = "";

        // Created_Date
        $this->Created_Date->HrefValue = "";
        $this->Created_Date->TooltipValue = "";

        // Created_By
        $this->Created_By->HrefValue = "";
        $this->Created_By->TooltipValue = "";

        // Last_Updated_Date
        $this->Last_Updated_Date->HrefValue = "";
        $this->Last_Updated_Date->TooltipValue = "";

        // Last_Updated_By
        $this->Last_Updated_By->HrefValue = "";
        $this->Last_Updated_By->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // EmployeeID
        $this->EmployeeID->setupEditAttributes();
        $this->EmployeeID->EditValue = $this->EmployeeID->CurrentValue;

        // FirstName
        $this->FirstName->setupEditAttributes();
        if (!$this->FirstName->Raw) {
            $this->FirstName->CurrentValue = HtmlDecode($this->FirstName->CurrentValue);
        }
        $this->FirstName->EditValue = $this->FirstName->CurrentValue;
        $this->FirstName->PlaceHolder = RemoveHtml($this->FirstName->caption());

        // LastName
        $this->LastName->setupEditAttributes();
        if (!$this->LastName->Raw) {
            $this->LastName->CurrentValue = HtmlDecode($this->LastName->CurrentValue);
        }
        $this->LastName->EditValue = $this->LastName->CurrentValue;
        $this->LastName->PlaceHolder = RemoveHtml($this->LastName->caption());

        // FullName
        $this->FullName->setupEditAttributes();
        if (!$this->FullName->Raw) {
            $this->FullName->CurrentValue = HtmlDecode($this->FullName->CurrentValue);
        }
        $this->FullName->EditValue = $this->FullName->CurrentValue;
        $this->FullName->PlaceHolder = RemoveHtml($this->FullName->caption());

        // Username
        $this->_Username->setupEditAttributes();
        if (!$this->_Username->Raw) {
            $this->_Username->CurrentValue = HtmlDecode($this->_Username->CurrentValue);
        }
        $this->_Username->EditValue = $this->_Username->CurrentValue;
        $this->_Username->PlaceHolder = RemoveHtml($this->_Username->caption());

        // UserPassword
        $this->UserPassword->setupEditAttributes();
        $this->UserPassword->EditValue = $Language->phrase("PasswordMask"); // Show as masked password
        $this->UserPassword->PlaceHolder = RemoveHtml($this->UserPassword->caption());

        // Level
        $this->Level->setupEditAttributes();
        if (!$Security->canAdmin()) { // System admin
            $this->Level->EditValue = $Language->phrase("PasswordMask");
        } else {
            $this->Level->PlaceHolder = RemoveHtml($this->Level->caption());
        }

        // Email
        $this->_Email->setupEditAttributes();
        if (!$this->_Email->Raw) {
            $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
        }
        $this->_Email->EditValue = $this->_Email->CurrentValue;
        $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

        // Position
        $this->Position->setupEditAttributes();
        $this->Position->EditValue = $this->Position->options(true);
        $this->Position->PlaceHolder = RemoveHtml($this->Position->caption());

        // Department
        $this->Department->setupEditAttributes();
        if (!$this->Department->Raw) {
            $this->Department->CurrentValue = HtmlDecode($this->Department->CurrentValue);
        }
        $this->Department->EditValue = $this->Department->CurrentValue;
        $this->Department->PlaceHolder = RemoveHtml($this->Department->caption());

        // Employee
        $this->Employee->EditValue = $this->Employee->options(false);
        $this->Employee->PlaceHolder = RemoveHtml($this->Employee->caption());

        // WhatsAppNumber
        $this->WhatsAppNumber->setupEditAttributes();
        if (!$this->WhatsAppNumber->Raw) {
            $this->WhatsAppNumber->CurrentValue = HtmlDecode($this->WhatsAppNumber->CurrentValue);
        }
        $this->WhatsAppNumber->EditValue = $this->WhatsAppNumber->CurrentValue;
        $this->WhatsAppNumber->PlaceHolder = RemoveHtml($this->WhatsAppNumber->caption());

        // Active
        $this->Active->EditValue = $this->Active->options(false);
        $this->Active->PlaceHolder = RemoveHtml($this->Active->caption());

        // Created_Date
        $this->Created_Date->setupEditAttributes();
        $this->Created_Date->CurrentValue = FormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());

        // Created_By
        $this->Created_By->setupEditAttributes();

        // Last_Updated_Date

        // Last_Updated_By

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->EmployeeID);
                    $doc->exportCaption($this->FirstName);
                    $doc->exportCaption($this->LastName);
                    $doc->exportCaption($this->FullName);
                    $doc->exportCaption($this->_Username);
                    $doc->exportCaption($this->UserPassword);
                    $doc->exportCaption($this->Level);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->Position);
                    $doc->exportCaption($this->Department);
                    $doc->exportCaption($this->Employee);
                    $doc->exportCaption($this->WhatsAppNumber);
                    $doc->exportCaption($this->Active);
                    $doc->exportCaption($this->Created_Date);
                    $doc->exportCaption($this->Created_By);
                    $doc->exportCaption($this->Last_Updated_Date);
                    $doc->exportCaption($this->Last_Updated_By);
                } else {
                    $doc->exportCaption($this->EmployeeID);
                    $doc->exportCaption($this->FirstName);
                    $doc->exportCaption($this->LastName);
                    $doc->exportCaption($this->FullName);
                    $doc->exportCaption($this->_Username);
                    $doc->exportCaption($this->UserPassword);
                    $doc->exportCaption($this->Level);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->Position);
                    $doc->exportCaption($this->Department);
                    $doc->exportCaption($this->Employee);
                    $doc->exportCaption($this->WhatsAppNumber);
                    $doc->exportCaption($this->Active);
                    $doc->exportCaption($this->Created_Date);
                    $doc->exportCaption($this->Created_By);
                    $doc->exportCaption($this->Last_Updated_Date);
                    $doc->exportCaption($this->Last_Updated_By);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->EmployeeID);
                        $doc->exportField($this->FirstName);
                        $doc->exportField($this->LastName);
                        $doc->exportField($this->FullName);
                        $doc->exportField($this->_Username);
                        $doc->exportField($this->UserPassword);
                        $doc->exportField($this->Level);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->Position);
                        $doc->exportField($this->Department);
                        $doc->exportField($this->Employee);
                        $doc->exportField($this->WhatsAppNumber);
                        $doc->exportField($this->Active);
                        $doc->exportField($this->Created_Date);
                        $doc->exportField($this->Created_By);
                        $doc->exportField($this->Last_Updated_Date);
                        $doc->exportField($this->Last_Updated_By);
                    } else {
                        $doc->exportField($this->EmployeeID);
                        $doc->exportField($this->FirstName);
                        $doc->exportField($this->LastName);
                        $doc->exportField($this->FullName);
                        $doc->exportField($this->_Username);
                        $doc->exportField($this->UserPassword);
                        $doc->exportField($this->Level);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->Position);
                        $doc->exportField($this->Department);
                        $doc->exportField($this->Employee);
                        $doc->exportField($this->WhatsAppNumber);
                        $doc->exportField($this->Active);
                        $doc->exportField($this->Created_Date);
                        $doc->exportField($this->Created_By);
                        $doc->exportField($this->Last_Updated_Date);
                        $doc->exportField($this->Last_Updated_By);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        if (in_array(CurrentUserLevel(), array("4", "5", "6", "7", "8", "9", "10"))) {
            $currentUser = CurrentUserName(); // Ambil nama pengguna saat ini
            // Pastikan untuk meng-escape string nama pengguna untuk keamanan
            $currentUser = addslashes($currentUser);

            // Perbarui filter dengan query yang benar
            $existsClause = "UserName = '" . $currentUser . "'"; // Fixed the missing semicolon here
            if (strlen($filter) == 0) {
                $filter = $existsClause;
            } else {
                $filter .= ' AND ' . $existsClause;
            }
        }
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false

    // Check if the current user has a level between 4 and 10
    if (in_array(CurrentUserLevel(), array("4", "5", "6", "7", "8", "9", "10"))) {
                 if (isset($rsnew["Employee"]))
                 {
                    if($rsnew["Employee"]==1)
                    {
                         $rsnew["Level"] = "4";
                    }
                    else
                    {
                        $rsnew["Level"] = "5";
                    }    
                 } 
        }
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
    // Check if the current user has a level between 4 and 10
    if (in_array(CurrentUserLevel(), array("4", "5", "6", "7", "8", "9", "10"))) {
        if( $rsold["Level"] == "4"||  $rsold["Level"] == "5")
        {
                 if (isset($rsnew["Employee"]))
                 {
                    if($rsnew["Employee"]==1)
                    {
                         $rsnew["Level"] = "4";
                    }
                    else
                    {
                        $rsnew["Level"] = "5";
                    }    
                 } 
        }
    }
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
           if (in_array(CurrentUserLevel(), array("4", "5", "6", "7", "8", "9", "10"))) {
                 $this->Level->Visible = FALSE;
        }
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
