<?php

namespace ProjectManagement\prjProjectManagement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MasteruserUpdate extends Masteruser
{
    use MessagesTrait;

    // Page ID
    public $PageID = "update";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MasteruserUpdate";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "masteruserupdate";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->EmployeeID->Visible = false;
        $this->FirstName->setVisibility();
        $this->LastName->setVisibility();
        $this->FullName->Visible = false;
        $this->_Username->setVisibility();
        $this->UserPassword->setVisibility();
        $this->Level->setVisibility();
        $this->_Email->setVisibility();
        $this->Position->setVisibility();
        $this->Department->setVisibility();
        $this->Employee->setVisibility();
        $this->WhatsAppNumber->setVisibility();
        $this->Active->setVisibility();
        $this->Created_Date->setVisibility();
        $this->Created_By->setVisibility();
        $this->Last_Updated_Date->setVisibility();
        $this->Last_Updated_By->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'masteruser';
        $this->TableName = 'masteruser';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-update-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (masteruser)
        if (!isset($GLOBALS["masteruser"]) || $GLOBALS["masteruser"]::class == PROJECT_NAMESPACE . "masteruser") {
            $GLOBALS["masteruser"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'masteruser');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "masteruserview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['EmployeeID'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->EmployeeID->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-update-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $RecKeys;
    public $Disabled;
    public $UpdateCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->Level);
        $this->setupLookupOptions($this->Position);
        $this->setupLookupOptions($this->Employee);
        $this->setupLookupOptions($this->Active);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Try to load keys from list form
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        if (Post("action") !== null && Post("action") !== "") {
            // Get action
            $this->CurrentAction = Post("action");
            $this->loadFormValues(); // Get form values

            // Validate form
            if (!$this->validateForm()) {
                $this->CurrentAction = "show"; // Form error, reset action
                if (!$this->hasInvalidFields()) { // No fields selected
                    $this->setFailureMessage($Language->phrase("NoFieldSelected"));
                }
            }
        } else {
            $this->loadMultiUpdateValues(); // Load initial values to form
        }
        if (count($this->RecKeys) <= 0) {
            $this->terminate("masteruserlist"); // No records selected, return to list
            return;
        }
        if ($this->isUpdate()) {
                if ($this->updateRows()) { // Update Records based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
                    }

                    // Do not return Json for UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                    }
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([
                        "success" => false,
                        "validation" => $this->getValidationErrors(),
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->restoreFormValues(); // Restore form values
                }
        }

        // Render row
        $this->RowType = RowType::EDIT; // Render edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load initial values to form if field values are identical in all selected records
    protected function loadMultiUpdateValues()
    {
        $this->CurrentFilter = $this->getFilterFromRecordKeys();

        // Load result set
        if ($rs = $this->loadRecordset()) {
            $i = 1;
            while ($row = $rs->fetch()) {
                if ($i == 1) {
                    $this->FirstName->setDbValue($row['FirstName']);
                    $this->LastName->setDbValue($row['LastName']);
                    $this->_Username->setDbValue($row['Username']);
                    $this->UserPassword->setDbValue($row['UserPassword']);
                    $this->Level->setDbValue($row['Level']);
                    $this->_Email->setDbValue($row['Email']);
                    $this->Position->setDbValue($row['Position']);
                    $this->Department->setDbValue($row['Department']);
                    $this->Employee->setDbValue($row['Employee']);
                    $this->WhatsAppNumber->setDbValue($row['WhatsAppNumber']);
                    $this->Active->setDbValue($row['Active']);
                    $this->Created_Date->setDbValue($row['Created_Date']);
                    $this->Created_By->setDbValue($row['Created_By']);
                    $this->Last_Updated_Date->setDbValue($row['Last_Updated_Date']);
                    $this->Last_Updated_By->setDbValue($row['Last_Updated_By']);
                } else {
                    if (!CompareValue($this->FirstName->DbValue, $row['FirstName'])) {
                        $this->FirstName->CurrentValue = null;
                    }
                    if (!CompareValue($this->LastName->DbValue, $row['LastName'])) {
                        $this->LastName->CurrentValue = null;
                    }
                    if (!CompareValue($this->_Username->DbValue, $row['Username'])) {
                        $this->_Username->CurrentValue = null;
                    }
                    if (!CompareValue($this->UserPassword->DbValue, $row['UserPassword'])) {
                        $this->UserPassword->CurrentValue = null;
                    }
                    if (!CompareValue($this->Level->DbValue, $row['Level'])) {
                        $this->Level->CurrentValue = null;
                    }
                    if (!CompareValue($this->_Email->DbValue, $row['Email'])) {
                        $this->_Email->CurrentValue = null;
                    }
                    if (!CompareValue($this->Position->DbValue, $row['Position'])) {
                        $this->Position->CurrentValue = null;
                    }
                    if (!CompareValue($this->Department->DbValue, $row['Department'])) {
                        $this->Department->CurrentValue = null;
                    }
                    if (!CompareValue($this->Employee->DbValue, $row['Employee'])) {
                        $this->Employee->CurrentValue = null;
                    }
                    if (!CompareValue($this->WhatsAppNumber->DbValue, $row['WhatsAppNumber'])) {
                        $this->WhatsAppNumber->CurrentValue = null;
                    }
                    if (!CompareValue($this->Active->DbValue, $row['Active'])) {
                        $this->Active->CurrentValue = null;
                    }
                    if (!CompareValue($this->Created_Date->DbValue, $row['Created_Date'])) {
                        $this->Created_Date->CurrentValue = null;
                    }
                    if (!CompareValue($this->Created_By->DbValue, $row['Created_By'])) {
                        $this->Created_By->CurrentValue = null;
                    }
                    if (!CompareValue($this->Last_Updated_Date->DbValue, $row['Last_Updated_Date'])) {
                        $this->Last_Updated_Date->CurrentValue = null;
                    }
                    if (!CompareValue($this->Last_Updated_By->DbValue, $row['Last_Updated_By'])) {
                        $this->Last_Updated_By->CurrentValue = null;
                    }
                }
                $i++;
            }
            $rs->free();
        }
    }

    // Set up key value
    protected function setupKeyValues($key)
    {
        $keyFld = $key;
        if (!is_numeric($keyFld)) {
            return false;
        }
        $this->EmployeeID->OldValue = $keyFld;
        return true;
    }

    // Update all selected rows
    protected function updateRows()
    {
        global $Language;
        $conn = $this->getConnection();
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Get old records
        $this->CurrentFilter = $this->getFilterFromRecordKeys(false);
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAllAssociative($sql);

        // Update all rows
        $successKeys = [];
        $failKeys = [];
        foreach ($this->RecKeys as $reckey) {
            if ($this->setupKeyValues($reckey)) {
                $thisKey = $reckey;
                $this->SendEmail = false; // Do not send email on update success
                $this->UpdateCount += 1; // Update record count for records being updated
                $rowUpdated = $this->editRow(); // Update this row
            } else {
                $rowUpdated = false;
            }
            if (!$rowUpdated) {
                if ($this->UseTransaction) { // Update failed
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                $successKeys[] = $thisKey;
            }
        }

        // Check if any rows updated
        if (count($successKeys) > 0) {
            if ($this->UseTransaction) { // Commit transaction
                $conn->commit();
            }

            // Set warning message if update some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("UpdateSomeRecordsFailed")));
            }

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);
            return true;
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                $conn->rollback();
            }
            return false;
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'FirstName' first before field var 'x_FirstName'
        $val = $CurrentForm->hasValue("FirstName") ? $CurrentForm->getValue("FirstName") : $CurrentForm->getValue("x_FirstName");
        if (!$this->FirstName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FirstName->Visible = false; // Disable update for API request
            } else {
                $this->FirstName->setFormValue($val);
            }
        }
        $this->FirstName->MultiUpdate = $CurrentForm->getValue("u_FirstName");

        // Check field name 'LastName' first before field var 'x_LastName'
        $val = $CurrentForm->hasValue("LastName") ? $CurrentForm->getValue("LastName") : $CurrentForm->getValue("x_LastName");
        if (!$this->LastName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->LastName->Visible = false; // Disable update for API request
            } else {
                $this->LastName->setFormValue($val);
            }
        }
        $this->LastName->MultiUpdate = $CurrentForm->getValue("u_LastName");

        // Check field name 'Username' first before field var 'x__Username'
        $val = $CurrentForm->hasValue("Username") ? $CurrentForm->getValue("Username") : $CurrentForm->getValue("x__Username");
        if (!$this->_Username->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_Username->Visible = false; // Disable update for API request
            } else {
                $this->_Username->setFormValue($val);
            }
        }
        $this->_Username->MultiUpdate = $CurrentForm->getValue("u__Username");

        // Check field name 'UserPassword' first before field var 'x_UserPassword'
        $val = $CurrentForm->hasValue("UserPassword") ? $CurrentForm->getValue("UserPassword") : $CurrentForm->getValue("x_UserPassword");
        if (!$this->UserPassword->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->UserPassword->Visible = false; // Disable update for API request
            } else {
                $this->UserPassword->setFormValue($val);
            }
        }
        $this->UserPassword->MultiUpdate = $CurrentForm->getValue("u_UserPassword");

        // Check field name 'Level' first before field var 'x_Level'
        $val = $CurrentForm->hasValue("Level") ? $CurrentForm->getValue("Level") : $CurrentForm->getValue("x_Level");
        if (!$this->Level->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Level->Visible = false; // Disable update for API request
            } else {
                $this->Level->setFormValue($val);
            }
        }
        $this->Level->MultiUpdate = $CurrentForm->getValue("u_Level");

        // Check field name 'Email' first before field var 'x__Email'
        $val = $CurrentForm->hasValue("Email") ? $CurrentForm->getValue("Email") : $CurrentForm->getValue("x__Email");
        if (!$this->_Email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_Email->Visible = false; // Disable update for API request
            } else {
                $this->_Email->setFormValue($val);
            }
        }
        $this->_Email->MultiUpdate = $CurrentForm->getValue("u__Email");

        // Check field name 'Position' first before field var 'x_Position'
        $val = $CurrentForm->hasValue("Position") ? $CurrentForm->getValue("Position") : $CurrentForm->getValue("x_Position");
        if (!$this->Position->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Position->Visible = false; // Disable update for API request
            } else {
                $this->Position->setFormValue($val);
            }
        }
        $this->Position->MultiUpdate = $CurrentForm->getValue("u_Position");

        // Check field name 'Department' first before field var 'x_Department'
        $val = $CurrentForm->hasValue("Department") ? $CurrentForm->getValue("Department") : $CurrentForm->getValue("x_Department");
        if (!$this->Department->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Department->Visible = false; // Disable update for API request
            } else {
                $this->Department->setFormValue($val);
            }
        }
        $this->Department->MultiUpdate = $CurrentForm->getValue("u_Department");

        // Check field name 'Employee' first before field var 'x_Employee'
        $val = $CurrentForm->hasValue("Employee") ? $CurrentForm->getValue("Employee") : $CurrentForm->getValue("x_Employee");
        if (!$this->Employee->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Employee->Visible = false; // Disable update for API request
            } else {
                $this->Employee->setFormValue($val);
            }
        }
        $this->Employee->MultiUpdate = $CurrentForm->getValue("u_Employee");

        // Check field name 'WhatsAppNumber' first before field var 'x_WhatsAppNumber'
        $val = $CurrentForm->hasValue("WhatsAppNumber") ? $CurrentForm->getValue("WhatsAppNumber") : $CurrentForm->getValue("x_WhatsAppNumber");
        if (!$this->WhatsAppNumber->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->WhatsAppNumber->Visible = false; // Disable update for API request
            } else {
                $this->WhatsAppNumber->setFormValue($val);
            }
        }
        $this->WhatsAppNumber->MultiUpdate = $CurrentForm->getValue("u_WhatsAppNumber");

        // Check field name 'Active' first before field var 'x_Active'
        $val = $CurrentForm->hasValue("Active") ? $CurrentForm->getValue("Active") : $CurrentForm->getValue("x_Active");
        if (!$this->Active->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Active->Visible = false; // Disable update for API request
            } else {
                $this->Active->setFormValue($val);
            }
        }
        $this->Active->MultiUpdate = $CurrentForm->getValue("u_Active");

        // Check field name 'Created_Date' first before field var 'x_Created_Date'
        $val = $CurrentForm->hasValue("Created_Date") ? $CurrentForm->getValue("Created_Date") : $CurrentForm->getValue("x_Created_Date");
        if (!$this->Created_Date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Created_Date->Visible = false; // Disable update for API request
            } else {
                $this->Created_Date->setFormValue($val);
            }
            $this->Created_Date->CurrentValue = UnFormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());
        }
        $this->Created_Date->MultiUpdate = $CurrentForm->getValue("u_Created_Date");

        // Check field name 'Created_By' first before field var 'x_Created_By'
        $val = $CurrentForm->hasValue("Created_By") ? $CurrentForm->getValue("Created_By") : $CurrentForm->getValue("x_Created_By");
        if (!$this->Created_By->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Created_By->Visible = false; // Disable update for API request
            } else {
                $this->Created_By->setFormValue($val);
            }
        }
        $this->Created_By->MultiUpdate = $CurrentForm->getValue("u_Created_By");

        // Check field name 'Last_Updated_Date' first before field var 'x_Last_Updated_Date'
        $val = $CurrentForm->hasValue("Last_Updated_Date") ? $CurrentForm->getValue("Last_Updated_Date") : $CurrentForm->getValue("x_Last_Updated_Date");
        if (!$this->Last_Updated_Date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Last_Updated_Date->Visible = false; // Disable update for API request
            } else {
                $this->Last_Updated_Date->setFormValue($val);
            }
            $this->Last_Updated_Date->CurrentValue = UnFormatDateTime($this->Last_Updated_Date->CurrentValue, $this->Last_Updated_Date->formatPattern());
        }
        $this->Last_Updated_Date->MultiUpdate = $CurrentForm->getValue("u_Last_Updated_Date");

        // Check field name 'Last_Updated_By' first before field var 'x_Last_Updated_By'
        $val = $CurrentForm->hasValue("Last_Updated_By") ? $CurrentForm->getValue("Last_Updated_By") : $CurrentForm->getValue("x_Last_Updated_By");
        if (!$this->Last_Updated_By->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Last_Updated_By->Visible = false; // Disable update for API request
            } else {
                $this->Last_Updated_By->setFormValue($val);
            }
        }
        $this->Last_Updated_By->MultiUpdate = $CurrentForm->getValue("u_Last_Updated_By");

        // Check field name 'EmployeeID' first before field var 'x_EmployeeID'
        $val = $CurrentForm->hasValue("EmployeeID") ? $CurrentForm->getValue("EmployeeID") : $CurrentForm->getValue("x_EmployeeID");
        if (!$this->EmployeeID->IsDetailKey) {
            $this->EmployeeID->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->EmployeeID->CurrentValue = $this->EmployeeID->FormValue;
        $this->FirstName->CurrentValue = $this->FirstName->FormValue;
        $this->LastName->CurrentValue = $this->LastName->FormValue;
        $this->_Username->CurrentValue = $this->_Username->FormValue;
        $this->UserPassword->CurrentValue = $this->UserPassword->FormValue;
        $this->Level->CurrentValue = $this->Level->FormValue;
        $this->_Email->CurrentValue = $this->_Email->FormValue;
        $this->Position->CurrentValue = $this->Position->FormValue;
        $this->Department->CurrentValue = $this->Department->FormValue;
        $this->Employee->CurrentValue = $this->Employee->FormValue;
        $this->WhatsAppNumber->CurrentValue = $this->WhatsAppNumber->FormValue;
        $this->Active->CurrentValue = $this->Active->FormValue;
        $this->Created_Date->CurrentValue = $this->Created_Date->FormValue;
        $this->Created_Date->CurrentValue = UnFormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());
        $this->Created_By->CurrentValue = $this->Created_By->FormValue;
        $this->Last_Updated_Date->CurrentValue = $this->Last_Updated_Date->FormValue;
        $this->Last_Updated_Date->CurrentValue = UnFormatDateTime($this->Last_Updated_Date->CurrentValue, $this->Last_Updated_Date->formatPattern());
        $this->Last_Updated_By->CurrentValue = $this->Last_Updated_By->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->EmployeeID->setDbValue($row['EmployeeID']);
        $this->FirstName->setDbValue($row['FirstName']);
        $this->LastName->setDbValue($row['LastName']);
        $this->FullName->setDbValue($row['FullName']);
        $this->_Username->setDbValue($row['Username']);
        $this->UserPassword->setDbValue($row['UserPassword']);
        $this->Level->setDbValue($row['Level']);
        $this->_Email->setDbValue($row['Email']);
        $this->Position->setDbValue($row['Position']);
        $this->Department->setDbValue($row['Department']);
        $this->Employee->setDbValue($row['Employee']);
        $this->WhatsAppNumber->setDbValue($row['WhatsAppNumber']);
        $this->Active->setDbValue($row['Active']);
        $this->Created_Date->setDbValue($row['Created_Date']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->Last_Updated_Date->setDbValue($row['Last_Updated_Date']);
        $this->Last_Updated_By->setDbValue($row['Last_Updated_By']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['EmployeeID'] = $this->EmployeeID->DefaultValue;
        $row['FirstName'] = $this->FirstName->DefaultValue;
        $row['LastName'] = $this->LastName->DefaultValue;
        $row['FullName'] = $this->FullName->DefaultValue;
        $row['Username'] = $this->_Username->DefaultValue;
        $row['UserPassword'] = $this->UserPassword->DefaultValue;
        $row['Level'] = $this->Level->DefaultValue;
        $row['Email'] = $this->_Email->DefaultValue;
        $row['Position'] = $this->Position->DefaultValue;
        $row['Department'] = $this->Department->DefaultValue;
        $row['Employee'] = $this->Employee->DefaultValue;
        $row['WhatsAppNumber'] = $this->WhatsAppNumber->DefaultValue;
        $row['Active'] = $this->Active->DefaultValue;
        $row['Created_Date'] = $this->Created_Date->DefaultValue;
        $row['Created_By'] = $this->Created_By->DefaultValue;
        $row['Last_Updated_Date'] = $this->Last_Updated_Date->DefaultValue;
        $row['Last_Updated_By'] = $this->Last_Updated_By->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // EmployeeID
        $this->EmployeeID->RowCssClass = "row";

        // FirstName
        $this->FirstName->RowCssClass = "row";

        // LastName
        $this->LastName->RowCssClass = "row";

        // FullName
        $this->FullName->RowCssClass = "row";

        // Username
        $this->_Username->RowCssClass = "row";

        // UserPassword
        $this->UserPassword->RowCssClass = "row";

        // Level
        $this->Level->RowCssClass = "row";

        // Email
        $this->_Email->RowCssClass = "row";

        // Position
        $this->Position->RowCssClass = "row";

        // Department
        $this->Department->RowCssClass = "row";

        // Employee
        $this->Employee->RowCssClass = "row";

        // WhatsAppNumber
        $this->WhatsAppNumber->RowCssClass = "row";

        // Active
        $this->Active->RowCssClass = "row";

        // Created_Date
        $this->Created_Date->RowCssClass = "row";

        // Created_By
        $this->Created_By->RowCssClass = "row";

        // Last_Updated_Date
        $this->Last_Updated_Date->RowCssClass = "row";

        // Last_Updated_By
        $this->Last_Updated_By->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // EmployeeID
            $this->EmployeeID->ViewValue = $this->EmployeeID->CurrentValue;

            // FirstName
            $this->FirstName->ViewValue = $this->FirstName->CurrentValue;

            // LastName
            $this->LastName->ViewValue = $this->LastName->CurrentValue;

            // FullName
            $this->FullName->ViewValue = $this->FullName->CurrentValue;

            // Username
            $this->_Username->ViewValue = $this->_Username->CurrentValue;

            // UserPassword
            $this->UserPassword->ViewValue = $Language->phrase("PasswordMask");

            // Level
            if ($Security->canAdmin()) { // System admin
                $curVal = strval($this->Level->CurrentValue);
                if ($curVal != "") {
                    $this->Level->ViewValue = $this->Level->lookupCacheOption($curVal);
                    if ($this->Level->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->Level->Lookup->getTable()->Fields["userlevelid"]->searchExpression(), "=", $curVal, $this->Level->Lookup->getTable()->Fields["userlevelid"]->searchDataType(), "");
                        $sqlWrk = $this->Level->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->Level->Lookup->renderViewRow($rswrk[0]);
                            $this->Level->ViewValue = $this->Level->displayValue($arwrk);
                        } else {
                            $this->Level->ViewValue = FormatNumber($this->Level->CurrentValue, $this->Level->formatPattern());
                        }
                    }
                } else {
                    $this->Level->ViewValue = null;
                }
            } else {
                $this->Level->ViewValue = $Language->phrase("PasswordMask");
            }

            // Email
            $this->_Email->ViewValue = $this->_Email->CurrentValue;

            // Position
            if (strval($this->Position->CurrentValue) != "") {
                $this->Position->ViewValue = $this->Position->optionCaption($this->Position->CurrentValue);
            } else {
                $this->Position->ViewValue = null;
            }

            // Department
            $this->Department->ViewValue = $this->Department->CurrentValue;

            // Employee
            if (ConvertToBool($this->Employee->CurrentValue)) {
                $this->Employee->ViewValue = $this->Employee->tagCaption(1) != "" ? $this->Employee->tagCaption(1) : "Yes";
            } else {
                $this->Employee->ViewValue = $this->Employee->tagCaption(2) != "" ? $this->Employee->tagCaption(2) : "No";
            }
            $this->Employee->CellCssStyle .= "text-align: center;";

            // WhatsAppNumber
            $this->WhatsAppNumber->ViewValue = $this->WhatsAppNumber->CurrentValue;

            // Active
            if (ConvertToBool($this->Active->CurrentValue)) {
                $this->Active->ViewValue = $this->Active->tagCaption(1) != "" ? $this->Active->tagCaption(1) : "Yes";
            } else {
                $this->Active->ViewValue = $this->Active->tagCaption(2) != "" ? $this->Active->tagCaption(2) : "No";
            }
            $this->Active->CellCssStyle .= "text-align: center;";

            // Created_Date
            $this->Created_Date->ViewValue = $this->Created_Date->CurrentValue;
            $this->Created_Date->ViewValue = FormatDateTime($this->Created_Date->ViewValue, $this->Created_Date->formatPattern());

            // Created_By
            $this->Created_By->ViewValue = $this->Created_By->CurrentValue;

            // Last_Updated_Date
            $this->Last_Updated_Date->ViewValue = $this->Last_Updated_Date->CurrentValue;
            $this->Last_Updated_Date->ViewValue = FormatDateTime($this->Last_Updated_Date->ViewValue, $this->Last_Updated_Date->formatPattern());

            // Last_Updated_By
            $this->Last_Updated_By->ViewValue = $this->Last_Updated_By->CurrentValue;

            // FirstName
            $this->FirstName->HrefValue = "";
            $this->FirstName->TooltipValue = "";

            // LastName
            $this->LastName->HrefValue = "";
            $this->LastName->TooltipValue = "";

            // Username
            $this->_Username->HrefValue = "";
            $this->_Username->TooltipValue = "";

            // UserPassword
            $this->UserPassword->HrefValue = "";
            $this->UserPassword->TooltipValue = "";

            // Level
            $this->Level->HrefValue = "";
            $this->Level->TooltipValue = "";

            // Email
            $this->_Email->HrefValue = "";
            $this->_Email->TooltipValue = "";

            // Position
            $this->Position->HrefValue = "";
            $this->Position->TooltipValue = "";

            // Department
            $this->Department->HrefValue = "";
            $this->Department->TooltipValue = "";

            // Employee
            $this->Employee->HrefValue = "";
            $this->Employee->TooltipValue = "";

            // WhatsAppNumber
            $this->WhatsAppNumber->HrefValue = "";
            $this->WhatsAppNumber->TooltipValue = "";

            // Active
            $this->Active->HrefValue = "";
            $this->Active->TooltipValue = "";

            // Created_Date
            $this->Created_Date->HrefValue = "";
            $this->Created_Date->TooltipValue = "";

            // Created_By
            $this->Created_By->HrefValue = "";
            $this->Created_By->TooltipValue = "";

            // Last_Updated_Date
            $this->Last_Updated_Date->HrefValue = "";
            $this->Last_Updated_Date->TooltipValue = "";

            // Last_Updated_By
            $this->Last_Updated_By->HrefValue = "";
            $this->Last_Updated_By->TooltipValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // FirstName
            $this->FirstName->setupEditAttributes();
            if (!$this->FirstName->Raw) {
                $this->FirstName->CurrentValue = HtmlDecode($this->FirstName->CurrentValue);
            }
            $this->FirstName->EditValue = HtmlEncode($this->FirstName->CurrentValue);
            $this->FirstName->PlaceHolder = RemoveHtml($this->FirstName->caption());

            // LastName
            $this->LastName->setupEditAttributes();
            if (!$this->LastName->Raw) {
                $this->LastName->CurrentValue = HtmlDecode($this->LastName->CurrentValue);
            }
            $this->LastName->EditValue = HtmlEncode($this->LastName->CurrentValue);
            $this->LastName->PlaceHolder = RemoveHtml($this->LastName->caption());

            // Username
            $this->_Username->setupEditAttributes();
            if (!$this->_Username->Raw) {
                $this->_Username->CurrentValue = HtmlDecode($this->_Username->CurrentValue);
            }
            $this->_Username->EditValue = HtmlEncode($this->_Username->CurrentValue);
            $this->_Username->PlaceHolder = RemoveHtml($this->_Username->caption());

            // UserPassword
            $this->UserPassword->setupEditAttributes();
            $this->UserPassword->EditValue = $Language->phrase("PasswordMask"); // Show as masked password
            $this->UserPassword->PlaceHolder = RemoveHtml($this->UserPassword->caption());

            // Level
            $this->Level->setupEditAttributes();
            if (!$Security->canAdmin()) { // System admin
                $this->Level->EditValue = $Language->phrase("PasswordMask");
            } else {
                $curVal = trim(strval($this->Level->CurrentValue));
                if ($curVal != "") {
                    $this->Level->ViewValue = $this->Level->lookupCacheOption($curVal);
                } else {
                    $this->Level->ViewValue = $this->Level->Lookup !== null && is_array($this->Level->lookupOptions()) && count($this->Level->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->Level->ViewValue !== null) { // Load from cache
                    $this->Level->EditValue = array_values($this->Level->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->Level->Lookup->getTable()->Fields["userlevelid"]->searchExpression(), "=", $this->Level->CurrentValue, $this->Level->Lookup->getTable()->Fields["userlevelid"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->Level->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->Level->EditValue = $arwrk;
                }
                $this->Level->PlaceHolder = RemoveHtml($this->Level->caption());
            }

            // Email
            $this->_Email->setupEditAttributes();
            if (!$this->_Email->Raw) {
                $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
            }
            $this->_Email->EditValue = HtmlEncode($this->_Email->CurrentValue);
            $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

            // Position
            $this->Position->setupEditAttributes();
            $this->Position->EditValue = $this->Position->options(true);
            $this->Position->PlaceHolder = RemoveHtml($this->Position->caption());

            // Department
            $this->Department->setupEditAttributes();
            if (!$this->Department->Raw) {
                $this->Department->CurrentValue = HtmlDecode($this->Department->CurrentValue);
            }
            $this->Department->EditValue = HtmlEncode($this->Department->CurrentValue);
            $this->Department->PlaceHolder = RemoveHtml($this->Department->caption());

            // Employee
            $this->Employee->EditValue = $this->Employee->options(false);
            $this->Employee->PlaceHolder = RemoveHtml($this->Employee->caption());

            // WhatsAppNumber
            $this->WhatsAppNumber->setupEditAttributes();
            if (!$this->WhatsAppNumber->Raw) {
                $this->WhatsAppNumber->CurrentValue = HtmlDecode($this->WhatsAppNumber->CurrentValue);
            }
            $this->WhatsAppNumber->EditValue = HtmlEncode($this->WhatsAppNumber->CurrentValue);
            $this->WhatsAppNumber->PlaceHolder = RemoveHtml($this->WhatsAppNumber->caption());

            // Active
            $this->Active->EditValue = $this->Active->options(false);
            $this->Active->PlaceHolder = RemoveHtml($this->Active->caption());

            // Created_Date
            $this->Created_Date->setupEditAttributes();
            $this->Created_Date->CurrentValue = FormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());

            // Created_By
            $this->Created_By->setupEditAttributes();

            // Last_Updated_Date

            // Last_Updated_By

            // Edit refer script

            // FirstName
            $this->FirstName->HrefValue = "";

            // LastName
            $this->LastName->HrefValue = "";

            // Username
            $this->_Username->HrefValue = "";

            // UserPassword
            $this->UserPassword->HrefValue = "";

            // Level
            $this->Level->HrefValue = "";

            // Email
            $this->_Email->HrefValue = "";

            // Position
            $this->Position->HrefValue = "";

            // Department
            $this->Department->HrefValue = "";

            // Employee
            $this->Employee->HrefValue = "";

            // WhatsAppNumber
            $this->WhatsAppNumber->HrefValue = "";

            // Active
            $this->Active->HrefValue = "";

            // Created_Date
            $this->Created_Date->HrefValue = "";

            // Created_By
            $this->Created_By->HrefValue = "";

            // Last_Updated_Date
            $this->Last_Updated_Date->HrefValue = "";

            // Last_Updated_By
            $this->Last_Updated_By->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;
        $updateCnt = 0;
        if ($this->FirstName->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->LastName->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->_Username->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->UserPassword->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Level->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->_Email->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Position->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Department->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Employee->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->WhatsAppNumber->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Active->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Created_Date->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Created_By->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Last_Updated_Date->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Last_Updated_By->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($updateCnt == 0) {
            return false;
        }

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->FirstName->Visible && $this->FirstName->Required) {
                if ($this->FirstName->MultiUpdate != "" && !$this->FirstName->IsDetailKey && EmptyValue($this->FirstName->FormValue)) {
                    $this->FirstName->addErrorMessage(str_replace("%s", $this->FirstName->caption(), $this->FirstName->RequiredErrorMessage));
                }
            }
            if ($this->LastName->Visible && $this->LastName->Required) {
                if ($this->LastName->MultiUpdate != "" && !$this->LastName->IsDetailKey && EmptyValue($this->LastName->FormValue)) {
                    $this->LastName->addErrorMessage(str_replace("%s", $this->LastName->caption(), $this->LastName->RequiredErrorMessage));
                }
            }
            if ($this->_Username->Visible && $this->_Username->Required) {
                if ($this->_Username->MultiUpdate != "" && !$this->_Username->IsDetailKey && EmptyValue($this->_Username->FormValue)) {
                    $this->_Username->addErrorMessage(str_replace("%s", $this->_Username->caption(), $this->_Username->RequiredErrorMessage));
                }
            }
            if (!$this->_Username->Raw && Config("REMOVE_XSS") && CheckUsername($this->_Username->FormValue)) {
                $this->_Username->addErrorMessage($Language->phrase("InvalidUsernameChars"));
            }
            if ($this->UserPassword->Visible && $this->UserPassword->Required) {
                if ($this->UserPassword->MultiUpdate != "" && !$this->UserPassword->IsDetailKey && EmptyValue($this->UserPassword->FormValue)) {
                    $this->UserPassword->addErrorMessage(str_replace("%s", $this->UserPassword->caption(), $this->UserPassword->RequiredErrorMessage));
                }
            }
            if (!$this->UserPassword->Raw && Config("REMOVE_XSS") && CheckPassword($this->UserPassword->FormValue)) {
                $this->UserPassword->addErrorMessage($Language->phrase("InvalidPasswordChars"));
            }
            if ($this->Level->Visible && $this->Level->Required) {
                if ($this->Level->MultiUpdate != "" && $Security->canAdmin() && !$this->Level->IsDetailKey && EmptyValue($this->Level->FormValue)) {
                    $this->Level->addErrorMessage(str_replace("%s", $this->Level->caption(), $this->Level->RequiredErrorMessage));
                }
            }
            if ($this->_Email->Visible && $this->_Email->Required) {
                if ($this->_Email->MultiUpdate != "" && !$this->_Email->IsDetailKey && EmptyValue($this->_Email->FormValue)) {
                    $this->_Email->addErrorMessage(str_replace("%s", $this->_Email->caption(), $this->_Email->RequiredErrorMessage));
                }
            }
            if ($this->Position->Visible && $this->Position->Required) {
                if ($this->Position->MultiUpdate != "" && !$this->Position->IsDetailKey && EmptyValue($this->Position->FormValue)) {
                    $this->Position->addErrorMessage(str_replace("%s", $this->Position->caption(), $this->Position->RequiredErrorMessage));
                }
            }
            if ($this->Department->Visible && $this->Department->Required) {
                if ($this->Department->MultiUpdate != "" && !$this->Department->IsDetailKey && EmptyValue($this->Department->FormValue)) {
                    $this->Department->addErrorMessage(str_replace("%s", $this->Department->caption(), $this->Department->RequiredErrorMessage));
                }
            }
            if ($this->Employee->Visible && $this->Employee->Required) {
                if ($this->Employee->MultiUpdate != "" && $this->Employee->FormValue == "") {
                    $this->Employee->addErrorMessage(str_replace("%s", $this->Employee->caption(), $this->Employee->RequiredErrorMessage));
                }
            }
            if ($this->WhatsAppNumber->Visible && $this->WhatsAppNumber->Required) {
                if ($this->WhatsAppNumber->MultiUpdate != "" && !$this->WhatsAppNumber->IsDetailKey && EmptyValue($this->WhatsAppNumber->FormValue)) {
                    $this->WhatsAppNumber->addErrorMessage(str_replace("%s", $this->WhatsAppNumber->caption(), $this->WhatsAppNumber->RequiredErrorMessage));
                }
            }
            if ($this->Active->Visible && $this->Active->Required) {
                if ($this->Active->MultiUpdate != "" && $this->Active->FormValue == "") {
                    $this->Active->addErrorMessage(str_replace("%s", $this->Active->caption(), $this->Active->RequiredErrorMessage));
                }
            }
            if ($this->Created_Date->Visible && $this->Created_Date->Required) {
                if ($this->Created_Date->MultiUpdate != "" && !$this->Created_Date->IsDetailKey && EmptyValue($this->Created_Date->FormValue)) {
                    $this->Created_Date->addErrorMessage(str_replace("%s", $this->Created_Date->caption(), $this->Created_Date->RequiredErrorMessage));
                }
            }
            if ($this->Created_By->Visible && $this->Created_By->Required) {
                if ($this->Created_By->MultiUpdate != "" && !$this->Created_By->IsDetailKey && EmptyValue($this->Created_By->FormValue)) {
                    $this->Created_By->addErrorMessage(str_replace("%s", $this->Created_By->caption(), $this->Created_By->RequiredErrorMessage));
                }
            }
            if ($this->Last_Updated_Date->Visible && $this->Last_Updated_Date->Required) {
                if ($this->Last_Updated_Date->MultiUpdate != "" && !$this->Last_Updated_Date->IsDetailKey && EmptyValue($this->Last_Updated_Date->FormValue)) {
                    $this->Last_Updated_Date->addErrorMessage(str_replace("%s", $this->Last_Updated_Date->caption(), $this->Last_Updated_Date->RequiredErrorMessage));
                }
            }
            if ($this->Last_Updated_By->Visible && $this->Last_Updated_By->Required) {
                if ($this->Last_Updated_By->MultiUpdate != "" && !$this->Last_Updated_By->IsDetailKey && EmptyValue($this->Last_Updated_By->FormValue)) {
                    $this->Last_Updated_By->addErrorMessage(str_replace("%s", $this->Last_Updated_By->caption(), $this->Last_Updated_By->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (Username)
        if ($this->_Username->CurrentValue != "") {
            $filterChk = "(`Username` = '" . AdjustSql($this->_Username->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->_Username->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->_Username->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Check field with unique index (Email)
        if ($this->_Email->CurrentValue != "") {
            $filterChk = "(`Email` = '" . AdjustSql($this->_Email->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->_Email->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->_Email->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // FirstName
        $this->FirstName->setDbValueDef($rsnew, $this->FirstName->CurrentValue, $this->FirstName->ReadOnly || $this->FirstName->MultiUpdate != "1");

        // LastName
        $this->LastName->setDbValueDef($rsnew, $this->LastName->CurrentValue, $this->LastName->ReadOnly || $this->LastName->MultiUpdate != "1");

        // Username
        $this->_Username->setDbValueDef($rsnew, $this->_Username->CurrentValue, $this->_Username->ReadOnly || $this->_Username->MultiUpdate != "1");

        // UserPassword
        if (!IsMaskedPassword($this->UserPassword->CurrentValue)) {
            $this->UserPassword->setDbValueDef($rsnew, $this->UserPassword->CurrentValue, $this->UserPassword->ReadOnly || $this->UserPassword->MultiUpdate != "1" || Config("ENCRYPTED_PASSWORD") && $rsold['UserPassword'] == $this->UserPassword->CurrentValue);
        }

        // Level
        if ($Security->canAdmin()) { // System admin
            $this->Level->setDbValueDef($rsnew, $this->Level->CurrentValue, $this->Level->ReadOnly || $this->Level->MultiUpdate != "1");
        }

        // Email
        $this->_Email->setDbValueDef($rsnew, $this->_Email->CurrentValue, $this->_Email->ReadOnly || $this->_Email->MultiUpdate != "1");

        // Position
        $this->Position->setDbValueDef($rsnew, $this->Position->CurrentValue, $this->Position->ReadOnly || $this->Position->MultiUpdate != "1");

        // Department
        $this->Department->setDbValueDef($rsnew, $this->Department->CurrentValue, $this->Department->ReadOnly || $this->Department->MultiUpdate != "1");

        // Employee
        $tmpBool = $this->Employee->CurrentValue;
        if ($tmpBool != "1" && $tmpBool != "0") {
            $tmpBool = !empty($tmpBool) ? "1" : "0";
        }
        $this->Employee->setDbValueDef($rsnew, $tmpBool, $this->Employee->ReadOnly || $this->Employee->MultiUpdate != "1");

        // WhatsAppNumber
        $this->WhatsAppNumber->setDbValueDef($rsnew, $this->WhatsAppNumber->CurrentValue, $this->WhatsAppNumber->ReadOnly || $this->WhatsAppNumber->MultiUpdate != "1");

        // Active
        $tmpBool = $this->Active->CurrentValue;
        if ($tmpBool != "1" && $tmpBool != "0") {
            $tmpBool = !empty($tmpBool) ? "1" : "0";
        }
        $this->Active->setDbValueDef($rsnew, $tmpBool, $this->Active->ReadOnly || $this->Active->MultiUpdate != "1");

        // Created_Date
        $this->Created_Date->setDbValueDef($rsnew, UnFormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern()), $this->Created_Date->ReadOnly || $this->Created_Date->MultiUpdate != "1");

        // Created_By
        $this->Created_By->setDbValueDef($rsnew, $this->Created_By->CurrentValue, $this->Created_By->ReadOnly || $this->Created_By->MultiUpdate != "1");

        // Last_Updated_Date
        $this->Last_Updated_Date->CurrentValue = $this->Last_Updated_Date->getAutoUpdateValue(); // PHP
        $this->Last_Updated_Date->setDbValueDef($rsnew, UnFormatDateTime($this->Last_Updated_Date->CurrentValue, $this->Last_Updated_Date->formatPattern()));

        // Last_Updated_By
        $this->Last_Updated_By->CurrentValue = $this->Last_Updated_By->getAutoUpdateValue(); // PHP
        $this->Last_Updated_By->setDbValueDef($rsnew, $this->Last_Updated_By->CurrentValue);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['FirstName'])) { // FirstName
            $this->FirstName->CurrentValue = $row['FirstName'];
        }
        if (isset($row['LastName'])) { // LastName
            $this->LastName->CurrentValue = $row['LastName'];
        }
        if (isset($row['Username'])) { // Username
            $this->_Username->CurrentValue = $row['Username'];
        }
        if (isset($row['UserPassword'])) { // UserPassword
            $this->UserPassword->CurrentValue = $row['UserPassword'];
        }
        if (isset($row['Level'])) { // Level
            $this->Level->CurrentValue = $row['Level'];
        }
        if (isset($row['Email'])) { // Email
            $this->_Email->CurrentValue = $row['Email'];
        }
        if (isset($row['Position'])) { // Position
            $this->Position->CurrentValue = $row['Position'];
        }
        if (isset($row['Department'])) { // Department
            $this->Department->CurrentValue = $row['Department'];
        }
        if (isset($row['Employee'])) { // Employee
            $this->Employee->CurrentValue = $row['Employee'];
        }
        if (isset($row['WhatsAppNumber'])) { // WhatsAppNumber
            $this->WhatsAppNumber->CurrentValue = $row['WhatsAppNumber'];
        }
        if (isset($row['Active'])) { // Active
            $this->Active->CurrentValue = $row['Active'];
        }
        if (isset($row['Created_Date'])) { // Created_Date
            $this->Created_Date->CurrentValue = $row['Created_Date'];
        }
        if (isset($row['Created_By'])) { // Created_By
            $this->Created_By->CurrentValue = $row['Created_By'];
        }
        if (isset($row['Last_Updated_Date'])) { // Last_Updated_Date
            $this->Last_Updated_Date->CurrentValue = $row['Last_Updated_Date'];
        }
        if (isset($row['Last_Updated_By'])) { // Last_Updated_By
            $this->Last_Updated_By->CurrentValue = $row['Last_Updated_By'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("masterprojectlist");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("masteruserlist"), "", $this->TableVar, true);
        $pageId = "update";
        $Breadcrumb->add("update", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Level":
                    break;
                case "x_Position":
                    break;
                case "x_Employee":
                    break;
                case "x_Active":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
