<?php

namespace ProjectManagement\prjProjectManagement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProjectproblemsEdit extends Projectproblems
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProjectproblemsEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "projectproblemsedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ProblemId->setVisibility();
        $this->ProblemDate->setVisibility();
        $this->ProblemDescription->setVisibility();
        $this->SolutionDescription->setVisibility();
        $this->AriseById->setVisibility();
        $this->SolvedById->setVisibility();
        $this->ProblemFile->setVisibility();
        $this->_ProjectID->setVisibility();
        $this->Created_Date->setVisibility();
        $this->Created_By->setVisibility();
        $this->Last_Updated_Date->setVisibility();
        $this->Last_Updated_By->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'projectproblems';
        $this->TableName = 'projectproblems';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (projectproblems)
        if (!isset($GLOBALS["projectproblems"]) || $GLOBALS["projectproblems"]::class == PROJECT_NAMESPACE . "projectproblems") {
            $GLOBALS["projectproblems"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'projectproblems');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "projectproblemsview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->ProblemFile->OldUploadPath = $this->ProblemFile->getUploadPath(); // PHP
                $this->ProblemFile->UploadPath = $this->ProblemFile->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['ProblemId'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->ProblemId->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->AriseById);
        $this->setupLookupOptions($this->SolvedById);
        $this->setupLookupOptions($this->_ProjectID);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("ProblemId") ?? Key(0) ?? Route(2)) !== null) {
                $this->ProblemId->setQueryStringValue($keyValue);
                $this->ProblemId->setOldValue($this->ProblemId->QueryStringValue);
            } elseif (Post("ProblemId") !== null) {
                $this->ProblemId->setFormValue(Post("ProblemId"));
                $this->ProblemId->setOldValue($this->ProblemId->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("ProblemId") ?? Route("ProblemId")) !== null) {
                    $this->ProblemId->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->ProblemId->CurrentValue = null;
                }
            }

            // Set up master detail parameters
            $this->setupMasterParms();

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("projectproblemslist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "projectproblemslist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "projectproblemslist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "projectproblemslist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->ProblemFile->Upload->Index = $CurrentForm->Index;
        $this->ProblemFile->Upload->uploadFile();
        $this->ProblemFile->CurrentValue = $this->ProblemFile->Upload->FileName;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ProblemId' first before field var 'x_ProblemId'
        $val = $CurrentForm->hasValue("ProblemId") ? $CurrentForm->getValue("ProblemId") : $CurrentForm->getValue("x_ProblemId");
        if (!$this->ProblemId->IsDetailKey) {
            $this->ProblemId->setFormValue($val);
        }

        // Check field name 'ProblemDate' first before field var 'x_ProblemDate'
        $val = $CurrentForm->hasValue("ProblemDate") ? $CurrentForm->getValue("ProblemDate") : $CurrentForm->getValue("x_ProblemDate");
        if (!$this->ProblemDate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProblemDate->Visible = false; // Disable update for API request
            } else {
                $this->ProblemDate->setFormValue($val, true, $validate);
            }
            $this->ProblemDate->CurrentValue = UnFormatDateTime($this->ProblemDate->CurrentValue, $this->ProblemDate->formatPattern());
        }

        // Check field name 'ProblemDescription' first before field var 'x_ProblemDescription'
        $val = $CurrentForm->hasValue("ProblemDescription") ? $CurrentForm->getValue("ProblemDescription") : $CurrentForm->getValue("x_ProblemDescription");
        if (!$this->ProblemDescription->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProblemDescription->Visible = false; // Disable update for API request
            } else {
                $this->ProblemDescription->setFormValue($val);
            }
        }

        // Check field name 'SolutionDescription' first before field var 'x_SolutionDescription'
        $val = $CurrentForm->hasValue("SolutionDescription") ? $CurrentForm->getValue("SolutionDescription") : $CurrentForm->getValue("x_SolutionDescription");
        if (!$this->SolutionDescription->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SolutionDescription->Visible = false; // Disable update for API request
            } else {
                $this->SolutionDescription->setFormValue($val);
            }
        }

        // Check field name 'AriseById' first before field var 'x_AriseById'
        $val = $CurrentForm->hasValue("AriseById") ? $CurrentForm->getValue("AriseById") : $CurrentForm->getValue("x_AriseById");
        if (!$this->AriseById->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->AriseById->Visible = false; // Disable update for API request
            } else {
                $this->AriseById->setFormValue($val);
            }
        }

        // Check field name 'SolvedById' first before field var 'x_SolvedById'
        $val = $CurrentForm->hasValue("SolvedById") ? $CurrentForm->getValue("SolvedById") : $CurrentForm->getValue("x_SolvedById");
        if (!$this->SolvedById->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SolvedById->Visible = false; // Disable update for API request
            } else {
                $this->SolvedById->setFormValue($val);
            }
        }

        // Check field name 'ProjectID' first before field var 'x__ProjectID'
        $val = $CurrentForm->hasValue("ProjectID") ? $CurrentForm->getValue("ProjectID") : $CurrentForm->getValue("x__ProjectID");
        if (!$this->_ProjectID->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_ProjectID->Visible = false; // Disable update for API request
            } else {
                $this->_ProjectID->setFormValue($val);
            }
        }

        // Check field name 'Created_Date' first before field var 'x_Created_Date'
        $val = $CurrentForm->hasValue("Created_Date") ? $CurrentForm->getValue("Created_Date") : $CurrentForm->getValue("x_Created_Date");
        if (!$this->Created_Date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Created_Date->Visible = false; // Disable update for API request
            } else {
                $this->Created_Date->setFormValue($val);
            }
            $this->Created_Date->CurrentValue = UnFormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());
        }

        // Check field name 'Created_By' first before field var 'x_Created_By'
        $val = $CurrentForm->hasValue("Created_By") ? $CurrentForm->getValue("Created_By") : $CurrentForm->getValue("x_Created_By");
        if (!$this->Created_By->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Created_By->Visible = false; // Disable update for API request
            } else {
                $this->Created_By->setFormValue($val);
            }
        }

        // Check field name 'Last_Updated_Date' first before field var 'x_Last_Updated_Date'
        $val = $CurrentForm->hasValue("Last_Updated_Date") ? $CurrentForm->getValue("Last_Updated_Date") : $CurrentForm->getValue("x_Last_Updated_Date");
        if (!$this->Last_Updated_Date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Last_Updated_Date->Visible = false; // Disable update for API request
            } else {
                $this->Last_Updated_Date->setFormValue($val);
            }
            $this->Last_Updated_Date->CurrentValue = UnFormatDateTime($this->Last_Updated_Date->CurrentValue, $this->Last_Updated_Date->formatPattern());
        }

        // Check field name 'Last_Updated_By' first before field var 'x_Last_Updated_By'
        $val = $CurrentForm->hasValue("Last_Updated_By") ? $CurrentForm->getValue("Last_Updated_By") : $CurrentForm->getValue("x_Last_Updated_By");
        if (!$this->Last_Updated_By->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Last_Updated_By->Visible = false; // Disable update for API request
            } else {
                $this->Last_Updated_By->setFormValue($val);
            }
        }
		$this->ProblemFile->OldUploadPath = $this->ProblemFile->getUploadPath(); // PHP
		$this->ProblemFile->UploadPath = $this->ProblemFile->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ProblemId->CurrentValue = $this->ProblemId->FormValue;
        $this->ProblemDate->CurrentValue = $this->ProblemDate->FormValue;
        $this->ProblemDate->CurrentValue = UnFormatDateTime($this->ProblemDate->CurrentValue, $this->ProblemDate->formatPattern());
        $this->ProblemDescription->CurrentValue = $this->ProblemDescription->FormValue;
        $this->SolutionDescription->CurrentValue = $this->SolutionDescription->FormValue;
        $this->AriseById->CurrentValue = $this->AriseById->FormValue;
        $this->SolvedById->CurrentValue = $this->SolvedById->FormValue;
        $this->_ProjectID->CurrentValue = $this->_ProjectID->FormValue;
        $this->Created_Date->CurrentValue = $this->Created_Date->FormValue;
        $this->Created_Date->CurrentValue = UnFormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());
        $this->Created_By->CurrentValue = $this->Created_By->FormValue;
        $this->Last_Updated_Date->CurrentValue = $this->Last_Updated_Date->FormValue;
        $this->Last_Updated_Date->CurrentValue = UnFormatDateTime($this->Last_Updated_Date->CurrentValue, $this->Last_Updated_Date->formatPattern());
        $this->Last_Updated_By->CurrentValue = $this->Last_Updated_By->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ProblemId->setDbValue($row['ProblemId']);
        $this->ProblemDate->setDbValue($row['ProblemDate']);
        $this->ProblemDescription->setDbValue($row['ProblemDescription']);
        $this->SolutionDescription->setDbValue($row['SolutionDescription']);
        $this->AriseById->setDbValue($row['AriseById']);
        $this->SolvedById->setDbValue($row['SolvedById']);
        $this->ProblemFile->Upload->DbValue = $row['ProblemFile'];
        $this->ProblemFile->setDbValue($this->ProblemFile->Upload->DbValue);
        $this->_ProjectID->setDbValue($row['ProjectID']);
        $this->Created_Date->setDbValue($row['Created_Date']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->Last_Updated_Date->setDbValue($row['Last_Updated_Date']);
        $this->Last_Updated_By->setDbValue($row['Last_Updated_By']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ProblemId'] = $this->ProblemId->DefaultValue;
        $row['ProblemDate'] = $this->ProblemDate->DefaultValue;
        $row['ProblemDescription'] = $this->ProblemDescription->DefaultValue;
        $row['SolutionDescription'] = $this->SolutionDescription->DefaultValue;
        $row['AriseById'] = $this->AriseById->DefaultValue;
        $row['SolvedById'] = $this->SolvedById->DefaultValue;
        $row['ProblemFile'] = $this->ProblemFile->DefaultValue;
        $row['ProjectID'] = $this->_ProjectID->DefaultValue;
        $row['Created_Date'] = $this->Created_Date->DefaultValue;
        $row['Created_By'] = $this->Created_By->DefaultValue;
        $row['Last_Updated_Date'] = $this->Last_Updated_Date->DefaultValue;
        $row['Last_Updated_By'] = $this->Last_Updated_By->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProblemId
        $this->ProblemId->RowCssClass = "row";

        // ProblemDate
        $this->ProblemDate->RowCssClass = "row";

        // ProblemDescription
        $this->ProblemDescription->RowCssClass = "row";

        // SolutionDescription
        $this->SolutionDescription->RowCssClass = "row";

        // AriseById
        $this->AriseById->RowCssClass = "row";

        // SolvedById
        $this->SolvedById->RowCssClass = "row";

        // ProblemFile
        $this->ProblemFile->RowCssClass = "row";

        // ProjectID
        $this->_ProjectID->RowCssClass = "row";

        // Created_Date
        $this->Created_Date->RowCssClass = "row";

        // Created_By
        $this->Created_By->RowCssClass = "row";

        // Last_Updated_Date
        $this->Last_Updated_Date->RowCssClass = "row";

        // Last_Updated_By
        $this->Last_Updated_By->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProblemId
            $this->ProblemId->ViewValue = $this->ProblemId->CurrentValue;

            // ProblemDate
            $this->ProblemDate->ViewValue = $this->ProblemDate->CurrentValue;
            $this->ProblemDate->ViewValue = FormatDateTime($this->ProblemDate->ViewValue, $this->ProblemDate->formatPattern());

            // ProblemDescription
            $this->ProblemDescription->ViewValue = $this->ProblemDescription->CurrentValue;

            // SolutionDescription
            $this->SolutionDescription->ViewValue = $this->SolutionDescription->CurrentValue;

            // AriseById
            $curVal = strval($this->AriseById->CurrentValue);
            if ($curVal != "") {
                $this->AriseById->ViewValue = $this->AriseById->lookupCacheOption($curVal);
                if ($this->AriseById->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->AriseById->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $curVal, $this->AriseById->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                    $lookupFilter = $this->AriseById->getSelectFilter($this); // PHP
                    $sqlWrk = $this->AriseById->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->AriseById->Lookup->renderViewRow($rswrk[0]);
                        $this->AriseById->ViewValue = $this->AriseById->displayValue($arwrk);
                    } else {
                        $this->AriseById->ViewValue = FormatNumber($this->AriseById->CurrentValue, $this->AriseById->formatPattern());
                    }
                }
            } else {
                $this->AriseById->ViewValue = null;
            }

            // SolvedById
            $curVal = strval($this->SolvedById->CurrentValue);
            if ($curVal != "") {
                $this->SolvedById->ViewValue = $this->SolvedById->lookupCacheOption($curVal);
                if ($this->SolvedById->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SolvedById->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $curVal, $this->SolvedById->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                    $lookupFilter = $this->SolvedById->getSelectFilter($this); // PHP
                    $sqlWrk = $this->SolvedById->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SolvedById->Lookup->renderViewRow($rswrk[0]);
                        $this->SolvedById->ViewValue = $this->SolvedById->displayValue($arwrk);
                    } else {
                        $this->SolvedById->ViewValue = FormatNumber($this->SolvedById->CurrentValue, $this->SolvedById->formatPattern());
                    }
                }
            } else {
                $this->SolvedById->ViewValue = null;
            }

            // ProblemFile
            $this->ProblemFile->UploadPath = $this->ProblemFile->getUploadPath(); // PHP
            if (!EmptyValue($this->ProblemFile->Upload->DbValue)) {
                $this->ProblemFile->ViewValue = $this->ProblemFile->Upload->DbValue;
            } else {
                $this->ProblemFile->ViewValue = "";
            }

            // ProjectID
            $curVal = strval($this->_ProjectID->CurrentValue);
            if ($curVal != "") {
                $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                if ($this->_ProjectID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                    $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_ProjectID->Lookup->renderViewRow($rswrk[0]);
                        $this->_ProjectID->ViewValue = $this->_ProjectID->displayValue($arwrk);
                    } else {
                        $this->_ProjectID->ViewValue = FormatNumber($this->_ProjectID->CurrentValue, $this->_ProjectID->formatPattern());
                    }
                }
            } else {
                $this->_ProjectID->ViewValue = null;
            }

            // Created_Date
            $this->Created_Date->ViewValue = $this->Created_Date->CurrentValue;
            $this->Created_Date->ViewValue = FormatDateTime($this->Created_Date->ViewValue, $this->Created_Date->formatPattern());

            // Created_By
            $this->Created_By->ViewValue = $this->Created_By->CurrentValue;

            // Last_Updated_Date
            $this->Last_Updated_Date->ViewValue = $this->Last_Updated_Date->CurrentValue;
            $this->Last_Updated_Date->ViewValue = FormatDateTime($this->Last_Updated_Date->ViewValue, $this->Last_Updated_Date->formatPattern());

            // Last_Updated_By
            $this->Last_Updated_By->ViewValue = $this->Last_Updated_By->CurrentValue;

            // ProblemId
            $this->ProblemId->HrefValue = "";

            // ProblemDate
            $this->ProblemDate->HrefValue = "";

            // ProblemDescription
            $this->ProblemDescription->HrefValue = "";

            // SolutionDescription
            $this->SolutionDescription->HrefValue = "";

            // AriseById
            $this->AriseById->HrefValue = "";

            // SolvedById
            $this->SolvedById->HrefValue = "";

            // ProblemFile
            $this->ProblemFile->UploadPath = $this->ProblemFile->getUploadPath(); // PHP
            if (!EmptyValue($this->ProblemFile->Upload->DbValue)) {
                $this->ProblemFile->HrefValue = GetFileUploadUrl($this->ProblemFile, $this->ProblemFile->htmlDecode($this->ProblemFile->Upload->DbValue)); // Add prefix/suffix
                $this->ProblemFile->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->ProblemFile->HrefValue = FullUrl($this->ProblemFile->HrefValue, "href");
                }
            } else {
                $this->ProblemFile->HrefValue = "";
            }
            $this->ProblemFile->ExportHrefValue = $this->ProblemFile->UploadPath . $this->ProblemFile->Upload->DbValue;

            // ProjectID
            $this->_ProjectID->HrefValue = "";

            // Created_Date
            $this->Created_Date->HrefValue = "";

            // Created_By
            $this->Created_By->HrefValue = "";

            // Last_Updated_Date
            $this->Last_Updated_Date->HrefValue = "";

            // Last_Updated_By
            $this->Last_Updated_By->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // ProblemId
            $this->ProblemId->setupEditAttributes();
            $this->ProblemId->EditValue = $this->ProblemId->CurrentValue;

            // ProblemDate
            $this->ProblemDate->setupEditAttributes();
            $this->ProblemDate->EditValue = HtmlEncode(FormatDateTime($this->ProblemDate->CurrentValue, $this->ProblemDate->formatPattern()));
            $this->ProblemDate->PlaceHolder = RemoveHtml($this->ProblemDate->caption());

            // ProblemDescription
            $this->ProblemDescription->setupEditAttributes();
            $this->ProblemDescription->EditValue = HtmlEncode($this->ProblemDescription->CurrentValue);
            $this->ProblemDescription->PlaceHolder = RemoveHtml($this->ProblemDescription->caption());

            // SolutionDescription
            $this->SolutionDescription->setupEditAttributes();
            $this->SolutionDescription->EditValue = HtmlEncode($this->SolutionDescription->CurrentValue);
            $this->SolutionDescription->PlaceHolder = RemoveHtml($this->SolutionDescription->caption());

            // AriseById
            $this->AriseById->setupEditAttributes();
            $curVal = trim(strval($this->AriseById->CurrentValue));
            if ($curVal != "") {
                $this->AriseById->ViewValue = $this->AriseById->lookupCacheOption($curVal);
            } else {
                $this->AriseById->ViewValue = $this->AriseById->Lookup !== null && is_array($this->AriseById->lookupOptions()) && count($this->AriseById->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->AriseById->ViewValue !== null) { // Load from cache
                $this->AriseById->EditValue = array_values($this->AriseById->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->AriseById->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $this->AriseById->CurrentValue, $this->AriseById->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                }
                $lookupFilter = $this->AriseById->getSelectFilter($this); // PHP
                $sqlWrk = $this->AriseById->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->AriseById->EditValue = $arwrk;
            }
            $this->AriseById->PlaceHolder = RemoveHtml($this->AriseById->caption());

            // SolvedById
            $this->SolvedById->setupEditAttributes();
            $curVal = trim(strval($this->SolvedById->CurrentValue));
            if ($curVal != "") {
                $this->SolvedById->ViewValue = $this->SolvedById->lookupCacheOption($curVal);
            } else {
                $this->SolvedById->ViewValue = $this->SolvedById->Lookup !== null && is_array($this->SolvedById->lookupOptions()) && count($this->SolvedById->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->SolvedById->ViewValue !== null) { // Load from cache
                $this->SolvedById->EditValue = array_values($this->SolvedById->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->SolvedById->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $this->SolvedById->CurrentValue, $this->SolvedById->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                }
                $lookupFilter = $this->SolvedById->getSelectFilter($this); // PHP
                $sqlWrk = $this->SolvedById->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->SolvedById->EditValue = $arwrk;
            }
            $this->SolvedById->PlaceHolder = RemoveHtml($this->SolvedById->caption());

            // ProblemFile
            $this->ProblemFile->setupEditAttributes();
            $this->ProblemFile->UploadPath = $this->ProblemFile->getUploadPath(); // PHP
            if (!EmptyValue($this->ProblemFile->Upload->DbValue)) {
                $this->ProblemFile->EditValue = $this->ProblemFile->Upload->DbValue;
            } else {
                $this->ProblemFile->EditValue = "";
            }
            if (!EmptyValue($this->ProblemFile->CurrentValue)) {
                $this->ProblemFile->Upload->FileName = $this->ProblemFile->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->ProblemFile);
            }

            // ProjectID
            $this->_ProjectID->setupEditAttributes();
            if ($this->_ProjectID->getSessionValue() != "") {
                $this->_ProjectID->CurrentValue = GetForeignKeyValue($this->_ProjectID->getSessionValue());
                $curVal = strval($this->_ProjectID->CurrentValue);
                if ($curVal != "") {
                    $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                    if ($this->_ProjectID->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                        $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->_ProjectID->Lookup->renderViewRow($rswrk[0]);
                            $this->_ProjectID->ViewValue = $this->_ProjectID->displayValue($arwrk);
                        } else {
                            $this->_ProjectID->ViewValue = FormatNumber($this->_ProjectID->CurrentValue, $this->_ProjectID->formatPattern());
                        }
                    }
                } else {
                    $this->_ProjectID->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->_ProjectID->CurrentValue));
                if ($curVal != "") {
                    $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                } else {
                    $this->_ProjectID->ViewValue = $this->_ProjectID->Lookup !== null && is_array($this->_ProjectID->lookupOptions()) && count($this->_ProjectID->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->_ProjectID->ViewValue !== null) { // Load from cache
                    $this->_ProjectID->EditValue = array_values($this->_ProjectID->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $this->_ProjectID->CurrentValue, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->_ProjectID->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->_ProjectID->EditValue = $arwrk;
                }
                $this->_ProjectID->PlaceHolder = RemoveHtml($this->_ProjectID->caption());
            }

            // Created_Date
            $this->Created_Date->setupEditAttributes();
            $this->Created_Date->CurrentValue = FormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());

            // Created_By
            $this->Created_By->setupEditAttributes();

            // Last_Updated_Date

            // Last_Updated_By

            // Edit refer script

            // ProblemId
            $this->ProblemId->HrefValue = "";

            // ProblemDate
            $this->ProblemDate->HrefValue = "";

            // ProblemDescription
            $this->ProblemDescription->HrefValue = "";

            // SolutionDescription
            $this->SolutionDescription->HrefValue = "";

            // AriseById
            $this->AriseById->HrefValue = "";

            // SolvedById
            $this->SolvedById->HrefValue = "";

            // ProblemFile
            $this->ProblemFile->UploadPath = $this->ProblemFile->getUploadPath(); // PHP
            if (!EmptyValue($this->ProblemFile->Upload->DbValue)) {
                $this->ProblemFile->HrefValue = GetFileUploadUrl($this->ProblemFile, $this->ProblemFile->htmlDecode($this->ProblemFile->Upload->DbValue)); // Add prefix/suffix
                $this->ProblemFile->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->ProblemFile->HrefValue = FullUrl($this->ProblemFile->HrefValue, "href");
                }
            } else {
                $this->ProblemFile->HrefValue = "";
            }
            $this->ProblemFile->ExportHrefValue = $this->ProblemFile->UploadPath . $this->ProblemFile->Upload->DbValue;

            // ProjectID
            $this->_ProjectID->HrefValue = "";

            // Created_Date
            $this->Created_Date->HrefValue = "";

            // Created_By
            $this->Created_By->HrefValue = "";

            // Last_Updated_Date
            $this->Last_Updated_Date->HrefValue = "";

            // Last_Updated_By
            $this->Last_Updated_By->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->ProblemId->Visible && $this->ProblemId->Required) {
                if (!$this->ProblemId->IsDetailKey && EmptyValue($this->ProblemId->FormValue)) {
                    $this->ProblemId->addErrorMessage(str_replace("%s", $this->ProblemId->caption(), $this->ProblemId->RequiredErrorMessage));
                }
            }
            if ($this->ProblemDate->Visible && $this->ProblemDate->Required) {
                if (!$this->ProblemDate->IsDetailKey && EmptyValue($this->ProblemDate->FormValue)) {
                    $this->ProblemDate->addErrorMessage(str_replace("%s", $this->ProblemDate->caption(), $this->ProblemDate->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->ProblemDate->FormValue, $this->ProblemDate->formatPattern())) {
                $this->ProblemDate->addErrorMessage($this->ProblemDate->getErrorMessage(false));
            }
            if ($this->ProblemDescription->Visible && $this->ProblemDescription->Required) {
                if (!$this->ProblemDescription->IsDetailKey && EmptyValue($this->ProblemDescription->FormValue)) {
                    $this->ProblemDescription->addErrorMessage(str_replace("%s", $this->ProblemDescription->caption(), $this->ProblemDescription->RequiredErrorMessage));
                }
            }
            if ($this->SolutionDescription->Visible && $this->SolutionDescription->Required) {
                if (!$this->SolutionDescription->IsDetailKey && EmptyValue($this->SolutionDescription->FormValue)) {
                    $this->SolutionDescription->addErrorMessage(str_replace("%s", $this->SolutionDescription->caption(), $this->SolutionDescription->RequiredErrorMessage));
                }
            }
            if ($this->AriseById->Visible && $this->AriseById->Required) {
                if (!$this->AriseById->IsDetailKey && EmptyValue($this->AriseById->FormValue)) {
                    $this->AriseById->addErrorMessage(str_replace("%s", $this->AriseById->caption(), $this->AriseById->RequiredErrorMessage));
                }
            }
            if ($this->SolvedById->Visible && $this->SolvedById->Required) {
                if (!$this->SolvedById->IsDetailKey && EmptyValue($this->SolvedById->FormValue)) {
                    $this->SolvedById->addErrorMessage(str_replace("%s", $this->SolvedById->caption(), $this->SolvedById->RequiredErrorMessage));
                }
            }
            if ($this->ProblemFile->Visible && $this->ProblemFile->Required) {
                if ($this->ProblemFile->Upload->FileName == "" && !$this->ProblemFile->Upload->KeepFile) {
                    $this->ProblemFile->addErrorMessage(str_replace("%s", $this->ProblemFile->caption(), $this->ProblemFile->RequiredErrorMessage));
                }
            }
            if ($this->_ProjectID->Visible && $this->_ProjectID->Required) {
                if (!$this->_ProjectID->IsDetailKey && EmptyValue($this->_ProjectID->FormValue)) {
                    $this->_ProjectID->addErrorMessage(str_replace("%s", $this->_ProjectID->caption(), $this->_ProjectID->RequiredErrorMessage));
                }
            }
            if ($this->Created_Date->Visible && $this->Created_Date->Required) {
                if (!$this->Created_Date->IsDetailKey && EmptyValue($this->Created_Date->FormValue)) {
                    $this->Created_Date->addErrorMessage(str_replace("%s", $this->Created_Date->caption(), $this->Created_Date->RequiredErrorMessage));
                }
            }
            if ($this->Created_By->Visible && $this->Created_By->Required) {
                if (!$this->Created_By->IsDetailKey && EmptyValue($this->Created_By->FormValue)) {
                    $this->Created_By->addErrorMessage(str_replace("%s", $this->Created_By->caption(), $this->Created_By->RequiredErrorMessage));
                }
            }
            if ($this->Last_Updated_Date->Visible && $this->Last_Updated_Date->Required) {
                if (!$this->Last_Updated_Date->IsDetailKey && EmptyValue($this->Last_Updated_Date->FormValue)) {
                    $this->Last_Updated_Date->addErrorMessage(str_replace("%s", $this->Last_Updated_Date->caption(), $this->Last_Updated_Date->RequiredErrorMessage));
                }
            }
            if ($this->Last_Updated_By->Visible && $this->Last_Updated_By->Required) {
                if (!$this->Last_Updated_By->IsDetailKey && EmptyValue($this->Last_Updated_By->FormValue)) {
                    $this->Last_Updated_By->addErrorMessage(str_replace("%s", $this->Last_Updated_By->caption(), $this->Last_Updated_By->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check referential integrity for master table 'masterproject'
        $detailKeys = [];
        $keyValue = $rsnew['ProjectID'] ?? $rsold['ProjectID'];
        $detailKeys['ProjectID'] = $keyValue;
        $masterTable = Container("masterproject");
        $masterFilter = $this->getMasterFilter($masterTable, $detailKeys);
        if (!EmptyValue($masterFilter)) {
            $rsmaster = $masterTable->loadRs($masterFilter)->fetch();
            $validMasterRecord = $rsmaster !== false;
        } else { // Allow null value if not required field
            $validMasterRecord = $masterFilter === null;
        }
        if (!$validMasterRecord) {
            $relatedRecordMsg = str_replace("%t", "masterproject", $Language->phrase("RelatedRecordRequired"));
            $this->setFailureMessage($relatedRecordMsg);
            return false;
        }
        if ($this->ProblemFile->Visible && !$this->ProblemFile->Upload->KeepFile) {
            $this->ProblemFile->UploadPath = $this->ProblemFile->getUploadPath();
            if (!EmptyValue($this->ProblemFile->Upload->FileName)) {
                FixUploadFileNames($this->ProblemFile);
                $this->ProblemFile->setDbValueDef($rsnew, $this->ProblemFile->Upload->FileName, $this->ProblemFile->ReadOnly);
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->ProblemFile->Visible && !$this->ProblemFile->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->ProblemFile, $rsnew['ProblemFile'], false)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->ProblemFile->OldUploadPath = $this->ProblemFile->getUploadPath(); // PHP
        $this->ProblemFile->UploadPath = $this->ProblemFile->OldUploadPath;
        $rsnew = [];

        // ProblemDate
        $this->ProblemDate->setDbValueDef($rsnew, UnFormatDateTime($this->ProblemDate->CurrentValue, $this->ProblemDate->formatPattern()), $this->ProblemDate->ReadOnly);

        // ProblemDescription
        $this->ProblemDescription->setDbValueDef($rsnew, $this->ProblemDescription->CurrentValue, $this->ProblemDescription->ReadOnly);

        // SolutionDescription
        $this->SolutionDescription->setDbValueDef($rsnew, $this->SolutionDescription->CurrentValue, $this->SolutionDescription->ReadOnly);

        // AriseById
        $this->AriseById->setDbValueDef($rsnew, $this->AriseById->CurrentValue, $this->AriseById->ReadOnly);

        // SolvedById
        $this->SolvedById->setDbValueDef($rsnew, $this->SolvedById->CurrentValue, $this->SolvedById->ReadOnly);

        // ProblemFile
        if ($this->ProblemFile->Visible && !$this->ProblemFile->ReadOnly && !$this->ProblemFile->Upload->KeepFile) {
            if ($this->ProblemFile->Upload->FileName == "") {
                $rsnew['ProblemFile'] = null;
            } else {
                FixUploadTempFileNames($this->ProblemFile);
                $rsnew['ProblemFile'] = $this->ProblemFile->Upload->FileName;
            }
        }

        // ProjectID
        if ($this->_ProjectID->getSessionValue() != "") {
            $this->_ProjectID->ReadOnly = true;
        }
        $this->_ProjectID->setDbValueDef($rsnew, $this->_ProjectID->CurrentValue, $this->_ProjectID->ReadOnly);

        // Created_Date
        $this->Created_Date->setDbValueDef($rsnew, UnFormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern()), $this->Created_Date->ReadOnly);

        // Created_By
        $this->Created_By->setDbValueDef($rsnew, $this->Created_By->CurrentValue, $this->Created_By->ReadOnly);

        // Last_Updated_Date
        $this->Last_Updated_Date->CurrentValue = $this->Last_Updated_Date->getAutoUpdateValue(); // PHP
        $this->Last_Updated_Date->setDbValueDef($rsnew, UnFormatDateTime($this->Last_Updated_Date->CurrentValue, $this->Last_Updated_Date->formatPattern()));

        // Last_Updated_By
        $this->Last_Updated_By->CurrentValue = $this->Last_Updated_By->getAutoUpdateValue(); // PHP
        $this->Last_Updated_By->setDbValueDef($rsnew, $this->Last_Updated_By->CurrentValue);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['ProblemDate'])) { // ProblemDate
            $this->ProblemDate->CurrentValue = $row['ProblemDate'];
        }
        if (isset($row['ProblemDescription'])) { // ProblemDescription
            $this->ProblemDescription->CurrentValue = $row['ProblemDescription'];
        }
        if (isset($row['SolutionDescription'])) { // SolutionDescription
            $this->SolutionDescription->CurrentValue = $row['SolutionDescription'];
        }
        if (isset($row['AriseById'])) { // AriseById
            $this->AriseById->CurrentValue = $row['AriseById'];
        }
        if (isset($row['SolvedById'])) { // SolvedById
            $this->SolvedById->CurrentValue = $row['SolvedById'];
        }
        if (isset($row['ProblemFile'])) { // ProblemFile
            $this->ProblemFile->CurrentValue = $row['ProblemFile'];
        }
        if (isset($row['ProjectID'])) { // ProjectID
            $this->_ProjectID->CurrentValue = $row['ProjectID'];
        }
        if (isset($row['Created_Date'])) { // Created_Date
            $this->Created_Date->CurrentValue = $row['Created_Date'];
        }
        if (isset($row['Created_By'])) { // Created_By
            $this->Created_By->CurrentValue = $row['Created_By'];
        }
        if (isset($row['Last_Updated_Date'])) { // Last_Updated_Date
            $this->Last_Updated_Date->CurrentValue = $row['Last_Updated_Date'];
        }
        if (isset($row['Last_Updated_By'])) { // Last_Updated_By
            $this->Last_Updated_By->CurrentValue = $row['Last_Updated_By'];
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "masterproject") {
                $validMaster = true;
                $masterTbl = Container("masterproject");
                if (($parm = Get("fk__ProjectID", Get("_ProjectID"))) !== null) {
                    $masterTbl->_ProjectID->setQueryStringValue($parm);
                    $this->_ProjectID->QueryStringValue = $masterTbl->_ProjectID->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->_ProjectID->setSessionValue($this->_ProjectID->QueryStringValue);
                    $foreignKeys["_ProjectID"] = $this->_ProjectID->QueryStringValue;
                    if (!is_numeric($masterTbl->_ProjectID->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "masterproject") {
                $validMaster = true;
                $masterTbl = Container("masterproject");
                if (($parm = Post("fk__ProjectID", Post("_ProjectID"))) !== null) {
                    $masterTbl->_ProjectID->setFormValue($parm);
                    $this->_ProjectID->FormValue = $masterTbl->_ProjectID->FormValue;
                    $this->_ProjectID->setSessionValue($this->_ProjectID->FormValue);
                    $foreignKeys["_ProjectID"] = $this->_ProjectID->FormValue;
                    if (!is_numeric($masterTbl->_ProjectID->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);
            $this->setSessionWhere($this->getDetailFilterFromSession());

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "masterproject") {
                if (!array_key_exists("_ProjectID", $foreignKeys)) { // Not current foreign key
                    $this->_ProjectID->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("masterprojectlist");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("projectproblemslist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_AriseById":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_SolvedById":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__ProjectID":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
