<?php

namespace ProjectManagement\prjProjectManagement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProjectresultUpdate extends Projectresult
{
    use MessagesTrait;

    // Page ID
    public $PageID = "update";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProjectresultUpdate";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "projectresultupdate";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ResultID->Visible = false;
        $this->Activities->setVisibility();
        $this->DateDelivered->setVisibility();
        $this->Progress->setVisibility();
        $this->Status->setVisibility();
        $this->Category->setVisibility();
        $this->Weight->setVisibility();
        $this->File->setVisibility();
        $this->Notes->setVisibility();
        $this->_ProjectID->setVisibility();
        $this->templateid->Visible = false;
        $this->Created_Date->setVisibility();
        $this->Created_By->setVisibility();
        $this->Last_Updated_Date->setVisibility();
        $this->Last_Updated_By->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'projectresult';
        $this->TableName = 'projectresult';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-update-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (projectresult)
        if (!isset($GLOBALS["projectresult"]) || $GLOBALS["projectresult"]::class == PROJECT_NAMESPACE . "projectresult") {
            $GLOBALS["projectresult"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'projectresult');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "projectresultview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->File->OldUploadPath = $this->File->getUploadPath(); // PHP
                $this->File->UploadPath = $this->File->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['ResultID'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->ResultID->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-update-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $RecKeys;
    public $Disabled;
    public $UpdateCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->Status);
        $this->setupLookupOptions($this->Category);
        $this->setupLookupOptions($this->_ProjectID);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Try to load keys from list form
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        if (Post("action") !== null && Post("action") !== "") {
            // Get action
            $this->CurrentAction = Post("action");
            $this->loadFormValues(); // Get form values

            // Validate form
            if (!$this->validateForm()) {
                $this->CurrentAction = "show"; // Form error, reset action
                if (!$this->hasInvalidFields()) { // No fields selected
                    $this->setFailureMessage($Language->phrase("NoFieldSelected"));
                }
            }
        } else {
            $this->loadMultiUpdateValues(); // Load initial values to form
        }
        if (count($this->RecKeys) <= 0) {
            $this->terminate("projectresultlist"); // No records selected, return to list
            return;
        }
        if ($this->isUpdate()) {
                if ($this->updateRows()) { // Update Records based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
                    }

                    // Do not return Json for UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                    }
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([
                        "success" => false,
                        "validation" => $this->getValidationErrors(),
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->restoreFormValues(); // Restore form values
                }
        }

        // Render row
        $this->RowType = RowType::EDIT; // Render edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load initial values to form if field values are identical in all selected records
    protected function loadMultiUpdateValues()
    {
        $this->CurrentFilter = $this->getFilterFromRecordKeys();

        // Load result set
        if ($rs = $this->loadRecordset()) {
            $i = 1;
            while ($row = $rs->fetch()) {
                if ($i == 1) {
                    $this->Activities->setDbValue($row['Activities']);
                    $this->DateDelivered->setDbValue($row['DateDelivered']);
                    $this->Progress->setDbValue($row['Progress']);
                    $this->Status->setDbValue($row['Status']);
                    $this->Category->setDbValue($row['Category']);
                    $this->Weight->setDbValue($row['Weight']);
                    $this->Notes->setDbValue($row['Notes']);
                    $this->_ProjectID->setDbValue($row['ProjectID']);
                    $this->Created_Date->setDbValue($row['Created_Date']);
                    $this->Created_By->setDbValue($row['Created_By']);
                    $this->Last_Updated_Date->setDbValue($row['Last_Updated_Date']);
                    $this->Last_Updated_By->setDbValue($row['Last_Updated_By']);
                } else {
                    if (!CompareValue($this->Activities->DbValue, $row['Activities'])) {
                        $this->Activities->CurrentValue = null;
                    }
                    if (!CompareValue($this->DateDelivered->DbValue, $row['DateDelivered'])) {
                        $this->DateDelivered->CurrentValue = null;
                    }
                    if (!CompareValue($this->Progress->DbValue, $row['Progress'])) {
                        $this->Progress->CurrentValue = null;
                    }
                    if (!CompareValue($this->Status->DbValue, $row['Status'])) {
                        $this->Status->CurrentValue = null;
                    }
                    if (!CompareValue($this->Category->DbValue, $row['Category'])) {
                        $this->Category->CurrentValue = null;
                    }
                    if (!CompareValue($this->Weight->DbValue, $row['Weight'])) {
                        $this->Weight->CurrentValue = null;
                    }
                    if (!CompareValue($this->Notes->DbValue, $row['Notes'])) {
                        $this->Notes->CurrentValue = null;
                    }
                    if (!CompareValue($this->_ProjectID->DbValue, $row['ProjectID'])) {
                        $this->_ProjectID->CurrentValue = null;
                    }
                    if (!CompareValue($this->Created_Date->DbValue, $row['Created_Date'])) {
                        $this->Created_Date->CurrentValue = null;
                    }
                    if (!CompareValue($this->Created_By->DbValue, $row['Created_By'])) {
                        $this->Created_By->CurrentValue = null;
                    }
                    if (!CompareValue($this->Last_Updated_Date->DbValue, $row['Last_Updated_Date'])) {
                        $this->Last_Updated_Date->CurrentValue = null;
                    }
                    if (!CompareValue($this->Last_Updated_By->DbValue, $row['Last_Updated_By'])) {
                        $this->Last_Updated_By->CurrentValue = null;
                    }
                }
                $i++;
            }
            $rs->free();
        }
    }

    // Set up key value
    protected function setupKeyValues($key)
    {
        $keyFld = $key;
        if (!is_numeric($keyFld)) {
            return false;
        }
        $this->ResultID->OldValue = $keyFld;
        return true;
    }

    // Update all selected rows
    protected function updateRows()
    {
        global $Language;
        $conn = $this->getConnection();
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Get old records
        $this->CurrentFilter = $this->getFilterFromRecordKeys(false);
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAllAssociative($sql);

        // Update all rows
        $successKeys = [];
        $failKeys = [];
        foreach ($this->RecKeys as $reckey) {
            if ($this->setupKeyValues($reckey)) {
                $thisKey = $reckey;
                $this->SendEmail = false; // Do not send email on update success
                $this->UpdateCount += 1; // Update record count for records being updated
                $rowUpdated = $this->editRow(); // Update this row
            } else {
                $rowUpdated = false;
            }
            if (!$rowUpdated) {
                if ($this->UseTransaction) { // Update failed
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                $successKeys[] = $thisKey;
            }
        }

        // Check if any rows updated
        if (count($successKeys) > 0) {
            if ($this->UseTransaction) { // Commit transaction
                $conn->commit();
            }

            // Set warning message if update some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("UpdateSomeRecordsFailed")));
            }

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);
            return true;
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                $conn->rollback();
            }
            return false;
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->File->Upload->Index = $CurrentForm->Index;
        $this->File->Upload->uploadFile();
        $this->File->CurrentValue = $this->File->Upload->FileName;
        $this->File->MultiUpdate = $CurrentForm->getValue("u_File");
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'Activities' first before field var 'x_Activities'
        $val = $CurrentForm->hasValue("Activities") ? $CurrentForm->getValue("Activities") : $CurrentForm->getValue("x_Activities");
        if (!$this->Activities->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Activities->Visible = false; // Disable update for API request
            } else {
                $this->Activities->setFormValue($val);
            }
        }
        $this->Activities->MultiUpdate = $CurrentForm->getValue("u_Activities");

        // Check field name 'DateDelivered' first before field var 'x_DateDelivered'
        $val = $CurrentForm->hasValue("DateDelivered") ? $CurrentForm->getValue("DateDelivered") : $CurrentForm->getValue("x_DateDelivered");
        if (!$this->DateDelivered->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DateDelivered->Visible = false; // Disable update for API request
            } else {
                $this->DateDelivered->setFormValue($val, true, $validate);
            }
            $this->DateDelivered->CurrentValue = UnFormatDateTime($this->DateDelivered->CurrentValue, $this->DateDelivered->formatPattern());
        }
        $this->DateDelivered->MultiUpdate = $CurrentForm->getValue("u_DateDelivered");

        // Check field name 'Progress' first before field var 'x_Progress'
        $val = $CurrentForm->hasValue("Progress") ? $CurrentForm->getValue("Progress") : $CurrentForm->getValue("x_Progress");
        if (!$this->Progress->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Progress->Visible = false; // Disable update for API request
            } else {
                $this->Progress->setFormValue($val, true, $validate);
            }
        }
        $this->Progress->MultiUpdate = $CurrentForm->getValue("u_Progress");

        // Check field name 'Status' first before field var 'x_Status'
        $val = $CurrentForm->hasValue("Status") ? $CurrentForm->getValue("Status") : $CurrentForm->getValue("x_Status");
        if (!$this->Status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Status->Visible = false; // Disable update for API request
            } else {
                $this->Status->setFormValue($val);
            }
        }
        $this->Status->MultiUpdate = $CurrentForm->getValue("u_Status");

        // Check field name 'Category' first before field var 'x_Category'
        $val = $CurrentForm->hasValue("Category") ? $CurrentForm->getValue("Category") : $CurrentForm->getValue("x_Category");
        if (!$this->Category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Category->Visible = false; // Disable update for API request
            } else {
                $this->Category->setFormValue($val);
            }
        }
        $this->Category->MultiUpdate = $CurrentForm->getValue("u_Category");

        // Check field name 'Weight' first before field var 'x_Weight'
        $val = $CurrentForm->hasValue("Weight") ? $CurrentForm->getValue("Weight") : $CurrentForm->getValue("x_Weight");
        if (!$this->Weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Weight->Visible = false; // Disable update for API request
            } else {
                $this->Weight->setFormValue($val, true, $validate);
            }
        }
        $this->Weight->MultiUpdate = $CurrentForm->getValue("u_Weight");

        // Check field name 'Notes' first before field var 'x_Notes'
        $val = $CurrentForm->hasValue("Notes") ? $CurrentForm->getValue("Notes") : $CurrentForm->getValue("x_Notes");
        if (!$this->Notes->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Notes->Visible = false; // Disable update for API request
            } else {
                $this->Notes->setFormValue($val);
            }
        }
        $this->Notes->MultiUpdate = $CurrentForm->getValue("u_Notes");

        // Check field name 'ProjectID' first before field var 'x__ProjectID'
        $val = $CurrentForm->hasValue("ProjectID") ? $CurrentForm->getValue("ProjectID") : $CurrentForm->getValue("x__ProjectID");
        if (!$this->_ProjectID->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_ProjectID->Visible = false; // Disable update for API request
            } else {
                $this->_ProjectID->setFormValue($val);
            }
        }
        $this->_ProjectID->MultiUpdate = $CurrentForm->getValue("u__ProjectID");

        // Check field name 'Created_Date' first before field var 'x_Created_Date'
        $val = $CurrentForm->hasValue("Created_Date") ? $CurrentForm->getValue("Created_Date") : $CurrentForm->getValue("x_Created_Date");
        if (!$this->Created_Date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Created_Date->Visible = false; // Disable update for API request
            } else {
                $this->Created_Date->setFormValue($val);
            }
            $this->Created_Date->CurrentValue = UnFormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());
        }
        $this->Created_Date->MultiUpdate = $CurrentForm->getValue("u_Created_Date");

        // Check field name 'Created_By' first before field var 'x_Created_By'
        $val = $CurrentForm->hasValue("Created_By") ? $CurrentForm->getValue("Created_By") : $CurrentForm->getValue("x_Created_By");
        if (!$this->Created_By->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Created_By->Visible = false; // Disable update for API request
            } else {
                $this->Created_By->setFormValue($val);
            }
        }
        $this->Created_By->MultiUpdate = $CurrentForm->getValue("u_Created_By");

        // Check field name 'Last_Updated_Date' first before field var 'x_Last_Updated_Date'
        $val = $CurrentForm->hasValue("Last_Updated_Date") ? $CurrentForm->getValue("Last_Updated_Date") : $CurrentForm->getValue("x_Last_Updated_Date");
        if (!$this->Last_Updated_Date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Last_Updated_Date->Visible = false; // Disable update for API request
            } else {
                $this->Last_Updated_Date->setFormValue($val);
            }
            $this->Last_Updated_Date->CurrentValue = UnFormatDateTime($this->Last_Updated_Date->CurrentValue, $this->Last_Updated_Date->formatPattern());
        }
        $this->Last_Updated_Date->MultiUpdate = $CurrentForm->getValue("u_Last_Updated_Date");

        // Check field name 'Last_Updated_By' first before field var 'x_Last_Updated_By'
        $val = $CurrentForm->hasValue("Last_Updated_By") ? $CurrentForm->getValue("Last_Updated_By") : $CurrentForm->getValue("x_Last_Updated_By");
        if (!$this->Last_Updated_By->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Last_Updated_By->Visible = false; // Disable update for API request
            } else {
                $this->Last_Updated_By->setFormValue($val);
            }
        }
        $this->Last_Updated_By->MultiUpdate = $CurrentForm->getValue("u_Last_Updated_By");

        // Check field name 'ResultID' first before field var 'x_ResultID'
        $val = $CurrentForm->hasValue("ResultID") ? $CurrentForm->getValue("ResultID") : $CurrentForm->getValue("x_ResultID");
        if (!$this->ResultID->IsDetailKey) {
            $this->ResultID->setFormValue($val);
        }
		$this->File->OldUploadPath = $this->File->getUploadPath(); // PHP
		$this->File->UploadPath = $this->File->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ResultID->CurrentValue = $this->ResultID->FormValue;
        $this->Activities->CurrentValue = $this->Activities->FormValue;
        $this->DateDelivered->CurrentValue = $this->DateDelivered->FormValue;
        $this->DateDelivered->CurrentValue = UnFormatDateTime($this->DateDelivered->CurrentValue, $this->DateDelivered->formatPattern());
        $this->Progress->CurrentValue = $this->Progress->FormValue;
        $this->Status->CurrentValue = $this->Status->FormValue;
        $this->Category->CurrentValue = $this->Category->FormValue;
        $this->Weight->CurrentValue = $this->Weight->FormValue;
        $this->Notes->CurrentValue = $this->Notes->FormValue;
        $this->_ProjectID->CurrentValue = $this->_ProjectID->FormValue;
        $this->Created_Date->CurrentValue = $this->Created_Date->FormValue;
        $this->Created_Date->CurrentValue = UnFormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());
        $this->Created_By->CurrentValue = $this->Created_By->FormValue;
        $this->Last_Updated_Date->CurrentValue = $this->Last_Updated_Date->FormValue;
        $this->Last_Updated_Date->CurrentValue = UnFormatDateTime($this->Last_Updated_Date->CurrentValue, $this->Last_Updated_Date->formatPattern());
        $this->Last_Updated_By->CurrentValue = $this->Last_Updated_By->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ResultID->setDbValue($row['ResultID']);
        $this->Activities->setDbValue($row['Activities']);
        $this->DateDelivered->setDbValue($row['DateDelivered']);
        $this->Progress->setDbValue($row['Progress']);
        $this->Status->setDbValue($row['Status']);
        $this->Category->setDbValue($row['Category']);
        $this->Weight->setDbValue($row['Weight']);
        $this->File->Upload->DbValue = $row['File'];
        $this->File->setDbValue($this->File->Upload->DbValue);
        $this->Notes->setDbValue($row['Notes']);
        $this->_ProjectID->setDbValue($row['ProjectID']);
        $this->templateid->setDbValue($row['templateid']);
        $this->Created_Date->setDbValue($row['Created_Date']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->Last_Updated_Date->setDbValue($row['Last_Updated_Date']);
        $this->Last_Updated_By->setDbValue($row['Last_Updated_By']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ResultID'] = $this->ResultID->DefaultValue;
        $row['Activities'] = $this->Activities->DefaultValue;
        $row['DateDelivered'] = $this->DateDelivered->DefaultValue;
        $row['Progress'] = $this->Progress->DefaultValue;
        $row['Status'] = $this->Status->DefaultValue;
        $row['Category'] = $this->Category->DefaultValue;
        $row['Weight'] = $this->Weight->DefaultValue;
        $row['File'] = $this->File->DefaultValue;
        $row['Notes'] = $this->Notes->DefaultValue;
        $row['ProjectID'] = $this->_ProjectID->DefaultValue;
        $row['templateid'] = $this->templateid->DefaultValue;
        $row['Created_Date'] = $this->Created_Date->DefaultValue;
        $row['Created_By'] = $this->Created_By->DefaultValue;
        $row['Last_Updated_Date'] = $this->Last_Updated_Date->DefaultValue;
        $row['Last_Updated_By'] = $this->Last_Updated_By->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ResultID
        $this->ResultID->RowCssClass = "row";

        // Activities
        $this->Activities->RowCssClass = "row";

        // DateDelivered
        $this->DateDelivered->RowCssClass = "row";

        // Progress
        $this->Progress->RowCssClass = "row";

        // Status
        $this->Status->RowCssClass = "row";

        // Category
        $this->Category->RowCssClass = "row";

        // Weight
        $this->Weight->RowCssClass = "row";

        // File
        $this->File->RowCssClass = "row";

        // Notes
        $this->Notes->RowCssClass = "row";

        // ProjectID
        $this->_ProjectID->RowCssClass = "row";

        // templateid
        $this->templateid->RowCssClass = "row";

        // Created_Date
        $this->Created_Date->RowCssClass = "row";

        // Created_By
        $this->Created_By->RowCssClass = "row";

        // Last_Updated_Date
        $this->Last_Updated_Date->RowCssClass = "row";

        // Last_Updated_By
        $this->Last_Updated_By->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ResultID
            $this->ResultID->ViewValue = $this->ResultID->CurrentValue;

            // Activities
            $this->Activities->ViewValue = $this->Activities->CurrentValue;

            // DateDelivered
            $this->DateDelivered->ViewValue = $this->DateDelivered->CurrentValue;
            $this->DateDelivered->ViewValue = FormatDateTime($this->DateDelivered->ViewValue, $this->DateDelivered->formatPattern());

            // Progress
            $this->Progress->ViewValue = $this->Progress->CurrentValue;
            $this->Progress->ViewValue = FormatPercent($this->Progress->ViewValue, $this->Progress->formatPattern());
            $this->Progress->CellCssStyle .= "text-align: right;";

            // Status
            $curVal = strval($this->Status->CurrentValue);
            if ($curVal != "") {
                $this->Status->ViewValue = $this->Status->lookupCacheOption($curVal);
                if ($this->Status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Status->Lookup->getTable()->Fields["Status"]->searchExpression(), "=", $curVal, $this->Status->Lookup->getTable()->Fields["Status"]->searchDataType(), "");
                    $sqlWrk = $this->Status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Status->Lookup->renderViewRow($rswrk[0]);
                        $this->Status->ViewValue = $this->Status->displayValue($arwrk);
                    } else {
                        $this->Status->ViewValue = $this->Status->CurrentValue;
                    }
                }
            } else {
                $this->Status->ViewValue = null;
            }

            // Category
            $curVal = strval($this->Category->CurrentValue);
            if ($curVal != "") {
                $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
                if ($this->Category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Category->Lookup->getTable()->Fields["CategoryName"]->searchExpression(), "=", $curVal, $this->Category->Lookup->getTable()->Fields["CategoryName"]->searchDataType(), "");
                    $lookupFilter = $this->Category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Category->Lookup->renderViewRow($rswrk[0]);
                        $this->Category->ViewValue = $this->Category->displayValue($arwrk);
                    } else {
                        $this->Category->ViewValue = $this->Category->CurrentValue;
                    }
                }
            } else {
                $this->Category->ViewValue = null;
            }

            // Weight
            $this->Weight->ViewValue = $this->Weight->CurrentValue;
            $this->Weight->ViewValue = FormatNumber($this->Weight->ViewValue, $this->Weight->formatPattern());
            $this->Weight->CellCssStyle .= "text-align: right;";

            // File
            $this->File->UploadPath = $this->File->getUploadPath(); // PHP
            if (!EmptyValue($this->File->Upload->DbValue)) {
                $this->File->ViewValue = $this->File->Upload->DbValue;
            } else {
                $this->File->ViewValue = "";
            }

            // Notes
            $this->Notes->ViewValue = $this->Notes->CurrentValue;

            // ProjectID
            $curVal = strval($this->_ProjectID->CurrentValue);
            if ($curVal != "") {
                $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                if ($this->_ProjectID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                    $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_ProjectID->Lookup->renderViewRow($rswrk[0]);
                        $this->_ProjectID->ViewValue = $this->_ProjectID->displayValue($arwrk);
                    } else {
                        $this->_ProjectID->ViewValue = FormatNumber($this->_ProjectID->CurrentValue, $this->_ProjectID->formatPattern());
                    }
                }
            } else {
                $this->_ProjectID->ViewValue = null;
            }

            // Created_Date
            $this->Created_Date->ViewValue = $this->Created_Date->CurrentValue;
            $this->Created_Date->ViewValue = FormatDateTime($this->Created_Date->ViewValue, $this->Created_Date->formatPattern());

            // Created_By
            $this->Created_By->ViewValue = $this->Created_By->CurrentValue;

            // Last_Updated_Date
            $this->Last_Updated_Date->ViewValue = $this->Last_Updated_Date->CurrentValue;
            $this->Last_Updated_Date->ViewValue = FormatDateTime($this->Last_Updated_Date->ViewValue, $this->Last_Updated_Date->formatPattern());

            // Last_Updated_By
            $this->Last_Updated_By->ViewValue = $this->Last_Updated_By->CurrentValue;

            // Activities
            $this->Activities->HrefValue = "";
            $this->Activities->TooltipValue = "";

            // DateDelivered
            $this->DateDelivered->HrefValue = "";
            $this->DateDelivered->TooltipValue = "";

            // Progress
            $this->Progress->HrefValue = "";
            $this->Progress->TooltipValue = "";

            // Status
            $this->Status->HrefValue = "";
            $this->Status->TooltipValue = "";

            // Category
            $this->Category->HrefValue = "";
            $this->Category->TooltipValue = "";

            // Weight
            $this->Weight->HrefValue = "";
            $this->Weight->TooltipValue = "";

            // File
            $this->File->UploadPath = $this->File->getUploadPath(); // PHP
            if (!EmptyValue($this->File->Upload->DbValue)) {
                $this->File->HrefValue = GetFileUploadUrl($this->File, $this->File->htmlDecode($this->File->Upload->DbValue)); // Add prefix/suffix
                $this->File->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->File->HrefValue = FullUrl($this->File->HrefValue, "href");
                }
            } else {
                $this->File->HrefValue = "";
            }
            $this->File->ExportHrefValue = $this->File->UploadPath . $this->File->Upload->DbValue;
            $this->File->TooltipValue = "";

            // Notes
            $this->Notes->HrefValue = "";
            $this->Notes->TooltipValue = "";

            // ProjectID
            $this->_ProjectID->HrefValue = "";
            $this->_ProjectID->TooltipValue = "";

            // Created_Date
            $this->Created_Date->HrefValue = "";
            $this->Created_Date->TooltipValue = "";

            // Created_By
            $this->Created_By->HrefValue = "";
            $this->Created_By->TooltipValue = "";

            // Last_Updated_Date
            $this->Last_Updated_Date->HrefValue = "";
            $this->Last_Updated_Date->TooltipValue = "";

            // Last_Updated_By
            $this->Last_Updated_By->HrefValue = "";
            $this->Last_Updated_By->TooltipValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // Activities
            $this->Activities->setupEditAttributes();
            $this->Activities->EditValue = HtmlEncode($this->Activities->CurrentValue);
            $this->Activities->PlaceHolder = RemoveHtml($this->Activities->caption());

            // DateDelivered
            $this->DateDelivered->setupEditAttributes();
            $this->DateDelivered->EditValue = HtmlEncode(FormatDateTime($this->DateDelivered->CurrentValue, $this->DateDelivered->formatPattern()));
            $this->DateDelivered->PlaceHolder = RemoveHtml($this->DateDelivered->caption());

            // Progress
            $this->Progress->setupEditAttributes();
            $this->Progress->EditValue = $this->Progress->CurrentValue;
            $this->Progress->PlaceHolder = RemoveHtml($this->Progress->caption());
            if (strval($this->Progress->EditValue) != "" && is_numeric($this->Progress->EditValue)) {
                $this->Progress->EditValue = FormatNumber($this->Progress->EditValue, null);
            }

            // Status
            $this->Status->setupEditAttributes();
            $curVal = trim(strval($this->Status->CurrentValue));
            if ($curVal != "") {
                $this->Status->ViewValue = $this->Status->lookupCacheOption($curVal);
            } else {
                $this->Status->ViewValue = $this->Status->Lookup !== null && is_array($this->Status->lookupOptions()) && count($this->Status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Status->ViewValue !== null) { // Load from cache
                $this->Status->EditValue = array_values($this->Status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Status->Lookup->getTable()->Fields["Status"]->searchExpression(), "=", $this->Status->CurrentValue, $this->Status->Lookup->getTable()->Fields["Status"]->searchDataType(), "");
                }
                $sqlWrk = $this->Status->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Status->EditValue = $arwrk;
            }
            $this->Status->PlaceHolder = RemoveHtml($this->Status->caption());

            // Category
            $this->Category->setupEditAttributes();
            $curVal = trim(strval($this->Category->CurrentValue));
            if ($curVal != "") {
                $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
            } else {
                $this->Category->ViewValue = $this->Category->Lookup !== null && is_array($this->Category->lookupOptions()) && count($this->Category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Category->ViewValue !== null) { // Load from cache
                $this->Category->EditValue = array_values($this->Category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Category->Lookup->getTable()->Fields["CategoryName"]->searchExpression(), "=", $this->Category->CurrentValue, $this->Category->Lookup->getTable()->Fields["CategoryName"]->searchDataType(), "");
                }
                $lookupFilter = $this->Category->getSelectFilter($this); // PHP
                $sqlWrk = $this->Category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Category->EditValue = $arwrk;
            }
            $this->Category->PlaceHolder = RemoveHtml($this->Category->caption());

            // Weight
            $this->Weight->setupEditAttributes();
            $this->Weight->EditValue = $this->Weight->CurrentValue;
            $this->Weight->PlaceHolder = RemoveHtml($this->Weight->caption());
            if (strval($this->Weight->EditValue) != "" && is_numeric($this->Weight->EditValue)) {
                $this->Weight->EditValue = FormatNumber($this->Weight->EditValue, null);
            }

            // File
            $this->File->setupEditAttributes();
            $this->File->UploadPath = $this->File->getUploadPath(); // PHP
            if (!EmptyValue($this->File->Upload->DbValue)) {
                $this->File->EditValue = $this->File->Upload->DbValue;
            } else {
                $this->File->EditValue = "";
            }
            if (!EmptyValue($this->File->CurrentValue)) {
                $this->File->Upload->FileName = $this->File->CurrentValue;
            }

            // Notes
            $this->Notes->setupEditAttributes();
            $this->Notes->EditValue = HtmlEncode($this->Notes->CurrentValue);
            $this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

            // ProjectID
            $this->_ProjectID->setupEditAttributes();
            if ($this->_ProjectID->getSessionValue() != "") {
                $this->_ProjectID->CurrentValue = GetForeignKeyValue($this->_ProjectID->getSessionValue());
                $curVal = strval($this->_ProjectID->CurrentValue);
                if ($curVal != "") {
                    $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                    if ($this->_ProjectID->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                        $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->_ProjectID->Lookup->renderViewRow($rswrk[0]);
                            $this->_ProjectID->ViewValue = $this->_ProjectID->displayValue($arwrk);
                        } else {
                            $this->_ProjectID->ViewValue = FormatNumber($this->_ProjectID->CurrentValue, $this->_ProjectID->formatPattern());
                        }
                    }
                } else {
                    $this->_ProjectID->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->_ProjectID->CurrentValue));
                if ($curVal != "") {
                    $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                } else {
                    $this->_ProjectID->ViewValue = $this->_ProjectID->Lookup !== null && is_array($this->_ProjectID->lookupOptions()) && count($this->_ProjectID->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->_ProjectID->ViewValue !== null) { // Load from cache
                    $this->_ProjectID->EditValue = array_values($this->_ProjectID->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $this->_ProjectID->CurrentValue, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->_ProjectID->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->_ProjectID->EditValue = $arwrk;
                }
                $this->_ProjectID->PlaceHolder = RemoveHtml($this->_ProjectID->caption());
            }

            // Created_Date
            $this->Created_Date->setupEditAttributes();
            $this->Created_Date->CurrentValue = FormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());

            // Created_By
            $this->Created_By->setupEditAttributes();

            // Last_Updated_Date

            // Last_Updated_By

            // Edit refer script

            // Activities
            $this->Activities->HrefValue = "";

            // DateDelivered
            $this->DateDelivered->HrefValue = "";

            // Progress
            $this->Progress->HrefValue = "";

            // Status
            $this->Status->HrefValue = "";

            // Category
            $this->Category->HrefValue = "";

            // Weight
            $this->Weight->HrefValue = "";

            // File
            $this->File->UploadPath = $this->File->getUploadPath(); // PHP
            if (!EmptyValue($this->File->Upload->DbValue)) {
                $this->File->HrefValue = GetFileUploadUrl($this->File, $this->File->htmlDecode($this->File->Upload->DbValue)); // Add prefix/suffix
                $this->File->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->File->HrefValue = FullUrl($this->File->HrefValue, "href");
                }
            } else {
                $this->File->HrefValue = "";
            }
            $this->File->ExportHrefValue = $this->File->UploadPath . $this->File->Upload->DbValue;

            // Notes
            $this->Notes->HrefValue = "";

            // ProjectID
            $this->_ProjectID->HrefValue = "";

            // Created_Date
            $this->Created_Date->HrefValue = "";

            // Created_By
            $this->Created_By->HrefValue = "";

            // Last_Updated_Date
            $this->Last_Updated_Date->HrefValue = "";

            // Last_Updated_By
            $this->Last_Updated_By->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;
        $updateCnt = 0;
        if ($this->Activities->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->DateDelivered->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Progress->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Status->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Category->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Weight->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->File->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Notes->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->_ProjectID->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Created_Date->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Created_By->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Last_Updated_Date->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->Last_Updated_By->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($updateCnt == 0) {
            return false;
        }

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->Activities->Visible && $this->Activities->Required) {
                if ($this->Activities->MultiUpdate != "" && !$this->Activities->IsDetailKey && EmptyValue($this->Activities->FormValue)) {
                    $this->Activities->addErrorMessage(str_replace("%s", $this->Activities->caption(), $this->Activities->RequiredErrorMessage));
                }
            }
            if ($this->DateDelivered->Visible && $this->DateDelivered->Required) {
                if ($this->DateDelivered->MultiUpdate != "" && !$this->DateDelivered->IsDetailKey && EmptyValue($this->DateDelivered->FormValue)) {
                    $this->DateDelivered->addErrorMessage(str_replace("%s", $this->DateDelivered->caption(), $this->DateDelivered->RequiredErrorMessage));
                }
            }
            if ($this->DateDelivered->MultiUpdate != "") {
                if (!CheckDate($this->DateDelivered->FormValue, $this->DateDelivered->formatPattern())) {
                    $this->DateDelivered->addErrorMessage($this->DateDelivered->getErrorMessage(false));
                }
            }
            if ($this->Progress->Visible && $this->Progress->Required) {
                if ($this->Progress->MultiUpdate != "" && !$this->Progress->IsDetailKey && EmptyValue($this->Progress->FormValue)) {
                    $this->Progress->addErrorMessage(str_replace("%s", $this->Progress->caption(), $this->Progress->RequiredErrorMessage));
                }
            }
            if ($this->Progress->MultiUpdate != "") {
                if (!CheckNumber($this->Progress->FormValue)) {
                    $this->Progress->addErrorMessage($this->Progress->getErrorMessage(false));
                }
            }
            if ($this->Status->Visible && $this->Status->Required) {
                if ($this->Status->MultiUpdate != "" && !$this->Status->IsDetailKey && EmptyValue($this->Status->FormValue)) {
                    $this->Status->addErrorMessage(str_replace("%s", $this->Status->caption(), $this->Status->RequiredErrorMessage));
                }
            }
            if ($this->Category->Visible && $this->Category->Required) {
                if ($this->Category->MultiUpdate != "" && !$this->Category->IsDetailKey && EmptyValue($this->Category->FormValue)) {
                    $this->Category->addErrorMessage(str_replace("%s", $this->Category->caption(), $this->Category->RequiredErrorMessage));
                }
            }
            if ($this->Weight->Visible && $this->Weight->Required) {
                if ($this->Weight->MultiUpdate != "" && !$this->Weight->IsDetailKey && EmptyValue($this->Weight->FormValue)) {
                    $this->Weight->addErrorMessage(str_replace("%s", $this->Weight->caption(), $this->Weight->RequiredErrorMessage));
                }
            }
            if ($this->Weight->MultiUpdate != "") {
                if (!CheckInteger($this->Weight->FormValue)) {
                    $this->Weight->addErrorMessage($this->Weight->getErrorMessage(false));
                }
            }
            if ($this->File->Visible && $this->File->Required) {
                if ($this->File->MultiUpdate != "" && $this->File->Upload->FileName == "" && !$this->File->Upload->KeepFile) {
                    $this->File->addErrorMessage(str_replace("%s", $this->File->caption(), $this->File->RequiredErrorMessage));
                }
            }
            if ($this->Notes->Visible && $this->Notes->Required) {
                if ($this->Notes->MultiUpdate != "" && !$this->Notes->IsDetailKey && EmptyValue($this->Notes->FormValue)) {
                    $this->Notes->addErrorMessage(str_replace("%s", $this->Notes->caption(), $this->Notes->RequiredErrorMessage));
                }
            }
            if ($this->_ProjectID->Visible && $this->_ProjectID->Required) {
                if ($this->_ProjectID->MultiUpdate != "" && !$this->_ProjectID->IsDetailKey && EmptyValue($this->_ProjectID->FormValue)) {
                    $this->_ProjectID->addErrorMessage(str_replace("%s", $this->_ProjectID->caption(), $this->_ProjectID->RequiredErrorMessage));
                }
            }
            if ($this->Created_Date->Visible && $this->Created_Date->Required) {
                if ($this->Created_Date->MultiUpdate != "" && !$this->Created_Date->IsDetailKey && EmptyValue($this->Created_Date->FormValue)) {
                    $this->Created_Date->addErrorMessage(str_replace("%s", $this->Created_Date->caption(), $this->Created_Date->RequiredErrorMessage));
                }
            }
            if ($this->Created_By->Visible && $this->Created_By->Required) {
                if ($this->Created_By->MultiUpdate != "" && !$this->Created_By->IsDetailKey && EmptyValue($this->Created_By->FormValue)) {
                    $this->Created_By->addErrorMessage(str_replace("%s", $this->Created_By->caption(), $this->Created_By->RequiredErrorMessage));
                }
            }
            if ($this->Last_Updated_Date->Visible && $this->Last_Updated_Date->Required) {
                if ($this->Last_Updated_Date->MultiUpdate != "" && !$this->Last_Updated_Date->IsDetailKey && EmptyValue($this->Last_Updated_Date->FormValue)) {
                    $this->Last_Updated_Date->addErrorMessage(str_replace("%s", $this->Last_Updated_Date->caption(), $this->Last_Updated_Date->RequiredErrorMessage));
                }
            }
            if ($this->Last_Updated_By->Visible && $this->Last_Updated_By->Required) {
                if ($this->Last_Updated_By->MultiUpdate != "" && !$this->Last_Updated_By->IsDetailKey && EmptyValue($this->Last_Updated_By->FormValue)) {
                    $this->Last_Updated_By->addErrorMessage(str_replace("%s", $this->Last_Updated_By->caption(), $this->Last_Updated_By->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check referential integrity for master table 'masterproject'
        $detailKeys = [];
        $keyValue = $rsnew['ProjectID'] ?? $rsold['ProjectID'];
        $detailKeys['ProjectID'] = $keyValue;
        $masterTable = Container("masterproject");
        $masterFilter = $this->getMasterFilter($masterTable, $detailKeys);
        if (!EmptyValue($masterFilter)) {
            $rsmaster = $masterTable->loadRs($masterFilter)->fetch();
            $validMasterRecord = $rsmaster !== false;
        } else { // Allow null value if not required field
            $validMasterRecord = $masterFilter === null;
        }
        if (!$validMasterRecord) {
            $relatedRecordMsg = str_replace("%t", "masterproject", $Language->phrase("RelatedRecordRequired"));
            $this->setFailureMessage($relatedRecordMsg);
            return false;
        }
        if ($this->File->Visible && !$this->File->Upload->KeepFile) {
            $this->File->UploadPath = $this->File->getUploadPath();
            if (!EmptyValue($this->File->Upload->FileName) && $this->UpdateCount == 1) {
                FixUploadFileNames($this->File);
                $this->File->setDbValueDef($rsnew, $this->File->Upload->FileName, $this->File->ReadOnly || $this->File->MultiUpdate != "1");
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->File->Visible && !$this->File->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->File, $rsnew['File'], false)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->File->OldUploadPath = $this->File->getUploadPath(); // PHP
        $this->File->UploadPath = $this->File->OldUploadPath;
        $rsnew = [];

        // Activities
        $this->Activities->setDbValueDef($rsnew, $this->Activities->CurrentValue, $this->Activities->ReadOnly || $this->Activities->MultiUpdate != "1");

        // DateDelivered
        $this->DateDelivered->setDbValueDef($rsnew, UnFormatDateTime($this->DateDelivered->CurrentValue, $this->DateDelivered->formatPattern()), $this->DateDelivered->ReadOnly || $this->DateDelivered->MultiUpdate != "1");

        // Progress
        $this->Progress->setDbValueDef($rsnew, $this->Progress->CurrentValue, $this->Progress->ReadOnly || $this->Progress->MultiUpdate != "1");

        // Status
        $this->Status->setDbValueDef($rsnew, $this->Status->CurrentValue, $this->Status->ReadOnly || $this->Status->MultiUpdate != "1");

        // Category
        $this->Category->setDbValueDef($rsnew, $this->Category->CurrentValue, $this->Category->ReadOnly || $this->Category->MultiUpdate != "1");

        // Weight
        $this->Weight->setDbValueDef($rsnew, $this->Weight->CurrentValue, $this->Weight->ReadOnly || $this->Weight->MultiUpdate != "1");

        // File
        if ($this->File->Visible && !$this->File->ReadOnly && strval($this->File->MultiUpdate) == "1" && !$this->File->Upload->KeepFile) {
            if ($this->File->Upload->FileName == "") {
                $rsnew['File'] = null;
            } else {
                FixUploadTempFileNames($this->File);
                $rsnew['File'] = $this->File->Upload->FileName;
            }
        }

        // Notes
        $this->Notes->setDbValueDef($rsnew, $this->Notes->CurrentValue, $this->Notes->ReadOnly || $this->Notes->MultiUpdate != "1");

        // ProjectID
        if ($this->_ProjectID->getSessionValue() != "") {
            $this->_ProjectID->ReadOnly = true;
        }
        $this->_ProjectID->setDbValueDef($rsnew, $this->_ProjectID->CurrentValue, $this->_ProjectID->ReadOnly || $this->_ProjectID->MultiUpdate != "1");

        // Created_Date
        $this->Created_Date->setDbValueDef($rsnew, UnFormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern()), $this->Created_Date->ReadOnly || $this->Created_Date->MultiUpdate != "1");

        // Created_By
        $this->Created_By->setDbValueDef($rsnew, $this->Created_By->CurrentValue, $this->Created_By->ReadOnly || $this->Created_By->MultiUpdate != "1");

        // Last_Updated_Date
        $this->Last_Updated_Date->CurrentValue = $this->Last_Updated_Date->getAutoUpdateValue(); // PHP
        $this->Last_Updated_Date->setDbValueDef($rsnew, UnFormatDateTime($this->Last_Updated_Date->CurrentValue, $this->Last_Updated_Date->formatPattern()));

        // Last_Updated_By
        $this->Last_Updated_By->CurrentValue = $this->Last_Updated_By->getAutoUpdateValue(); // PHP
        $this->Last_Updated_By->setDbValueDef($rsnew, $this->Last_Updated_By->CurrentValue);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['Activities'])) { // Activities
            $this->Activities->CurrentValue = $row['Activities'];
        }
        if (isset($row['DateDelivered'])) { // DateDelivered
            $this->DateDelivered->CurrentValue = $row['DateDelivered'];
        }
        if (isset($row['Progress'])) { // Progress
            $this->Progress->CurrentValue = $row['Progress'];
        }
        if (isset($row['Status'])) { // Status
            $this->Status->CurrentValue = $row['Status'];
        }
        if (isset($row['Category'])) { // Category
            $this->Category->CurrentValue = $row['Category'];
        }
        if (isset($row['Weight'])) { // Weight
            $this->Weight->CurrentValue = $row['Weight'];
        }
        if (isset($row['File'])) { // File
            $this->File->CurrentValue = $row['File'];
        }
        if (isset($row['Notes'])) { // Notes
            $this->Notes->CurrentValue = $row['Notes'];
        }
        if (isset($row['ProjectID'])) { // ProjectID
            $this->_ProjectID->CurrentValue = $row['ProjectID'];
        }
        if (isset($row['Created_Date'])) { // Created_Date
            $this->Created_Date->CurrentValue = $row['Created_Date'];
        }
        if (isset($row['Created_By'])) { // Created_By
            $this->Created_By->CurrentValue = $row['Created_By'];
        }
        if (isset($row['Last_Updated_Date'])) { // Last_Updated_Date
            $this->Last_Updated_Date->CurrentValue = $row['Last_Updated_Date'];
        }
        if (isset($row['Last_Updated_By'])) { // Last_Updated_By
            $this->Last_Updated_By->CurrentValue = $row['Last_Updated_By'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("masterprojectlist");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("projectresultlist"), "", $this->TableVar, true);
        $pageId = "update";
        $Breadcrumb->add("update", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Status":
                    break;
                case "x_Category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__ProjectID":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
