<?php

namespace ProjectManagement\prjProjectManagement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for projecttask
 */
class Projecttask extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $TaskID;
    public $TaskName;
    public $Description;
    public $AssignedTo;
    public $Progress;
    public $Complete;
    public $Target;
    public $Track;
    public $PlanStart;
    public $PlanEnd;
    public $StartDate;
    public $EndDate;
    public $Priority;
    public $Category;
    public $_ProjectID;
    public $Created_Date;
    public $Created_By;
    public $Last_Updated_Date;
    public $Last_Updated_By;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "projecttask";
        $this->TableName = 'projecttask';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "projecttask";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = true; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // TaskID
        $this->TaskID = new DbField(
            $this, // Table
            'x_TaskID', // Variable name
            'TaskID', // Name
            '`TaskID`', // Expression
            '`TaskID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TaskID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->TaskID->InputTextType = "text";
        $this->TaskID->Raw = true;
        $this->TaskID->IsAutoIncrement = true; // Autoincrement field
        $this->TaskID->IsPrimaryKey = true; // Primary key field
        $this->TaskID->Nullable = false; // NOT NULL field
        $this->TaskID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->TaskID->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['TaskID'] = &$this->TaskID;

        // TaskName
        $this->TaskName = new DbField(
            $this, // Table
            'x_TaskName', // Variable name
            'TaskName', // Name
            '`TaskName`', // Expression
            '`TaskName`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TaskName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TaskName->InputTextType = "text";
        $this->TaskName->Required = true; // Required field
        $this->TaskName->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->TaskName->Lookup = new Lookup($this->TaskName, 'projecttask', true, 'TaskName', ["TaskName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->TaskName->Lookup = new Lookup($this->TaskName, 'projecttask', true, 'TaskName', ["TaskName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->TaskName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['TaskName'] = &$this->TaskName;

        // Description
        $this->Description = new DbField(
            $this, // Table
            'x_Description', // Variable name
            'Description', // Name
            '`Description`', // Expression
            '`Description`', // Basic search expression
            200, // Type
            65535, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Description`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->Description->InputTextType = "text";
        $this->Description->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Description->Lookup = new Lookup($this->Description, 'projecttask', true, 'Description', ["Description","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Description->Lookup = new Lookup($this->Description, 'projecttask', true, 'Description', ["Description","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Description->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Description'] = &$this->Description;

        // AssignedTo
        $this->AssignedTo = new DbField(
            $this, // Table
            'x_AssignedTo', // Variable name
            'AssignedTo', // Name
            '`AssignedTo`', // Expression
            '`AssignedTo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`AssignedTo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->AssignedTo->InputTextType = "text";
        $this->AssignedTo->Raw = true;
        $this->AssignedTo->setSelectMultiple(false); // Select one
        $this->AssignedTo->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->AssignedTo->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->AssignedTo->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->AssignedTo->Lookup = new Lookup($this->AssignedTo, 'viewprojectmember', true, 'EmployeeID', ["FullName","","",""], '', '', ["x__ProjectID"], [], ["ProjectID"], ["x__ProjectID"], [], [], false, '', '', "`FullName`");
                break;
            default:
                $this->AssignedTo->Lookup = new Lookup($this->AssignedTo, 'viewprojectmember', true, 'EmployeeID', ["FullName","","",""], '', '', ["x__ProjectID"], [], ["ProjectID"], ["x__ProjectID"], [], [], false, '', '', "`FullName`");
                break;
        }
        $this->AssignedTo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->AssignedTo->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['AssignedTo'] = &$this->AssignedTo;

        // Progress
        $this->Progress = new DbField(
            $this, // Table
            'x_Progress', // Variable name
            'Progress', // Name
            '`Progress`', // Expression
            '`Progress`', // Basic search expression
            131, // Type
            7, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Progress`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Progress->addMethod("getDefault", fn() => 0);
        $this->Progress->InputTextType = "text";
        $this->Progress->Raw = true;
        $this->Progress->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Progress->Lookup = new Lookup($this->Progress, 'projecttask', true, 'Progress', ["Progress","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Progress->Lookup = new Lookup($this->Progress, 'projecttask', true, 'Progress', ["Progress","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Progress->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Progress->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Progress'] = &$this->Progress;

        // Complete
        $this->Complete = new DbField(
            $this, // Table
            'x_Complete', // Variable name
            'Complete', // Name
            'IF(Progress>=1,\'Complete\',\'Not Completed\')', // Expression
            'IF(Progress>=1,\'Complete\',\'Not Completed\')', // Basic search expression
            200, // Type
            13, // Size
            -1, // Date/Time format
            false, // Is upload field
            'IF(Progress>=1,\'Complete\',\'Not Completed\')', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Complete->InputTextType = "text";
        $this->Complete->IsCustom = true; // Custom field
        $this->Complete->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Complete->Lookup = new Lookup($this->Complete, 'projecttask', true, 'Complete', ["Complete","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Complete->Lookup = new Lookup($this->Complete, 'projecttask', true, 'Complete', ["Complete","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Complete->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Complete'] = &$this->Complete;

        // Target
        $this->Target = new DbField(
            $this, // Table
            'x_Target', // Variable name
            'Target', // Name
            'CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END', // Expression
            'CASE
                WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
                ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
            END', // Basic search expression
            5, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            'CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Target->InputTextType = "text";
        $this->Target->Raw = true;
        $this->Target->IsCustom = true; // Custom field
        $this->Target->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Target->Lookup = new Lookup($this->Target, 'projecttask', true, 'Target', ["Target","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Target->Lookup = new Lookup($this->Target, 'projecttask', true, 'Target', ["Target","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Target->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Target->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Target'] = &$this->Target;

        // Track
        $this->Track = new DbField(
            $this, // Table
            'x_Track', // Variable name
            'Track', // Name
            'CASE WHEN EndDate > PlanEnd THEN \'Late\'
WHEN Progress<1 AND CURDATE()>PlanEnd THEN \'Late\'
        WHEN Progress<(CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END )THEN \'Warning\'
        ELSE \'On Track\'
    END', // Expression
            'CASE WHEN EndDate > PlanEnd THEN \'Late\'
            WHEN Progress<1 AND CURDATE()>PlanEnd THEN \'Late\'
                    WHEN Progress<(CASE
                WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
                ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
            END )THEN \'Warning\'
                    ELSE \'On Track\'
                END', // Basic search expression
            200, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            'CASE WHEN EndDate > PlanEnd THEN \'Late\'
WHEN Progress<1 AND CURDATE()>PlanEnd THEN \'Late\'
        WHEN Progress<(CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END )THEN \'Warning\'
        ELSE \'On Track\'
    END', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Track->InputTextType = "text";
        $this->Track->IsCustom = true; // Custom field
        $this->Track->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Track->Lookup = new Lookup($this->Track, 'projecttask', true, 'Track', ["Track","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Track->Lookup = new Lookup($this->Track, 'projecttask', true, 'Track', ["Track","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Track->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Track'] = &$this->Track;

        // PlanStart
        $this->PlanStart = new DbField(
            $this, // Table
            'x_PlanStart', // Variable name
            'PlanStart', // Name
            '`PlanStart`', // Expression
            CastDateFieldForLike("`PlanStart`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`PlanStart`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PlanStart->addMethod("getDefault", fn() => CurrentDate());
        $this->PlanStart->InputTextType = "text";
        $this->PlanStart->Raw = true;
        $this->PlanStart->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->PlanStart->Lookup = new Lookup($this->PlanStart, 'projecttask', true, 'PlanStart', ["PlanStart","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->PlanStart->Lookup = new Lookup($this->PlanStart, 'projecttask', true, 'PlanStart', ["PlanStart","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->PlanStart->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->PlanStart->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PlanStart'] = &$this->PlanStart;

        // PlanEnd
        $this->PlanEnd = new DbField(
            $this, // Table
            'x_PlanEnd', // Variable name
            'PlanEnd', // Name
            '`PlanEnd`', // Expression
            CastDateFieldForLike("`PlanEnd`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`PlanEnd`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PlanEnd->addMethod("getDefault", fn() => date('Y-m-d', strtotime('+1 day')));
        $this->PlanEnd->InputTextType = "text";
        $this->PlanEnd->Raw = true;
        $this->PlanEnd->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->PlanEnd->Lookup = new Lookup($this->PlanEnd, 'projecttask', true, 'PlanEnd', ["PlanEnd","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->PlanEnd->Lookup = new Lookup($this->PlanEnd, 'projecttask', true, 'PlanEnd', ["PlanEnd","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->PlanEnd->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->PlanEnd->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PlanEnd'] = &$this->PlanEnd;

        // StartDate
        $this->StartDate = new DbField(
            $this, // Table
            'x_StartDate', // Variable name
            'StartDate', // Name
            '`StartDate`', // Expression
            CastDateFieldForLike("`StartDate`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`StartDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->StartDate->addMethod("getDefault", fn() => CurrentDate());
        $this->StartDate->InputTextType = "text";
        $this->StartDate->Raw = true;
        $this->StartDate->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->StartDate->Lookup = new Lookup($this->StartDate, 'projecttask', true, 'StartDate', ["StartDate","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->StartDate->Lookup = new Lookup($this->StartDate, 'projecttask', true, 'StartDate', ["StartDate","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->StartDate->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->StartDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['StartDate'] = &$this->StartDate;

        // EndDate
        $this->EndDate = new DbField(
            $this, // Table
            'x_EndDate', // Variable name
            'EndDate', // Name
            '`EndDate`', // Expression
            CastDateFieldForLike("`EndDate`", 5, "DB"), // Basic search expression
            133, // Type
            10, // Size
            5, // Date/Time format
            false, // Is upload field
            '`EndDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->EndDate->addMethod("getDefault", fn() => date('Y-m-d', strtotime('+1 day')));
        $this->EndDate->InputTextType = "text";
        $this->EndDate->Raw = true;
        $this->EndDate->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->EndDate->Lookup = new Lookup($this->EndDate, 'projecttask', true, 'EndDate', ["EndDate","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->EndDate->Lookup = new Lookup($this->EndDate, 'projecttask', true, 'EndDate', ["EndDate","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->EndDate->DefaultErrorMessage = str_replace("%s", DateFormat(5), $Language->phrase("IncorrectDate"));
        $this->EndDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['EndDate'] = &$this->EndDate;

        // Priority
        $this->Priority = new DbField(
            $this, // Table
            'x_Priority', // Variable name
            'Priority', // Name
            '`Priority`', // Expression
            '`Priority`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Priority`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Priority->addMethod("getDefault", fn() => 1);
        $this->Priority->InputTextType = "text";
        $this->Priority->Raw = true;
        $this->Priority->Required = true; // Required field
        $this->Priority->setSelectMultiple(false); // Select one
        $this->Priority->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Priority->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->Priority->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Priority->Lookup = new Lookup($this->Priority, 'projecttask', true, 'Priority', ["Priority","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Priority->Lookup = new Lookup($this->Priority, 'projecttask', true, 'Priority', ["Priority","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Priority->OptionCount = 3;
        $this->Priority->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Priority->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Priority'] = &$this->Priority;

        // Category
        $this->Category = new DbField(
            $this, // Table
            'x_Category', // Variable name
            'Category', // Name
            '`Category`', // Expression
            '`Category`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Category->addMethod("getSelectFilter", fn() => "`Active`=1");
        $this->Category->InputTextType = "text";
        $this->Category->Required = true; // Required field
        $this->Category->setSelectMultiple(false); // Select one
        $this->Category->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Category->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->Category->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Category->Lookup = new Lookup($this->Category, 'masterprojectcategory', true, 'CategoryName', ["CategoryName","","",""], '', '', [], [], [], [], [], [], false, '', '', "`CategoryName`");
                break;
            default:
                $this->Category->Lookup = new Lookup($this->Category, 'masterprojectcategory', true, 'CategoryName', ["CategoryName","","",""], '', '', [], [], [], [], [], [], false, '', '', "`CategoryName`");
                break;
        }
        $this->Category->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Category'] = &$this->Category;

        // ProjectID
        $this->_ProjectID = new DbField(
            $this, // Table
            'x__ProjectID', // Variable name
            'ProjectID', // Name
            '`ProjectID`', // Expression
            '`ProjectID`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProjectID`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->_ProjectID->InputTextType = "text";
        $this->_ProjectID->Raw = true;
        $this->_ProjectID->IsForeignKey = true; // Foreign key field
        $this->_ProjectID->Required = true; // Required field
        $this->_ProjectID->setSelectMultiple(false); // Select one
        $this->_ProjectID->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->_ProjectID->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->_ProjectID->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->_ProjectID->Lookup = new Lookup($this->_ProjectID, 'masterproject', true, 'ProjectID', ["ProjectName","","",""], '', '', [], ["x_AssignedTo"], [], [], [], [], false, '', '', "`ProjectName`");
                break;
            default:
                $this->_ProjectID->Lookup = new Lookup($this->_ProjectID, 'masterproject', true, 'ProjectID', ["ProjectName","","",""], '', '', [], ["x_AssignedTo"], [], [], [], [], false, '', '', "`ProjectName`");
                break;
        }
        $this->_ProjectID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_ProjectID->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ProjectID'] = &$this->_ProjectID;

        // Created_Date
        $this->Created_Date = new DbField(
            $this, // Table
            'x_Created_Date', // Variable name
            'Created_Date', // Name
            '`Created_Date`', // Expression
            CastDateFieldForLike("`Created_Date`", 109, "DB"), // Basic search expression
            135, // Type
            19, // Size
            109, // Date/Time format
            false, // Is upload field
            '`Created_Date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Created_Date->addMethod("getDefault", fn() => CurrentDateTime());
        $this->Created_Date->InputTextType = "text";
        $this->Created_Date->Raw = true;
        $this->Created_Date->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Created_Date->Lookup = new Lookup($this->Created_Date, 'projecttask', true, 'Created_Date', ["Created_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Created_Date->Lookup = new Lookup($this->Created_Date, 'projecttask', true, 'Created_Date', ["Created_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Created_Date->DefaultErrorMessage = str_replace("%s", DateFormat(109), $Language->phrase("IncorrectDate"));
        $this->Created_Date->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Created_Date'] = &$this->Created_Date;

        // Created_By
        $this->Created_By = new DbField(
            $this, // Table
            'x_Created_By', // Variable name
            'Created_By', // Name
            '`Created_By`', // Expression
            '`Created_By`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Created_By`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Created_By->addMethod("getDefault", fn() => CurrentUserName());
        $this->Created_By->InputTextType = "text";
        $this->Created_By->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Created_By->Lookup = new Lookup($this->Created_By, 'projecttask', true, 'Created_By', ["Created_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Created_By->Lookup = new Lookup($this->Created_By, 'projecttask', true, 'Created_By', ["Created_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Created_By->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Created_By'] = &$this->Created_By;

        // Last_Updated_Date
        $this->Last_Updated_Date = new DbField(
            $this, // Table
            'x_Last_Updated_Date', // Variable name
            'Last_Updated_Date', // Name
            '`Last_Updated_Date`', // Expression
            CastDateFieldForLike("`Last_Updated_Date`", 109, "DB"), // Basic search expression
            135, // Type
            19, // Size
            109, // Date/Time format
            false, // Is upload field
            '`Last_Updated_Date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Last_Updated_Date->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->Last_Updated_Date->addMethod("getDefault", fn() => CurrentDateTime());
        $this->Last_Updated_Date->InputTextType = "text";
        $this->Last_Updated_Date->Raw = true;
        $this->Last_Updated_Date->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Last_Updated_Date->Lookup = new Lookup($this->Last_Updated_Date, 'projecttask', true, 'Last_Updated_Date', ["Last_Updated_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Last_Updated_Date->Lookup = new Lookup($this->Last_Updated_Date, 'projecttask', true, 'Last_Updated_Date', ["Last_Updated_Date","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Last_Updated_Date->DefaultErrorMessage = str_replace("%s", DateFormat(109), $Language->phrase("IncorrectDate"));
        $this->Last_Updated_Date->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Last_Updated_Date'] = &$this->Last_Updated_Date;

        // Last_Updated_By
        $this->Last_Updated_By = new DbField(
            $this, // Table
            'x_Last_Updated_By', // Variable name
            'Last_Updated_By', // Name
            '`Last_Updated_By`', // Expression
            '`Last_Updated_By`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Last_Updated_By`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'HIDDEN' // Edit Tag
        );
        $this->Last_Updated_By->addMethod("getAutoUpdateValue", fn() => CurrentUserName());
        $this->Last_Updated_By->addMethod("getDefault", fn() => CurrentUserName());
        $this->Last_Updated_By->InputTextType = "text";
        $this->Last_Updated_By->UseFilter = true; // Table header filter
        global $CurrentLanguage;
        switch ($CurrentLanguage) {
            case "en-US":
                $this->Last_Updated_By->Lookup = new Lookup($this->Last_Updated_By, 'projecttask', true, 'Last_Updated_By', ["Last_Updated_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
            default:
                $this->Last_Updated_By->Lookup = new Lookup($this->Last_Updated_By, 'projecttask', true, 'Last_Updated_By', ["Last_Updated_By","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
                break;
        }
        $this->Last_Updated_By->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Last_Updated_By'] = &$this->Last_Updated_By;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Get master WHERE clause from session values
    public function getMasterFilterFromSession()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "masterproject") {
            $masterTable = Container("masterproject");
            if ($this->_ProjectID->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->_ProjectID, $this->_ProjectID->getSessionValue(), $masterTable->_ProjectID->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Get detail WHERE clause from session values
    public function getDetailFilterFromSession()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "masterproject") {
            $masterTable = Container("masterproject");
            if ($this->_ProjectID->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->_ProjectID, $this->_ProjectID->getSessionValue(), $masterTable->_ProjectID->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    /**
     * Get master filter
     *
     * @param object $masterTable Master Table
     * @param array $keys Detail Keys
     * @return mixed NULL is returned if all keys are empty, Empty string is returned if some keys are empty and is required
     */
    public function getMasterFilter($masterTable, $keys)
    {
        $validKeys = true;
        switch ($masterTable->TableVar) {
            case "masterproject":
                $key = $keys["ProjectID"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->_ProjectID->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->_ProjectID, $keys["ProjectID"], $this->_ProjectID->DataType, $this->Dbid);
                }
                break;
        }
        return null; // All null values and no required fields
    }

    // Get detail filter
    public function getDetailFilter($masterTable)
    {
        switch ($masterTable->TableVar) {
            case "masterproject":
                return GetKeyFilter($this->_ProjectID, $masterTable->_ProjectID->DbValue, $masterTable->_ProjectID->DataType, $masterTable->Dbid);
        }
        return "";
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "projecttask";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        return "*, IF(Progress>=1,'Complete','Not Completed') AS `Complete`, CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END AS `Target`, CASE WHEN EndDate > PlanEnd THEN 'Late'
WHEN Progress<1 AND CURDATE()>PlanEnd THEN 'Late'
        WHEN Progress<(CASE
    WHEN PlanEnd IS NULL OR PlanStart IS NULL THEN 0
    ELSE LEAST(1.0, CAST(DATEDIFF(CURDATE(), PlanStart) AS FLOAT) / NULLIF(DATEDIFF(PlanEnd, PlanStart), 0))
END )THEN 'Warning'
        ELSE 'On Track'
    END AS `Track`";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->TaskID->setDbValue($conn->lastInsertId());
            $rs['TaskID'] = $this->TaskID->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['TaskID']) && !EmptyValue($this->TaskID->CurrentValue)) {
                $rs['TaskID'] = $this->TaskID->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('TaskID', $rs)) {
                AddFilter($where, QuotedName('TaskID', $this->Dbid) . '=' . QuotedValue($rs['TaskID'], $this->TaskID->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->TaskID->DbValue = $row['TaskID'];
        $this->TaskName->DbValue = $row['TaskName'];
        $this->Description->DbValue = $row['Description'];
        $this->AssignedTo->DbValue = $row['AssignedTo'];
        $this->Progress->DbValue = $row['Progress'];
        $this->Complete->DbValue = $row['Complete'];
        $this->Target->DbValue = $row['Target'];
        $this->Track->DbValue = $row['Track'];
        $this->PlanStart->DbValue = $row['PlanStart'];
        $this->PlanEnd->DbValue = $row['PlanEnd'];
        $this->StartDate->DbValue = $row['StartDate'];
        $this->EndDate->DbValue = $row['EndDate'];
        $this->Priority->DbValue = $row['Priority'];
        $this->Category->DbValue = $row['Category'];
        $this->_ProjectID->DbValue = $row['ProjectID'];
        $this->Created_Date->DbValue = $row['Created_Date'];
        $this->Created_By->DbValue = $row['Created_By'];
        $this->Last_Updated_Date->DbValue = $row['Last_Updated_Date'];
        $this->Last_Updated_By->DbValue = $row['Last_Updated_By'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`TaskID` = @TaskID@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->TaskID->CurrentValue : $this->TaskID->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->TaskID->CurrentValue = $keys[0];
            } else {
                $this->TaskID->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('TaskID', $row) ? $row['TaskID'] : null;
        } else {
            $val = !EmptyValue($this->TaskID->OldValue) && !$current ? $this->TaskID->OldValue : $this->TaskID->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@TaskID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("projecttasklist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "projecttaskview" => $Language->phrase("View"),
            "projecttaskedit" => $Language->phrase("Edit"),
            "projecttaskadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "projecttasklist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ProjecttaskView",
            Config("API_ADD_ACTION") => "ProjecttaskAdd",
            Config("API_EDIT_ACTION") => "ProjecttaskEdit",
            Config("API_DELETE_ACTION") => "ProjecttaskDelete",
            Config("API_LIST_ACTION") => "ProjecttaskList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "projecttasklist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("projecttaskview", $parm);
        } else {
            $url = $this->keyUrl("projecttaskview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "projecttaskadd?" . $parm;
        } else {
            $url = "projecttaskadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("projecttaskedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("projecttasklist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("projecttaskadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("projecttasklist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("projecttaskdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "masterproject" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->getSessionValue()); // Use Session Value
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"TaskID\":" . VarToJson($this->TaskID->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->TaskID->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->TaskID->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("TaskID") ?? Route("TaskID")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->TaskID->CurrentValue = $key;
            } else {
                $this->TaskID->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->TaskID->setDbValue($row['TaskID']);
        $this->TaskName->setDbValue($row['TaskName']);
        $this->Description->setDbValue($row['Description']);
        $this->AssignedTo->setDbValue($row['AssignedTo']);
        $this->Progress->setDbValue($row['Progress']);
        $this->Complete->setDbValue($row['Complete']);
        $this->Target->setDbValue($row['Target']);
        $this->Track->setDbValue($row['Track']);
        $this->PlanStart->setDbValue($row['PlanStart']);
        $this->PlanEnd->setDbValue($row['PlanEnd']);
        $this->StartDate->setDbValue($row['StartDate']);
        $this->EndDate->setDbValue($row['EndDate']);
        $this->Priority->setDbValue($row['Priority']);
        $this->Category->setDbValue($row['Category']);
        $this->_ProjectID->setDbValue($row['ProjectID']);
        $this->Created_Date->setDbValue($row['Created_Date']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->Last_Updated_Date->setDbValue($row['Last_Updated_Date']);
        $this->Last_Updated_By->setDbValue($row['Last_Updated_By']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ProjecttaskList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // TaskID

        // TaskName
        $this->TaskName->CellCssStyle = "white-space: nowrap;";

        // Description
        $this->Description->CellCssStyle = "white-space: nowrap;";

        // AssignedTo
        $this->AssignedTo->CellCssStyle = "white-space: nowrap;";

        // Progress
        $this->Progress->CellCssStyle = "white-space: nowrap;";

        // Complete
        $this->Complete->CellCssStyle = "white-space: nowrap;";

        // Target
        $this->Target->CellCssStyle = "white-space: nowrap;";

        // Track
        $this->Track->CellCssStyle = "white-space: nowrap;";

        // PlanStart
        $this->PlanStart->CellCssStyle = "white-space: nowrap;";

        // PlanEnd
        $this->PlanEnd->CellCssStyle = "white-space: nowrap;";

        // StartDate
        $this->StartDate->CellCssStyle = "white-space: nowrap;";

        // EndDate
        $this->EndDate->CellCssStyle = "white-space: nowrap;";

        // Priority
        $this->Priority->CellCssStyle = "white-space: nowrap;";

        // Category
        $this->Category->CellCssStyle = "white-space: nowrap;";

        // ProjectID
        $this->_ProjectID->CellCssStyle = "white-space: nowrap;";

        // Created_Date
        $this->Created_Date->CellCssStyle = "white-space: nowrap;";

        // Created_By
        $this->Created_By->CellCssStyle = "white-space: nowrap;";

        // Last_Updated_Date
        $this->Last_Updated_Date->CellCssStyle = "white-space: nowrap;";

        // Last_Updated_By
        $this->Last_Updated_By->CellCssStyle = "white-space: nowrap;";

        // TaskID
        $this->TaskID->ViewValue = $this->TaskID->CurrentValue;

        // TaskName
        $this->TaskName->ViewValue = $this->TaskName->CurrentValue;

        // Description
        $this->Description->ViewValue = $this->Description->CurrentValue;

        // AssignedTo
        $curVal = strval($this->AssignedTo->CurrentValue);
        if ($curVal != "") {
            $this->AssignedTo->ViewValue = $this->AssignedTo->lookupCacheOption($curVal);
            if ($this->AssignedTo->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->AssignedTo->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $curVal, $this->AssignedTo->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                $sqlWrk = $this->AssignedTo->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->AssignedTo->Lookup->renderViewRow($rswrk[0]);
                    $this->AssignedTo->ViewValue = $this->AssignedTo->displayValue($arwrk);
                } else {
                    $this->AssignedTo->ViewValue = FormatNumber($this->AssignedTo->CurrentValue, $this->AssignedTo->formatPattern());
                }
            }
        } else {
            $this->AssignedTo->ViewValue = null;
        }

        // Progress
        $this->Progress->ViewValue = $this->Progress->CurrentValue;
        $this->Progress->ViewValue = FormatPercent($this->Progress->ViewValue, $this->Progress->formatPattern());
        $this->Progress->CellCssStyle .= "text-align: right;";

        // Complete
        $this->Complete->ViewValue = $this->Complete->CurrentValue;

        // Target
        $this->Target->ViewValue = $this->Target->CurrentValue;
        $this->Target->ViewValue = FormatPercent($this->Target->ViewValue, $this->Target->formatPattern());
        $this->Target->CellCssStyle .= "text-align: right;";

        // Track
        $this->Track->ViewValue = $this->Track->CurrentValue;

        // PlanStart
        $this->PlanStart->ViewValue = $this->PlanStart->CurrentValue;
        $this->PlanStart->ViewValue = FormatDateTime($this->PlanStart->ViewValue, $this->PlanStart->formatPattern());

        // PlanEnd
        $this->PlanEnd->ViewValue = $this->PlanEnd->CurrentValue;
        $this->PlanEnd->ViewValue = FormatDateTime($this->PlanEnd->ViewValue, $this->PlanEnd->formatPattern());

        // StartDate
        $this->StartDate->ViewValue = $this->StartDate->CurrentValue;
        $this->StartDate->ViewValue = FormatDateTime($this->StartDate->ViewValue, $this->StartDate->formatPattern());

        // EndDate
        $this->EndDate->ViewValue = $this->EndDate->CurrentValue;
        $this->EndDate->ViewValue = FormatDateTime($this->EndDate->ViewValue, $this->EndDate->formatPattern());

        // Priority
        if (strval($this->Priority->CurrentValue) != "") {
            $this->Priority->ViewValue = $this->Priority->optionCaption($this->Priority->CurrentValue);
        } else {
            $this->Priority->ViewValue = null;
        }

        // Category
        $curVal = strval($this->Category->CurrentValue);
        if ($curVal != "") {
            $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
            if ($this->Category->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->Category->Lookup->getTable()->Fields["CategoryName"]->searchExpression(), "=", $curVal, $this->Category->Lookup->getTable()->Fields["CategoryName"]->searchDataType(), "");
                $lookupFilter = $this->Category->getSelectFilter($this); // PHP
                $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Category->Lookup->renderViewRow($rswrk[0]);
                    $this->Category->ViewValue = $this->Category->displayValue($arwrk);
                } else {
                    $this->Category->ViewValue = $this->Category->CurrentValue;
                }
            }
        } else {
            $this->Category->ViewValue = null;
        }

        // ProjectID
        $curVal = strval($this->_ProjectID->CurrentValue);
        if ($curVal != "") {
            $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
            if ($this->_ProjectID->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->_ProjectID->Lookup->renderViewRow($rswrk[0]);
                    $this->_ProjectID->ViewValue = $this->_ProjectID->displayValue($arwrk);
                } else {
                    $this->_ProjectID->ViewValue = FormatNumber($this->_ProjectID->CurrentValue, $this->_ProjectID->formatPattern());
                }
            }
        } else {
            $this->_ProjectID->ViewValue = null;
        }

        // Created_Date
        $this->Created_Date->ViewValue = $this->Created_Date->CurrentValue;
        $this->Created_Date->ViewValue = FormatDateTime($this->Created_Date->ViewValue, $this->Created_Date->formatPattern());

        // Created_By
        $this->Created_By->ViewValue = $this->Created_By->CurrentValue;

        // Last_Updated_Date
        $this->Last_Updated_Date->ViewValue = $this->Last_Updated_Date->CurrentValue;
        $this->Last_Updated_Date->ViewValue = FormatDateTime($this->Last_Updated_Date->ViewValue, $this->Last_Updated_Date->formatPattern());

        // Last_Updated_By
        $this->Last_Updated_By->ViewValue = $this->Last_Updated_By->CurrentValue;

        // TaskID
        $this->TaskID->HrefValue = "";
        $this->TaskID->TooltipValue = "";

        // TaskName
        $this->TaskName->HrefValue = "";
        $this->TaskName->TooltipValue = "";

        // Description
        $this->Description->HrefValue = "";
        $this->Description->TooltipValue = "";

        // AssignedTo
        $this->AssignedTo->HrefValue = "";
        $this->AssignedTo->TooltipValue = "";

        // Progress
        $this->Progress->HrefValue = "";
        $this->Progress->TooltipValue = "";

        // Complete
        $this->Complete->HrefValue = "";
        $this->Complete->TooltipValue = "";

        // Target
        $this->Target->HrefValue = "";
        $this->Target->TooltipValue = "";

        // Track
        $this->Track->HrefValue = "";
        $this->Track->TooltipValue = "";

        // PlanStart
        $this->PlanStart->HrefValue = "";
        $this->PlanStart->TooltipValue = "";

        // PlanEnd
        $this->PlanEnd->HrefValue = "";
        $this->PlanEnd->TooltipValue = "";

        // StartDate
        $this->StartDate->HrefValue = "";
        $this->StartDate->TooltipValue = "";

        // EndDate
        $this->EndDate->HrefValue = "";
        $this->EndDate->TooltipValue = "";

        // Priority
        $this->Priority->HrefValue = "";
        $this->Priority->TooltipValue = "";

        // Category
        $this->Category->HrefValue = "";
        $this->Category->TooltipValue = "";

        // ProjectID
        $this->_ProjectID->HrefValue = "";
        $this->_ProjectID->TooltipValue = "";

        // Created_Date
        $this->Created_Date->HrefValue = "";
        $this->Created_Date->TooltipValue = "";

        // Created_By
        $this->Created_By->HrefValue = "";
        $this->Created_By->TooltipValue = "";

        // Last_Updated_Date
        $this->Last_Updated_Date->HrefValue = "";
        $this->Last_Updated_Date->TooltipValue = "";

        // Last_Updated_By
        $this->Last_Updated_By->HrefValue = "";
        $this->Last_Updated_By->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // TaskID
        $this->TaskID->setupEditAttributes();
        $this->TaskID->EditValue = $this->TaskID->CurrentValue;

        // TaskName
        $this->TaskName->setupEditAttributes();
        if (!$this->TaskName->Raw) {
            $this->TaskName->CurrentValue = HtmlDecode($this->TaskName->CurrentValue);
        }
        $this->TaskName->EditValue = $this->TaskName->CurrentValue;
        $this->TaskName->PlaceHolder = RemoveHtml($this->TaskName->caption());

        // Description
        $this->Description->setupEditAttributes();
        $this->Description->EditValue = $this->Description->CurrentValue;
        $this->Description->PlaceHolder = RemoveHtml($this->Description->caption());

        // AssignedTo
        $this->AssignedTo->setupEditAttributes();
        $this->AssignedTo->PlaceHolder = RemoveHtml($this->AssignedTo->caption());

        // Progress
        $this->Progress->setupEditAttributes();
        $this->Progress->EditValue = $this->Progress->CurrentValue;
        $this->Progress->PlaceHolder = RemoveHtml($this->Progress->caption());
        if (strval($this->Progress->EditValue) != "" && is_numeric($this->Progress->EditValue)) {
            $this->Progress->EditValue = FormatNumber($this->Progress->EditValue, null);
        }

        // Complete
        $this->Complete->setupEditAttributes();
        if (!$this->Complete->Raw) {
            $this->Complete->CurrentValue = HtmlDecode($this->Complete->CurrentValue);
        }
        $this->Complete->EditValue = $this->Complete->CurrentValue;
        $this->Complete->PlaceHolder = RemoveHtml($this->Complete->caption());

        // Target
        $this->Target->setupEditAttributes();
        $this->Target->EditValue = $this->Target->CurrentValue;
        $this->Target->PlaceHolder = RemoveHtml($this->Target->caption());
        if (strval($this->Target->EditValue) != "" && is_numeric($this->Target->EditValue)) {
            $this->Target->EditValue = FormatNumber($this->Target->EditValue, null);
        }

        // Track
        $this->Track->setupEditAttributes();
        if (!$this->Track->Raw) {
            $this->Track->CurrentValue = HtmlDecode($this->Track->CurrentValue);
        }
        $this->Track->EditValue = $this->Track->CurrentValue;
        $this->Track->PlaceHolder = RemoveHtml($this->Track->caption());

        // PlanStart
        $this->PlanStart->setupEditAttributes();
        $this->PlanStart->EditValue = FormatDateTime($this->PlanStart->CurrentValue, $this->PlanStart->formatPattern());
        $this->PlanStart->PlaceHolder = RemoveHtml($this->PlanStart->caption());

        // PlanEnd
        $this->PlanEnd->setupEditAttributes();
        $this->PlanEnd->EditValue = FormatDateTime($this->PlanEnd->CurrentValue, $this->PlanEnd->formatPattern());
        $this->PlanEnd->PlaceHolder = RemoveHtml($this->PlanEnd->caption());

        // StartDate
        $this->StartDate->setupEditAttributes();
        $this->StartDate->EditValue = FormatDateTime($this->StartDate->CurrentValue, $this->StartDate->formatPattern());
        $this->StartDate->PlaceHolder = RemoveHtml($this->StartDate->caption());

        // EndDate
        $this->EndDate->setupEditAttributes();
        $this->EndDate->EditValue = FormatDateTime($this->EndDate->CurrentValue, $this->EndDate->formatPattern());
        $this->EndDate->PlaceHolder = RemoveHtml($this->EndDate->caption());

        // Priority
        $this->Priority->setupEditAttributes();
        $this->Priority->EditValue = $this->Priority->options(true);
        $this->Priority->PlaceHolder = RemoveHtml($this->Priority->caption());

        // Category
        $this->Category->setupEditAttributes();
        $this->Category->PlaceHolder = RemoveHtml($this->Category->caption());

        // ProjectID
        $this->_ProjectID->setupEditAttributes();
        if ($this->_ProjectID->getSessionValue() != "") {
            $this->_ProjectID->CurrentValue = GetForeignKeyValue($this->_ProjectID->getSessionValue());
            $curVal = strval($this->_ProjectID->CurrentValue);
            if ($curVal != "") {
                $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                if ($this->_ProjectID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                    $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_ProjectID->Lookup->renderViewRow($rswrk[0]);
                        $this->_ProjectID->ViewValue = $this->_ProjectID->displayValue($arwrk);
                    } else {
                        $this->_ProjectID->ViewValue = FormatNumber($this->_ProjectID->CurrentValue, $this->_ProjectID->formatPattern());
                    }
                }
            } else {
                $this->_ProjectID->ViewValue = null;
            }
        } else {
            $this->_ProjectID->PlaceHolder = RemoveHtml($this->_ProjectID->caption());
        }

        // Created_Date
        $this->Created_Date->setupEditAttributes();
        $this->Created_Date->CurrentValue = FormatDateTime($this->Created_Date->CurrentValue, $this->Created_Date->formatPattern());

        // Created_By
        $this->Created_By->setupEditAttributes();

        // Last_Updated_Date

        // Last_Updated_By

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            $this->Progress->Count++; // Increment count
            if (is_numeric($this->Progress->CurrentValue)) {
                $this->Progress->Total += $this->Progress->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            if ($this->Progress->Count > 0) {
                $this->Progress->CurrentValue = $this->Progress->Total / $this->Progress->Count;
            }
            $this->Progress->ViewValue = $this->Progress->CurrentValue;
            $this->Progress->ViewValue = FormatPercent($this->Progress->ViewValue, $this->Progress->formatPattern());
            $this->Progress->CellCssStyle .= "text-align: right;";
            $this->Progress->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->TaskID);
                    $doc->exportCaption($this->TaskName);
                    $doc->exportCaption($this->Description);
                    $doc->exportCaption($this->AssignedTo);
                    $doc->exportCaption($this->Progress);
                    $doc->exportCaption($this->Complete);
                    $doc->exportCaption($this->Target);
                    $doc->exportCaption($this->Track);
                    $doc->exportCaption($this->PlanStart);
                    $doc->exportCaption($this->PlanEnd);
                    $doc->exportCaption($this->StartDate);
                    $doc->exportCaption($this->EndDate);
                    $doc->exportCaption($this->Priority);
                    $doc->exportCaption($this->Category);
                    $doc->exportCaption($this->_ProjectID);
                    $doc->exportCaption($this->Created_Date);
                    $doc->exportCaption($this->Created_By);
                    $doc->exportCaption($this->Last_Updated_Date);
                    $doc->exportCaption($this->Last_Updated_By);
                } else {
                    $doc->exportCaption($this->TaskID);
                    $doc->exportCaption($this->TaskName);
                    $doc->exportCaption($this->Description);
                    $doc->exportCaption($this->AssignedTo);
                    $doc->exportCaption($this->Progress);
                    $doc->exportCaption($this->Complete);
                    $doc->exportCaption($this->Target);
                    $doc->exportCaption($this->Track);
                    $doc->exportCaption($this->PlanStart);
                    $doc->exportCaption($this->PlanEnd);
                    $doc->exportCaption($this->StartDate);
                    $doc->exportCaption($this->EndDate);
                    $doc->exportCaption($this->Priority);
                    $doc->exportCaption($this->Category);
                    $doc->exportCaption($this->_ProjectID);
                    $doc->exportCaption($this->Created_Date);
                    $doc->exportCaption($this->Created_By);
                    $doc->exportCaption($this->Last_Updated_Date);
                    $doc->exportCaption($this->Last_Updated_By);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->TaskID);
                        $doc->exportField($this->TaskName);
                        $doc->exportField($this->Description);
                        $doc->exportField($this->AssignedTo);
                        $doc->exportField($this->Progress);
                        $doc->exportField($this->Complete);
                        $doc->exportField($this->Target);
                        $doc->exportField($this->Track);
                        $doc->exportField($this->PlanStart);
                        $doc->exportField($this->PlanEnd);
                        $doc->exportField($this->StartDate);
                        $doc->exportField($this->EndDate);
                        $doc->exportField($this->Priority);
                        $doc->exportField($this->Category);
                        $doc->exportField($this->_ProjectID);
                        $doc->exportField($this->Created_Date);
                        $doc->exportField($this->Created_By);
                        $doc->exportField($this->Last_Updated_Date);
                        $doc->exportField($this->Last_Updated_By);
                    } else {
                        $doc->exportField($this->TaskID);
                        $doc->exportField($this->TaskName);
                        $doc->exportField($this->Description);
                        $doc->exportField($this->AssignedTo);
                        $doc->exportField($this->Progress);
                        $doc->exportField($this->Complete);
                        $doc->exportField($this->Target);
                        $doc->exportField($this->Track);
                        $doc->exportField($this->PlanStart);
                        $doc->exportField($this->PlanEnd);
                        $doc->exportField($this->StartDate);
                        $doc->exportField($this->EndDate);
                        $doc->exportField($this->Priority);
                        $doc->exportField($this->Category);
                        $doc->exportField($this->_ProjectID);
                        $doc->exportField($this->Created_Date);
                        $doc->exportField($this->Created_By);
                        $doc->exportField($this->Last_Updated_Date);
                        $doc->exportField($this->Last_Updated_By);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->TaskID, '');
                $doc->exportAggregate($this->TaskName, '');
                $doc->exportAggregate($this->Description, '');
                $doc->exportAggregate($this->AssignedTo, '');
                $doc->exportAggregate($this->Progress, 'AVERAGE');
                $doc->exportAggregate($this->Complete, '');
                $doc->exportAggregate($this->Target, '');
                $doc->exportAggregate($this->Track, '');
                $doc->exportAggregate($this->PlanStart, '');
                $doc->exportAggregate($this->PlanEnd, '');
                $doc->exportAggregate($this->StartDate, '');
                $doc->exportAggregate($this->EndDate, '');
                $doc->exportAggregate($this->Priority, '');
                $doc->exportAggregate($this->Category, '');
                $doc->exportAggregate($this->_ProjectID, '');
                $doc->exportAggregate($this->Created_Date, '');
                $doc->exportAggregate($this->Created_By, '');
                $doc->exportAggregate($this->Last_Updated_Date, '');
                $doc->exportAggregate($this->Last_Updated_By, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
                if (in_array(CurrentUserLevel(), array("4", "5", "6","7","8","9","10"))) {
            $currentUser = CurrentUserName(); // Ambil nama pengguna saat ini
            // Pastikan untuk meng-escape string nama pengguna untuk keamanan
            $currentUser = addslashes($currentUser);

            // Perbarui filter dengan query yang benar
            $existsClause = "EXISTS (
                    SELECT 1 FROM vprojectid 
                    WHERE vprojectid.projectid = projecttask.projectid 
                    AND vprojectid.UserName = '" . $currentUser . "'
                )";
             if (strlen($filter) == 0) {
                $filter = $existsClause;
            } else {
                $filter .= ' AND ' . $existsClause;
            }
        }
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        $progress = floatval($this->Progress->CurrentValue);
        $target = floatval($this->Target->CurrentValue);
        $planStart = $this->PlanStart->CurrentValue;
        $planEnd = $this->PlanEnd->CurrentValue;
        $today = CurrentDate();// Membuat objek DateTime
        if ($progress == 1) {
             $this->Target->CellAttrs["class"] = "table-bg-success";
        }
        // Ganti warna latar belakang kolom Progress sesuai kondisi
        else if ($today > $planEnd && $progress < 1) {
            // Warna merah
            $this->Progress->CellAttrs["class"] = "table-bg-danger";
        } else if ($target >= $progress) {
            // Warna kuning
            $this->Progress->CellAttrs["class"] = "table-bg-warning";
        } else {
            // Warna hijau
            $this->Progress->CellAttrs["class"] = "table-bg-success";
        }
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
