<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "manualdocument" table
 */
#[Entity]
#[Table(name: "manualdocument")]
class Manualdocument extends AbstractEntity
{
    public static array $propertyNames = [
        'ManualID' => 'manualId',
        'ManualTitle' => 'manualTitle',
        'Category' => 'category',
        'Description' => 'description',
        'FileName' => 'fileName',
        'Created_Date' => 'createdDate',
        'Created_By' => 'createdBy',
        'Last_Updated_Date' => 'lastUpdatedDate',
        'Last_Updated_By' => 'lastUpdatedBy',
    ];

    #[Id]
    #[Column(name: "ManualID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $manualId;

    #[Column(name: "ManualTitle", type: "string", nullable: true)]
    private ?string $manualTitle;

    #[Column(name: "Category", type: "string", nullable: true)]
    private ?string $category;

    #[Column(name: "Description", type: "string", nullable: true)]
    private ?string $description;

    #[Column(name: "FileName", type: "string", nullable: true)]
    private ?string $fileName;

    #[Column(name: "Created_Date", type: "datetime", nullable: true)]
    private ?DateTime $createdDate;

    #[Column(name: "Created_By", type: "string", nullable: true)]
    private ?string $createdBy;

    #[Column(name: "Last_Updated_Date", type: "datetime", nullable: true)]
    private ?DateTime $lastUpdatedDate;

    #[Column(name: "Last_Updated_By", type: "string", nullable: true)]
    private ?string $lastUpdatedBy;

    public function getManualId(): int
    {
        return $this->manualId;
    }

    public function setManualId(int $value): static
    {
        $this->manualId = $value;
        return $this;
    }

    public function getManualTitle(): ?string
    {
        return HtmlDecode($this->manualTitle);
    }

    public function setManualTitle(?string $value): static
    {
        $this->manualTitle = RemoveXss($value);
        return $this;
    }

    public function getCategory(): ?string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(?string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getFileName(): ?string
    {
        return HtmlDecode($this->fileName);
    }

    public function setFileName(?string $value): static
    {
        $this->fileName = RemoveXss($value);
        return $this;
    }

    public function getCreatedDate(): ?DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(?DateTime $value): static
    {
        $this->createdDate = $value;
        return $this;
    }

    public function getCreatedBy(): ?string
    {
        return HtmlDecode($this->createdBy);
    }

    public function setCreatedBy(?string $value): static
    {
        $this->createdBy = RemoveXss($value);
        return $this;
    }

    public function getLastUpdatedDate(): ?DateTime
    {
        return $this->lastUpdatedDate;
    }

    public function setLastUpdatedDate(?DateTime $value): static
    {
        $this->lastUpdatedDate = $value;
        return $this;
    }

    public function getLastUpdatedBy(): ?string
    {
        return HtmlDecode($this->lastUpdatedBy);
    }

    public function setLastUpdatedBy(?string $value): static
    {
        $this->lastUpdatedBy = RemoveXss($value);
        return $this;
    }
}
