<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "masterclient" table
 */
#[Entity]
#[Table(name: "masterclient")]
class Masterclient extends AbstractEntity
{
    public static array $propertyNames = [
        'ClientID' => 'clientId',
        'CompanyName' => 'companyName',
        'ContactName' => 'contactName',
        'ContactEmail' => 'contactEmail',
        'Phone' => 'phone',
        'NPWP' => 'npwp',
        'Address' => 'address',
        'City' => 'city',
        'Active' => 'active',
        'Created_Date' => 'createdDate',
        'Created_By' => 'createdBy',
        'Last_Updated_Date' => 'lastUpdatedDate',
        'Last_Updated_By' => 'lastUpdatedBy',
    ];

    #[Id]
    #[Column(name: "ClientID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $clientId;

    #[Column(name: "CompanyName", type: "string", nullable: true)]
    private ?string $companyName;

    #[Column(name: "ContactName", type: "string", nullable: true)]
    private ?string $contactName;

    #[Column(name: "ContactEmail", type: "string", unique: true, nullable: true)]
    private ?string $contactEmail;

    #[Column(name: "Phone", type: "string", nullable: true)]
    private ?string $phone;

    #[Column(name: "NPWP", type: "string", nullable: true)]
    private ?string $npwp;

    #[Column(name: "Address", type: "string", nullable: true)]
    private ?string $address;

    #[Column(name: "City", type: "string", nullable: true)]
    private ?string $city;

    #[Column(name: "Active", type: "boolean", nullable: true)]
    private ?bool $active = true;

    #[Column(name: "Created_Date", type: "datetime", nullable: true)]
    private ?DateTime $createdDate;

    #[Column(name: "Created_By", type: "string", nullable: true)]
    private ?string $createdBy;

    #[Column(name: "Last_Updated_Date", type: "datetime", nullable: true)]
    private ?DateTime $lastUpdatedDate;

    #[Column(name: "Last_Updated_By", type: "string", nullable: true)]
    private ?string $lastUpdatedBy;

    public function getClientId(): int
    {
        return $this->clientId;
    }

    public function setClientId(int $value): static
    {
        $this->clientId = $value;
        return $this;
    }

    public function getCompanyName(): ?string
    {
        return HtmlDecode($this->companyName);
    }

    public function setCompanyName(?string $value): static
    {
        $this->companyName = RemoveXss($value);
        return $this;
    }

    public function getContactName(): ?string
    {
        return HtmlDecode($this->contactName);
    }

    public function setContactName(?string $value): static
    {
        $this->contactName = RemoveXss($value);
        return $this;
    }

    public function getContactEmail(): ?string
    {
        return HtmlDecode($this->contactEmail);
    }

    public function setContactEmail(?string $value): static
    {
        $this->contactEmail = RemoveXss($value);
        return $this;
    }

    public function getPhone(): ?string
    {
        return HtmlDecode($this->phone);
    }

    public function setPhone(?string $value): static
    {
        $this->phone = RemoveXss($value);
        return $this;
    }

    public function getNpwp(): ?string
    {
        return HtmlDecode($this->npwp);
    }

    public function setNpwp(?string $value): static
    {
        $this->npwp = RemoveXss($value);
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getCity(): ?string
    {
        return HtmlDecode($this->city);
    }

    public function setCity(?string $value): static
    {
        $this->city = RemoveXss($value);
        return $this;
    }

    public function getActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(?bool $value): static
    {
        $this->active = $value;
        return $this;
    }

    public function getCreatedDate(): ?DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(?DateTime $value): static
    {
        $this->createdDate = $value;
        return $this;
    }

    public function getCreatedBy(): ?string
    {
        return HtmlDecode($this->createdBy);
    }

    public function setCreatedBy(?string $value): static
    {
        $this->createdBy = RemoveXss($value);
        return $this;
    }

    public function getLastUpdatedDate(): ?DateTime
    {
        return $this->lastUpdatedDate;
    }

    public function setLastUpdatedDate(?DateTime $value): static
    {
        $this->lastUpdatedDate = $value;
        return $this;
    }

    public function getLastUpdatedBy(): ?string
    {
        return HtmlDecode($this->lastUpdatedBy);
    }

    public function setLastUpdatedBy(?string $value): static
    {
        $this->lastUpdatedBy = RemoveXss($value);
        return $this;
    }
}
