<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "masterproject" table
 */
#[Entity]
#[Table(name: "masterproject")]
class Masterproject extends AbstractEntity
{
    public static array $propertyNames = [
        'ProjectID' => 'projectId',
        'ProjectName' => 'projectName',
        'PlanStart' => 'planStart',
        'PlanEnd' => 'planEnd',
        'StartDate' => 'startDate',
        'EndDate' => 'endDate',
        'WarrantyEnd' => 'warrantyEnd',
        'Status' => 'status',
        'Progress' => 'progress',
        'PaymentProgress' => 'paymentProgress',
        'PaymentDate' => 'paymentDate',
        'ClientID' => 'clientId',
        'ManagerID' => 'managerId',
        'ProjectTemplateID' => 'projectTemplateId',
        'Priority' => 'priority',
        'Description' => 'description',
        'ProjectValue' => 'projectValue',
        'ProjectDebt' => 'projectDebt',
        'PONumber' => 'poNumber',
        'PaymentLink' => 'paymentLink',
        'ClearingDate' => 'clearingDate',
        'Active' => 'active',
        'Created_Date' => 'createdDate',
        'Created_By' => 'createdBy',
        'Last_Updated_Date' => 'lastUpdatedDate',
        'Last_Updated_By' => 'lastUpdatedBy',
    ];

    #[Id]
    #[Column(name: "ProjectID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $projectId;

    #[Column(name: "ProjectName", type: "string", unique: true, nullable: true)]
    private ?string $projectName;

    #[Column(name: "PlanStart", type: "date", nullable: true)]
    private ?DateTime $planStart;

    #[Column(name: "PlanEnd", type: "date", nullable: true)]
    private ?DateTime $planEnd;

    #[Column(name: "StartDate", type: "date", nullable: true)]
    private ?DateTime $startDate;

    #[Column(name: "EndDate", type: "date", nullable: true)]
    private ?DateTime $endDate;

    #[Column(name: "WarrantyEnd", type: "date", nullable: true)]
    private ?DateTime $warrantyEnd;

    #[Column(name: "Status", type: "string", nullable: true)]
    private ?string $status = "Not Started";

    #[Column(name: "Progress", type: "decimal", nullable: true)]
    private ?string $progress = "0";

    #[Column(name: "PaymentProgress", type: "decimal", nullable: true)]
    private ?string $paymentProgress = "0";

    #[Column(name: "PaymentDate", type: "date", nullable: true)]
    private ?DateTime $paymentDate;

    #[Column(name: "ClientID", type: "integer", nullable: true)]
    private ?int $clientId;

    #[Column(name: "ManagerID", type: "integer", nullable: true)]
    private ?int $managerId;

    #[Column(name: "ProjectTemplateID", type: "integer")]
    private int $projectTemplateId;

    #[Column(name: "Priority", type: "integer", nullable: true)]
    private ?int $priority = 1;

    #[Column(name: "Description", type: "string", nullable: true)]
    private ?string $description;

    #[Column(name: "ProjectValue", type: "decimal", nullable: true)]
    private ?string $projectValue;

    #[Column(name: "ProjectDebt", type: "decimal", nullable: true)]
    private ?string $projectDebt;

    #[Column(name: "PONumber", type: "string", nullable: true)]
    private ?string $poNumber;

    #[Column(name: "PaymentLink", type: "text", nullable: true)]
    private ?string $paymentLink;

    #[Column(name: "ClearingDate", type: "date", nullable: true)]
    private ?DateTime $clearingDate;

    #[Column(name: "Active", type: "boolean", nullable: true)]
    private ?bool $active = true;

    #[Column(name: "Created_Date", type: "datetime", nullable: true)]
    private ?DateTime $createdDate;

    #[Column(name: "Created_By", type: "string", nullable: true)]
    private ?string $createdBy;

    #[Column(name: "Last_Updated_Date", type: "datetime", nullable: true)]
    private ?DateTime $lastUpdatedDate;

    #[Column(name: "Last_Updated_By", type: "string", nullable: true)]
    private ?string $lastUpdatedBy;

    public function getProjectId(): int
    {
        return $this->projectId;
    }

    public function setProjectId(int $value): static
    {
        $this->projectId = $value;
        return $this;
    }

    public function getProjectName(): ?string
    {
        return HtmlDecode($this->projectName);
    }

    public function setProjectName(?string $value): static
    {
        $this->projectName = RemoveXss($value);
        return $this;
    }

    public function getPlanStart(): ?DateTime
    {
        return $this->planStart;
    }

    public function setPlanStart(?DateTime $value): static
    {
        $this->planStart = $value;
        return $this;
    }

    public function getPlanEnd(): ?DateTime
    {
        return $this->planEnd;
    }

    public function setPlanEnd(?DateTime $value): static
    {
        $this->planEnd = $value;
        return $this;
    }

    public function getStartDate(): ?DateTime
    {
        return $this->startDate;
    }

    public function setStartDate(?DateTime $value): static
    {
        $this->startDate = $value;
        return $this;
    }

    public function getEndDate(): ?DateTime
    {
        return $this->endDate;
    }

    public function setEndDate(?DateTime $value): static
    {
        $this->endDate = $value;
        return $this;
    }

    public function getWarrantyEnd(): ?DateTime
    {
        return $this->warrantyEnd;
    }

    public function setWarrantyEnd(?DateTime $value): static
    {
        $this->warrantyEnd = $value;
        return $this;
    }

    public function getStatus(): ?string
    {
        return HtmlDecode($this->status);
    }

    public function setStatus(?string $value): static
    {
        $this->status = RemoveXss($value);
        return $this;
    }

    public function getProgress(): ?string
    {
        return $this->progress;
    }

    public function setProgress(?string $value): static
    {
        $this->progress = $value;
        return $this;
    }

    public function getPaymentProgress(): ?string
    {
        return $this->paymentProgress;
    }

    public function setPaymentProgress(?string $value): static
    {
        $this->paymentProgress = $value;
        return $this;
    }

    public function getPaymentDate(): ?DateTime
    {
        return $this->paymentDate;
    }

    public function setPaymentDate(?DateTime $value): static
    {
        $this->paymentDate = $value;
        return $this;
    }

    public function getClientId(): ?int
    {
        return $this->clientId;
    }

    public function setClientId(?int $value): static
    {
        $this->clientId = $value;
        return $this;
    }

    public function getManagerId(): ?int
    {
        return $this->managerId;
    }

    public function setManagerId(?int $value): static
    {
        $this->managerId = $value;
        return $this;
    }

    public function getProjectTemplateId(): int
    {
        return $this->projectTemplateId;
    }

    public function setProjectTemplateId(int $value): static
    {
        $this->projectTemplateId = $value;
        return $this;
    }

    public function getPriority(): ?int
    {
        return $this->priority;
    }

    public function setPriority(?int $value): static
    {
        $this->priority = $value;
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getProjectValue(): ?string
    {
        return $this->projectValue;
    }

    public function setProjectValue(?string $value): static
    {
        $this->projectValue = $value;
        return $this;
    }

    public function getProjectDebt(): ?string
    {
        return $this->projectDebt;
    }

    public function setProjectDebt(?string $value): static
    {
        $this->projectDebt = $value;
        return $this;
    }

    public function getPoNumber(): ?string
    {
        return HtmlDecode($this->poNumber);
    }

    public function setPoNumber(?string $value): static
    {
        $this->poNumber = RemoveXss($value);
        return $this;
    }

    public function getPaymentLink(): ?string
    {
        return HtmlDecode($this->paymentLink);
    }

    public function setPaymentLink(?string $value): static
    {
        $this->paymentLink = RemoveXss($value);
        return $this;
    }

    public function getClearingDate(): ?DateTime
    {
        return $this->clearingDate;
    }

    public function setClearingDate(?DateTime $value): static
    {
        $this->clearingDate = $value;
        return $this;
    }

    public function getActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(?bool $value): static
    {
        $this->active = $value;
        return $this;
    }

    public function getCreatedDate(): ?DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(?DateTime $value): static
    {
        $this->createdDate = $value;
        return $this;
    }

    public function getCreatedBy(): ?string
    {
        return HtmlDecode($this->createdBy);
    }

    public function setCreatedBy(?string $value): static
    {
        $this->createdBy = RemoveXss($value);
        return $this;
    }

    public function getLastUpdatedDate(): ?DateTime
    {
        return $this->lastUpdatedDate;
    }

    public function setLastUpdatedDate(?DateTime $value): static
    {
        $this->lastUpdatedDate = $value;
        return $this;
    }

    public function getLastUpdatedBy(): ?string
    {
        return HtmlDecode($this->lastUpdatedBy);
    }

    public function setLastUpdatedBy(?string $value): static
    {
        $this->lastUpdatedBy = RemoveXss($value);
        return $this;
    }
}
