<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "projectdocuments" table
 */
#[Entity]
#[Table(name: "projectdocuments")]
class Projectdocument extends AbstractEntity
{
    public static array $propertyNames = [
        'DocID' => 'docId',
        'DocDate' => 'docDate',
        'DocumentTitle' => 'documentTitle',
        'DocumentFile' => 'documentFile',
        'DocumentType' => 'documentType',
        'ProjectID' => 'projectId',
        'Created_Date' => 'createdDate',
        'Created_By' => 'createdBy',
        'Last_Updated_Date' => 'lastUpdatedDate',
        'Last_Updated_By' => 'lastUpdatedBy',
    ];

    #[Id]
    #[Column(name: "DocID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $docId;

    #[Column(name: "DocDate", type: "date", nullable: true)]
    private ?DateTime $docDate;

    #[Column(name: "DocumentTitle", type: "string", nullable: true)]
    private ?string $documentTitle;

    #[Column(name: "DocumentFile", type: "string", nullable: true)]
    private ?string $documentFile;

    #[Column(name: "DocumentType", type: "string", nullable: true)]
    private ?string $documentType;

    #[Column(name: "ProjectID", type: "integer", nullable: true)]
    private ?int $projectId;

    #[Column(name: "Created_Date", type: "datetime", nullable: true)]
    private ?DateTime $createdDate;

    #[Column(name: "Created_By", type: "string", nullable: true)]
    private ?string $createdBy;

    #[Column(name: "Last_Updated_Date", type: "datetime", nullable: true)]
    private ?DateTime $lastUpdatedDate;

    #[Column(name: "Last_Updated_By", type: "string", nullable: true)]
    private ?string $lastUpdatedBy;

    public function getDocId(): int
    {
        return $this->docId;
    }

    public function setDocId(int $value): static
    {
        $this->docId = $value;
        return $this;
    }

    public function getDocDate(): ?DateTime
    {
        return $this->docDate;
    }

    public function setDocDate(?DateTime $value): static
    {
        $this->docDate = $value;
        return $this;
    }

    public function getDocumentTitle(): ?string
    {
        return HtmlDecode($this->documentTitle);
    }

    public function setDocumentTitle(?string $value): static
    {
        $this->documentTitle = RemoveXss($value);
        return $this;
    }

    public function getDocumentFile(): ?string
    {
        return HtmlDecode($this->documentFile);
    }

    public function setDocumentFile(?string $value): static
    {
        $this->documentFile = RemoveXss($value);
        return $this;
    }

    public function getDocumentType(): ?string
    {
        return HtmlDecode($this->documentType);
    }

    public function setDocumentType(?string $value): static
    {
        $this->documentType = RemoveXss($value);
        return $this;
    }

    public function getProjectId(): ?int
    {
        return $this->projectId;
    }

    public function setProjectId(?int $value): static
    {
        $this->projectId = $value;
        return $this;
    }

    public function getCreatedDate(): ?DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(?DateTime $value): static
    {
        $this->createdDate = $value;
        return $this;
    }

    public function getCreatedBy(): ?string
    {
        return HtmlDecode($this->createdBy);
    }

    public function setCreatedBy(?string $value): static
    {
        $this->createdBy = RemoveXss($value);
        return $this;
    }

    public function getLastUpdatedDate(): ?DateTime
    {
        return $this->lastUpdatedDate;
    }

    public function setLastUpdatedDate(?DateTime $value): static
    {
        $this->lastUpdatedDate = $value;
        return $this;
    }

    public function getLastUpdatedBy(): ?string
    {
        return HtmlDecode($this->lastUpdatedBy);
    }

    public function setLastUpdatedBy(?string $value): static
    {
        $this->lastUpdatedBy = RemoveXss($value);
        return $this;
    }
}
