<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "projectmom" table
 */
#[Entity]
#[Table(name: "projectmom")]
class Projectmom extends AbstractEntity
{
    public static array $propertyNames = [
        'MOMID' => 'momid',
        'MomDate' => 'momDate',
        'MomTitle' => 'momTitle',
        'MomDesc' => 'momDesc',
        'Internal' => 'internal',
        'ProjectID' => 'projectId',
        'Created_Date' => 'createdDate',
        'Created_By' => 'createdBy',
        'Last_Updated_Date' => 'lastUpdatedDate',
        'Last_Updated_By' => 'lastUpdatedBy',
    ];

    #[Id]
    #[Column(name: "MOMID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $momid;

    #[Column(name: "MomDate", type: "date", nullable: true)]
    private ?DateTime $momDate;

    #[Column(name: "MomTitle", type: "string", nullable: true)]
    private ?string $momTitle;

    #[Column(name: "MomDesc", type: "text")]
    private string $momDesc;

    #[Column(name: "Internal", type: "boolean", nullable: true)]
    private ?bool $internal;

    #[Column(name: "ProjectID", type: "integer", nullable: true)]
    private ?int $projectId;

    #[Column(name: "Created_Date", type: "datetime", nullable: true)]
    private ?DateTime $createdDate;

    #[Column(name: "Created_By", type: "string", nullable: true)]
    private ?string $createdBy;

    #[Column(name: "Last_Updated_Date", type: "datetime", nullable: true)]
    private ?DateTime $lastUpdatedDate;

    #[Column(name: "Last_Updated_By", type: "string", nullable: true)]
    private ?string $lastUpdatedBy;

    public function getMomid(): int
    {
        return $this->momid;
    }

    public function setMomid(int $value): static
    {
        $this->momid = $value;
        return $this;
    }

    public function getMomDate(): ?DateTime
    {
        return $this->momDate;
    }

    public function setMomDate(?DateTime $value): static
    {
        $this->momDate = $value;
        return $this;
    }

    public function getMomTitle(): ?string
    {
        return HtmlDecode($this->momTitle);
    }

    public function setMomTitle(?string $value): static
    {
        $this->momTitle = RemoveXss($value);
        return $this;
    }

    public function getMomDesc(): string
    {
        return HtmlDecode($this->momDesc);
    }

    public function setMomDesc(string $value): static
    {
        $this->momDesc = RemoveXss($value);
        return $this;
    }

    public function getInternal(): ?bool
    {
        return $this->internal;
    }

    public function setInternal(?bool $value): static
    {
        $this->internal = $value;
        return $this;
    }

    public function getProjectId(): ?int
    {
        return $this->projectId;
    }

    public function setProjectId(?int $value): static
    {
        $this->projectId = $value;
        return $this;
    }

    public function getCreatedDate(): ?DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(?DateTime $value): static
    {
        $this->createdDate = $value;
        return $this;
    }

    public function getCreatedBy(): ?string
    {
        return HtmlDecode($this->createdBy);
    }

    public function setCreatedBy(?string $value): static
    {
        $this->createdBy = RemoveXss($value);
        return $this;
    }

    public function getLastUpdatedDate(): ?DateTime
    {
        return $this->lastUpdatedDate;
    }

    public function setLastUpdatedDate(?DateTime $value): static
    {
        $this->lastUpdatedDate = $value;
        return $this;
    }

    public function getLastUpdatedBy(): ?string
    {
        return HtmlDecode($this->lastUpdatedBy);
    }

    public function setLastUpdatedBy(?string $value): static
    {
        $this->lastUpdatedBy = RemoveXss($value);
        return $this;
    }
}
