<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "projectproblems" table
 */
#[Entity]
#[Table(name: "projectproblems")]
class Projectproblem extends AbstractEntity
{
    public static array $propertyNames = [
        'ProblemId' => 'problemId',
        'ProblemDate' => 'problemDate',
        'ProblemDescription' => 'problemDescription',
        'SolutionDescription' => 'solutionDescription',
        'AriseById' => 'ariseById',
        'SolvedById' => 'solvedById',
        'ProblemFile' => 'problemFile',
        'ProjectID' => 'projectId',
        'Created_Date' => 'createdDate',
        'Created_By' => 'createdBy',
        'Last_Updated_Date' => 'lastUpdatedDate',
        'Last_Updated_By' => 'lastUpdatedBy',
    ];

    #[Id]
    #[Column(name: "ProblemId", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $problemId;

    #[Column(name: "ProblemDate", type: "date", nullable: true)]
    private ?DateTime $problemDate;

    #[Column(name: "ProblemDescription", type: "text", nullable: true)]
    private ?string $problemDescription;

    #[Column(name: "SolutionDescription", type: "text", nullable: true)]
    private ?string $solutionDescription;

    #[Column(name: "AriseById", type: "integer", nullable: true)]
    private ?int $ariseById;

    #[Column(name: "SolvedById", type: "integer", nullable: true)]
    private ?int $solvedById;

    #[Column(name: "ProblemFile", type: "string", nullable: true)]
    private ?string $problemFile;

    #[Column(name: "ProjectID", type: "integer", nullable: true)]
    private ?int $projectId;

    #[Column(name: "Created_Date", type: "datetime", nullable: true)]
    private ?DateTime $createdDate;

    #[Column(name: "Created_By", type: "string", nullable: true)]
    private ?string $createdBy;

    #[Column(name: "Last_Updated_Date", type: "datetime", nullable: true)]
    private ?DateTime $lastUpdatedDate;

    #[Column(name: "Last_Updated_By", type: "string", nullable: true)]
    private ?string $lastUpdatedBy;

    public function getProblemId(): int
    {
        return $this->problemId;
    }

    public function setProblemId(int $value): static
    {
        $this->problemId = $value;
        return $this;
    }

    public function getProblemDate(): ?DateTime
    {
        return $this->problemDate;
    }

    public function setProblemDate(?DateTime $value): static
    {
        $this->problemDate = $value;
        return $this;
    }

    public function getProblemDescription(): ?string
    {
        return HtmlDecode($this->problemDescription);
    }

    public function setProblemDescription(?string $value): static
    {
        $this->problemDescription = RemoveXss($value);
        return $this;
    }

    public function getSolutionDescription(): ?string
    {
        return HtmlDecode($this->solutionDescription);
    }

    public function setSolutionDescription(?string $value): static
    {
        $this->solutionDescription = RemoveXss($value);
        return $this;
    }

    public function getAriseById(): ?int
    {
        return $this->ariseById;
    }

    public function setAriseById(?int $value): static
    {
        $this->ariseById = $value;
        return $this;
    }

    public function getSolvedById(): ?int
    {
        return $this->solvedById;
    }

    public function setSolvedById(?int $value): static
    {
        $this->solvedById = $value;
        return $this;
    }

    public function getProblemFile(): ?string
    {
        return HtmlDecode($this->problemFile);
    }

    public function setProblemFile(?string $value): static
    {
        $this->problemFile = RemoveXss($value);
        return $this;
    }

    public function getProjectId(): ?int
    {
        return $this->projectId;
    }

    public function setProjectId(?int $value): static
    {
        $this->projectId = $value;
        return $this;
    }

    public function getCreatedDate(): ?DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(?DateTime $value): static
    {
        $this->createdDate = $value;
        return $this;
    }

    public function getCreatedBy(): ?string
    {
        return HtmlDecode($this->createdBy);
    }

    public function setCreatedBy(?string $value): static
    {
        $this->createdBy = RemoveXss($value);
        return $this;
    }

    public function getLastUpdatedDate(): ?DateTime
    {
        return $this->lastUpdatedDate;
    }

    public function setLastUpdatedDate(?DateTime $value): static
    {
        $this->lastUpdatedDate = $value;
        return $this;
    }

    public function getLastUpdatedBy(): ?string
    {
        return HtmlDecode($this->lastUpdatedBy);
    }

    public function setLastUpdatedBy(?string $value): static
    {
        $this->lastUpdatedBy = RemoveXss($value);
        return $this;
    }
}
