<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "projecttask" table
 */
#[Entity]
#[Table(name: "projecttask")]
class Projecttask extends AbstractEntity
{
    public static array $propertyNames = [
        'TaskID' => 'taskId',
        'TaskName' => 'taskName',
        'Description' => 'description',
        'AssignedTo' => 'assignedTo',
        'Progress' => 'progress',
        'PlanStart' => 'planStart',
        'PlanEnd' => 'planEnd',
        'StartDate' => 'startDate',
        'EndDate' => 'endDate',
        'Priority' => 'priority',
        'Category' => 'category',
        'ProjectID' => 'projectId',
        'Created_Date' => 'createdDate',
        'Created_By' => 'createdBy',
        'Last_Updated_Date' => 'lastUpdatedDate',
        'Last_Updated_By' => 'lastUpdatedBy',
    ];

    #[Id]
    #[Column(name: "TaskID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $taskId;

    #[Column(name: "TaskName", type: "string", nullable: true)]
    private ?string $taskName;

    #[Column(name: "Description", type: "text", nullable: true)]
    private ?string $description;

    #[Column(name: "AssignedTo", type: "integer", nullable: true)]
    private ?int $assignedTo;

    #[Column(name: "Progress", type: "decimal", nullable: true)]
    private ?string $progress = "0";

    #[Column(name: "PlanStart", type: "date", nullable: true)]
    private ?DateTime $planStart;

    #[Column(name: "PlanEnd", type: "date", nullable: true)]
    private ?DateTime $planEnd = date('Y-m-d', strtotime('+1 day'));

    #[Column(name: "StartDate", type: "date", nullable: true)]
    private ?DateTime $startDate;

    #[Column(name: "EndDate", type: "date", nullable: true)]
    private ?DateTime $endDate = date('Y-m-d', strtotime('+1 day'));

    #[Column(name: "Priority", type: "integer", nullable: true)]
    private ?int $priority = 1;

    #[Column(name: "Category", type: "string", nullable: true)]
    private ?string $category;

    #[Column(name: "ProjectID", type: "integer", nullable: true)]
    private ?int $projectId;

    #[Column(name: "Created_Date", type: "datetime", nullable: true)]
    private ?DateTime $createdDate;

    #[Column(name: "Created_By", type: "string", nullable: true)]
    private ?string $createdBy;

    #[Column(name: "Last_Updated_Date", type: "datetime", nullable: true)]
    private ?DateTime $lastUpdatedDate;

    #[Column(name: "Last_Updated_By", type: "string", nullable: true)]
    private ?string $lastUpdatedBy;

    public function getTaskId(): int
    {
        return $this->taskId;
    }

    public function setTaskId(int $value): static
    {
        $this->taskId = $value;
        return $this;
    }

    public function getTaskName(): ?string
    {
        return HtmlDecode($this->taskName);
    }

    public function setTaskName(?string $value): static
    {
        $this->taskName = RemoveXss($value);
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getAssignedTo(): ?int
    {
        return $this->assignedTo;
    }

    public function setAssignedTo(?int $value): static
    {
        $this->assignedTo = $value;
        return $this;
    }

    public function getProgress(): ?string
    {
        return $this->progress;
    }

    public function setProgress(?string $value): static
    {
        $this->progress = $value;
        return $this;
    }

    public function getPlanStart(): ?DateTime
    {
        return $this->planStart;
    }

    public function setPlanStart(?DateTime $value): static
    {
        $this->planStart = $value;
        return $this;
    }

    public function getPlanEnd(): ?DateTime
    {
        return $this->planEnd;
    }

    public function setPlanEnd(?DateTime $value): static
    {
        $this->planEnd = $value;
        return $this;
    }

    public function getStartDate(): ?DateTime
    {
        return $this->startDate;
    }

    public function setStartDate(?DateTime $value): static
    {
        $this->startDate = $value;
        return $this;
    }

    public function getEndDate(): ?DateTime
    {
        return $this->endDate;
    }

    public function setEndDate(?DateTime $value): static
    {
        $this->endDate = $value;
        return $this;
    }

    public function getPriority(): ?int
    {
        return $this->priority;
    }

    public function setPriority(?int $value): static
    {
        $this->priority = $value;
        return $this;
    }

    public function getCategory(): ?string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(?string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getProjectId(): ?int
    {
        return $this->projectId;
    }

    public function setProjectId(?int $value): static
    {
        $this->projectId = $value;
        return $this;
    }

    public function getCreatedDate(): ?DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(?DateTime $value): static
    {
        $this->createdDate = $value;
        return $this;
    }

    public function getCreatedBy(): ?string
    {
        return HtmlDecode($this->createdBy);
    }

    public function setCreatedBy(?string $value): static
    {
        $this->createdBy = RemoveXss($value);
        return $this;
    }

    public function getLastUpdatedDate(): ?DateTime
    {
        return $this->lastUpdatedDate;
    }

    public function setLastUpdatedDate(?DateTime $value): static
    {
        $this->lastUpdatedDate = $value;
        return $this;
    }

    public function getLastUpdatedBy(): ?string
    {
        return HtmlDecode($this->lastUpdatedBy);
    }

    public function setLastUpdatedBy(?string $value): static
    {
        $this->lastUpdatedBy = RemoveXss($value);
        return $this;
    }
}
