<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "viewprojectmember" table
 */
#[Entity]
#[Table(name: "viewprojectmember")]
class Viewprojectmember extends AbstractEntity
{
    public static array $propertyNames = [
        'ProjectID' => 'projectId',
        'EmployeeID' => 'employeeId',
        'FullName' => 'fullName',
    ];

    #[Column(name: "ProjectID", type: "integer", nullable: true)]
    private ?int $projectId;

    #[Column(name: "EmployeeID", type: "integer", nullable: true)]
    private ?int $employeeId;

    #[Column(name: "FullName", type: "string", nullable: true)]
    private ?string $fullName;

    public function getProjectId(): ?int
    {
        return $this->projectId;
    }

    public function setProjectId(?int $value): static
    {
        $this->projectId = $value;
        return $this;
    }

    public function getEmployeeId(): ?int
    {
        return $this->employeeId;
    }

    public function setEmployeeId(?int $value): static
    {
        $this->employeeId = $value;
        return $this;
    }

    public function getFullName(): ?string
    {
        return HtmlDecode($this->fullName);
    }

    public function setFullName(?string $value): static
    {
        $this->fullName = RemoveXss($value);
        return $this;
    }
}
