<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "vuser" table
 */
#[Entity]
#[Table(name: "vuser")]
class Vuser extends AbstractEntity
{
    public static array $propertyNames = [
        'EmployeeID' => 'employeeId',
        'FirstName' => 'firstName',
        'LastName' => 'lastName',
        'Email' => 'email',
        'WhatsAppNumber' => 'whatsAppNumber',
        'Department' => 'department',
        'Position' => 'position',
        'Username' => 'username',
    ];

    #[Id]
    #[Column(name: "EmployeeID", type: "integer")]
    #[GeneratedValue]
    private int $employeeId;

    #[Column(name: "FirstName", type: "string", nullable: true)]
    private ?string $firstName;

    #[Column(name: "LastName", type: "string", nullable: true)]
    private ?string $lastName;

    #[Column(name: "Email", type: "string", nullable: true)]
    private ?string $email;

    #[Column(name: "WhatsAppNumber", type: "string", nullable: true)]
    private ?string $whatsAppNumber;

    #[Column(name: "Department", type: "string", nullable: true)]
    private ?string $department;

    #[Column(name: "Position", type: "string", nullable: true)]
    private ?string $position;

    #[Column(name: "Username", type: "string")]
    private string $username;

    public function getEmployeeId(): int
    {
        return $this->employeeId;
    }

    public function setEmployeeId(int $value): static
    {
        $this->employeeId = $value;
        return $this;
    }

    public function getFirstName(): ?string
    {
        return HtmlDecode($this->firstName);
    }

    public function setFirstName(?string $value): static
    {
        $this->firstName = RemoveXss($value);
        return $this;
    }

    public function getLastName(): ?string
    {
        return HtmlDecode($this->lastName);
    }

    public function setLastName(?string $value): static
    {
        $this->lastName = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getWhatsAppNumber(): ?string
    {
        return HtmlDecode($this->whatsAppNumber);
    }

    public function setWhatsAppNumber(?string $value): static
    {
        $this->whatsAppNumber = RemoveXss($value);
        return $this;
    }

    public function getDepartment(): ?string
    {
        return HtmlDecode($this->department);
    }

    public function setDepartment(?string $value): static
    {
        $this->department = RemoveXss($value);
        return $this;
    }

    public function getPosition(): ?string
    {
        return HtmlDecode($this->position);
    }

    public function setPosition(?string $value): static
    {
        $this->position = RemoveXss($value);
        return $this;
    }

    public function getUsername(): string
    {
        return HtmlDecode($this->username);
    }

    public function setUsername(string $value): static
    {
        $this->username = RemoveXss($value);
        return $this;
    }
}
