<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$MasterclientList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masterclient: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "CompanyName": <?= $Page->CompanyName->toClientList($Page) ?>,
            "ContactName": <?= $Page->ContactName->toClientList($Page) ?>,
            "ContactEmail": <?= $Page->ContactEmail->toClientList($Page) ?>,
            "Phone": <?= $Page->Phone->toClientList($Page) ?>,
            "NPWP": <?= $Page->NPWP->toClientList($Page) ?>,
            "City": <?= $Page->City->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
            "Created_Date": <?= $Page->Created_Date->toClientList($Page) ?>,
            "Created_By": <?= $Page->Created_By->toClientList($Page) ?>,
            "Last_Updated_Date": <?= $Page->Last_Updated_Date->toClientList($Page) ?>,
            "Last_Updated_By": <?= $Page->Last_Updated_By->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.6.2", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.6.4",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.6.4"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fmasterclientsrch" id="fmasterclientsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fmasterclientsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masterclient: currentTable } });
var currentForm;
var fmasterclientsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmasterclientsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "CompanyName": <?= $Page->CompanyName->toClientList($Page) ?>,
            "ContactName": <?= $Page->ContactName->toClientList($Page) ?>,
            "ContactEmail": <?= $Page->ContactEmail->toClientList($Page) ?>,
            "Phone": <?= $Page->Phone->toClientList($Page) ?>,
            "NPWP": <?= $Page->NPWP->toClientList($Page) ?>,
            "City": <?= $Page->City->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
            "Created_Date": <?= $Page->Created_Date->toClientList($Page) ?>,
            "Created_By": <?= $Page->Created_By->toClientList($Page) ?>,
            "Last_Updated_Date": <?= $Page->Last_Updated_Date->toClientList($Page) ?>,
            "Last_Updated_By": <?= $Page->Last_Updated_By->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->CompanyName->Visible) { // CompanyName ?>
<?php
if (!$Page->CompanyName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_CompanyName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->CompanyName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_CompanyName"
            name="x_CompanyName[]"
            class="form-control ew-select<?= $Page->CompanyName->isInvalidClass() ?>"
            data-select2-id="fmasterclientsrch_x_CompanyName"
            data-table="masterclient"
            data-field="x_CompanyName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->CompanyName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->CompanyName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->CompanyName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->CompanyName->editAttributes() ?>>
            <?= $Page->CompanyName->selectOptionListHtml("x_CompanyName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->CompanyName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterclientsrch", function() {
            var options = {
                name: "x_CompanyName",
                selectId: "fmasterclientsrch_x_CompanyName",
                ajax: { id: "x_CompanyName", form: "fmasterclientsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterclient.fields.CompanyName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ContactName->Visible) { // ContactName ?>
<?php
if (!$Page->ContactName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ContactName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ContactName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_ContactName"
            name="x_ContactName[]"
            class="form-control ew-select<?= $Page->ContactName->isInvalidClass() ?>"
            data-select2-id="fmasterclientsrch_x_ContactName"
            data-table="masterclient"
            data-field="x_ContactName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->ContactName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->ContactName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->ContactName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->ContactName->editAttributes() ?>>
            <?= $Page->ContactName->selectOptionListHtml("x_ContactName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->ContactName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterclientsrch", function() {
            var options = {
                name: "x_ContactName",
                selectId: "fmasterclientsrch_x_ContactName",
                ajax: { id: "x_ContactName", form: "fmasterclientsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterclient.fields.ContactName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ContactEmail->Visible) { // ContactEmail ?>
<?php
if (!$Page->ContactEmail->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ContactEmail" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ContactEmail->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_ContactEmail"
            name="x_ContactEmail[]"
            class="form-control ew-select<?= $Page->ContactEmail->isInvalidClass() ?>"
            data-select2-id="fmasterclientsrch_x_ContactEmail"
            data-table="masterclient"
            data-field="x_ContactEmail"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->ContactEmail->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->ContactEmail->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->ContactEmail->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->ContactEmail->editAttributes() ?>>
            <?= $Page->ContactEmail->selectOptionListHtml("x_ContactEmail", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->ContactEmail->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterclientsrch", function() {
            var options = {
                name: "x_ContactEmail",
                selectId: "fmasterclientsrch_x_ContactEmail",
                ajax: { id: "x_ContactEmail", form: "fmasterclientsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterclient.fields.ContactEmail.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Phone->Visible) { // Phone ?>
<?php
if (!$Page->Phone->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Phone" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Phone->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Phone"
            name="x_Phone[]"
            class="form-control ew-select<?= $Page->Phone->isInvalidClass() ?>"
            data-select2-id="fmasterclientsrch_x_Phone"
            data-table="masterclient"
            data-field="x_Phone"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Phone->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Phone->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Phone->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Phone->editAttributes() ?>>
            <?= $Page->Phone->selectOptionListHtml("x_Phone", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Phone->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterclientsrch", function() {
            var options = {
                name: "x_Phone",
                selectId: "fmasterclientsrch_x_Phone",
                ajax: { id: "x_Phone", form: "fmasterclientsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterclient.fields.Phone.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->NPWP->Visible) { // NPWP ?>
<?php
if (!$Page->NPWP->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_NPWP" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->NPWP->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_NPWP"
            name="x_NPWP[]"
            class="form-control ew-select<?= $Page->NPWP->isInvalidClass() ?>"
            data-select2-id="fmasterclientsrch_x_NPWP"
            data-table="masterclient"
            data-field="x_NPWP"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->NPWP->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->NPWP->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->NPWP->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->NPWP->editAttributes() ?>>
            <?= $Page->NPWP->selectOptionListHtml("x_NPWP", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->NPWP->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterclientsrch", function() {
            var options = {
                name: "x_NPWP",
                selectId: "fmasterclientsrch_x_NPWP",
                ajax: { id: "x_NPWP", form: "fmasterclientsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterclient.fields.NPWP.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->City->Visible) { // City ?>
<?php
if (!$Page->City->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_City" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->City->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_City"
            name="x_City[]"
            class="form-control ew-select<?= $Page->City->isInvalidClass() ?>"
            data-select2-id="fmasterclientsrch_x_City"
            data-table="masterclient"
            data-field="x_City"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->City->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->City->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->City->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->City->editAttributes() ?>>
            <?= $Page->City->selectOptionListHtml("x_City", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->City->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterclientsrch", function() {
            var options = {
                name: "x_City",
                selectId: "fmasterclientsrch_x_City",
                ajax: { id: "x_City", form: "fmasterclientsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterclient.fields.City.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Active->Visible) { // Active ?>
<?php
if (!$Page->Active->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Active" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Active->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Active"
            name="x_Active[]"
            class="form-control ew-select<?= $Page->Active->isInvalidClass() ?>"
            data-select2-id="fmasterclientsrch_x_Active"
            data-table="masterclient"
            data-field="x_Active"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Active->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Active->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Active->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Active->editAttributes() ?>>
            <?= $Page->Active->selectOptionListHtml("x_Active", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Active->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterclientsrch", function() {
            var options = {
                name: "x_Active",
                selectId: "fmasterclientsrch_x_Active",
                ajax: { id: "x_Active", form: "fmasterclientsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterclient.fields.Active.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
<?php
if (!$Page->Created_Date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Created_Date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Created_Date->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Created_Date"
            name="x_Created_Date[]"
            class="form-control ew-select<?= $Page->Created_Date->isInvalidClass() ?>"
            data-select2-id="fmasterclientsrch_x_Created_Date"
            data-table="masterclient"
            data-field="x_Created_Date"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Created_Date->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Created_Date->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Created_Date->editAttributes() ?>>
            <?= $Page->Created_Date->selectOptionListHtml("x_Created_Date", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterclientsrch", function() {
            var options = {
                name: "x_Created_Date",
                selectId: "fmasterclientsrch_x_Created_Date",
                ajax: { id: "x_Created_Date", form: "fmasterclientsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterclient.fields.Created_Date.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
<?php
if (!$Page->Created_By->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Created_By" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Created_By->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Created_By"
            name="x_Created_By[]"
            class="form-control ew-select<?= $Page->Created_By->isInvalidClass() ?>"
            data-select2-id="fmasterclientsrch_x_Created_By"
            data-table="masterclient"
            data-field="x_Created_By"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Created_By->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Created_By->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Created_By->editAttributes() ?>>
            <?= $Page->Created_By->selectOptionListHtml("x_Created_By", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterclientsrch", function() {
            var options = {
                name: "x_Created_By",
                selectId: "fmasterclientsrch_x_Created_By",
                ajax: { id: "x_Created_By", form: "fmasterclientsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterclient.fields.Created_By.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
<?php
if (!$Page->Last_Updated_Date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Last_Updated_Date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Last_Updated_Date->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Last_Updated_Date"
            name="x_Last_Updated_Date[]"
            class="form-control ew-select<?= $Page->Last_Updated_Date->isInvalidClass() ?>"
            data-select2-id="fmasterclientsrch_x_Last_Updated_Date"
            data-table="masterclient"
            data-field="x_Last_Updated_Date"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Last_Updated_Date->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Last_Updated_Date->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Last_Updated_Date->editAttributes() ?>>
            <?= $Page->Last_Updated_Date->selectOptionListHtml("x_Last_Updated_Date", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterclientsrch", function() {
            var options = {
                name: "x_Last_Updated_Date",
                selectId: "fmasterclientsrch_x_Last_Updated_Date",
                ajax: { id: "x_Last_Updated_Date", form: "fmasterclientsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterclient.fields.Last_Updated_Date.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
<?php
if (!$Page->Last_Updated_By->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Last_Updated_By" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Last_Updated_By->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Last_Updated_By"
            name="x_Last_Updated_By[]"
            class="form-control ew-select<?= $Page->Last_Updated_By->isInvalidClass() ?>"
            data-select2-id="fmasterclientsrch_x_Last_Updated_By"
            data-table="masterclient"
            data-field="x_Last_Updated_By"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Last_Updated_By->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Last_Updated_By->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Last_Updated_By->editAttributes() ?>>
            <?= $Page->Last_Updated_By->selectOptionListHtml("x_Last_Updated_By", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterclientsrch", function() {
            var options = {
                name: "x_Last_Updated_By",
                selectId: "fmasterclientsrch_x_Last_Updated_By",
                ajax: { id: "x_Last_Updated_By", form: "fmasterclientsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterclient.fields.Last_Updated_By.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fmasterclientsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fmasterclientsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fmasterclientsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fmasterclientsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fmasterclientsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fmasterclientsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fmasterclientsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="masterclient">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_masterclient" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_masterclientlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->CompanyName->Visible) { // CompanyName ?>
        <th data-name="CompanyName" class="<?= $Page->CompanyName->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterclient_CompanyName" class="masterclient_CompanyName"><?= $Page->renderFieldHeader($Page->CompanyName) ?></div></th>
<?php } ?>
<?php if ($Page->ContactName->Visible) { // ContactName ?>
        <th data-name="ContactName" class="<?= $Page->ContactName->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterclient_ContactName" class="masterclient_ContactName"><?= $Page->renderFieldHeader($Page->ContactName) ?></div></th>
<?php } ?>
<?php if ($Page->ContactEmail->Visible) { // ContactEmail ?>
        <th data-name="ContactEmail" class="<?= $Page->ContactEmail->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterclient_ContactEmail" class="masterclient_ContactEmail"><?= $Page->renderFieldHeader($Page->ContactEmail) ?></div></th>
<?php } ?>
<?php if ($Page->Phone->Visible) { // Phone ?>
        <th data-name="Phone" class="<?= $Page->Phone->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterclient_Phone" class="masterclient_Phone"><?= $Page->renderFieldHeader($Page->Phone) ?></div></th>
<?php } ?>
<?php if ($Page->NPWP->Visible) { // NPWP ?>
        <th data-name="NPWP" class="<?= $Page->NPWP->headerCellClass() ?>"><div id="elh_masterclient_NPWP" class="masterclient_NPWP"><?= $Page->renderFieldHeader($Page->NPWP) ?></div></th>
<?php } ?>
<?php if ($Page->City->Visible) { // City ?>
        <th data-name="City" class="<?= $Page->City->headerCellClass() ?>"><div id="elh_masterclient_City" class="masterclient_City"><?= $Page->renderFieldHeader($Page->City) ?></div></th>
<?php } ?>
<?php if ($Page->Active->Visible) { // Active ?>
        <th data-name="Active" class="<?= $Page->Active->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterclient_Active" class="masterclient_Active"><?= $Page->renderFieldHeader($Page->Active) ?></div></th>
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Page->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterclient_Created_Date" class="masterclient_Created_Date"><?= $Page->renderFieldHeader($Page->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Page->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterclient_Created_By" class="masterclient_Created_By"><?= $Page->renderFieldHeader($Page->Created_By) ?></div></th>
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Page->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterclient_Last_Updated_Date" class="masterclient_Last_Updated_Date"><?= $Page->renderFieldHeader($Page->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Page->Last_Updated_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterclient_Last_Updated_By" class="masterclient_Last_Updated_By"><?= $Page->renderFieldHeader($Page->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->CompanyName->Visible) { // CompanyName ?>
        <td data-name="CompanyName"<?= $Page->CompanyName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterclient_CompanyName" class="el_masterclient_CompanyName">
<span<?= $Page->CompanyName->viewAttributes() ?>>
<?= $Page->CompanyName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ContactName->Visible) { // ContactName ?>
        <td data-name="ContactName"<?= $Page->ContactName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterclient_ContactName" class="el_masterclient_ContactName">
<span<?= $Page->ContactName->viewAttributes() ?>>
<?= $Page->ContactName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ContactEmail->Visible) { // ContactEmail ?>
        <td data-name="ContactEmail"<?= $Page->ContactEmail->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterclient_ContactEmail" class="el_masterclient_ContactEmail">
<span<?= $Page->ContactEmail->viewAttributes() ?>>
<?= $Page->ContactEmail->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Phone->Visible) { // Phone ?>
        <td data-name="Phone"<?= $Page->Phone->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterclient_Phone" class="el_masterclient_Phone">
<span<?= $Page->Phone->viewAttributes() ?>>
<?= $Page->Phone->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->NPWP->Visible) { // NPWP ?>
        <td data-name="NPWP"<?= $Page->NPWP->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterclient_NPWP" class="el_masterclient_NPWP">
<span<?= $Page->NPWP->viewAttributes() ?>>
<?= $Page->NPWP->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->City->Visible) { // City ?>
        <td data-name="City"<?= $Page->City->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterclient_City" class="el_masterclient_City">
<span<?= $Page->City->viewAttributes() ?>>
<?= $Page->City->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Active->Visible) { // Active ?>
        <td data-name="Active"<?= $Page->Active->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterclient_Active" class="el_masterclient_Active">
<span<?= $Page->Active->viewAttributes() ?>>
<i class="fa-regular fa-square<?php if (ConvertToBool($Page->Active->CurrentValue)) { ?>-check<?php } ?> ew-icon ew-boolean"></i>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Page->Created_Date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterclient_Created_Date" class="el_masterclient_Created_Date">
<span<?= $Page->Created_Date->viewAttributes() ?>>
<?= $Page->Created_Date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Page->Created_By->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterclient_Created_By" class="el_masterclient_Created_By">
<span<?= $Page->Created_By->viewAttributes() ?>>
<?= $Page->Created_By->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Page->Last_Updated_Date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterclient_Last_Updated_Date" class="el_masterclient_Last_Updated_Date">
<span<?= $Page->Last_Updated_Date->viewAttributes() ?>>
<?= $Page->Last_Updated_Date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Page->Last_Updated_By->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterclient_Last_Updated_By" class="el_masterclient_Last_Updated_By">
<span<?= $Page->Last_Updated_By->viewAttributes() ?>>
<?= $Page->Last_Updated_By->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masterclient");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
