<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$MasterprojectList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masterproject: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "ProjectName": <?= $Page->ProjectName->toClientList($Page) ?>,
            "PlanStart": <?= $Page->PlanStart->toClientList($Page) ?>,
            "PlanEnd": <?= $Page->PlanEnd->toClientList($Page) ?>,
            "StartDate": <?= $Page->StartDate->toClientList($Page) ?>,
            "EndDate": <?= $Page->EndDate->toClientList($Page) ?>,
            "WarrantyEnd": <?= $Page->WarrantyEnd->toClientList($Page) ?>,
            "Status": <?= $Page->Status->toClientList($Page) ?>,
            "Progress": <?= $Page->Progress->toClientList($Page) ?>,
            "Target": <?= $Page->Target->toClientList($Page) ?>,
            "Track": <?= $Page->Track->toClientList($Page) ?>,
            "PaymentProgress": <?= $Page->PaymentProgress->toClientList($Page) ?>,
            "PaymentDate": <?= $Page->PaymentDate->toClientList($Page) ?>,
            "PaymentComplete": <?= $Page->PaymentComplete->toClientList($Page) ?>,
            "AgingPayment": <?= $Page->AgingPayment->toClientList($Page) ?>,
            "ClientID": <?= $Page->ClientID->toClientList($Page) ?>,
            "ManagerID": <?= $Page->ManagerID->toClientList($Page) ?>,
            "ProjectTemplateID": <?= $Page->ProjectTemplateID->toClientList($Page) ?>,
            "Priority": <?= $Page->Priority->toClientList($Page) ?>,
            "ProjectValue": <?= $Page->ProjectValue->toClientList($Page) ?>,
            "ProjectDebt": <?= $Page->ProjectDebt->toClientList($Page) ?>,
            "PONumber": <?= $Page->PONumber->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
            "Created_Date": <?= $Page->Created_Date->toClientList($Page) ?>,
            "Created_By": <?= $Page->Created_By->toClientList($Page) ?>,
            "Last_Updated_Date": <?= $Page->Last_Updated_Date->toClientList($Page) ?>,
            "Last_Updated_By": <?= $Page->Last_Updated_By->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.6.2", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.6.4",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.6.4"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fmasterprojectsrch" id="fmasterprojectsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fmasterprojectsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masterproject: currentTable } });
var currentForm;
var fmasterprojectsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmasterprojectsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProjectName": <?= $Page->ProjectName->toClientList($Page) ?>,
            "PlanStart": <?= $Page->PlanStart->toClientList($Page) ?>,
            "PlanEnd": <?= $Page->PlanEnd->toClientList($Page) ?>,
            "StartDate": <?= $Page->StartDate->toClientList($Page) ?>,
            "EndDate": <?= $Page->EndDate->toClientList($Page) ?>,
            "WarrantyEnd": <?= $Page->WarrantyEnd->toClientList($Page) ?>,
            "Status": <?= $Page->Status->toClientList($Page) ?>,
            "Progress": <?= $Page->Progress->toClientList($Page) ?>,
            "Target": <?= $Page->Target->toClientList($Page) ?>,
            "Track": <?= $Page->Track->toClientList($Page) ?>,
            "PaymentProgress": <?= $Page->PaymentProgress->toClientList($Page) ?>,
            "PaymentDate": <?= $Page->PaymentDate->toClientList($Page) ?>,
            "PaymentComplete": <?= $Page->PaymentComplete->toClientList($Page) ?>,
            "AgingPayment": <?= $Page->AgingPayment->toClientList($Page) ?>,
            "ClientID": <?= $Page->ClientID->toClientList($Page) ?>,
            "ManagerID": <?= $Page->ManagerID->toClientList($Page) ?>,
            "ProjectTemplateID": <?= $Page->ProjectTemplateID->toClientList($Page) ?>,
            "Priority": <?= $Page->Priority->toClientList($Page) ?>,
            "ProjectValue": <?= $Page->ProjectValue->toClientList($Page) ?>,
            "ProjectDebt": <?= $Page->ProjectDebt->toClientList($Page) ?>,
            "PONumber": <?= $Page->PONumber->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
            "Created_Date": <?= $Page->Created_Date->toClientList($Page) ?>,
            "Created_By": <?= $Page->Created_By->toClientList($Page) ?>,
            "Last_Updated_Date": <?= $Page->Last_Updated_Date->toClientList($Page) ?>,
            "Last_Updated_By": <?= $Page->Last_Updated_By->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->ProjectName->Visible) { // ProjectName ?>
<?php
if (!$Page->ProjectName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ProjectName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ProjectName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_ProjectName"
            name="x_ProjectName[]"
            class="form-control ew-select<?= $Page->ProjectName->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_ProjectName"
            data-table="masterproject"
            data-field="x_ProjectName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->ProjectName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->ProjectName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->ProjectName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->ProjectName->editAttributes() ?>>
            <?= $Page->ProjectName->selectOptionListHtml("x_ProjectName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->ProjectName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_ProjectName",
                selectId: "fmasterprojectsrch_x_ProjectName",
                ajax: { id: "x_ProjectName", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.ProjectName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->PlanStart->Visible) { // PlanStart ?>
<?php
if (!$Page->PlanStart->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_PlanStart" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->PlanStart->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_PlanStart"
            name="x_PlanStart[]"
            class="form-control ew-select<?= $Page->PlanStart->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_PlanStart"
            data-table="masterproject"
            data-field="x_PlanStart"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->PlanStart->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->PlanStart->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->PlanStart->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->PlanStart->editAttributes() ?>>
            <?= $Page->PlanStart->selectOptionListHtml("x_PlanStart", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->PlanStart->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_PlanStart",
                selectId: "fmasterprojectsrch_x_PlanStart",
                ajax: { id: "x_PlanStart", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.PlanStart.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->PlanEnd->Visible) { // PlanEnd ?>
<?php
if (!$Page->PlanEnd->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_PlanEnd" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->PlanEnd->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_PlanEnd"
            name="x_PlanEnd[]"
            class="form-control ew-select<?= $Page->PlanEnd->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_PlanEnd"
            data-table="masterproject"
            data-field="x_PlanEnd"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->PlanEnd->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->PlanEnd->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->PlanEnd->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->PlanEnd->editAttributes() ?>>
            <?= $Page->PlanEnd->selectOptionListHtml("x_PlanEnd", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->PlanEnd->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_PlanEnd",
                selectId: "fmasterprojectsrch_x_PlanEnd",
                ajax: { id: "x_PlanEnd", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.PlanEnd.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->StartDate->Visible) { // StartDate ?>
<?php
if (!$Page->StartDate->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_StartDate" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->StartDate->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_StartDate"
            name="x_StartDate[]"
            class="form-control ew-select<?= $Page->StartDate->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_StartDate"
            data-table="masterproject"
            data-field="x_StartDate"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->StartDate->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->StartDate->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->StartDate->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->StartDate->editAttributes() ?>>
            <?= $Page->StartDate->selectOptionListHtml("x_StartDate", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->StartDate->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_StartDate",
                selectId: "fmasterprojectsrch_x_StartDate",
                ajax: { id: "x_StartDate", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.StartDate.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->EndDate->Visible) { // EndDate ?>
<?php
if (!$Page->EndDate->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_EndDate" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->EndDate->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_EndDate"
            name="x_EndDate[]"
            class="form-control ew-select<?= $Page->EndDate->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_EndDate"
            data-table="masterproject"
            data-field="x_EndDate"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->EndDate->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->EndDate->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->EndDate->editAttributes() ?>>
            <?= $Page->EndDate->selectOptionListHtml("x_EndDate", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_EndDate",
                selectId: "fmasterprojectsrch_x_EndDate",
                ajax: { id: "x_EndDate", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.EndDate.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->WarrantyEnd->Visible) { // WarrantyEnd ?>
<?php
if (!$Page->WarrantyEnd->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_WarrantyEnd" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->WarrantyEnd->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_WarrantyEnd"
            name="x_WarrantyEnd[]"
            class="form-control ew-select<?= $Page->WarrantyEnd->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_WarrantyEnd"
            data-table="masterproject"
            data-field="x_WarrantyEnd"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->WarrantyEnd->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->WarrantyEnd->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->WarrantyEnd->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->WarrantyEnd->editAttributes() ?>>
            <?= $Page->WarrantyEnd->selectOptionListHtml("x_WarrantyEnd", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->WarrantyEnd->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_WarrantyEnd",
                selectId: "fmasterprojectsrch_x_WarrantyEnd",
                ajax: { id: "x_WarrantyEnd", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.WarrantyEnd.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Status->Visible) { // Status ?>
<?php
if (!$Page->Status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Status->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Status"
            name="x_Status[]"
            class="form-control ew-select<?= $Page->Status->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_Status"
            data-table="masterproject"
            data-field="x_Status"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Status->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Status->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Status->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Status->editAttributes() ?>>
            <?= $Page->Status->selectOptionListHtml("x_Status", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Status->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_Status",
                selectId: "fmasterprojectsrch_x_Status",
                ajax: { id: "x_Status", form: "fmasterprojectsrch", limit: 3, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.Status.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Progress->Visible) { // Progress ?>
<?php
if (!$Page->Progress->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Progress" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Progress->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Progress"
            name="x_Progress[]"
            class="form-control ew-select<?= $Page->Progress->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_Progress"
            data-table="masterproject"
            data-field="x_Progress"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Progress->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Progress->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Progress->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Progress->editAttributes() ?>>
            <?= $Page->Progress->selectOptionListHtml("x_Progress", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Progress->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_Progress",
                selectId: "fmasterprojectsrch_x_Progress",
                ajax: { id: "x_Progress", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.Progress.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Target->Visible) { // Target ?>
<?php
if (!$Page->Target->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Target" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Target->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Target"
            name="x_Target[]"
            class="form-control ew-select<?= $Page->Target->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_Target"
            data-table="masterproject"
            data-field="x_Target"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Target->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Target->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Target->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Target->editAttributes() ?>>
            <?= $Page->Target->selectOptionListHtml("x_Target", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Target->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_Target",
                selectId: "fmasterprojectsrch_x_Target",
                ajax: { id: "x_Target", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.Target.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Track->Visible) { // Track ?>
<?php
if (!$Page->Track->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Track" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Track->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Track"
            name="x_Track[]"
            class="form-control ew-select<?= $Page->Track->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_Track"
            data-table="masterproject"
            data-field="x_Track"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Track->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Track->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Track->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Track->editAttributes() ?>>
            <?= $Page->Track->selectOptionListHtml("x_Track", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Track->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_Track",
                selectId: "fmasterprojectsrch_x_Track",
                ajax: { id: "x_Track", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.Track.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->PaymentProgress->Visible) { // PaymentProgress ?>
<?php
if (!$Page->PaymentProgress->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_PaymentProgress" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->PaymentProgress->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_PaymentProgress"
            name="x_PaymentProgress[]"
            class="form-control ew-select<?= $Page->PaymentProgress->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_PaymentProgress"
            data-table="masterproject"
            data-field="x_PaymentProgress"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->PaymentProgress->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->PaymentProgress->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->PaymentProgress->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->PaymentProgress->editAttributes() ?>>
            <?= $Page->PaymentProgress->selectOptionListHtml("x_PaymentProgress", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->PaymentProgress->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_PaymentProgress",
                selectId: "fmasterprojectsrch_x_PaymentProgress",
                ajax: { id: "x_PaymentProgress", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.PaymentProgress.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->PaymentDate->Visible) { // PaymentDate ?>
<?php
if (!$Page->PaymentDate->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_PaymentDate" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->PaymentDate->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_PaymentDate"
            name="x_PaymentDate[]"
            class="form-control ew-select<?= $Page->PaymentDate->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_PaymentDate"
            data-table="masterproject"
            data-field="x_PaymentDate"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->PaymentDate->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->PaymentDate->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->PaymentDate->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->PaymentDate->editAttributes() ?>>
            <?= $Page->PaymentDate->selectOptionListHtml("x_PaymentDate", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->PaymentDate->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_PaymentDate",
                selectId: "fmasterprojectsrch_x_PaymentDate",
                ajax: { id: "x_PaymentDate", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.PaymentDate.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->PaymentComplete->Visible) { // PaymentComplete ?>
<?php
if (!$Page->PaymentComplete->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_PaymentComplete" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->PaymentComplete->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_PaymentComplete"
            name="x_PaymentComplete[]"
            class="form-control ew-select<?= $Page->PaymentComplete->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_PaymentComplete"
            data-table="masterproject"
            data-field="x_PaymentComplete"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->PaymentComplete->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->PaymentComplete->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->PaymentComplete->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->PaymentComplete->editAttributes() ?>>
            <?= $Page->PaymentComplete->selectOptionListHtml("x_PaymentComplete", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->PaymentComplete->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_PaymentComplete",
                selectId: "fmasterprojectsrch_x_PaymentComplete",
                ajax: { id: "x_PaymentComplete", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.PaymentComplete.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->AgingPayment->Visible) { // AgingPayment ?>
<?php
if (!$Page->AgingPayment->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_AgingPayment" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->AgingPayment->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_AgingPayment"
            name="x_AgingPayment[]"
            class="form-control ew-select<?= $Page->AgingPayment->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_AgingPayment"
            data-table="masterproject"
            data-field="x_AgingPayment"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->AgingPayment->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->AgingPayment->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->AgingPayment->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->AgingPayment->editAttributes() ?>>
            <?= $Page->AgingPayment->selectOptionListHtml("x_AgingPayment", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->AgingPayment->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_AgingPayment",
                selectId: "fmasterprojectsrch_x_AgingPayment",
                ajax: { id: "x_AgingPayment", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.AgingPayment.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ClientID->Visible) { // ClientID ?>
<?php
if (!$Page->ClientID->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ClientID" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ClientID->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_ClientID"
            name="x_ClientID[]"
            class="form-control ew-select<?= $Page->ClientID->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_ClientID"
            data-table="masterproject"
            data-field="x_ClientID"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->ClientID->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->ClientID->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->ClientID->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->ClientID->editAttributes() ?>>
            <?= $Page->ClientID->selectOptionListHtml("x_ClientID", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->ClientID->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_ClientID",
                selectId: "fmasterprojectsrch_x_ClientID",
                ajax: { id: "x_ClientID", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.ClientID.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ManagerID->Visible) { // ManagerID ?>
<?php
if (!$Page->ManagerID->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ManagerID" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ManagerID->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_ManagerID"
            name="x_ManagerID[]"
            class="form-control ew-select<?= $Page->ManagerID->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_ManagerID"
            data-table="masterproject"
            data-field="x_ManagerID"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->ManagerID->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->ManagerID->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->ManagerID->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->ManagerID->editAttributes() ?>>
            <?= $Page->ManagerID->selectOptionListHtml("x_ManagerID", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->ManagerID->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_ManagerID",
                selectId: "fmasterprojectsrch_x_ManagerID",
                ajax: { id: "x_ManagerID", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.ManagerID.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ProjectTemplateID->Visible) { // ProjectTemplateID ?>
<?php
if (!$Page->ProjectTemplateID->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ProjectTemplateID" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ProjectTemplateID->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_ProjectTemplateID"
            name="x_ProjectTemplateID[]"
            class="form-control ew-select<?= $Page->ProjectTemplateID->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_ProjectTemplateID"
            data-table="masterproject"
            data-field="x_ProjectTemplateID"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->ProjectTemplateID->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->ProjectTemplateID->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->ProjectTemplateID->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->ProjectTemplateID->editAttributes() ?>>
            <?= $Page->ProjectTemplateID->selectOptionListHtml("x_ProjectTemplateID", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->ProjectTemplateID->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_ProjectTemplateID",
                selectId: "fmasterprojectsrch_x_ProjectTemplateID",
                ajax: { id: "x_ProjectTemplateID", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.ProjectTemplateID.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Priority->Visible) { // Priority ?>
<?php
if (!$Page->Priority->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Priority" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Priority->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Priority"
            name="x_Priority[]"
            class="form-control ew-select<?= $Page->Priority->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_Priority"
            data-table="masterproject"
            data-field="x_Priority"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Priority->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Priority->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Priority->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Priority->editAttributes() ?>>
            <?= $Page->Priority->selectOptionListHtml("x_Priority", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Priority->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_Priority",
                selectId: "fmasterprojectsrch_x_Priority",
                ajax: { id: "x_Priority", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.Priority.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ProjectValue->Visible) { // ProjectValue ?>
<?php
if (!$Page->ProjectValue->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ProjectValue" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ProjectValue->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_ProjectValue"
            name="x_ProjectValue[]"
            class="form-control ew-select<?= $Page->ProjectValue->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_ProjectValue"
            data-table="masterproject"
            data-field="x_ProjectValue"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->ProjectValue->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->ProjectValue->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->ProjectValue->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->ProjectValue->editAttributes() ?>>
            <?= $Page->ProjectValue->selectOptionListHtml("x_ProjectValue", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->ProjectValue->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_ProjectValue",
                selectId: "fmasterprojectsrch_x_ProjectValue",
                ajax: { id: "x_ProjectValue", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.ProjectValue.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->ProjectDebt->Visible) { // ProjectDebt ?>
<?php
if (!$Page->ProjectDebt->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_ProjectDebt" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->ProjectDebt->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_ProjectDebt"
            name="x_ProjectDebt[]"
            class="form-control ew-select<?= $Page->ProjectDebt->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_ProjectDebt"
            data-table="masterproject"
            data-field="x_ProjectDebt"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->ProjectDebt->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->ProjectDebt->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->ProjectDebt->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->ProjectDebt->editAttributes() ?>>
            <?= $Page->ProjectDebt->selectOptionListHtml("x_ProjectDebt", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->ProjectDebt->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_ProjectDebt",
                selectId: "fmasterprojectsrch_x_ProjectDebt",
                ajax: { id: "x_ProjectDebt", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.ProjectDebt.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->PONumber->Visible) { // PONumber ?>
<?php
if (!$Page->PONumber->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_PONumber" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->PONumber->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_PONumber"
            name="x_PONumber[]"
            class="form-control ew-select<?= $Page->PONumber->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_PONumber"
            data-table="masterproject"
            data-field="x_PONumber"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->PONumber->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->PONumber->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->PONumber->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->PONumber->editAttributes() ?>>
            <?= $Page->PONumber->selectOptionListHtml("x_PONumber", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->PONumber->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_PONumber",
                selectId: "fmasterprojectsrch_x_PONumber",
                ajax: { id: "x_PONumber", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.PONumber.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Active->Visible) { // Active ?>
<?php
if (!$Page->Active->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Active" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Active->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Active"
            name="x_Active[]"
            class="form-control ew-select<?= $Page->Active->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_Active"
            data-table="masterproject"
            data-field="x_Active"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Active->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Active->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Active->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Active->editAttributes() ?>>
            <?= $Page->Active->selectOptionListHtml("x_Active", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Active->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_Active",
                selectId: "fmasterprojectsrch_x_Active",
                ajax: { id: "x_Active", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.Active.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
<?php
if (!$Page->Created_Date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Created_Date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Created_Date->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Created_Date"
            name="x_Created_Date[]"
            class="form-control ew-select<?= $Page->Created_Date->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_Created_Date"
            data-table="masterproject"
            data-field="x_Created_Date"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Created_Date->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Created_Date->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Created_Date->editAttributes() ?>>
            <?= $Page->Created_Date->selectOptionListHtml("x_Created_Date", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_Created_Date",
                selectId: "fmasterprojectsrch_x_Created_Date",
                ajax: { id: "x_Created_Date", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.Created_Date.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
<?php
if (!$Page->Created_By->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Created_By" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Created_By->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Created_By"
            name="x_Created_By[]"
            class="form-control ew-select<?= $Page->Created_By->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_Created_By"
            data-table="masterproject"
            data-field="x_Created_By"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Created_By->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Created_By->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Created_By->editAttributes() ?>>
            <?= $Page->Created_By->selectOptionListHtml("x_Created_By", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_Created_By",
                selectId: "fmasterprojectsrch_x_Created_By",
                ajax: { id: "x_Created_By", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.Created_By.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
<?php
if (!$Page->Last_Updated_Date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Last_Updated_Date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Last_Updated_Date->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Last_Updated_Date"
            name="x_Last_Updated_Date[]"
            class="form-control ew-select<?= $Page->Last_Updated_Date->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_Last_Updated_Date"
            data-table="masterproject"
            data-field="x_Last_Updated_Date"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Last_Updated_Date->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Last_Updated_Date->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Last_Updated_Date->editAttributes() ?>>
            <?= $Page->Last_Updated_Date->selectOptionListHtml("x_Last_Updated_Date", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_Last_Updated_Date",
                selectId: "fmasterprojectsrch_x_Last_Updated_Date",
                ajax: { id: "x_Last_Updated_Date", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.Last_Updated_Date.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
<?php
if (!$Page->Last_Updated_By->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Last_Updated_By" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Last_Updated_By->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Last_Updated_By"
            name="x_Last_Updated_By[]"
            class="form-control ew-select<?= $Page->Last_Updated_By->isInvalidClass() ?>"
            data-select2-id="fmasterprojectsrch_x_Last_Updated_By"
            data-table="masterproject"
            data-field="x_Last_Updated_By"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Last_Updated_By->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Last_Updated_By->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Last_Updated_By->editAttributes() ?>>
            <?= $Page->Last_Updated_By->selectOptionListHtml("x_Last_Updated_By", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterprojectsrch", function() {
            var options = {
                name: "x_Last_Updated_By",
                selectId: "fmasterprojectsrch_x_Last_Updated_By",
                ajax: { id: "x_Last_Updated_By", form: "fmasterprojectsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masterproject.fields.Last_Updated_By.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fmasterprojectsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fmasterprojectsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fmasterprojectsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fmasterprojectsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fmasterprojectsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fmasterprojectsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fmasterprojectsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="masterproject">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_masterproject" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_masterprojectlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->ProjectName->Visible) { // ProjectName ?>
        <th data-name="ProjectName" class="<?= $Page->ProjectName->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_ProjectName" class="masterproject_ProjectName"><?= $Page->renderFieldHeader($Page->ProjectName) ?></div></th>
<?php } ?>
<?php if ($Page->PlanStart->Visible) { // PlanStart ?>
        <th data-name="PlanStart" class="<?= $Page->PlanStart->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_PlanStart" class="masterproject_PlanStart"><?= $Page->renderFieldHeader($Page->PlanStart) ?></div></th>
<?php } ?>
<?php if ($Page->PlanEnd->Visible) { // PlanEnd ?>
        <th data-name="PlanEnd" class="<?= $Page->PlanEnd->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_PlanEnd" class="masterproject_PlanEnd"><?= $Page->renderFieldHeader($Page->PlanEnd) ?></div></th>
<?php } ?>
<?php if ($Page->StartDate->Visible) { // StartDate ?>
        <th data-name="StartDate" class="<?= $Page->StartDate->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_StartDate" class="masterproject_StartDate"><?= $Page->renderFieldHeader($Page->StartDate) ?></div></th>
<?php } ?>
<?php if ($Page->EndDate->Visible) { // EndDate ?>
        <th data-name="EndDate" class="<?= $Page->EndDate->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_EndDate" class="masterproject_EndDate"><?= $Page->renderFieldHeader($Page->EndDate) ?></div></th>
<?php } ?>
<?php if ($Page->WarrantyEnd->Visible) { // WarrantyEnd ?>
        <th data-name="WarrantyEnd" class="<?= $Page->WarrantyEnd->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_WarrantyEnd" class="masterproject_WarrantyEnd"><?= $Page->renderFieldHeader($Page->WarrantyEnd) ?></div></th>
<?php } ?>
<?php if ($Page->Status->Visible) { // Status ?>
        <th data-name="Status" class="<?= $Page->Status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_Status" class="masterproject_Status"><?= $Page->renderFieldHeader($Page->Status) ?></div></th>
<?php } ?>
<?php if ($Page->Progress->Visible) { // Progress ?>
        <th data-name="Progress" class="<?= $Page->Progress->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_Progress" class="masterproject_Progress"><?= $Page->renderFieldHeader($Page->Progress) ?></div></th>
<?php } ?>
<?php if ($Page->Target->Visible) { // Target ?>
        <th data-name="Target" class="<?= $Page->Target->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_Target" class="masterproject_Target"><?= $Page->renderFieldHeader($Page->Target) ?></div></th>
<?php } ?>
<?php if ($Page->Track->Visible) { // Track ?>
        <th data-name="Track" class="<?= $Page->Track->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_Track" class="masterproject_Track"><?= $Page->renderFieldHeader($Page->Track) ?></div></th>
<?php } ?>
<?php if ($Page->PaymentProgress->Visible) { // PaymentProgress ?>
        <th data-name="PaymentProgress" class="<?= $Page->PaymentProgress->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_PaymentProgress" class="masterproject_PaymentProgress"><?= $Page->renderFieldHeader($Page->PaymentProgress) ?></div></th>
<?php } ?>
<?php if ($Page->PaymentDate->Visible) { // PaymentDate ?>
        <th data-name="PaymentDate" class="<?= $Page->PaymentDate->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_PaymentDate" class="masterproject_PaymentDate"><?= $Page->renderFieldHeader($Page->PaymentDate) ?></div></th>
<?php } ?>
<?php if ($Page->PaymentComplete->Visible) { // PaymentComplete ?>
        <th data-name="PaymentComplete" class="<?= $Page->PaymentComplete->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_PaymentComplete" class="masterproject_PaymentComplete"><?= $Page->renderFieldHeader($Page->PaymentComplete) ?></div></th>
<?php } ?>
<?php if ($Page->AgingPayment->Visible) { // AgingPayment ?>
        <th data-name="AgingPayment" class="<?= $Page->AgingPayment->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_AgingPayment" class="masterproject_AgingPayment"><?= $Page->renderFieldHeader($Page->AgingPayment) ?></div></th>
<?php } ?>
<?php if ($Page->ClientID->Visible) { // ClientID ?>
        <th data-name="ClientID" class="<?= $Page->ClientID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_ClientID" class="masterproject_ClientID"><?= $Page->renderFieldHeader($Page->ClientID) ?></div></th>
<?php } ?>
<?php if ($Page->ManagerID->Visible) { // ManagerID ?>
        <th data-name="ManagerID" class="<?= $Page->ManagerID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_ManagerID" class="masterproject_ManagerID"><?= $Page->renderFieldHeader($Page->ManagerID) ?></div></th>
<?php } ?>
<?php if ($Page->ProjectTemplateID->Visible) { // ProjectTemplateID ?>
        <th data-name="ProjectTemplateID" class="<?= $Page->ProjectTemplateID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_ProjectTemplateID" class="masterproject_ProjectTemplateID"><?= $Page->renderFieldHeader($Page->ProjectTemplateID) ?></div></th>
<?php } ?>
<?php if ($Page->Priority->Visible) { // Priority ?>
        <th data-name="Priority" class="<?= $Page->Priority->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_Priority" class="masterproject_Priority"><?= $Page->renderFieldHeader($Page->Priority) ?></div></th>
<?php } ?>
<?php if ($Page->ProjectValue->Visible) { // ProjectValue ?>
        <th data-name="ProjectValue" class="<?= $Page->ProjectValue->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_ProjectValue" class="masterproject_ProjectValue"><?= $Page->renderFieldHeader($Page->ProjectValue) ?></div></th>
<?php } ?>
<?php if ($Page->ProjectDebt->Visible) { // ProjectDebt ?>
        <th data-name="ProjectDebt" class="<?= $Page->ProjectDebt->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_ProjectDebt" class="masterproject_ProjectDebt"><?= $Page->renderFieldHeader($Page->ProjectDebt) ?></div></th>
<?php } ?>
<?php if ($Page->PONumber->Visible) { // PONumber ?>
        <th data-name="PONumber" class="<?= $Page->PONumber->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_PONumber" class="masterproject_PONumber"><?= $Page->renderFieldHeader($Page->PONumber) ?></div></th>
<?php } ?>
<?php if ($Page->ClearingDate->Visible) { // ClearingDate ?>
        <th data-name="ClearingDate" class="<?= $Page->ClearingDate->headerCellClass() ?>"><div id="elh_masterproject_ClearingDate" class="masterproject_ClearingDate"><?= $Page->renderFieldHeader($Page->ClearingDate) ?></div></th>
<?php } ?>
<?php if ($Page->ClearingAging->Visible) { // ClearingAging ?>
        <th data-name="ClearingAging" class="<?= $Page->ClearingAging->headerCellClass() ?>"><div id="elh_masterproject_ClearingAging" class="masterproject_ClearingAging"><?= $Page->renderFieldHeader($Page->ClearingAging) ?></div></th>
<?php } ?>
<?php if ($Page->Active->Visible) { // Active ?>
        <th data-name="Active" class="<?= $Page->Active->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_Active" class="masterproject_Active"><?= $Page->renderFieldHeader($Page->Active) ?></div></th>
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Page->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_Created_Date" class="masterproject_Created_Date"><?= $Page->renderFieldHeader($Page->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Page->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_Created_By" class="masterproject_Created_By"><?= $Page->renderFieldHeader($Page->Created_By) ?></div></th>
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Page->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_Last_Updated_Date" class="masterproject_Last_Updated_Date"><?= $Page->renderFieldHeader($Page->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Page->Last_Updated_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masterproject_Last_Updated_By" class="masterproject_Last_Updated_By"><?= $Page->renderFieldHeader($Page->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->ProjectName->Visible) { // ProjectName ?>
        <td data-name="ProjectName"<?= $Page->ProjectName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_ProjectName" class="el_masterproject_ProjectName">
<span<?= $Page->ProjectName->viewAttributes() ?>>
<?= $Page->ProjectName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PlanStart->Visible) { // PlanStart ?>
        <td data-name="PlanStart"<?= $Page->PlanStart->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_PlanStart" class="el_masterproject_PlanStart">
<span<?= $Page->PlanStart->viewAttributes() ?>>
<?= $Page->PlanStart->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PlanEnd->Visible) { // PlanEnd ?>
        <td data-name="PlanEnd"<?= $Page->PlanEnd->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_PlanEnd" class="el_masterproject_PlanEnd">
<span<?= $Page->PlanEnd->viewAttributes() ?>>
<?= $Page->PlanEnd->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->StartDate->Visible) { // StartDate ?>
        <td data-name="StartDate"<?= $Page->StartDate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_StartDate" class="el_masterproject_StartDate">
<span<?= $Page->StartDate->viewAttributes() ?>>
<?= $Page->StartDate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->EndDate->Visible) { // EndDate ?>
        <td data-name="EndDate"<?= $Page->EndDate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_EndDate" class="el_masterproject_EndDate">
<span<?= $Page->EndDate->viewAttributes() ?>>
<?= $Page->EndDate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->WarrantyEnd->Visible) { // WarrantyEnd ?>
        <td data-name="WarrantyEnd"<?= $Page->WarrantyEnd->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_WarrantyEnd" class="el_masterproject_WarrantyEnd">
<span<?= $Page->WarrantyEnd->viewAttributes() ?>>
<?= $Page->WarrantyEnd->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Status->Visible) { // Status ?>
        <td data-name="Status"<?= $Page->Status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_Status" class="el_masterproject_Status">
<span<?= $Page->Status->viewAttributes() ?>>
<?= $Page->Status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Progress->Visible) { // Progress ?>
        <td data-name="Progress"<?= $Page->Progress->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_Progress" class="el_masterproject_Progress">
<span<?= $Page->Progress->viewAttributes() ?>>
<?= $Page->Progress->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Target->Visible) { // Target ?>
        <td data-name="Target"<?= $Page->Target->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_Target" class="el_masterproject_Target">
<span<?= $Page->Target->viewAttributes() ?>>
<?= $Page->Target->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Track->Visible) { // Track ?>
        <td data-name="Track"<?= $Page->Track->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_Track" class="el_masterproject_Track">
<span<?= $Page->Track->viewAttributes() ?>>
<?= $Page->Track->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PaymentProgress->Visible) { // PaymentProgress ?>
        <td data-name="PaymentProgress"<?= $Page->PaymentProgress->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_PaymentProgress" class="el_masterproject_PaymentProgress">
<span<?= $Page->PaymentProgress->viewAttributes() ?>>
<?= $Page->PaymentProgress->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PaymentDate->Visible) { // PaymentDate ?>
        <td data-name="PaymentDate"<?= $Page->PaymentDate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_PaymentDate" class="el_masterproject_PaymentDate">
<span<?= $Page->PaymentDate->viewAttributes() ?>>
<?= $Page->PaymentDate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PaymentComplete->Visible) { // PaymentComplete ?>
        <td data-name="PaymentComplete"<?= $Page->PaymentComplete->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_PaymentComplete" class="el_masterproject_PaymentComplete">
<span<?= $Page->PaymentComplete->viewAttributes() ?>>
<?= $Page->PaymentComplete->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->AgingPayment->Visible) { // AgingPayment ?>
        <td data-name="AgingPayment"<?= $Page->AgingPayment->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_AgingPayment" class="el_masterproject_AgingPayment">
<span<?= $Page->AgingPayment->viewAttributes() ?>>
<?= $Page->AgingPayment->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ClientID->Visible) { // ClientID ?>
        <td data-name="ClientID"<?= $Page->ClientID->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_ClientID" class="el_masterproject_ClientID">
<span<?= $Page->ClientID->viewAttributes() ?>>
<?= $Page->ClientID->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ManagerID->Visible) { // ManagerID ?>
        <td data-name="ManagerID"<?= $Page->ManagerID->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_ManagerID" class="el_masterproject_ManagerID">
<span<?= $Page->ManagerID->viewAttributes() ?>>
<?= $Page->ManagerID->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ProjectTemplateID->Visible) { // ProjectTemplateID ?>
        <td data-name="ProjectTemplateID"<?= $Page->ProjectTemplateID->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_ProjectTemplateID" class="el_masterproject_ProjectTemplateID">
<span<?= $Page->ProjectTemplateID->viewAttributes() ?>>
<?= $Page->ProjectTemplateID->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Priority->Visible) { // Priority ?>
        <td data-name="Priority"<?= $Page->Priority->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_Priority" class="el_masterproject_Priority">
<span<?= $Page->Priority->viewAttributes() ?>>
<?= $Page->Priority->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ProjectValue->Visible) { // ProjectValue ?>
        <td data-name="ProjectValue"<?= $Page->ProjectValue->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_ProjectValue" class="el_masterproject_ProjectValue">
<span<?= $Page->ProjectValue->viewAttributes() ?>>
<?= $Page->ProjectValue->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ProjectDebt->Visible) { // ProjectDebt ?>
        <td data-name="ProjectDebt"<?= $Page->ProjectDebt->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_ProjectDebt" class="el_masterproject_ProjectDebt">
<span<?= $Page->ProjectDebt->viewAttributes() ?>>
<?= $Page->ProjectDebt->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PONumber->Visible) { // PONumber ?>
        <td data-name="PONumber"<?= $Page->PONumber->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_PONumber" class="el_masterproject_PONumber">
<span<?= $Page->PONumber->viewAttributes() ?>>
<?= $Page->PONumber->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ClearingDate->Visible) { // ClearingDate ?>
        <td data-name="ClearingDate"<?= $Page->ClearingDate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_ClearingDate" class="el_masterproject_ClearingDate">
<span<?= $Page->ClearingDate->viewAttributes() ?>>
<?= $Page->ClearingDate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ClearingAging->Visible) { // ClearingAging ?>
        <td data-name="ClearingAging"<?= $Page->ClearingAging->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_ClearingAging" class="el_masterproject_ClearingAging">
<span<?= $Page->ClearingAging->viewAttributes() ?>>
<?= $Page->ClearingAging->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Active->Visible) { // Active ?>
        <td data-name="Active"<?= $Page->Active->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_Active" class="el_masterproject_Active">
<span<?= $Page->Active->viewAttributes() ?>>
<i class="fa-regular fa-square<?php if (ConvertToBool($Page->Active->CurrentValue)) { ?>-check<?php } ?> ew-icon ew-boolean"></i>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Page->Created_Date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_Created_Date" class="el_masterproject_Created_Date">
<span<?= $Page->Created_Date->viewAttributes() ?>>
<?= $Page->Created_Date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Page->Created_By->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_Created_By" class="el_masterproject_Created_By">
<span<?= $Page->Created_By->viewAttributes() ?>>
<?= $Page->Created_By->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Page->Last_Updated_Date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_Last_Updated_Date" class="el_masterproject_Last_Updated_Date">
<span<?= $Page->Last_Updated_Date->viewAttributes() ?>>
<?= $Page->Last_Updated_Date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Page->Last_Updated_By->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masterproject_Last_Updated_By" class="el_masterproject_Last_Updated_By">
<span<?= $Page->Last_Updated_By->viewAttributes() ?>>
<?= $Page->Last_Updated_By->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->ProjectName->Visible) { // ProjectName ?>
        <td data-name="ProjectName" class="<?= $Page->ProjectName->footerCellClass() ?>"><span id="elf_masterproject_ProjectName" class="masterproject_ProjectName">
        </span></td>
    <?php } ?>
    <?php if ($Page->PlanStart->Visible) { // PlanStart ?>
        <td data-name="PlanStart" class="<?= $Page->PlanStart->footerCellClass() ?>"><span id="elf_masterproject_PlanStart" class="masterproject_PlanStart">
        </span></td>
    <?php } ?>
    <?php if ($Page->PlanEnd->Visible) { // PlanEnd ?>
        <td data-name="PlanEnd" class="<?= $Page->PlanEnd->footerCellClass() ?>"><span id="elf_masterproject_PlanEnd" class="masterproject_PlanEnd">
        </span></td>
    <?php } ?>
    <?php if ($Page->StartDate->Visible) { // StartDate ?>
        <td data-name="StartDate" class="<?= $Page->StartDate->footerCellClass() ?>"><span id="elf_masterproject_StartDate" class="masterproject_StartDate">
        </span></td>
    <?php } ?>
    <?php if ($Page->EndDate->Visible) { // EndDate ?>
        <td data-name="EndDate" class="<?= $Page->EndDate->footerCellClass() ?>"><span id="elf_masterproject_EndDate" class="masterproject_EndDate">
        </span></td>
    <?php } ?>
    <?php if ($Page->WarrantyEnd->Visible) { // WarrantyEnd ?>
        <td data-name="WarrantyEnd" class="<?= $Page->WarrantyEnd->footerCellClass() ?>"><span id="elf_masterproject_WarrantyEnd" class="masterproject_WarrantyEnd">
        </span></td>
    <?php } ?>
    <?php if ($Page->Status->Visible) { // Status ?>
        <td data-name="Status" class="<?= $Page->Status->footerCellClass() ?>"><span id="elf_masterproject_Status" class="masterproject_Status">
        </span></td>
    <?php } ?>
    <?php if ($Page->Progress->Visible) { // Progress ?>
        <td data-name="Progress" class="<?= $Page->Progress->footerCellClass() ?>"><span id="elf_masterproject_Progress" class="masterproject_Progress">
        </span></td>
    <?php } ?>
    <?php if ($Page->Target->Visible) { // Target ?>
        <td data-name="Target" class="<?= $Page->Target->footerCellClass() ?>"><span id="elf_masterproject_Target" class="masterproject_Target">
        </span></td>
    <?php } ?>
    <?php if ($Page->Track->Visible) { // Track ?>
        <td data-name="Track" class="<?= $Page->Track->footerCellClass() ?>"><span id="elf_masterproject_Track" class="masterproject_Track">
        </span></td>
    <?php } ?>
    <?php if ($Page->PaymentProgress->Visible) { // PaymentProgress ?>
        <td data-name="PaymentProgress" class="<?= $Page->PaymentProgress->footerCellClass() ?>"><span id="elf_masterproject_PaymentProgress" class="masterproject_PaymentProgress">
        </span></td>
    <?php } ?>
    <?php if ($Page->PaymentDate->Visible) { // PaymentDate ?>
        <td data-name="PaymentDate" class="<?= $Page->PaymentDate->footerCellClass() ?>"><span id="elf_masterproject_PaymentDate" class="masterproject_PaymentDate">
        </span></td>
    <?php } ?>
    <?php if ($Page->PaymentComplete->Visible) { // PaymentComplete ?>
        <td data-name="PaymentComplete" class="<?= $Page->PaymentComplete->footerCellClass() ?>"><span id="elf_masterproject_PaymentComplete" class="masterproject_PaymentComplete">
        </span></td>
    <?php } ?>
    <?php if ($Page->AgingPayment->Visible) { // AgingPayment ?>
        <td data-name="AgingPayment" class="<?= $Page->AgingPayment->footerCellClass() ?>"><span id="elf_masterproject_AgingPayment" class="masterproject_AgingPayment">
        </span></td>
    <?php } ?>
    <?php if ($Page->ClientID->Visible) { // ClientID ?>
        <td data-name="ClientID" class="<?= $Page->ClientID->footerCellClass() ?>"><span id="elf_masterproject_ClientID" class="masterproject_ClientID">
        </span></td>
    <?php } ?>
    <?php if ($Page->ManagerID->Visible) { // ManagerID ?>
        <td data-name="ManagerID" class="<?= $Page->ManagerID->footerCellClass() ?>"><span id="elf_masterproject_ManagerID" class="masterproject_ManagerID">
        </span></td>
    <?php } ?>
    <?php if ($Page->ProjectTemplateID->Visible) { // ProjectTemplateID ?>
        <td data-name="ProjectTemplateID" class="<?= $Page->ProjectTemplateID->footerCellClass() ?>"><span id="elf_masterproject_ProjectTemplateID" class="masterproject_ProjectTemplateID">
        </span></td>
    <?php } ?>
    <?php if ($Page->Priority->Visible) { // Priority ?>
        <td data-name="Priority" class="<?= $Page->Priority->footerCellClass() ?>"><span id="elf_masterproject_Priority" class="masterproject_Priority">
        </span></td>
    <?php } ?>
    <?php if ($Page->ProjectValue->Visible) { // ProjectValue ?>
        <td data-name="ProjectValue" class="<?= $Page->ProjectValue->footerCellClass() ?>"><span id="elf_masterproject_ProjectValue" class="masterproject_ProjectValue">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->ProjectValue->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->ProjectDebt->Visible) { // ProjectDebt ?>
        <td data-name="ProjectDebt" class="<?= $Page->ProjectDebt->footerCellClass() ?>"><span id="elf_masterproject_ProjectDebt" class="masterproject_ProjectDebt">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->ProjectDebt->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->PONumber->Visible) { // PONumber ?>
        <td data-name="PONumber" class="<?= $Page->PONumber->footerCellClass() ?>"><span id="elf_masterproject_PONumber" class="masterproject_PONumber">
        </span></td>
    <?php } ?>
    <?php if ($Page->ClearingDate->Visible) { // ClearingDate ?>
        <td data-name="ClearingDate" class="<?= $Page->ClearingDate->footerCellClass() ?>"><span id="elf_masterproject_ClearingDate" class="masterproject_ClearingDate">
        </span></td>
    <?php } ?>
    <?php if ($Page->ClearingAging->Visible) { // ClearingAging ?>
        <td data-name="ClearingAging" class="<?= $Page->ClearingAging->footerCellClass() ?>"><span id="elf_masterproject_ClearingAging" class="masterproject_ClearingAging">
        </span></td>
    <?php } ?>
    <?php if ($Page->Active->Visible) { // Active ?>
        <td data-name="Active" class="<?= $Page->Active->footerCellClass() ?>"><span id="elf_masterproject_Active" class="masterproject_Active">
        </span></td>
    <?php } ?>
    <?php if ($Page->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date" class="<?= $Page->Created_Date->footerCellClass() ?>"><span id="elf_masterproject_Created_Date" class="masterproject_Created_Date">
        </span></td>
    <?php } ?>
    <?php if ($Page->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By" class="<?= $Page->Created_By->footerCellClass() ?>"><span id="elf_masterproject_Created_By" class="masterproject_Created_By">
        </span></td>
    <?php } ?>
    <?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date" class="<?= $Page->Last_Updated_Date->footerCellClass() ?>"><span id="elf_masterproject_Last_Updated_Date" class="masterproject_Last_Updated_Date">
        </span></td>
    <?php } ?>
    <?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By" class="<?= $Page->Last_Updated_By->footerCellClass() ?>"><span id="elf_masterproject_Last_Updated_By" class="masterproject_Last_Updated_By">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masterproject");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
