<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$MasterprojectSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masterproject: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmasterprojectsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmasterprojectsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["_ProjectID", [ew.Validators.integer], fields._ProjectID.isInvalid],
            ["ProjectName", [], fields.ProjectName.isInvalid],
            ["PlanStart", [ew.Validators.datetime(fields.PlanStart.clientFormatPattern)], fields.PlanStart.isInvalid],
            ["y_PlanStart", [ew.Validators.between], false],
            ["PlanEnd", [ew.Validators.datetime(fields.PlanEnd.clientFormatPattern)], fields.PlanEnd.isInvalid],
            ["y_PlanEnd", [ew.Validators.between], false],
            ["StartDate", [ew.Validators.datetime(fields.StartDate.clientFormatPattern)], fields.StartDate.isInvalid],
            ["y_StartDate", [ew.Validators.between], false],
            ["EndDate", [ew.Validators.datetime(fields.EndDate.clientFormatPattern)], fields.EndDate.isInvalid],
            ["y_EndDate", [ew.Validators.between], false],
            ["WarrantyEnd", [ew.Validators.datetime(fields.WarrantyEnd.clientFormatPattern)], fields.WarrantyEnd.isInvalid],
            ["y_WarrantyEnd", [ew.Validators.between], false],
            ["Status", [], fields.Status.isInvalid],
            ["Progress", [ew.Validators.float], fields.Progress.isInvalid],
            ["y_Progress", [ew.Validators.between], false],
            ["Target", [ew.Validators.float], fields.Target.isInvalid],
            ["Track", [], fields.Track.isInvalid],
            ["PaymentProgress", [ew.Validators.float], fields.PaymentProgress.isInvalid],
            ["y_PaymentProgress", [ew.Validators.between], false],
            ["PaymentDate", [ew.Validators.datetime(fields.PaymentDate.clientFormatPattern)], fields.PaymentDate.isInvalid],
            ["y_PaymentDate", [ew.Validators.between], false],
            ["PaymentComplete", [], fields.PaymentComplete.isInvalid],
            ["AgingPayment", [ew.Validators.integer], fields.AgingPayment.isInvalid],
            ["ClientID", [], fields.ClientID.isInvalid],
            ["ManagerID", [], fields.ManagerID.isInvalid],
            ["ProjectTemplateID", [], fields.ProjectTemplateID.isInvalid],
            ["Priority", [], fields.Priority.isInvalid],
            ["ProjectValue", [ew.Validators.float], fields.ProjectValue.isInvalid],
            ["y_ProjectValue", [ew.Validators.between], false],
            ["ProjectDebt", [ew.Validators.float], fields.ProjectDebt.isInvalid],
            ["y_ProjectDebt", [ew.Validators.between], false],
            ["PONumber", [], fields.PONumber.isInvalid],
            ["PaymentLink", [], fields.PaymentLink.isInvalid],
            ["ClearingDate", [ew.Validators.datetime(fields.ClearingDate.clientFormatPattern)], fields.ClearingDate.isInvalid],
            ["ClearingAging", [ew.Validators.integer], fields.ClearingAging.isInvalid],
            ["Active", [], fields.Active.isInvalid],
            ["Created_Date", [], fields.Created_Date.isInvalid],
            ["y_Created_Date", [ew.Validators.between], false],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [], fields.Last_Updated_Date.isInvalid],
            ["y_Last_Updated_Date", [ew.Validators.between], false],
            ["Last_Updated_By", [], fields.Last_Updated_By.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "Status": <?= $Page->Status->toClientList($Page) ?>,
            "ClientID": <?= $Page->ClientID->toClientList($Page) ?>,
            "ManagerID": <?= $Page->ManagerID->toClientList($Page) ?>,
            "ProjectTemplateID": <?= $Page->ProjectTemplateID->toClientList($Page) ?>,
            "Priority": <?= $Page->Priority->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmasterprojectsearch" id="fmasterprojectsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("masterprojectlist")) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="masterproject">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_masterproject__ProjectID" class="masterprojectsearch"><span id="el_masterproject__ProjectID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_ProjectID->getInputTextType() ?>" name="x__ProjectID" id="x__ProjectID" data-table="masterproject" data-field="x__ProjectID" value="<?= $Page->_ProjectID->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->_ProjectID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_ProjectID->formatPattern()) ?>"<?= $Page->_ProjectID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_ProjectID->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_ProjectName" class="masterprojectsearch"><span id="el_masterproject_ProjectName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ProjectName->getInputTextType() ?>" name="x_ProjectName" id="x_ProjectName" data-table="masterproject" data-field="x_ProjectName" value="<?= $Page->ProjectName->EditValue ?>" data-page="1" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->ProjectName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectName->formatPattern()) ?>"<?= $Page->ProjectName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectName->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_PlanStart" class="masterprojectsearch"><span id="el_masterproject_PlanStart" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PlanStart->getInputTextType() ?>" name="x_PlanStart" id="x_PlanStart" data-table="masterproject" data-field="x_PlanStart" value="<?= $Page->PlanStart->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->PlanStart->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanStart->formatPattern()) ?>"<?= $Page->PlanStart->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanStart->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanStart->ReadOnly && !$Page->PlanStart->Disabled && !isset($Page->PlanStart->EditAttrs["readonly"]) && !isset($Page->PlanStart->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_PlanStart", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_PlanEnd" class="masterprojectsearch"><span id="el_masterproject_PlanEnd" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PlanEnd->getInputTextType() ?>" name="x_PlanEnd" id="x_PlanEnd" data-table="masterproject" data-field="x_PlanEnd" value="<?= $Page->PlanEnd->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->PlanEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanEnd->formatPattern()) ?>"<?= $Page->PlanEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanEnd->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanEnd->ReadOnly && !$Page->PlanEnd->Disabled && !isset($Page->PlanEnd->EditAttrs["readonly"]) && !isset($Page->PlanEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_PlanEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_StartDate" class="masterprojectsearch"><span id="el_masterproject_StartDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->StartDate->getInputTextType() ?>" name="x_StartDate" id="x_StartDate" data-table="masterproject" data-field="x_StartDate" value="<?= $Page->StartDate->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->StartDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->StartDate->formatPattern()) ?>"<?= $Page->StartDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->StartDate->getErrorMessage(false) ?></div>
<?php if (!$Page->StartDate->ReadOnly && !$Page->StartDate->Disabled && !isset($Page->StartDate->EditAttrs["readonly"]) && !isset($Page->StartDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_StartDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_EndDate" class="masterprojectsearch"><span id="el_masterproject_EndDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->EndDate->getInputTextType() ?>" name="x_EndDate" id="x_EndDate" data-table="masterproject" data-field="x_EndDate" value="<?= $Page->EndDate->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EndDate->formatPattern()) ?>"<?= $Page->EndDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage(false) ?></div>
<?php if (!$Page->EndDate->ReadOnly && !$Page->EndDate->Disabled && !isset($Page->EndDate->EditAttrs["readonly"]) && !isset($Page->EndDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_WarrantyEnd" class="masterprojectsearch"><span id="el_masterproject_WarrantyEnd" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->WarrantyEnd->getInputTextType() ?>" name="x_WarrantyEnd" id="x_WarrantyEnd" data-table="masterproject" data-field="x_WarrantyEnd" value="<?= $Page->WarrantyEnd->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->WarrantyEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WarrantyEnd->formatPattern()) ?>"<?= $Page->WarrantyEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->WarrantyEnd->getErrorMessage(false) ?></div>
<?php if (!$Page->WarrantyEnd->ReadOnly && !$Page->WarrantyEnd->Disabled && !isset($Page->WarrantyEnd->EditAttrs["readonly"]) && !isset($Page->WarrantyEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_WarrantyEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_Status" class="masterprojectsearch"><span id="el_masterproject_Status" class="ew-search-field ew-search-field-single">
    <select
        id="x_Status"
        name="x_Status"
        class="form-select ew-select<?= $Page->Status->isInvalidClass() ?>"
        <?php if (!$Page->Status->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_x_Status"
        <?php } ?>
        data-table="masterproject"
        data-field="x_Status"
        data-page="1"
        data-value-separator="<?= $Page->Status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Status->getPlaceHolder()) ?>"
        <?= $Page->Status->editAttributes() ?>>
        <?= $Page->Status->selectOptionListHtml("x_Status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Status->getErrorMessage(false) ?></div>
<?= $Page->Status->Lookup->getParamTag($Page, "p_x_Status") ?>
<?php if (!$Page->Status->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "x_Status", selectId: "fmasterprojectsearch_x_Status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.Status?.lookupOptions.length) {
        options.data = { id: "x_Status", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "x_Status", form: "fmasterprojectsearch", limit: 3 };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.Status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_Progress" class="masterprojectsearch"><span id="el_masterproject_Progress" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Progress->getInputTextType() ?>" name="x_Progress" id="x_Progress" data-table="masterproject" data-field="x_Progress" value="<?= $Page->Progress->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Progress->formatPattern()) ?>"<?= $Page->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Progress->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_Target" class="masterprojectsearch"><span id="el_masterproject_Target" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Target->getInputTextType() ?>" name="x_Target" id="x_Target" data-table="masterproject" data-field="x_Target" value="<?= $Page->Target->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->Target->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Target->formatPattern()) ?>"<?= $Page->Target->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Target->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_Track" class="masterprojectsearch"><span id="el_masterproject_Track" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Track->getInputTextType() ?>" name="x_Track" id="x_Track" data-table="masterproject" data-field="x_Track" value="<?= $Page->Track->EditValue ?>" data-page="1" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->Track->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Track->formatPattern()) ?>"<?= $Page->Track->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Track->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_PaymentProgress" class="masterprojectsearch"><span id="el_masterproject_PaymentProgress" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PaymentProgress->getInputTextType() ?>" name="x_PaymentProgress" id="x_PaymentProgress" data-table="masterproject" data-field="x_PaymentProgress" value="<?= $Page->PaymentProgress->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->PaymentProgress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PaymentProgress->formatPattern()) ?>"<?= $Page->PaymentProgress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PaymentProgress->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_PaymentDate" class="masterprojectsearch"><span id="el_masterproject_PaymentDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PaymentDate->getInputTextType() ?>" name="x_PaymentDate" id="x_PaymentDate" data-table="masterproject" data-field="x_PaymentDate" value="<?= $Page->PaymentDate->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->PaymentDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PaymentDate->formatPattern()) ?>"<?= $Page->PaymentDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PaymentDate->getErrorMessage(false) ?></div>
<?php if (!$Page->PaymentDate->ReadOnly && !$Page->PaymentDate->Disabled && !isset($Page->PaymentDate->EditAttrs["readonly"]) && !isset($Page->PaymentDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_PaymentDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_PaymentComplete" class="masterprojectsearch"><span id="el_masterproject_PaymentComplete" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PaymentComplete->getInputTextType() ?>" name="x_PaymentComplete" id="x_PaymentComplete" data-table="masterproject" data-field="x_PaymentComplete" value="<?= $Page->PaymentComplete->EditValue ?>" data-page="3" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->PaymentComplete->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PaymentComplete->formatPattern()) ?>"<?= $Page->PaymentComplete->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PaymentComplete->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_AgingPayment" class="masterprojectsearch"><span id="el_masterproject_AgingPayment" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->AgingPayment->getInputTextType() ?>" name="x_AgingPayment" id="x_AgingPayment" data-table="masterproject" data-field="x_AgingPayment" value="<?= $Page->AgingPayment->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->AgingPayment->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AgingPayment->formatPattern()) ?>"<?= $Page->AgingPayment->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AgingPayment->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_ClientID" class="masterprojectsearch"><span id="el_masterproject_ClientID" class="ew-search-field ew-search-field-single">
    <select
        id="x_ClientID"
        name="x_ClientID"
        class="form-select ew-select<?= $Page->ClientID->isInvalidClass() ?>"
        <?php if (!$Page->ClientID->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_x_ClientID"
        <?php } ?>
        data-table="masterproject"
        data-field="x_ClientID"
        data-page="1"
        data-value-separator="<?= $Page->ClientID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ClientID->getPlaceHolder()) ?>"
        <?= $Page->ClientID->editAttributes() ?>>
        <?= $Page->ClientID->selectOptionListHtml("x_ClientID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ClientID->getErrorMessage(false) ?></div>
<?= $Page->ClientID->Lookup->getParamTag($Page, "p_x_ClientID") ?>
<?php if (!$Page->ClientID->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "x_ClientID", selectId: "fmasterprojectsearch_x_ClientID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.ClientID?.lookupOptions.length) {
        options.data = { id: "x_ClientID", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "x_ClientID", form: "fmasterprojectsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ClientID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_ManagerID" class="masterprojectsearch"><span id="el_masterproject_ManagerID" class="ew-search-field ew-search-field-single">
    <select
        id="x_ManagerID"
        name="x_ManagerID"
        class="form-select ew-select<?= $Page->ManagerID->isInvalidClass() ?>"
        <?php if (!$Page->ManagerID->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_x_ManagerID"
        <?php } ?>
        data-table="masterproject"
        data-field="x_ManagerID"
        data-page="1"
        data-value-separator="<?= $Page->ManagerID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ManagerID->getPlaceHolder()) ?>"
        <?= $Page->ManagerID->editAttributes() ?>>
        <?= $Page->ManagerID->selectOptionListHtml("x_ManagerID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ManagerID->getErrorMessage(false) ?></div>
<?= $Page->ManagerID->Lookup->getParamTag($Page, "p_x_ManagerID") ?>
<?php if (!$Page->ManagerID->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "x_ManagerID", selectId: "fmasterprojectsearch_x_ManagerID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.ManagerID?.lookupOptions.length) {
        options.data = { id: "x_ManagerID", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "x_ManagerID", form: "fmasterprojectsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ManagerID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_ProjectTemplateID" class="masterprojectsearch"><span id="el_masterproject_ProjectTemplateID" class="ew-search-field ew-search-field-single">
    <select
        id="x_ProjectTemplateID"
        name="x_ProjectTemplateID"
        class="form-select ew-select<?= $Page->ProjectTemplateID->isInvalidClass() ?>"
        <?php if (!$Page->ProjectTemplateID->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_x_ProjectTemplateID"
        <?php } ?>
        data-table="masterproject"
        data-field="x_ProjectTemplateID"
        data-page="1"
        data-value-separator="<?= $Page->ProjectTemplateID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProjectTemplateID->getPlaceHolder()) ?>"
        <?= $Page->ProjectTemplateID->editAttributes() ?>>
        <?= $Page->ProjectTemplateID->selectOptionListHtml("x_ProjectTemplateID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProjectTemplateID->getErrorMessage(false) ?></div>
<?= $Page->ProjectTemplateID->Lookup->getParamTag($Page, "p_x_ProjectTemplateID") ?>
<?php if (!$Page->ProjectTemplateID->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "x_ProjectTemplateID", selectId: "fmasterprojectsearch_x_ProjectTemplateID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.ProjectTemplateID?.lookupOptions.length) {
        options.data = { id: "x_ProjectTemplateID", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "x_ProjectTemplateID", form: "fmasterprojectsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ProjectTemplateID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_Priority" class="masterprojectsearch"><span id="el_masterproject_Priority" class="ew-search-field ew-search-field-single">
    <select
        id="x_Priority"
        name="x_Priority"
        class="form-select ew-select<?= $Page->Priority->isInvalidClass() ?>"
        <?php if (!$Page->Priority->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_x_Priority"
        <?php } ?>
        data-table="masterproject"
        data-field="x_Priority"
        data-page="1"
        data-value-separator="<?= $Page->Priority->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Priority->getPlaceHolder()) ?>"
        <?= $Page->Priority->editAttributes() ?>>
        <?= $Page->Priority->selectOptionListHtml("x_Priority") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Priority->getErrorMessage(false) ?></div>
<?php if (!$Page->Priority->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "x_Priority", selectId: "fmasterprojectsearch_x_Priority" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.Priority?.lookupOptions.length) {
        options.data = { id: "x_Priority", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "x_Priority", form: "fmasterprojectsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.Priority.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_ProjectValue" class="masterprojectsearch"><span id="el_masterproject_ProjectValue" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ProjectValue->getInputTextType() ?>" name="x_ProjectValue" id="x_ProjectValue" data-table="masterproject" data-field="x_ProjectValue" value="<?= $Page->ProjectValue->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->ProjectValue->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectValue->formatPattern()) ?>"<?= $Page->ProjectValue->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectValue->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_ProjectDebt" class="masterprojectsearch"><span id="el_masterproject_ProjectDebt" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ProjectDebt->getInputTextType() ?>" name="x_ProjectDebt" id="x_ProjectDebt" data-table="masterproject" data-field="x_ProjectDebt" value="<?= $Page->ProjectDebt->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->ProjectDebt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectDebt->formatPattern()) ?>"<?= $Page->ProjectDebt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectDebt->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_PONumber" class="masterprojectsearch"><span id="el_masterproject_PONumber" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PONumber->getInputTextType() ?>" name="x_PONumber" id="x_PONumber" data-table="masterproject" data-field="x_PONumber" value="<?= $Page->PONumber->EditValue ?>" data-page="3" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->PONumber->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PONumber->formatPattern()) ?>"<?= $Page->PONumber->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PONumber->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_PaymentLink" class="masterprojectsearch"><span id="el_masterproject_PaymentLink" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PaymentLink->getInputTextType() ?>" name="x_PaymentLink" id="x_PaymentLink" data-table="masterproject" data-field="x_PaymentLink" value="<?= $Page->PaymentLink->EditValue ?>" data-page="3" maxlength="65535" placeholder="<?= HtmlEncode($Page->PaymentLink->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PaymentLink->formatPattern()) ?>"<?= $Page->PaymentLink->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PaymentLink->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_ClearingDate" class="masterprojectsearch"><span id="el_masterproject_ClearingDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ClearingDate->getInputTextType() ?>" name="x_ClearingDate" id="x_ClearingDate" data-table="masterproject" data-field="x_ClearingDate" value="<?= $Page->ClearingDate->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->ClearingDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ClearingDate->formatPattern()) ?>"<?= $Page->ClearingDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ClearingDate->getErrorMessage(false) ?></div>
<?php if (!$Page->ClearingDate->ReadOnly && !$Page->ClearingDate->Disabled && !isset($Page->ClearingDate->EditAttrs["readonly"]) && !isset($Page->ClearingDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_ClearingDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_ClearingAging" class="masterprojectsearch"><span id="el_masterproject_ClearingAging" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ClearingAging->getInputTextType() ?>" name="x_ClearingAging" id="x_ClearingAging" data-table="masterproject" data-field="x_ClearingAging" value="<?= $Page->ClearingAging->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->ClearingAging->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ClearingAging->formatPattern()) ?>"<?= $Page->ClearingAging->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ClearingAging->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_Active" class="masterprojectsearch"><span id="el_masterproject_Active" class="ew-search-field ew-search-field-single">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->Active->isInvalidClass() ?>" data-table="masterproject" data-field="x_Active" data-boolean data-page="1" name="x_Active" id="x_Active" value="1"<?= ConvertToBool($Page->Active->AdvancedSearch->SearchValue) ? " checked" : "" ?><?= $Page->Active->editAttributes() ?>>
    <div class="invalid-feedback"><?= $Page->Active->getErrorMessage(false) ?></div>
</div>
</span></template>
<template id="tpx_masterproject_Created_Date" class="masterprojectsearch"><span id="el_masterproject_Created_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="x_Created_Date" id="x_Created_Date" data-table="masterproject" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue ?>" data-page="4" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(9) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_Created_By" class="masterprojectsearch"><span id="el_masterproject_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="masterproject" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" data-page="4" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_masterproject_Last_Updated_Date" class="masterprojectsearch"><span id="el_masterproject_Last_Updated_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="x_Last_Updated_Date" id="x_Last_Updated_Date" data-table="masterproject" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue ?>" data-page="4" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(15) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_masterproject_Last_Updated_By" class="masterprojectsearch"><span id="el_masterproject_Last_Updated_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_By->getInputTextType() ?>" name="x_Last_Updated_By" id="x_Last_Updated_By" data-table="masterproject" data-field="x_Last_Updated_By" value="<?= $Page->Last_Updated_By->EditValue ?>" data-page="4" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_By->formatPattern()) ?>"<?= $Page->Last_Updated_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
</span></template>
<div id="masterproject_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "_ProjectID",
                type: "integer",
                label: currentTable.fields._ProjectID.caption,
                operators: currentTable.fields._ProjectID.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields._ProjectID.validators),
                data: {
                    format: currentTable.fields._ProjectID.clientFormatPattern
                }
            },
            {
                id: "ProjectName",
                type: "string",
                label: currentTable.fields.ProjectName.caption,
                operators: currentTable.fields.ProjectName.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.ProjectName.validators),
                data: {
                    format: currentTable.fields.ProjectName.clientFormatPattern
                }
            },
            {
                id: "PlanStart",
                type: "datetime",
                label: currentTable.fields.PlanStart.caption,
                operators: currentTable.fields.PlanStart.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.PlanStart.validators),
                data: {
                    format: currentTable.fields.PlanStart.clientFormatPattern
                }
            },
            {
                id: "PlanEnd",
                type: "datetime",
                label: currentTable.fields.PlanEnd.caption,
                operators: currentTable.fields.PlanEnd.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.PlanEnd.validators),
                data: {
                    format: currentTable.fields.PlanEnd.clientFormatPattern
                }
            },
            {
                id: "StartDate",
                type: "datetime",
                label: currentTable.fields.StartDate.caption,
                operators: currentTable.fields.StartDate.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.StartDate.validators),
                data: {
                    format: currentTable.fields.StartDate.clientFormatPattern
                }
            },
            {
                id: "EndDate",
                type: "datetime",
                label: currentTable.fields.EndDate.caption,
                operators: currentTable.fields.EndDate.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.EndDate.validators),
                data: {
                    format: currentTable.fields.EndDate.clientFormatPattern
                }
            },
            {
                id: "WarrantyEnd",
                type: "datetime",
                label: currentTable.fields.WarrantyEnd.caption,
                operators: currentTable.fields.WarrantyEnd.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.WarrantyEnd.validators),
                data: {
                    format: currentTable.fields.WarrantyEnd.clientFormatPattern
                }
            },
            {
                id: "Status",
                type: "string",
                label: currentTable.fields.Status.caption,
                operators: currentTable.fields.Status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.Status.validators),
                data: {
                    format: currentTable.fields.Status.clientFormatPattern
                }
            },
            {
                id: "Progress",
                type: "double",
                label: currentTable.fields.Progress.caption,
                operators: currentTable.fields.Progress.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.Progress.validators),
                data: {
                    format: currentTable.fields.Progress.clientFormatPattern
                }
            },
            {
                id: "Target",
                type: "double",
                label: currentTable.fields.Target.caption,
                operators: currentTable.fields.Target.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.Target.validators),
                data: {
                    format: currentTable.fields.Target.clientFormatPattern
                }
            },
            {
                id: "Track",
                type: "string",
                label: currentTable.fields.Track.caption,
                operators: currentTable.fields.Track.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.Track.validators),
                data: {
                    format: currentTable.fields.Track.clientFormatPattern
                }
            },
            {
                id: "PaymentProgress",
                type: "double",
                label: currentTable.fields.PaymentProgress.caption,
                operators: currentTable.fields.PaymentProgress.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.PaymentProgress.validators),
                data: {
                    format: currentTable.fields.PaymentProgress.clientFormatPattern
                }
            },
            {
                id: "PaymentDate",
                type: "datetime",
                label: currentTable.fields.PaymentDate.caption,
                operators: currentTable.fields.PaymentDate.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.PaymentDate.validators),
                data: {
                    format: currentTable.fields.PaymentDate.clientFormatPattern
                }
            },
            {
                id: "PaymentComplete",
                type: "string",
                label: currentTable.fields.PaymentComplete.caption,
                operators: currentTable.fields.PaymentComplete.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.PaymentComplete.validators),
                data: {
                    format: currentTable.fields.PaymentComplete.clientFormatPattern
                }
            },
            {
                id: "AgingPayment",
                type: "integer",
                label: currentTable.fields.AgingPayment.caption,
                operators: currentTable.fields.AgingPayment.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.AgingPayment.validators),
                data: {
                    format: currentTable.fields.AgingPayment.clientFormatPattern
                }
            },
            {
                id: "ClientID",
                type: "integer",
                label: currentTable.fields.ClientID.caption,
                operators: currentTable.fields.ClientID.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.ClientID.validators),
                data: {
                    format: currentTable.fields.ClientID.clientFormatPattern
                }
            },
            {
                id: "ManagerID",
                type: "integer",
                label: currentTable.fields.ManagerID.caption,
                operators: currentTable.fields.ManagerID.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.ManagerID.validators),
                data: {
                    format: currentTable.fields.ManagerID.clientFormatPattern
                }
            },
            {
                id: "ProjectTemplateID",
                type: "integer",
                label: currentTable.fields.ProjectTemplateID.caption,
                operators: currentTable.fields.ProjectTemplateID.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.ProjectTemplateID.validators),
                data: {
                    format: currentTable.fields.ProjectTemplateID.clientFormatPattern
                }
            },
            {
                id: "Priority",
                type: "integer",
                label: currentTable.fields.Priority.caption,
                operators: currentTable.fields.Priority.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.Priority.validators),
                data: {
                    format: currentTable.fields.Priority.clientFormatPattern
                }
            },
            {
                id: "ProjectValue",
                type: "double",
                label: currentTable.fields.ProjectValue.caption,
                operators: currentTable.fields.ProjectValue.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.ProjectValue.validators),
                data: {
                    format: currentTable.fields.ProjectValue.clientFormatPattern
                }
            },
            {
                id: "ProjectDebt",
                type: "double",
                label: currentTable.fields.ProjectDebt.caption,
                operators: currentTable.fields.ProjectDebt.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.ProjectDebt.validators),
                data: {
                    format: currentTable.fields.ProjectDebt.clientFormatPattern
                }
            },
            {
                id: "PONumber",
                type: "string",
                label: currentTable.fields.PONumber.caption,
                operators: currentTable.fields.PONumber.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.PONumber.validators),
                data: {
                    format: currentTable.fields.PONumber.clientFormatPattern
                }
            },
            {
                id: "PaymentLink",
                type: "string",
                label: currentTable.fields.PaymentLink.caption,
                operators: currentTable.fields.PaymentLink.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.PaymentLink.validators),
                data: {
                    format: currentTable.fields.PaymentLink.clientFormatPattern
                }
            },
            {
                id: "ClearingDate",
                type: "datetime",
                label: currentTable.fields.ClearingDate.caption,
                operators: currentTable.fields.ClearingDate.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.ClearingDate.validators),
                data: {
                    format: currentTable.fields.ClearingDate.clientFormatPattern
                }
            },
            {
                id: "ClearingAging",
                type: "integer",
                label: currentTable.fields.ClearingAging.caption,
                operators: currentTable.fields.ClearingAging.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.ClearingAging.validators),
                data: {
                    format: currentTable.fields.ClearingAging.clientFormatPattern
                }
            },
            {
                id: "Active",
                type: "boolean",
                label: currentTable.fields.Active.caption,
                operators: currentTable.fields.Active.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.Active.validators),
                data: {
                    format: currentTable.fields.Active.clientFormatPattern
                }
            },
            {
                id: "Created_Date",
                type: "datetime",
                label: currentTable.fields.Created_Date.caption,
                operators: currentTable.fields.Created_Date.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.Created_Date.validators),
                data: {
                    format: currentTable.fields.Created_Date.clientFormatPattern
                }
            },
            {
                id: "Created_By",
                type: "string",
                label: currentTable.fields.Created_By.caption,
                operators: currentTable.fields.Created_By.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.Created_By.validators),
                data: {
                    format: currentTable.fields.Created_By.clientFormatPattern
                }
            },
            {
                id: "Last_Updated_Date",
                type: "datetime",
                label: currentTable.fields.Last_Updated_Date.caption,
                operators: currentTable.fields.Last_Updated_Date.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.Last_Updated_Date.validators),
                data: {
                    format: currentTable.fields.Last_Updated_Date.clientFormatPattern
                }
            },
            {
                id: "Last_Updated_By",
                type: "string",
                label: currentTable.fields.Last_Updated_By.caption,
                operators: currentTable.fields.Last_Updated_By.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fmasterprojectsearch.fields.Last_Updated_By.validators),
                data: {
                    format: currentTable.fields.Last_Updated_By.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#masterproject_query_builder"),
        args = {},
        rules = ew.parseJson($("#fmasterprojectsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fmasterprojectsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fmasterprojectsearch" formaction="<?= HtmlEncode(GetUrl("masterprojectlist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmasterprojectsearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fmasterprojectsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masterproject");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
