<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$MasterprojectSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masterproject: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmasterprojectsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmasterprojectsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["_ProjectID", [ew.Validators.integer], fields._ProjectID.isInvalid],
            ["ProjectName", [], fields.ProjectName.isInvalid],
            ["PlanStart", [ew.Validators.datetime(fields.PlanStart.clientFormatPattern)], fields.PlanStart.isInvalid],
            ["y_PlanStart", [ew.Validators.between], false],
            ["PlanEnd", [ew.Validators.datetime(fields.PlanEnd.clientFormatPattern)], fields.PlanEnd.isInvalid],
            ["y_PlanEnd", [ew.Validators.between], false],
            ["StartDate", [ew.Validators.datetime(fields.StartDate.clientFormatPattern)], fields.StartDate.isInvalid],
            ["y_StartDate", [ew.Validators.between], false],
            ["EndDate", [ew.Validators.datetime(fields.EndDate.clientFormatPattern)], fields.EndDate.isInvalid],
            ["y_EndDate", [ew.Validators.between], false],
            ["WarrantyEnd", [ew.Validators.datetime(fields.WarrantyEnd.clientFormatPattern)], fields.WarrantyEnd.isInvalid],
            ["y_WarrantyEnd", [ew.Validators.between], false],
            ["Status", [], fields.Status.isInvalid],
            ["Progress", [ew.Validators.float], fields.Progress.isInvalid],
            ["y_Progress", [ew.Validators.between], false],
            ["Target", [ew.Validators.float], fields.Target.isInvalid],
            ["Track", [], fields.Track.isInvalid],
            ["PaymentProgress", [ew.Validators.float], fields.PaymentProgress.isInvalid],
            ["y_PaymentProgress", [ew.Validators.between], false],
            ["PaymentDate", [ew.Validators.datetime(fields.PaymentDate.clientFormatPattern)], fields.PaymentDate.isInvalid],
            ["y_PaymentDate", [ew.Validators.between], false],
            ["PaymentComplete", [], fields.PaymentComplete.isInvalid],
            ["AgingPayment", [ew.Validators.integer], fields.AgingPayment.isInvalid],
            ["ClientID", [], fields.ClientID.isInvalid],
            ["ManagerID", [], fields.ManagerID.isInvalid],
            ["ProjectTemplateID", [], fields.ProjectTemplateID.isInvalid],
            ["Priority", [], fields.Priority.isInvalid],
            ["ProjectValue", [ew.Validators.float], fields.ProjectValue.isInvalid],
            ["y_ProjectValue", [ew.Validators.between], false],
            ["ProjectDebt", [ew.Validators.float], fields.ProjectDebt.isInvalid],
            ["y_ProjectDebt", [ew.Validators.between], false],
            ["PONumber", [], fields.PONumber.isInvalid],
            ["PaymentLink", [], fields.PaymentLink.isInvalid],
            ["ClearingDate", [ew.Validators.datetime(fields.ClearingDate.clientFormatPattern)], fields.ClearingDate.isInvalid],
            ["ClearingAging", [ew.Validators.integer], fields.ClearingAging.isInvalid],
            ["Active", [], fields.Active.isInvalid],
            ["Created_Date", [], fields.Created_Date.isInvalid],
            ["y_Created_Date", [ew.Validators.between], false],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [], fields.Last_Updated_Date.isInvalid],
            ["y_Last_Updated_Date", [ew.Validators.between], false],
            ["Last_Updated_By", [], fields.Last_Updated_By.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Status": <?= $Page->Status->toClientList($Page) ?>,
            "ClientID": <?= $Page->ClientID->toClientList($Page) ?>,
            "ManagerID": <?= $Page->ManagerID->toClientList($Page) ?>,
            "ProjectTemplateID": <?= $Page->ProjectTemplateID->toClientList($Page) ?>,
            "Priority": <?= $Page->Priority->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmasterprojectsearch" id="fmasterprojectsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="masterproject">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav<?= $Page->MultiPages->containerClasses() ?>" id="pages_MasterprojectSearch"><!-- multi-page tabs -->
    <ul class="<?= $Page->MultiPages->navClasses() ?>" role="tablist">
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(1) ?>" data-bs-target="#tab_masterproject1" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_masterproject1" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>"><?= $Page->pageCaption(1) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(2) ?>" data-bs-target="#tab_masterproject2" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_masterproject2" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>"><?= $Page->pageCaption(2) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(3) ?>" data-bs-target="#tab_masterproject3" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_masterproject3" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>"><?= $Page->pageCaption(3) ?></button></li>
        <li class="nav-item"><button class="<?= $Page->MultiPages->navLinkClasses(4) ?>" data-bs-target="#tab_masterproject4" data-bs-toggle="tab" type="button" role="tab" aria-controls="tab_masterproject4" aria-selected="<?= JsonEncode($Page->MultiPages->isActive(4)) ?>"><?= $Page->pageCaption(4) ?></button></li>
    </ul>
    <div class="<?= $Page->MultiPages->tabContentClasses() ?>"><!-- multi-page tabs .tab-content -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(1) ?>" id="tab_masterproject1" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->_ProjectID->Visible) { // ProjectID ?>
    <div id="r__ProjectID" class="row"<?= $Page->_ProjectID->rowAttributes() ?>>
        <label for="x__ProjectID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject__ProjectID"><?= $Page->_ProjectID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__ProjectID" id="z__ProjectID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_ProjectID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject__ProjectID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_ProjectID->getInputTextType() ?>" name="x__ProjectID" id="x__ProjectID" data-table="masterproject" data-field="x__ProjectID" value="<?= $Page->_ProjectID->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->_ProjectID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_ProjectID->formatPattern()) ?>"<?= $Page->_ProjectID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_ProjectID->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ProjectName->Visible) { // ProjectName ?>
    <div id="r_ProjectName" class="row"<?= $Page->ProjectName->rowAttributes() ?>>
        <label for="x_ProjectName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_ProjectName"><?= $Page->ProjectName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ProjectName" id="z_ProjectName" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProjectName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_ProjectName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ProjectName->getInputTextType() ?>" name="x_ProjectName" id="x_ProjectName" data-table="masterproject" data-field="x_ProjectName" value="<?= $Page->ProjectName->EditValue ?>" data-page="1" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->ProjectName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectName->formatPattern()) ?>"<?= $Page->ProjectName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Status->Visible) { // Status ?>
    <div id="r_Status" class="row"<?= $Page->Status->rowAttributes() ?>>
        <label for="x_Status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_Status"><?= $Page->Status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Status" id="z_Status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_Status" class="ew-search-field">
    <select
        id="x_Status"
        name="x_Status"
        class="form-select ew-select<?= $Page->Status->isInvalidClass() ?>"
        <?php if (!$Page->Status->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_x_Status"
        <?php } ?>
        data-table="masterproject"
        data-field="x_Status"
        data-page="1"
        data-value-separator="<?= $Page->Status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Status->getPlaceHolder()) ?>"
        <?= $Page->Status->editAttributes() ?>>
        <?= $Page->Status->selectOptionListHtml("x_Status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Status->getErrorMessage(false) ?></div>
<?= $Page->Status->Lookup->getParamTag($Page, "p_x_Status") ?>
<?php if (!$Page->Status->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "x_Status", selectId: "fmasterprojectsearch_x_Status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.Status?.lookupOptions.length) {
        options.data = { id: "x_Status", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "x_Status", form: "fmasterprojectsearch", limit: 3 };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.Status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_Status_1" name="v_Status" value="AND"<?= ($Page->Status->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_Status_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_Status_2" name="v_Status" value="OR"<?= ($Page->Status->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_Status_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_Status" id="w_Status" value="=">
</span>
                    <span id="el2_masterproject_Status" class="ew-search-field2">
    <select
        id="y_Status"
        name="y_Status"
        class="form-select ew-select<?= $Page->Status->isInvalidClass() ?>"
        <?php if (!$Page->Status->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_y_Status"
        <?php } ?>
        data-table="masterproject"
        data-field="x_Status"
        data-page="1"
        data-value-separator="<?= $Page->Status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Status->getPlaceHolder()) ?>"
        <?= $Page->Status->editAttributes() ?>>
        <?= $Page->Status->selectOptionListHtml("y_Status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Status->getErrorMessage(false) ?></div>
<?= $Page->Status->Lookup->getParamTag($Page, "p_y_Status") ?>
<?php if (!$Page->Status->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "y_Status", selectId: "fmasterprojectsearch_y_Status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.Status?.lookupOptions.length) {
        options.data = { id: "y_Status", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "y_Status", form: "fmasterprojectsearch", limit: 3 };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.Status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Progress->Visible) { // Progress ?>
    <div id="r_Progress" class="row"<?= $Page->Progress->rowAttributes() ?>>
        <label for="x_Progress" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_Progress"><?= $Page->Progress->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Progress->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Progress" id="z_Progress" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Progress->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Progress->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_Progress" class="ew-search-field">
<input type="<?= $Page->Progress->getInputTextType() ?>" name="x_Progress" id="x_Progress" data-table="masterproject" data-field="x_Progress" value="<?= $Page->Progress->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Progress->formatPattern()) ?>"<?= $Page->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Progress->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_Progress" class="ew-search-field2 d-none">
<input type="<?= $Page->Progress->getInputTextType() ?>" name="y_Progress" id="y_Progress" data-table="masterproject" data-field="x_Progress" value="<?= $Page->Progress->EditValue2 ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Progress->formatPattern()) ?>"<?= $Page->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Progress->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Target->Visible) { // Target ?>
    <div id="r_Target" class="row"<?= $Page->Target->rowAttributes() ?>>
        <label for="x_Target" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_Target"><?= $Page->Target->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Target" id="z_Target" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Target->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_Target" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Target->getInputTextType() ?>" name="x_Target" id="x_Target" data-table="masterproject" data-field="x_Target" value="<?= $Page->Target->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->Target->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Target->formatPattern()) ?>"<?= $Page->Target->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Target->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Track->Visible) { // Track ?>
    <div id="r_Track" class="row"<?= $Page->Track->rowAttributes() ?>>
        <label for="x_Track" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_Track"><?= $Page->Track->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Track" id="z_Track" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Track->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_Track" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Track->getInputTextType() ?>" name="x_Track" id="x_Track" data-table="masterproject" data-field="x_Track" value="<?= $Page->Track->EditValue ?>" data-page="1" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->Track->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Track->formatPattern()) ?>"<?= $Page->Track->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Track->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ClientID->Visible) { // ClientID ?>
    <div id="r_ClientID" class="row"<?= $Page->ClientID->rowAttributes() ?>>
        <label for="x_ClientID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_ClientID"><?= $Page->ClientID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ClientID" id="z_ClientID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ClientID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_ClientID" class="ew-search-field">
    <select
        id="x_ClientID"
        name="x_ClientID"
        class="form-select ew-select<?= $Page->ClientID->isInvalidClass() ?>"
        <?php if (!$Page->ClientID->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_x_ClientID"
        <?php } ?>
        data-table="masterproject"
        data-field="x_ClientID"
        data-page="1"
        data-value-separator="<?= $Page->ClientID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ClientID->getPlaceHolder()) ?>"
        <?= $Page->ClientID->editAttributes() ?>>
        <?= $Page->ClientID->selectOptionListHtml("x_ClientID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ClientID->getErrorMessage(false) ?></div>
<?= $Page->ClientID->Lookup->getParamTag($Page, "p_x_ClientID") ?>
<?php if (!$Page->ClientID->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "x_ClientID", selectId: "fmasterprojectsearch_x_ClientID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.ClientID?.lookupOptions.length) {
        options.data = { id: "x_ClientID", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "x_ClientID", form: "fmasterprojectsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ClientID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_ClientID_1" name="v_ClientID" value="AND"<?= ($Page->ClientID->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_ClientID_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_ClientID_2" name="v_ClientID" value="OR"<?= ($Page->ClientID->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_ClientID_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_ClientID" id="w_ClientID" value="=">
</span>
                    <span id="el2_masterproject_ClientID" class="ew-search-field2">
    <select
        id="y_ClientID"
        name="y_ClientID"
        class="form-select ew-select<?= $Page->ClientID->isInvalidClass() ?>"
        <?php if (!$Page->ClientID->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_y_ClientID"
        <?php } ?>
        data-table="masterproject"
        data-field="x_ClientID"
        data-page="1"
        data-value-separator="<?= $Page->ClientID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ClientID->getPlaceHolder()) ?>"
        <?= $Page->ClientID->editAttributes() ?>>
        <?= $Page->ClientID->selectOptionListHtml("y_ClientID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ClientID->getErrorMessage(false) ?></div>
<?= $Page->ClientID->Lookup->getParamTag($Page, "p_y_ClientID") ?>
<?php if (!$Page->ClientID->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "y_ClientID", selectId: "fmasterprojectsearch_y_ClientID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.ClientID?.lookupOptions.length) {
        options.data = { id: "y_ClientID", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "y_ClientID", form: "fmasterprojectsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ClientID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ManagerID->Visible) { // ManagerID ?>
    <div id="r_ManagerID" class="row"<?= $Page->ManagerID->rowAttributes() ?>>
        <label for="x_ManagerID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_ManagerID"><?= $Page->ManagerID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ManagerID" id="z_ManagerID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ManagerID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_ManagerID" class="ew-search-field">
    <select
        id="x_ManagerID"
        name="x_ManagerID"
        class="form-select ew-select<?= $Page->ManagerID->isInvalidClass() ?>"
        <?php if (!$Page->ManagerID->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_x_ManagerID"
        <?php } ?>
        data-table="masterproject"
        data-field="x_ManagerID"
        data-page="1"
        data-value-separator="<?= $Page->ManagerID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ManagerID->getPlaceHolder()) ?>"
        <?= $Page->ManagerID->editAttributes() ?>>
        <?= $Page->ManagerID->selectOptionListHtml("x_ManagerID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ManagerID->getErrorMessage(false) ?></div>
<?= $Page->ManagerID->Lookup->getParamTag($Page, "p_x_ManagerID") ?>
<?php if (!$Page->ManagerID->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "x_ManagerID", selectId: "fmasterprojectsearch_x_ManagerID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.ManagerID?.lookupOptions.length) {
        options.data = { id: "x_ManagerID", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "x_ManagerID", form: "fmasterprojectsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ManagerID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_ManagerID_1" name="v_ManagerID" value="AND"<?= ($Page->ManagerID->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_ManagerID_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_ManagerID_2" name="v_ManagerID" value="OR"<?= ($Page->ManagerID->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_ManagerID_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_ManagerID" id="w_ManagerID" value="=">
</span>
                    <span id="el2_masterproject_ManagerID" class="ew-search-field2">
    <select
        id="y_ManagerID"
        name="y_ManagerID"
        class="form-select ew-select<?= $Page->ManagerID->isInvalidClass() ?>"
        <?php if (!$Page->ManagerID->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_y_ManagerID"
        <?php } ?>
        data-table="masterproject"
        data-field="x_ManagerID"
        data-page="1"
        data-value-separator="<?= $Page->ManagerID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ManagerID->getPlaceHolder()) ?>"
        <?= $Page->ManagerID->editAttributes() ?>>
        <?= $Page->ManagerID->selectOptionListHtml("y_ManagerID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ManagerID->getErrorMessage(false) ?></div>
<?= $Page->ManagerID->Lookup->getParamTag($Page, "p_y_ManagerID") ?>
<?php if (!$Page->ManagerID->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "y_ManagerID", selectId: "fmasterprojectsearch_y_ManagerID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.ManagerID?.lookupOptions.length) {
        options.data = { id: "y_ManagerID", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "y_ManagerID", form: "fmasterprojectsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ManagerID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ProjectTemplateID->Visible) { // ProjectTemplateID ?>
    <div id="r_ProjectTemplateID" class="row"<?= $Page->ProjectTemplateID->rowAttributes() ?>>
        <label for="x_ProjectTemplateID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_ProjectTemplateID"><?= $Page->ProjectTemplateID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ProjectTemplateID" id="z_ProjectTemplateID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProjectTemplateID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_ProjectTemplateID" class="ew-search-field">
    <select
        id="x_ProjectTemplateID"
        name="x_ProjectTemplateID"
        class="form-select ew-select<?= $Page->ProjectTemplateID->isInvalidClass() ?>"
        <?php if (!$Page->ProjectTemplateID->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_x_ProjectTemplateID"
        <?php } ?>
        data-table="masterproject"
        data-field="x_ProjectTemplateID"
        data-page="1"
        data-value-separator="<?= $Page->ProjectTemplateID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProjectTemplateID->getPlaceHolder()) ?>"
        <?= $Page->ProjectTemplateID->editAttributes() ?>>
        <?= $Page->ProjectTemplateID->selectOptionListHtml("x_ProjectTemplateID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProjectTemplateID->getErrorMessage(false) ?></div>
<?= $Page->ProjectTemplateID->Lookup->getParamTag($Page, "p_x_ProjectTemplateID") ?>
<?php if (!$Page->ProjectTemplateID->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "x_ProjectTemplateID", selectId: "fmasterprojectsearch_x_ProjectTemplateID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.ProjectTemplateID?.lookupOptions.length) {
        options.data = { id: "x_ProjectTemplateID", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "x_ProjectTemplateID", form: "fmasterprojectsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ProjectTemplateID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_ProjectTemplateID_1" name="v_ProjectTemplateID" value="AND"<?= ($Page->ProjectTemplateID->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_ProjectTemplateID_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_ProjectTemplateID_2" name="v_ProjectTemplateID" value="OR"<?= ($Page->ProjectTemplateID->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_ProjectTemplateID_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_ProjectTemplateID" id="w_ProjectTemplateID" value="=">
</span>
                    <span id="el2_masterproject_ProjectTemplateID" class="ew-search-field2">
    <select
        id="y_ProjectTemplateID"
        name="y_ProjectTemplateID"
        class="form-select ew-select<?= $Page->ProjectTemplateID->isInvalidClass() ?>"
        <?php if (!$Page->ProjectTemplateID->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_y_ProjectTemplateID"
        <?php } ?>
        data-table="masterproject"
        data-field="x_ProjectTemplateID"
        data-page="1"
        data-value-separator="<?= $Page->ProjectTemplateID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProjectTemplateID->getPlaceHolder()) ?>"
        <?= $Page->ProjectTemplateID->editAttributes() ?>>
        <?= $Page->ProjectTemplateID->selectOptionListHtml("y_ProjectTemplateID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ProjectTemplateID->getErrorMessage(false) ?></div>
<?= $Page->ProjectTemplateID->Lookup->getParamTag($Page, "p_y_ProjectTemplateID") ?>
<?php if (!$Page->ProjectTemplateID->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "y_ProjectTemplateID", selectId: "fmasterprojectsearch_y_ProjectTemplateID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.ProjectTemplateID?.lookupOptions.length) {
        options.data = { id: "y_ProjectTemplateID", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "y_ProjectTemplateID", form: "fmasterprojectsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.ProjectTemplateID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Priority->Visible) { // Priority ?>
    <div id="r_Priority" class="row"<?= $Page->Priority->rowAttributes() ?>>
        <label for="x_Priority" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_Priority"><?= $Page->Priority->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Priority" id="z_Priority" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Priority->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_Priority" class="ew-search-field ew-search-field-single">
    <select
        id="x_Priority"
        name="x_Priority"
        class="form-select ew-select<?= $Page->Priority->isInvalidClass() ?>"
        <?php if (!$Page->Priority->IsNativeSelect) { ?>
        data-select2-id="fmasterprojectsearch_x_Priority"
        <?php } ?>
        data-table="masterproject"
        data-field="x_Priority"
        data-page="1"
        data-value-separator="<?= $Page->Priority->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Priority->getPlaceHolder()) ?>"
        <?= $Page->Priority->editAttributes() ?>>
        <?= $Page->Priority->selectOptionListHtml("x_Priority") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Priority->getErrorMessage(false) ?></div>
<?php if (!$Page->Priority->IsNativeSelect) { ?>
<script>
loadjs.ready("fmasterprojectsearch", function() {
    var options = { name: "x_Priority", selectId: "fmasterprojectsearch_x_Priority" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmasterprojectsearch.lists.Priority?.lookupOptions.length) {
        options.data = { id: "x_Priority", form: "fmasterprojectsearch" };
    } else {
        options.ajax = { id: "x_Priority", form: "fmasterprojectsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masterproject.fields.Priority.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Active->Visible) { // Active ?>
    <div id="r_Active" class="row"<?= $Page->Active->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_Active"><?= $Page->Active->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Active" id="z_Active" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Active->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_Active" class="ew-search-field ew-search-field-single">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->Active->isInvalidClass() ?>" data-table="masterproject" data-field="x_Active" data-boolean data-page="1" name="x_Active" id="x_Active" value="1"<?= ConvertToBool($Page->Active->AdvancedSearch->SearchValue) ? " checked" : "" ?><?= $Page->Active->editAttributes() ?>>
    <div class="invalid-feedback"><?= $Page->Active->getErrorMessage(false) ?></div>
</div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(2) ?>" id="tab_masterproject2" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->PlanStart->Visible) { // PlanStart ?>
    <div id="r_PlanStart" class="row"<?= $Page->PlanStart->rowAttributes() ?>>
        <label for="x_PlanStart" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_PlanStart"><?= $Page->PlanStart->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PlanStart->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_PlanStart" id="z_PlanStart" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->PlanStart->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->PlanStart->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_PlanStart" class="ew-search-field">
<input type="<?= $Page->PlanStart->getInputTextType() ?>" name="x_PlanStart" id="x_PlanStart" data-table="masterproject" data-field="x_PlanStart" value="<?= $Page->PlanStart->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->PlanStart->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanStart->formatPattern()) ?>"<?= $Page->PlanStart->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanStart->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanStart->ReadOnly && !$Page->PlanStart->Disabled && !isset($Page->PlanStart->EditAttrs["readonly"]) && !isset($Page->PlanStart->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_PlanStart", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_PlanStart" class="ew-search-field2 d-none">
<input type="<?= $Page->PlanStart->getInputTextType() ?>" name="y_PlanStart" id="y_PlanStart" data-table="masterproject" data-field="x_PlanStart" value="<?= $Page->PlanStart->EditValue2 ?>" data-page="2" placeholder="<?= HtmlEncode($Page->PlanStart->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanStart->formatPattern()) ?>"<?= $Page->PlanStart->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanStart->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanStart->ReadOnly && !$Page->PlanStart->Disabled && !isset($Page->PlanStart->EditAttrs["readonly"]) && !isset($Page->PlanStart->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "y_PlanStart", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PlanEnd->Visible) { // PlanEnd ?>
    <div id="r_PlanEnd" class="row"<?= $Page->PlanEnd->rowAttributes() ?>>
        <label for="x_PlanEnd" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_PlanEnd"><?= $Page->PlanEnd->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PlanEnd->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_PlanEnd" id="z_PlanEnd" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->PlanEnd->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->PlanEnd->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_PlanEnd" class="ew-search-field">
<input type="<?= $Page->PlanEnd->getInputTextType() ?>" name="x_PlanEnd" id="x_PlanEnd" data-table="masterproject" data-field="x_PlanEnd" value="<?= $Page->PlanEnd->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->PlanEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanEnd->formatPattern()) ?>"<?= $Page->PlanEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanEnd->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanEnd->ReadOnly && !$Page->PlanEnd->Disabled && !isset($Page->PlanEnd->EditAttrs["readonly"]) && !isset($Page->PlanEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_PlanEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_PlanEnd" class="ew-search-field2 d-none">
<input type="<?= $Page->PlanEnd->getInputTextType() ?>" name="y_PlanEnd" id="y_PlanEnd" data-table="masterproject" data-field="x_PlanEnd" value="<?= $Page->PlanEnd->EditValue2 ?>" data-page="2" placeholder="<?= HtmlEncode($Page->PlanEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanEnd->formatPattern()) ?>"<?= $Page->PlanEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanEnd->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanEnd->ReadOnly && !$Page->PlanEnd->Disabled && !isset($Page->PlanEnd->EditAttrs["readonly"]) && !isset($Page->PlanEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "y_PlanEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->StartDate->Visible) { // StartDate ?>
    <div id="r_StartDate" class="row"<?= $Page->StartDate->rowAttributes() ?>>
        <label for="x_StartDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_StartDate"><?= $Page->StartDate->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->StartDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_StartDate" id="z_StartDate" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->StartDate->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->StartDate->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_StartDate" class="ew-search-field">
<input type="<?= $Page->StartDate->getInputTextType() ?>" name="x_StartDate" id="x_StartDate" data-table="masterproject" data-field="x_StartDate" value="<?= $Page->StartDate->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->StartDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->StartDate->formatPattern()) ?>"<?= $Page->StartDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->StartDate->getErrorMessage(false) ?></div>
<?php if (!$Page->StartDate->ReadOnly && !$Page->StartDate->Disabled && !isset($Page->StartDate->EditAttrs["readonly"]) && !isset($Page->StartDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_StartDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_StartDate" class="ew-search-field2 d-none">
<input type="<?= $Page->StartDate->getInputTextType() ?>" name="y_StartDate" id="y_StartDate" data-table="masterproject" data-field="x_StartDate" value="<?= $Page->StartDate->EditValue2 ?>" data-page="2" placeholder="<?= HtmlEncode($Page->StartDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->StartDate->formatPattern()) ?>"<?= $Page->StartDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->StartDate->getErrorMessage(false) ?></div>
<?php if (!$Page->StartDate->ReadOnly && !$Page->StartDate->Disabled && !isset($Page->StartDate->EditAttrs["readonly"]) && !isset($Page->StartDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "y_StartDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->EndDate->Visible) { // EndDate ?>
    <div id="r_EndDate" class="row"<?= $Page->EndDate->rowAttributes() ?>>
        <label for="x_EndDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_EndDate"><?= $Page->EndDate->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->EndDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_EndDate" id="z_EndDate" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->EndDate->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->EndDate->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_EndDate" class="ew-search-field">
<input type="<?= $Page->EndDate->getInputTextType() ?>" name="x_EndDate" id="x_EndDate" data-table="masterproject" data-field="x_EndDate" value="<?= $Page->EndDate->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EndDate->formatPattern()) ?>"<?= $Page->EndDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage(false) ?></div>
<?php if (!$Page->EndDate->ReadOnly && !$Page->EndDate->Disabled && !isset($Page->EndDate->EditAttrs["readonly"]) && !isset($Page->EndDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_EndDate" class="ew-search-field2 d-none">
<input type="<?= $Page->EndDate->getInputTextType() ?>" name="y_EndDate" id="y_EndDate" data-table="masterproject" data-field="x_EndDate" value="<?= $Page->EndDate->EditValue2 ?>" data-page="2" placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EndDate->formatPattern()) ?>"<?= $Page->EndDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage(false) ?></div>
<?php if (!$Page->EndDate->ReadOnly && !$Page->EndDate->Disabled && !isset($Page->EndDate->EditAttrs["readonly"]) && !isset($Page->EndDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "y_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->WarrantyEnd->Visible) { // WarrantyEnd ?>
    <div id="r_WarrantyEnd" class="row"<?= $Page->WarrantyEnd->rowAttributes() ?>>
        <label for="x_WarrantyEnd" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_WarrantyEnd"><?= $Page->WarrantyEnd->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->WarrantyEnd->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_WarrantyEnd" id="z_WarrantyEnd" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->WarrantyEnd->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->WarrantyEnd->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_WarrantyEnd" class="ew-search-field">
<input type="<?= $Page->WarrantyEnd->getInputTextType() ?>" name="x_WarrantyEnd" id="x_WarrantyEnd" data-table="masterproject" data-field="x_WarrantyEnd" value="<?= $Page->WarrantyEnd->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->WarrantyEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WarrantyEnd->formatPattern()) ?>"<?= $Page->WarrantyEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->WarrantyEnd->getErrorMessage(false) ?></div>
<?php if (!$Page->WarrantyEnd->ReadOnly && !$Page->WarrantyEnd->Disabled && !isset($Page->WarrantyEnd->EditAttrs["readonly"]) && !isset($Page->WarrantyEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_WarrantyEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_WarrantyEnd" class="ew-search-field2 d-none">
<input type="<?= $Page->WarrantyEnd->getInputTextType() ?>" name="y_WarrantyEnd" id="y_WarrantyEnd" data-table="masterproject" data-field="x_WarrantyEnd" value="<?= $Page->WarrantyEnd->EditValue2 ?>" data-page="2" placeholder="<?= HtmlEncode($Page->WarrantyEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WarrantyEnd->formatPattern()) ?>"<?= $Page->WarrantyEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->WarrantyEnd->getErrorMessage(false) ?></div>
<?php if (!$Page->WarrantyEnd->ReadOnly && !$Page->WarrantyEnd->Disabled && !isset($Page->WarrantyEnd->EditAttrs["readonly"]) && !isset($Page->WarrantyEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "y_WarrantyEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(3) ?>" id="tab_masterproject3" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->PaymentProgress->Visible) { // PaymentProgress ?>
    <div id="r_PaymentProgress" class="row"<?= $Page->PaymentProgress->rowAttributes() ?>>
        <label for="x_PaymentProgress" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_PaymentProgress"><?= $Page->PaymentProgress->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PaymentProgress->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_PaymentProgress" id="z_PaymentProgress" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->PaymentProgress->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->PaymentProgress->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_PaymentProgress" class="ew-search-field">
<input type="<?= $Page->PaymentProgress->getInputTextType() ?>" name="x_PaymentProgress" id="x_PaymentProgress" data-table="masterproject" data-field="x_PaymentProgress" value="<?= $Page->PaymentProgress->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->PaymentProgress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PaymentProgress->formatPattern()) ?>"<?= $Page->PaymentProgress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PaymentProgress->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_PaymentProgress" class="ew-search-field2 d-none">
<input type="<?= $Page->PaymentProgress->getInputTextType() ?>" name="y_PaymentProgress" id="y_PaymentProgress" data-table="masterproject" data-field="x_PaymentProgress" value="<?= $Page->PaymentProgress->EditValue2 ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->PaymentProgress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PaymentProgress->formatPattern()) ?>"<?= $Page->PaymentProgress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PaymentProgress->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PaymentDate->Visible) { // PaymentDate ?>
    <div id="r_PaymentDate" class="row"<?= $Page->PaymentDate->rowAttributes() ?>>
        <label for="x_PaymentDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_PaymentDate"><?= $Page->PaymentDate->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PaymentDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_PaymentDate" id="z_PaymentDate" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->PaymentDate->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->PaymentDate->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_PaymentDate" class="ew-search-field">
<input type="<?= $Page->PaymentDate->getInputTextType() ?>" name="x_PaymentDate" id="x_PaymentDate" data-table="masterproject" data-field="x_PaymentDate" value="<?= $Page->PaymentDate->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->PaymentDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PaymentDate->formatPattern()) ?>"<?= $Page->PaymentDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PaymentDate->getErrorMessage(false) ?></div>
<?php if (!$Page->PaymentDate->ReadOnly && !$Page->PaymentDate->Disabled && !isset($Page->PaymentDate->EditAttrs["readonly"]) && !isset($Page->PaymentDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_PaymentDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_PaymentDate" class="ew-search-field2 d-none">
<input type="<?= $Page->PaymentDate->getInputTextType() ?>" name="y_PaymentDate" id="y_PaymentDate" data-table="masterproject" data-field="x_PaymentDate" value="<?= $Page->PaymentDate->EditValue2 ?>" data-page="3" placeholder="<?= HtmlEncode($Page->PaymentDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PaymentDate->formatPattern()) ?>"<?= $Page->PaymentDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PaymentDate->getErrorMessage(false) ?></div>
<?php if (!$Page->PaymentDate->ReadOnly && !$Page->PaymentDate->Disabled && !isset($Page->PaymentDate->EditAttrs["readonly"]) && !isset($Page->PaymentDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "y_PaymentDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PaymentComplete->Visible) { // PaymentComplete ?>
    <div id="r_PaymentComplete" class="row"<?= $Page->PaymentComplete->rowAttributes() ?>>
        <label for="x_PaymentComplete" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_PaymentComplete"><?= $Page->PaymentComplete->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_PaymentComplete" id="z_PaymentComplete" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PaymentComplete->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_PaymentComplete" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PaymentComplete->getInputTextType() ?>" name="x_PaymentComplete" id="x_PaymentComplete" data-table="masterproject" data-field="x_PaymentComplete" value="<?= $Page->PaymentComplete->EditValue ?>" data-page="3" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->PaymentComplete->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PaymentComplete->formatPattern()) ?>"<?= $Page->PaymentComplete->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PaymentComplete->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->AgingPayment->Visible) { // AgingPayment ?>
    <div id="r_AgingPayment" class="row"<?= $Page->AgingPayment->rowAttributes() ?>>
        <label for="x_AgingPayment" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_AgingPayment"><?= $Page->AgingPayment->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_AgingPayment" id="z_AgingPayment" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->AgingPayment->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_AgingPayment" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->AgingPayment->getInputTextType() ?>" name="x_AgingPayment" id="x_AgingPayment" data-table="masterproject" data-field="x_AgingPayment" value="<?= $Page->AgingPayment->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->AgingPayment->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->AgingPayment->formatPattern()) ?>"<?= $Page->AgingPayment->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->AgingPayment->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ProjectValue->Visible) { // ProjectValue ?>
    <div id="r_ProjectValue" class="row"<?= $Page->ProjectValue->rowAttributes() ?>>
        <label for="x_ProjectValue" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_ProjectValue"><?= $Page->ProjectValue->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProjectValue->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_ProjectValue" id="z_ProjectValue" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->ProjectValue->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->ProjectValue->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_ProjectValue" class="ew-search-field">
<input type="<?= $Page->ProjectValue->getInputTextType() ?>" name="x_ProjectValue" id="x_ProjectValue" data-table="masterproject" data-field="x_ProjectValue" value="<?= $Page->ProjectValue->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->ProjectValue->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectValue->formatPattern()) ?>"<?= $Page->ProjectValue->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectValue->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_ProjectValue" class="ew-search-field2 d-none">
<input type="<?= $Page->ProjectValue->getInputTextType() ?>" name="y_ProjectValue" id="y_ProjectValue" data-table="masterproject" data-field="x_ProjectValue" value="<?= $Page->ProjectValue->EditValue2 ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->ProjectValue->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectValue->formatPattern()) ?>"<?= $Page->ProjectValue->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectValue->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ProjectDebt->Visible) { // ProjectDebt ?>
    <div id="r_ProjectDebt" class="row"<?= $Page->ProjectDebt->rowAttributes() ?>>
        <label for="x_ProjectDebt" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_ProjectDebt"><?= $Page->ProjectDebt->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProjectDebt->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_ProjectDebt" id="z_ProjectDebt" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->ProjectDebt->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->ProjectDebt->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_ProjectDebt" class="ew-search-field">
<input type="<?= $Page->ProjectDebt->getInputTextType() ?>" name="x_ProjectDebt" id="x_ProjectDebt" data-table="masterproject" data-field="x_ProjectDebt" value="<?= $Page->ProjectDebt->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->ProjectDebt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectDebt->formatPattern()) ?>"<?= $Page->ProjectDebt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectDebt->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_ProjectDebt" class="ew-search-field2 d-none">
<input type="<?= $Page->ProjectDebt->getInputTextType() ?>" name="y_ProjectDebt" id="y_ProjectDebt" data-table="masterproject" data-field="x_ProjectDebt" value="<?= $Page->ProjectDebt->EditValue2 ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->ProjectDebt->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectDebt->formatPattern()) ?>"<?= $Page->ProjectDebt->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProjectDebt->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PONumber->Visible) { // PONumber ?>
    <div id="r_PONumber" class="row"<?= $Page->PONumber->rowAttributes() ?>>
        <label for="x_PONumber" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_PONumber"><?= $Page->PONumber->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PONumber" id="z_PONumber" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PONumber->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_PONumber" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PONumber->getInputTextType() ?>" name="x_PONumber" id="x_PONumber" data-table="masterproject" data-field="x_PONumber" value="<?= $Page->PONumber->EditValue ?>" data-page="3" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->PONumber->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PONumber->formatPattern()) ?>"<?= $Page->PONumber->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PONumber->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PaymentLink->Visible) { // PaymentLink ?>
    <div id="r_PaymentLink" class="row"<?= $Page->PaymentLink->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_PaymentLink"><?= $Page->PaymentLink->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PaymentLink" id="z_PaymentLink" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PaymentLink->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_PaymentLink" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PaymentLink->getInputTextType() ?>" name="x_PaymentLink" id="x_PaymentLink" data-table="masterproject" data-field="x_PaymentLink" value="<?= $Page->PaymentLink->EditValue ?>" data-page="3" maxlength="65535" placeholder="<?= HtmlEncode($Page->PaymentLink->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PaymentLink->formatPattern()) ?>"<?= $Page->PaymentLink->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PaymentLink->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ClearingDate->Visible) { // ClearingDate ?>
    <div id="r_ClearingDate" class="row"<?= $Page->ClearingDate->rowAttributes() ?>>
        <label for="x_ClearingDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_ClearingDate"><?= $Page->ClearingDate->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ClearingDate" id="z_ClearingDate" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ClearingDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_ClearingDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ClearingDate->getInputTextType() ?>" name="x_ClearingDate" id="x_ClearingDate" data-table="masterproject" data-field="x_ClearingDate" value="<?= $Page->ClearingDate->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->ClearingDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ClearingDate->formatPattern()) ?>"<?= $Page->ClearingDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ClearingDate->getErrorMessage(false) ?></div>
<?php if (!$Page->ClearingDate->ReadOnly && !$Page->ClearingDate->Disabled && !isset($Page->ClearingDate->EditAttrs["readonly"]) && !isset($Page->ClearingDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_ClearingDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ClearingAging->Visible) { // ClearingAging ?>
    <div id="r_ClearingAging" class="row"<?= $Page->ClearingAging->rowAttributes() ?>>
        <label for="x_ClearingAging" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_ClearingAging"><?= $Page->ClearingAging->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ClearingAging" id="z_ClearingAging" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ClearingAging->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_ClearingAging" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ClearingAging->getInputTextType() ?>" name="x_ClearingAging" id="x_ClearingAging" data-table="masterproject" data-field="x_ClearingAging" value="<?= $Page->ClearingAging->EditValue ?>" data-page="3" size="30" placeholder="<?= HtmlEncode($Page->ClearingAging->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ClearingAging->formatPattern()) ?>"<?= $Page->ClearingAging->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ClearingAging->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
        <div class="<?= $Page->MultiPages->tabPaneClasses(4) ?>" id="tab_masterproject4" role="tabpanel"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
    <div id="r_Created_Date" class="row"<?= $Page->Created_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_Created_Date"><?= $Page->Created_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Created_Date" id="z_Created_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Created_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Created_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_Created_Date" class="ew-search-field">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="x_Created_Date" id="x_Created_Date" data-table="masterproject" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue ?>" data-page="4" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(9) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_Created_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="y_Created_Date" id="y_Created_Date" data-table="masterproject" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue2 ?>" data-page="4" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(9) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "y_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
    <div id="r_Created_By" class="row"<?= $Page->Created_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_Created_By"><?= $Page->Created_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Created_By" id="z_Created_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="masterproject" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" data-page="4" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
    <div id="r_Last_Updated_Date" class="row"<?= $Page->Last_Updated_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_Last_Updated_Date"><?= $Page->Last_Updated_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Last_Updated_Date" id="z_Last_Updated_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Last_Updated_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Last_Updated_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterproject_Last_Updated_Date" class="ew-search-field">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="x_Last_Updated_Date" id="x_Last_Updated_Date" data-table="masterproject" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue ?>" data-page="4" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(15) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "x_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterproject_Last_Updated_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="y_Last_Updated_Date" id="y_Last_Updated_Date" data-table="masterproject" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue2 ?>" data-page="4" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterprojectsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(15) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterprojectsearch", "y_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
    <div id="r_Last_Updated_By" class="row"<?= $Page->Last_Updated_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterproject_Last_Updated_By"><?= $Page->Last_Updated_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Last_Updated_By" id="z_Last_Updated_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterproject_Last_Updated_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_By->getInputTextType() ?>" name="x_Last_Updated_By" id="x_Last_Updated_By" data-table="masterproject" data-field="x_Last_Updated_By" value="<?= $Page->Last_Updated_By->EditValue ?>" data-page="4" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_By->formatPattern()) ?>"<?= $Page->Last_Updated_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
        </div><!-- /multi-page .tab-pane -->
    </div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmasterprojectsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmasterprojectsearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmasterprojectsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masterproject");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
