<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$MasteruserList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masteruser: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "FirstName": <?= $Page->FirstName->toClientList($Page) ?>,
            "LastName": <?= $Page->LastName->toClientList($Page) ?>,
            "FullName": <?= $Page->FullName->toClientList($Page) ?>,
            "_Username": <?= $Page->_Username->toClientList($Page) ?>,
            "Level": <?= $Page->Level->toClientList($Page) ?>,
            "_Email": <?= $Page->_Email->toClientList($Page) ?>,
            "Position": <?= $Page->Position->toClientList($Page) ?>,
            "Department": <?= $Page->Department->toClientList($Page) ?>,
            "Employee": <?= $Page->Employee->toClientList($Page) ?>,
            "WhatsAppNumber": <?= $Page->WhatsAppNumber->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
            "Created_Date": <?= $Page->Created_Date->toClientList($Page) ?>,
            "Created_By": <?= $Page->Created_By->toClientList($Page) ?>,
            "Last_Updated_Date": <?= $Page->Last_Updated_Date->toClientList($Page) ?>,
            "Last_Updated_By": <?= $Page->Last_Updated_By->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.6.2", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.6.4",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.6.4"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fmasterusersrch" id="fmasterusersrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fmasterusersrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masteruser: currentTable } });
var currentForm;
var fmasterusersrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmasterusersrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "FirstName": <?= $Page->FirstName->toClientList($Page) ?>,
            "LastName": <?= $Page->LastName->toClientList($Page) ?>,
            "FullName": <?= $Page->FullName->toClientList($Page) ?>,
            "_Username": <?= $Page->_Username->toClientList($Page) ?>,
            "Level": <?= $Page->Level->toClientList($Page) ?>,
            "_Email": <?= $Page->_Email->toClientList($Page) ?>,
            "Position": <?= $Page->Position->toClientList($Page) ?>,
            "Department": <?= $Page->Department->toClientList($Page) ?>,
            "Employee": <?= $Page->Employee->toClientList($Page) ?>,
            "WhatsAppNumber": <?= $Page->WhatsAppNumber->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
            "Created_Date": <?= $Page->Created_Date->toClientList($Page) ?>,
            "Created_By": <?= $Page->Created_By->toClientList($Page) ?>,
            "Last_Updated_Date": <?= $Page->Last_Updated_Date->toClientList($Page) ?>,
            "Last_Updated_By": <?= $Page->Last_Updated_By->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->FirstName->Visible) { // FirstName ?>
<?php
if (!$Page->FirstName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FirstName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FirstName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FirstName"
            name="x_FirstName[]"
            class="form-control ew-select<?= $Page->FirstName->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_FirstName"
            data-table="masteruser"
            data-field="x_FirstName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FirstName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FirstName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FirstName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FirstName->editAttributes() ?>>
            <?= $Page->FirstName->selectOptionListHtml("x_FirstName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FirstName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_FirstName",
                selectId: "fmasterusersrch_x_FirstName",
                ajax: { id: "x_FirstName", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.FirstName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->LastName->Visible) { // LastName ?>
<?php
if (!$Page->LastName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_LastName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->LastName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_LastName"
            name="x_LastName[]"
            class="form-control ew-select<?= $Page->LastName->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_LastName"
            data-table="masteruser"
            data-field="x_LastName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->LastName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->LastName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->LastName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->LastName->editAttributes() ?>>
            <?= $Page->LastName->selectOptionListHtml("x_LastName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->LastName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_LastName",
                selectId: "fmasterusersrch_x_LastName",
                ajax: { id: "x_LastName", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.LastName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->FullName->Visible) { // FullName ?>
<?php
if (!$Page->FullName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_FullName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->FullName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_FullName"
            name="x_FullName[]"
            class="form-control ew-select<?= $Page->FullName->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_FullName"
            data-table="masteruser"
            data-field="x_FullName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->FullName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->FullName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->FullName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->FullName->editAttributes() ?>>
            <?= $Page->FullName->selectOptionListHtml("x_FullName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->FullName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_FullName",
                selectId: "fmasterusersrch_x_FullName",
                ajax: { id: "x_FullName", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.FullName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_Username->Visible) { // Username ?>
<?php
if (!$Page->_Username->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__Username" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_Username->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x__Username"
            name="x__Username[]"
            class="form-control ew-select<?= $Page->_Username->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x__Username"
            data-table="masteruser"
            data-field="x__Username"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->_Username->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->_Username->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->_Username->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->_Username->editAttributes() ?>>
            <?= $Page->_Username->selectOptionListHtml("x__Username", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->_Username->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x__Username",
                selectId: "fmasterusersrch_x__Username",
                ajax: { id: "x__Username", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields._Username.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Level->Visible) { // Level ?>
<?php
if (!$Page->Level->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Level" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Level->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Level"
            name="x_Level[]"
            class="form-control ew-select<?= $Page->Level->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_Level"
            data-table="masteruser"
            data-field="x_Level"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Level->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Level->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Level->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Level->editAttributes() ?>>
            <?= $Page->Level->selectOptionListHtml("x_Level", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Level->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_Level",
                selectId: "fmasterusersrch_x_Level",
                ajax: { id: "x_Level", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.Level.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
<?php
if (!$Page->_Email->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__Email" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_Email->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x__Email"
            name="x__Email[]"
            class="form-control ew-select<?= $Page->_Email->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x__Email"
            data-table="masteruser"
            data-field="x__Email"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->_Email->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->_Email->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->_Email->editAttributes() ?>>
            <?= $Page->_Email->selectOptionListHtml("x__Email", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->_Email->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x__Email",
                selectId: "fmasterusersrch_x__Email",
                ajax: { id: "x__Email", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields._Email.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Position->Visible) { // Position ?>
<?php
if (!$Page->Position->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Position" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Position->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Position"
            name="x_Position[]"
            class="form-control ew-select<?= $Page->Position->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_Position"
            data-table="masteruser"
            data-field="x_Position"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Position->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Position->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Position->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Position->editAttributes() ?>>
            <?= $Page->Position->selectOptionListHtml("x_Position", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Position->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_Position",
                selectId: "fmasterusersrch_x_Position",
                ajax: { id: "x_Position", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.Position.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Department->Visible) { // Department ?>
<?php
if (!$Page->Department->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Department" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Department->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Department"
            name="x_Department[]"
            class="form-control ew-select<?= $Page->Department->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_Department"
            data-table="masteruser"
            data-field="x_Department"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Department->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Department->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Department->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Department->editAttributes() ?>>
            <?= $Page->Department->selectOptionListHtml("x_Department", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Department->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_Department",
                selectId: "fmasterusersrch_x_Department",
                ajax: { id: "x_Department", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.Department.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Employee->Visible) { // Employee ?>
<?php
if (!$Page->Employee->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Employee" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Employee->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Employee"
            name="x_Employee[]"
            class="form-control ew-select<?= $Page->Employee->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_Employee"
            data-table="masteruser"
            data-field="x_Employee"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Employee->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Employee->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Employee->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Employee->editAttributes() ?>>
            <?= $Page->Employee->selectOptionListHtml("x_Employee", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Employee->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_Employee",
                selectId: "fmasterusersrch_x_Employee",
                ajax: { id: "x_Employee", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.Employee.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->WhatsAppNumber->Visible) { // WhatsAppNumber ?>
<?php
if (!$Page->WhatsAppNumber->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_WhatsAppNumber" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->WhatsAppNumber->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_WhatsAppNumber"
            name="x_WhatsAppNumber[]"
            class="form-control ew-select<?= $Page->WhatsAppNumber->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_WhatsAppNumber"
            data-table="masteruser"
            data-field="x_WhatsAppNumber"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->WhatsAppNumber->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->WhatsAppNumber->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->WhatsAppNumber->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->WhatsAppNumber->editAttributes() ?>>
            <?= $Page->WhatsAppNumber->selectOptionListHtml("x_WhatsAppNumber", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->WhatsAppNumber->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_WhatsAppNumber",
                selectId: "fmasterusersrch_x_WhatsAppNumber",
                ajax: { id: "x_WhatsAppNumber", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.WhatsAppNumber.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Active->Visible) { // Active ?>
<?php
if (!$Page->Active->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Active" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Active->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Active"
            name="x_Active[]"
            class="form-control ew-select<?= $Page->Active->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_Active"
            data-table="masteruser"
            data-field="x_Active"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Active->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Active->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Active->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Active->editAttributes() ?>>
            <?= $Page->Active->selectOptionListHtml("x_Active", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Active->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_Active",
                selectId: "fmasterusersrch_x_Active",
                ajax: { id: "x_Active", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.Active.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
<?php
if (!$Page->Created_Date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Created_Date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Created_Date->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Created_Date"
            name="x_Created_Date[]"
            class="form-control ew-select<?= $Page->Created_Date->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_Created_Date"
            data-table="masteruser"
            data-field="x_Created_Date"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Created_Date->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Created_Date->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Created_Date->editAttributes() ?>>
            <?= $Page->Created_Date->selectOptionListHtml("x_Created_Date", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_Created_Date",
                selectId: "fmasterusersrch_x_Created_Date",
                ajax: { id: "x_Created_Date", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.Created_Date.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
<?php
if (!$Page->Created_By->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Created_By" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Created_By->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Created_By"
            name="x_Created_By[]"
            class="form-control ew-select<?= $Page->Created_By->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_Created_By"
            data-table="masteruser"
            data-field="x_Created_By"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Created_By->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Created_By->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Created_By->editAttributes() ?>>
            <?= $Page->Created_By->selectOptionListHtml("x_Created_By", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_Created_By",
                selectId: "fmasterusersrch_x_Created_By",
                ajax: { id: "x_Created_By", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.Created_By.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
<?php
if (!$Page->Last_Updated_Date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Last_Updated_Date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Last_Updated_Date->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Last_Updated_Date"
            name="x_Last_Updated_Date[]"
            class="form-control ew-select<?= $Page->Last_Updated_Date->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_Last_Updated_Date"
            data-table="masteruser"
            data-field="x_Last_Updated_Date"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Last_Updated_Date->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Last_Updated_Date->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Last_Updated_Date->editAttributes() ?>>
            <?= $Page->Last_Updated_Date->selectOptionListHtml("x_Last_Updated_Date", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_Last_Updated_Date",
                selectId: "fmasterusersrch_x_Last_Updated_Date",
                ajax: { id: "x_Last_Updated_Date", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.Last_Updated_Date.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
<?php
if (!$Page->Last_Updated_By->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Last_Updated_By" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Last_Updated_By->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Last_Updated_By"
            name="x_Last_Updated_By[]"
            class="form-control ew-select<?= $Page->Last_Updated_By->isInvalidClass() ?>"
            data-select2-id="fmasterusersrch_x_Last_Updated_By"
            data-table="masteruser"
            data-field="x_Last_Updated_By"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Last_Updated_By->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Last_Updated_By->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Last_Updated_By->editAttributes() ?>>
            <?= $Page->Last_Updated_By->selectOptionListHtml("x_Last_Updated_By", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fmasterusersrch", function() {
            var options = {
                name: "x_Last_Updated_By",
                selectId: "fmasterusersrch_x_Last_Updated_By",
                ajax: { id: "x_Last_Updated_By", form: "fmasterusersrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.masteruser.fields.Last_Updated_By.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fmasterusersrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fmasterusersrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fmasterusersrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fmasterusersrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fmasterusersrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fmasterusersrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fmasterusersrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="masteruser">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_masteruser" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_masteruserlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->FirstName->Visible) { // FirstName ?>
        <th data-name="FirstName" class="<?= $Page->FirstName->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_FirstName" class="masteruser_FirstName"><?= $Page->renderFieldHeader($Page->FirstName) ?></div></th>
<?php } ?>
<?php if ($Page->LastName->Visible) { // LastName ?>
        <th data-name="LastName" class="<?= $Page->LastName->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_LastName" class="masteruser_LastName"><?= $Page->renderFieldHeader($Page->LastName) ?></div></th>
<?php } ?>
<?php if ($Page->FullName->Visible) { // FullName ?>
        <th data-name="FullName" class="<?= $Page->FullName->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_FullName" class="masteruser_FullName"><?= $Page->renderFieldHeader($Page->FullName) ?></div></th>
<?php } ?>
<?php if ($Page->_Username->Visible) { // Username ?>
        <th data-name="_Username" class="<?= $Page->_Username->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser__Username" class="masteruser__Username"><?= $Page->renderFieldHeader($Page->_Username) ?></div></th>
<?php } ?>
<?php if ($Page->UserPassword->Visible) { // UserPassword ?>
        <th data-name="UserPassword" class="<?= $Page->UserPassword->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_UserPassword" class="masteruser_UserPassword"><?= $Page->renderFieldHeader($Page->UserPassword) ?></div></th>
<?php } ?>
<?php if ($Page->Level->Visible) { // Level ?>
        <th data-name="Level" class="<?= $Page->Level->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_Level" class="masteruser_Level"><?= $Page->renderFieldHeader($Page->Level) ?></div></th>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
        <th data-name="_Email" class="<?= $Page->_Email->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser__Email" class="masteruser__Email"><?= $Page->renderFieldHeader($Page->_Email) ?></div></th>
<?php } ?>
<?php if ($Page->Position->Visible) { // Position ?>
        <th data-name="Position" class="<?= $Page->Position->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_Position" class="masteruser_Position"><?= $Page->renderFieldHeader($Page->Position) ?></div></th>
<?php } ?>
<?php if ($Page->Department->Visible) { // Department ?>
        <th data-name="Department" class="<?= $Page->Department->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_Department" class="masteruser_Department"><?= $Page->renderFieldHeader($Page->Department) ?></div></th>
<?php } ?>
<?php if ($Page->Employee->Visible) { // Employee ?>
        <th data-name="Employee" class="<?= $Page->Employee->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_Employee" class="masteruser_Employee"><?= $Page->renderFieldHeader($Page->Employee) ?></div></th>
<?php } ?>
<?php if ($Page->WhatsAppNumber->Visible) { // WhatsAppNumber ?>
        <th data-name="WhatsAppNumber" class="<?= $Page->WhatsAppNumber->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_WhatsAppNumber" class="masteruser_WhatsAppNumber"><?= $Page->renderFieldHeader($Page->WhatsAppNumber) ?></div></th>
<?php } ?>
<?php if ($Page->Active->Visible) { // Active ?>
        <th data-name="Active" class="<?= $Page->Active->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_Active" class="masteruser_Active"><?= $Page->renderFieldHeader($Page->Active) ?></div></th>
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Page->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_Created_Date" class="masteruser_Created_Date"><?= $Page->renderFieldHeader($Page->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Page->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_Created_By" class="masteruser_Created_By"><?= $Page->renderFieldHeader($Page->Created_By) ?></div></th>
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Page->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_Last_Updated_Date" class="masteruser_Last_Updated_Date"><?= $Page->renderFieldHeader($Page->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Page->Last_Updated_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_masteruser_Last_Updated_By" class="masteruser_Last_Updated_By"><?= $Page->renderFieldHeader($Page->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->FirstName->Visible) { // FirstName ?>
        <td data-name="FirstName"<?= $Page->FirstName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_FirstName" class="el_masteruser_FirstName">
<span<?= $Page->FirstName->viewAttributes() ?>>
<?= $Page->FirstName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->LastName->Visible) { // LastName ?>
        <td data-name="LastName"<?= $Page->LastName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_LastName" class="el_masteruser_LastName">
<span<?= $Page->LastName->viewAttributes() ?>>
<?= $Page->LastName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->FullName->Visible) { // FullName ?>
        <td data-name="FullName"<?= $Page->FullName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_FullName" class="el_masteruser_FullName">
<span<?= $Page->FullName->viewAttributes() ?>>
<?= $Page->FullName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_Username->Visible) { // Username ?>
        <td data-name="_Username"<?= $Page->_Username->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser__Username" class="el_masteruser__Username">
<span<?= $Page->_Username->viewAttributes() ?>>
<?= $Page->_Username->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->UserPassword->Visible) { // UserPassword ?>
        <td data-name="UserPassword"<?= $Page->UserPassword->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_UserPassword" class="el_masteruser_UserPassword">
<span<?= $Page->UserPassword->viewAttributes() ?>>
<?= $Page->UserPassword->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Level->Visible) { // Level ?>
        <td data-name="Level"<?= $Page->Level->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_Level" class="el_masteruser_Level">
<span<?= $Page->Level->viewAttributes() ?>>
<?= $Page->Level->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_Email->Visible) { // Email ?>
        <td data-name="_Email"<?= $Page->_Email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser__Email" class="el_masteruser__Email">
<span<?= $Page->_Email->viewAttributes() ?>>
<?= $Page->_Email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Position->Visible) { // Position ?>
        <td data-name="Position"<?= $Page->Position->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_Position" class="el_masteruser_Position">
<span<?= $Page->Position->viewAttributes() ?>>
<?= $Page->Position->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Department->Visible) { // Department ?>
        <td data-name="Department"<?= $Page->Department->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_Department" class="el_masteruser_Department">
<span<?= $Page->Department->viewAttributes() ?>>
<?= $Page->Department->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Employee->Visible) { // Employee ?>
        <td data-name="Employee"<?= $Page->Employee->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_Employee" class="el_masteruser_Employee">
<span<?= $Page->Employee->viewAttributes() ?>>
<i class="fa-regular fa-square<?php if (ConvertToBool($Page->Employee->CurrentValue)) { ?>-check<?php } ?> ew-icon ew-boolean"></i>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->WhatsAppNumber->Visible) { // WhatsAppNumber ?>
        <td data-name="WhatsAppNumber"<?= $Page->WhatsAppNumber->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_WhatsAppNumber" class="el_masteruser_WhatsAppNumber">
<span<?= $Page->WhatsAppNumber->viewAttributes() ?>>
<?= $Page->WhatsAppNumber->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Active->Visible) { // Active ?>
        <td data-name="Active"<?= $Page->Active->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_Active" class="el_masteruser_Active">
<span<?= $Page->Active->viewAttributes() ?>>
<i class="fa-regular fa-square<?php if (ConvertToBool($Page->Active->CurrentValue)) { ?>-check<?php } ?> ew-icon ew-boolean"></i>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Page->Created_Date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_Created_Date" class="el_masteruser_Created_Date">
<span<?= $Page->Created_Date->viewAttributes() ?>>
<?= $Page->Created_Date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Page->Created_By->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_Created_By" class="el_masteruser_Created_By">
<span<?= $Page->Created_By->viewAttributes() ?>>
<?= $Page->Created_By->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Page->Last_Updated_Date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_Last_Updated_Date" class="el_masteruser_Last_Updated_Date">
<span<?= $Page->Last_Updated_Date->viewAttributes() ?>>
<?= $Page->Last_Updated_Date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Page->Last_Updated_By->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_masteruser_Last_Updated_By" class="el_masteruser_Last_Updated_By">
<span<?= $Page->Last_Updated_By->viewAttributes() ?>>
<?= $Page->Last_Updated_By->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masteruser");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
