<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$ProjectdocumentsSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { projectdocuments: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprojectdocumentssearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprojectdocumentssearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["DocID", [ew.Validators.integer], fields.DocID.isInvalid],
            ["DocDate", [ew.Validators.datetime(fields.DocDate.clientFormatPattern)], fields.DocDate.isInvalid],
            ["y_DocDate", [ew.Validators.between], false],
            ["DocumentTitle", [], fields.DocumentTitle.isInvalid],
            ["DocumentFile", [], fields.DocumentFile.isInvalid],
            ["DocumentType", [], fields.DocumentType.isInvalid],
            ["_ProjectID", [], fields._ProjectID.isInvalid],
            ["Created_Date", [], fields.Created_Date.isInvalid],
            ["y_Created_Date", [ew.Validators.between], false],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [], fields.Last_Updated_Date.isInvalid],
            ["y_Last_Updated_Date", [ew.Validators.between], false],
            ["Last_Updated_By", [], fields.Last_Updated_By.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "DocumentType": <?= $Page->DocumentType->toClientList($Page) ?>,
            "_ProjectID": <?= $Page->_ProjectID->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprojectdocumentssearch" id="fprojectdocumentssearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("projectdocumentslist")) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="projectdocuments">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_projectdocuments_DocID" class="projectdocumentssearch"><span id="el_projectdocuments_DocID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DocID->getInputTextType() ?>" name="x_DocID" id="x_DocID" data-table="projectdocuments" data-field="x_DocID" value="<?= $Page->DocID->EditValue ?>" placeholder="<?= HtmlEncode($Page->DocID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DocID->formatPattern()) ?>"<?= $Page->DocID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DocID->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projectdocuments_DocDate" class="projectdocumentssearch"><span id="el_projectdocuments_DocDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DocDate->getInputTextType() ?>" name="x_DocDate" id="x_DocDate" data-table="projectdocuments" data-field="x_DocDate" value="<?= $Page->DocDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->DocDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DocDate->formatPattern()) ?>"<?= $Page->DocDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DocDate->getErrorMessage(false) ?></div>
<?php if (!$Page->DocDate->ReadOnly && !$Page->DocDate->Disabled && !isset($Page->DocDate->EditAttrs["readonly"]) && !isset($Page->DocDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectdocumentssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectdocumentssearch", "x_DocDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projectdocuments_DocumentTitle" class="projectdocumentssearch"><span id="el_projectdocuments_DocumentTitle" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DocumentTitle->getInputTextType() ?>" name="x_DocumentTitle" id="x_DocumentTitle" data-table="projectdocuments" data-field="x_DocumentTitle" value="<?= $Page->DocumentTitle->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->DocumentTitle->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DocumentTitle->formatPattern()) ?>"<?= $Page->DocumentTitle->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DocumentTitle->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projectdocuments_DocumentFile" class="projectdocumentssearch"><span id="el_projectdocuments_DocumentFile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DocumentFile->getInputTextType() ?>" name="x_DocumentFile" id="x_DocumentFile" data-table="projectdocuments" data-field="x_DocumentFile" value="<?= $Page->DocumentFile->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->DocumentFile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DocumentFile->formatPattern()) ?>"<?= $Page->DocumentFile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DocumentFile->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projectdocuments_DocumentType" class="projectdocumentssearch"><span id="el_projectdocuments_DocumentType" class="ew-search-field ew-search-field-single">
    <select
        id="x_DocumentType"
        name="x_DocumentType"
        class="form-select ew-select<?= $Page->DocumentType->isInvalidClass() ?>"
        <?php if (!$Page->DocumentType->IsNativeSelect) { ?>
        data-select2-id="fprojectdocumentssearch_x_DocumentType"
        <?php } ?>
        data-table="projectdocuments"
        data-field="x_DocumentType"
        data-value-separator="<?= $Page->DocumentType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DocumentType->getPlaceHolder()) ?>"
        <?= $Page->DocumentType->editAttributes() ?>>
        <?= $Page->DocumentType->selectOptionListHtml("x_DocumentType") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->DocumentType->getErrorMessage(false) ?></div>
<?php if (!$Page->DocumentType->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectdocumentssearch", function() {
    var options = { name: "x_DocumentType", selectId: "fprojectdocumentssearch_x_DocumentType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectdocumentssearch.lists.DocumentType?.lookupOptions.length) {
        options.data = { id: "x_DocumentType", form: "fprojectdocumentssearch" };
    } else {
        options.ajax = { id: "x_DocumentType", form: "fprojectdocumentssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectdocuments.fields.DocumentType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projectdocuments__ProjectID" class="projectdocumentssearch"><span id="el_projectdocuments__ProjectID" class="ew-search-field ew-search-field-single">
    <select
        id="x__ProjectID"
        name="x__ProjectID"
        class="form-select ew-select<?= $Page->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectdocumentssearch_x__ProjectID"
        <?php } ?>
        data-table="projectdocuments"
        data-field="x__ProjectID"
        data-value-separator="<?= $Page->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_ProjectID->getPlaceHolder()) ?>"
        <?= $Page->_ProjectID->editAttributes() ?>>
        <?= $Page->_ProjectID->selectOptionListHtml("x__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_ProjectID->getErrorMessage(false) ?></div>
<?= $Page->_ProjectID->Lookup->getParamTag($Page, "p_x__ProjectID") ?>
<?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectdocumentssearch", function() {
    var options = { name: "x__ProjectID", selectId: "fprojectdocumentssearch_x__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectdocumentssearch.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x__ProjectID", form: "fprojectdocumentssearch" };
    } else {
        options.ajax = { id: "x__ProjectID", form: "fprojectdocumentssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectdocuments.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projectdocuments_Created_Date" class="projectdocumentssearch"><span id="el_projectdocuments_Created_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="x_Created_Date" id="x_Created_Date" data-table="projectdocuments" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectdocumentssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectdocumentssearch", "x_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projectdocuments_Created_By" class="projectdocumentssearch"><span id="el_projectdocuments_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="projectdocuments" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projectdocuments_Last_Updated_Date" class="projectdocumentssearch"><span id="el_projectdocuments_Last_Updated_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="x_Last_Updated_Date" id="x_Last_Updated_Date" data-table="projectdocuments" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectdocumentssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectdocumentssearch", "x_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projectdocuments_Last_Updated_By" class="projectdocumentssearch"><span id="el_projectdocuments_Last_Updated_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_By->getInputTextType() ?>" name="x_Last_Updated_By" id="x_Last_Updated_By" data-table="projectdocuments" data-field="x_Last_Updated_By" value="<?= $Page->Last_Updated_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_By->formatPattern()) ?>"<?= $Page->Last_Updated_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
</span></template>
<div id="projectdocuments_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "DocID",
                type: "integer",
                label: currentTable.fields.DocID.caption,
                operators: currentTable.fields.DocID.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectdocumentssearch.fields.DocID.validators),
                data: {
                    format: currentTable.fields.DocID.clientFormatPattern
                }
            },
            {
                id: "DocDate",
                type: "datetime",
                label: currentTable.fields.DocDate.caption,
                operators: currentTable.fields.DocDate.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojectdocumentssearch.fields.DocDate.validators),
                data: {
                    format: currentTable.fields.DocDate.clientFormatPattern
                }
            },
            {
                id: "DocumentTitle",
                type: "string",
                label: currentTable.fields.DocumentTitle.caption,
                operators: currentTable.fields.DocumentTitle.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojectdocumentssearch.fields.DocumentTitle.validators),
                data: {
                    format: currentTable.fields.DocumentTitle.clientFormatPattern
                }
            },
            {
                id: "DocumentFile",
                type: "string",
                label: currentTable.fields.DocumentFile.caption,
                operators: currentTable.fields.DocumentFile.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectdocumentssearch.fields.DocumentFile.validators),
                data: {
                    format: currentTable.fields.DocumentFile.clientFormatPattern
                }
            },
            {
                id: "DocumentType",
                type: "string",
                label: currentTable.fields.DocumentType.caption,
                operators: currentTable.fields.DocumentType.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprojectdocumentssearch.fields.DocumentType.validators),
                data: {
                    format: currentTable.fields.DocumentType.clientFormatPattern
                }
            },
            {
                id: "_ProjectID",
                type: "integer",
                label: currentTable.fields._ProjectID.caption,
                operators: currentTable.fields._ProjectID.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprojectdocumentssearch.fields._ProjectID.validators),
                data: {
                    format: currentTable.fields._ProjectID.clientFormatPattern
                }
            },
            {
                id: "Created_Date",
                type: "datetime",
                label: currentTable.fields.Created_Date.caption,
                operators: currentTable.fields.Created_Date.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectdocumentssearch.fields.Created_Date.validators),
                data: {
                    format: currentTable.fields.Created_Date.clientFormatPattern
                }
            },
            {
                id: "Created_By",
                type: "string",
                label: currentTable.fields.Created_By.caption,
                operators: currentTable.fields.Created_By.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectdocumentssearch.fields.Created_By.validators),
                data: {
                    format: currentTable.fields.Created_By.clientFormatPattern
                }
            },
            {
                id: "Last_Updated_Date",
                type: "datetime",
                label: currentTable.fields.Last_Updated_Date.caption,
                operators: currentTable.fields.Last_Updated_Date.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectdocumentssearch.fields.Last_Updated_Date.validators),
                data: {
                    format: currentTable.fields.Last_Updated_Date.clientFormatPattern
                }
            },
            {
                id: "Last_Updated_By",
                type: "string",
                label: currentTable.fields.Last_Updated_By.caption,
                operators: currentTable.fields.Last_Updated_By.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectdocumentssearch.fields.Last_Updated_By.validators),
                data: {
                    format: currentTable.fields.Last_Updated_By.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#projectdocuments_query_builder"),
        args = {},
        rules = ew.parseJson($("#fprojectdocumentssearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fprojectdocumentssearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fprojectdocumentssearch" formaction="<?= HtmlEncode(GetUrl("projectdocumentslist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprojectdocumentssearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fprojectdocumentssearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projectdocuments");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
