<?php

namespace ProjectManagement\prjProjectManagement;

// Set up and run Grid object
$Grid = Container("ProjectmemberGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fprojectmembergrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { projectmember: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fprojectmembergrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["EmployeeID", [fields.EmployeeID.visible && fields.EmployeeID.required ? ew.Validators.required(fields.EmployeeID.caption) : null], fields.EmployeeID.isInvalid],
            ["RoleID", [fields.RoleID.visible && fields.RoleID.required ? ew.Validators.required(fields.RoleID.caption) : null], fields.RoleID.isInvalid],
            ["_ProjectID", [fields._ProjectID.visible && fields._ProjectID.required ? ew.Validators.required(fields._ProjectID.caption) : null], fields._ProjectID.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["EmployeeID",false],["RoleID",false],["_ProjectID",false],["Created_Date",false],["Created_By",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "EmployeeID": <?= $Grid->EmployeeID->toClientList($Grid) ?>,
            "RoleID": <?= $Grid->RoleID->toClientList($Grid) ?>,
            "_ProjectID": <?= $Grid->_ProjectID->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="fprojectmembergrid" class="ew-form ew-list-form">
<div id="gmp_projectmember" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_projectmembergrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->EmployeeID->Visible) { // EmployeeID ?>
        <th data-name="EmployeeID" class="<?= $Grid->EmployeeID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmember_EmployeeID" class="projectmember_EmployeeID"><?= $Grid->renderFieldHeader($Grid->EmployeeID) ?></div></th>
<?php } ?>
<?php if ($Grid->RoleID->Visible) { // RoleID ?>
        <th data-name="RoleID" class="<?= $Grid->RoleID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmember_RoleID" class="projectmember_RoleID"><?= $Grid->renderFieldHeader($Grid->RoleID) ?></div></th>
<?php } ?>
<?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <th data-name="_ProjectID" class="<?= $Grid->_ProjectID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmember__ProjectID" class="projectmember__ProjectID"><?= $Grid->renderFieldHeader($Grid->_ProjectID) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Grid->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmember_Created_Date" class="projectmember_Created_Date"><?= $Grid->renderFieldHeader($Grid->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Grid->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmember_Created_By" class="projectmember_Created_By"><?= $Grid->renderFieldHeader($Grid->Created_By) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Grid->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmember_Last_Updated_Date" class="projectmember_Last_Updated_Date"><?= $Grid->renderFieldHeader($Grid->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Grid->Last_Updated_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmember_Last_Updated_By" class="projectmember_Last_Updated_By"><?= $Grid->renderFieldHeader($Grid->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->EmployeeID->Visible) { // EmployeeID ?>
        <td data-name="EmployeeID"<?= $Grid->EmployeeID->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_EmployeeID" class="el_projectmember_EmployeeID">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_EmployeeID"
        name="x<?= $Grid->RowIndex ?>_EmployeeID"
        class="form-select ew-select<?= $Grid->EmployeeID->isInvalidClass() ?>"
        <?php if (!$Grid->EmployeeID->IsNativeSelect) { ?>
        data-select2-id="fprojectmembergrid_x<?= $Grid->RowIndex ?>_EmployeeID"
        <?php } ?>
        data-table="projectmember"
        data-field="x_EmployeeID"
        data-value-separator="<?= $Grid->EmployeeID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->EmployeeID->getPlaceHolder()) ?>"
        <?= $Grid->EmployeeID->editAttributes() ?>>
        <?= $Grid->EmployeeID->selectOptionListHtml("x{$Grid->RowIndex}_EmployeeID") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "masteruser") && !$Grid->EmployeeID->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_EmployeeID" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->EmployeeID->caption() ?>" data-title="<?= $Grid->EmployeeID->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_EmployeeID" data-url="<?= GetUrl("masteruseraddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->EmployeeID->getErrorMessage() ?></div>
<?= $Grid->EmployeeID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_EmployeeID") ?>
<?php if (!$Grid->EmployeeID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectmembergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_EmployeeID", selectId: "fprojectmembergrid_x<?= $Grid->RowIndex ?>_EmployeeID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectmembergrid.lists.EmployeeID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_EmployeeID", form: "fprojectmembergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_EmployeeID", form: "fprojectmembergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectmember.fields.EmployeeID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projectmember" data-field="x_EmployeeID" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_EmployeeID" id="o<?= $Grid->RowIndex ?>_EmployeeID" value="<?= HtmlEncode($Grid->EmployeeID->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_EmployeeID" class="el_projectmember_EmployeeID">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_EmployeeID"
        name="x<?= $Grid->RowIndex ?>_EmployeeID"
        class="form-select ew-select<?= $Grid->EmployeeID->isInvalidClass() ?>"
        <?php if (!$Grid->EmployeeID->IsNativeSelect) { ?>
        data-select2-id="fprojectmembergrid_x<?= $Grid->RowIndex ?>_EmployeeID"
        <?php } ?>
        data-table="projectmember"
        data-field="x_EmployeeID"
        data-value-separator="<?= $Grid->EmployeeID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->EmployeeID->getPlaceHolder()) ?>"
        <?= $Grid->EmployeeID->editAttributes() ?>>
        <?= $Grid->EmployeeID->selectOptionListHtml("x{$Grid->RowIndex}_EmployeeID") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "masteruser") && !$Grid->EmployeeID->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_EmployeeID" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->EmployeeID->caption() ?>" data-title="<?= $Grid->EmployeeID->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_EmployeeID" data-url="<?= GetUrl("masteruseraddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->EmployeeID->getErrorMessage() ?></div>
<?= $Grid->EmployeeID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_EmployeeID") ?>
<?php if (!$Grid->EmployeeID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectmembergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_EmployeeID", selectId: "fprojectmembergrid_x<?= $Grid->RowIndex ?>_EmployeeID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectmembergrid.lists.EmployeeID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_EmployeeID", form: "fprojectmembergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_EmployeeID", form: "fprojectmembergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectmember.fields.EmployeeID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_EmployeeID" class="el_projectmember_EmployeeID">
<span<?= $Grid->EmployeeID->viewAttributes() ?>>
<?= $Grid->EmployeeID->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmember" data-field="x_EmployeeID" data-hidden="1" name="fprojectmembergrid$x<?= $Grid->RowIndex ?>_EmployeeID" id="fprojectmembergrid$x<?= $Grid->RowIndex ?>_EmployeeID" value="<?= HtmlEncode($Grid->EmployeeID->FormValue) ?>">
<input type="hidden" data-table="projectmember" data-field="x_EmployeeID" data-hidden="1" data-old name="fprojectmembergrid$o<?= $Grid->RowIndex ?>_EmployeeID" id="fprojectmembergrid$o<?= $Grid->RowIndex ?>_EmployeeID" value="<?= HtmlEncode($Grid->EmployeeID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->RoleID->Visible) { // RoleID ?>
        <td data-name="RoleID"<?= $Grid->RoleID->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_RoleID" class="el_projectmember_RoleID">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_RoleID"
        name="x<?= $Grid->RowIndex ?>_RoleID"
        class="form-select ew-select<?= $Grid->RoleID->isInvalidClass() ?>"
        <?php if (!$Grid->RoleID->IsNativeSelect) { ?>
        data-select2-id="fprojectmembergrid_x<?= $Grid->RowIndex ?>_RoleID"
        <?php } ?>
        data-table="projectmember"
        data-field="x_RoleID"
        data-value-separator="<?= $Grid->RoleID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->RoleID->getPlaceHolder()) ?>"
        <?= $Grid->RoleID->editAttributes() ?>>
        <?= $Grid->RoleID->selectOptionListHtml("x{$Grid->RowIndex}_RoleID") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "masterrole") && !$Grid->RoleID->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_RoleID" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->RoleID->caption() ?>" data-title="<?= $Grid->RoleID->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_RoleID" data-url="<?= GetUrl("masterroleaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->RoleID->getErrorMessage() ?></div>
<?= $Grid->RoleID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_RoleID") ?>
<?php if (!$Grid->RoleID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectmembergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_RoleID", selectId: "fprojectmembergrid_x<?= $Grid->RowIndex ?>_RoleID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectmembergrid.lists.RoleID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_RoleID", form: "fprojectmembergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_RoleID", form: "fprojectmembergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectmember.fields.RoleID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projectmember" data-field="x_RoleID" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_RoleID" id="o<?= $Grid->RowIndex ?>_RoleID" value="<?= HtmlEncode($Grid->RoleID->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_RoleID" class="el_projectmember_RoleID">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_RoleID"
        name="x<?= $Grid->RowIndex ?>_RoleID"
        class="form-select ew-select<?= $Grid->RoleID->isInvalidClass() ?>"
        <?php if (!$Grid->RoleID->IsNativeSelect) { ?>
        data-select2-id="fprojectmembergrid_x<?= $Grid->RowIndex ?>_RoleID"
        <?php } ?>
        data-table="projectmember"
        data-field="x_RoleID"
        data-value-separator="<?= $Grid->RoleID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->RoleID->getPlaceHolder()) ?>"
        <?= $Grid->RoleID->editAttributes() ?>>
        <?= $Grid->RoleID->selectOptionListHtml("x{$Grid->RowIndex}_RoleID") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "masterrole") && !$Grid->RoleID->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_RoleID" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->RoleID->caption() ?>" data-title="<?= $Grid->RoleID->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_RoleID" data-url="<?= GetUrl("masterroleaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->RoleID->getErrorMessage() ?></div>
<?= $Grid->RoleID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_RoleID") ?>
<?php if (!$Grid->RoleID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectmembergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_RoleID", selectId: "fprojectmembergrid_x<?= $Grid->RowIndex ?>_RoleID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectmembergrid.lists.RoleID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_RoleID", form: "fprojectmembergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_RoleID", form: "fprojectmembergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectmember.fields.RoleID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_RoleID" class="el_projectmember_RoleID">
<span<?= $Grid->RoleID->viewAttributes() ?>>
<?= $Grid->RoleID->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmember" data-field="x_RoleID" data-hidden="1" name="fprojectmembergrid$x<?= $Grid->RowIndex ?>_RoleID" id="fprojectmembergrid$x<?= $Grid->RowIndex ?>_RoleID" value="<?= HtmlEncode($Grid->RoleID->FormValue) ?>">
<input type="hidden" data-table="projectmember" data-field="x_RoleID" data-hidden="1" data-old name="fprojectmembergrid$o<?= $Grid->RowIndex ?>_RoleID" id="fprojectmembergrid$o<?= $Grid->RowIndex ?>_RoleID" value="<?= HtmlEncode($Grid->RoleID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <td data-name="_ProjectID"<?= $Grid->_ProjectID->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember__ProjectID" class="el_projectmember__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectmembergrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projectmember"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectmembergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojectmembergrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectmembergrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectmembergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectmembergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectmember.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="projectmember" data-field="x__ProjectID" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__ProjectID" id="o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember__ProjectID" class="el_projectmember__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectmembergrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projectmember"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectmembergrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojectmembergrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectmembergrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectmembergrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectmembergrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectmember.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember__ProjectID" class="el_projectmember__ProjectID">
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<?= $Grid->_ProjectID->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmember" data-field="x__ProjectID" data-hidden="1" name="fprojectmembergrid$x<?= $Grid->RowIndex ?>__ProjectID" id="fprojectmembergrid$x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->FormValue) ?>">
<input type="hidden" data-table="projectmember" data-field="x__ProjectID" data-hidden="1" data-old name="fprojectmembergrid$o<?= $Grid->RowIndex ?>__ProjectID" id="fprojectmembergrid$o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Grid->Created_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_Created_Date" class="el_projectmember_Created_Date">
<input type="hidden" data-table="projectmember" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projectmember" data-field="x_Created_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_Date" id="o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_Created_Date" class="el_projectmember_Created_Date">
<input type="hidden" data-table="projectmember" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_Created_Date" class="el_projectmember_Created_Date">
<span<?= $Grid->Created_Date->viewAttributes() ?>>
<?= $Grid->Created_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmember" data-field="x_Created_Date" data-hidden="1" name="fprojectmembergrid$x<?= $Grid->RowIndex ?>_Created_Date" id="fprojectmembergrid$x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->FormValue) ?>">
<input type="hidden" data-table="projectmember" data-field="x_Created_Date" data-hidden="1" data-old name="fprojectmembergrid$o<?= $Grid->RowIndex ?>_Created_Date" id="fprojectmembergrid$o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Grid->Created_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_Created_By" class="el_projectmember_Created_By">
<input type="hidden" data-table="projectmember" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projectmember" data-field="x_Created_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_By" id="o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_Created_By" class="el_projectmember_Created_By">
<input type="hidden" data-table="projectmember" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_Created_By" class="el_projectmember_Created_By">
<span<?= $Grid->Created_By->viewAttributes() ?>>
<?= $Grid->Created_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmember" data-field="x_Created_By" data-hidden="1" name="fprojectmembergrid$x<?= $Grid->RowIndex ?>_Created_By" id="fprojectmembergrid$x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->FormValue) ?>">
<input type="hidden" data-table="projectmember" data-field="x_Created_By" data-hidden="1" data-old name="fprojectmembergrid$o<?= $Grid->RowIndex ?>_Created_By" id="fprojectmembergrid$o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Grid->Last_Updated_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projectmember" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_Last_Updated_Date" class="el_projectmember_Last_Updated_Date">
<span<?= $Grid->Last_Updated_Date->viewAttributes() ?>>
<?= $Grid->Last_Updated_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmember" data-field="x_Last_Updated_Date" data-hidden="1" name="fprojectmembergrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojectmembergrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->FormValue) ?>">
<input type="hidden" data-table="projectmember" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="fprojectmembergrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojectmembergrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Grid->Last_Updated_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projectmember" data-field="x_Last_Updated_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_By" id="o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmember_Last_Updated_By" class="el_projectmember_Last_Updated_By">
<span<?= $Grid->Last_Updated_By->viewAttributes() ?>>
<?= $Grid->Last_Updated_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmember" data-field="x_Last_Updated_By" data-hidden="1" name="fprojectmembergrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojectmembergrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->FormValue) ?>">
<input type="hidden" data-table="projectmember" data-field="x_Last_Updated_By" data-hidden="1" data-old name="fprojectmembergrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojectmembergrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fprojectmembergrid","load"], () => fprojectmembergrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fprojectmembergrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projectmember");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
