<?php

namespace ProjectManagement\prjProjectManagement;

// Set up and run Grid object
$Grid = Container("ProjectmomGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fprojectmomgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { projectmom: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fprojectmomgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["MomDate", [fields.MomDate.visible && fields.MomDate.required ? ew.Validators.required(fields.MomDate.caption) : null, ew.Validators.datetime(fields.MomDate.clientFormatPattern)], fields.MomDate.isInvalid],
            ["MomTitle", [fields.MomTitle.visible && fields.MomTitle.required ? ew.Validators.required(fields.MomTitle.caption) : null], fields.MomTitle.isInvalid],
            ["Internal", [fields.Internal.visible && fields.Internal.required ? ew.Validators.required(fields.Internal.caption) : null], fields.Internal.isInvalid],
            ["_ProjectID", [fields._ProjectID.visible && fields._ProjectID.required ? ew.Validators.required(fields._ProjectID.caption) : null], fields._ProjectID.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["MomDate",false],["MomTitle",false],["Internal",true],["_ProjectID",false],["Created_Date",false],["Created_By",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Internal": <?= $Grid->Internal->toClientList($Grid) ?>,
            "_ProjectID": <?= $Grid->_ProjectID->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<div id="fprojectmomgrid" class="ew-form ew-list-form">
<div id="gmp_projectmom" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_projectmomgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->MomDate->Visible) { // MomDate ?>
        <th data-name="MomDate" class="<?= $Grid->MomDate->headerCellClass() ?>"><div id="elh_projectmom_MomDate" class="projectmom_MomDate"><?= $Grid->renderFieldHeader($Grid->MomDate) ?></div></th>
<?php } ?>
<?php if ($Grid->MomTitle->Visible) { // MomTitle ?>
        <th data-name="MomTitle" class="<?= $Grid->MomTitle->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmom_MomTitle" class="projectmom_MomTitle"><?= $Grid->renderFieldHeader($Grid->MomTitle) ?></div></th>
<?php } ?>
<?php if ($Grid->Internal->Visible) { // Internal ?>
        <th data-name="Internal" class="<?= $Grid->Internal->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmom_Internal" class="projectmom_Internal"><?= $Grid->renderFieldHeader($Grid->Internal) ?></div></th>
<?php } ?>
<?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <th data-name="_ProjectID" class="<?= $Grid->_ProjectID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmom__ProjectID" class="projectmom__ProjectID"><?= $Grid->renderFieldHeader($Grid->_ProjectID) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Grid->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmom_Created_Date" class="projectmom_Created_Date"><?= $Grid->renderFieldHeader($Grid->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Grid->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmom_Created_By" class="projectmom_Created_By"><?= $Grid->renderFieldHeader($Grid->Created_By) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Grid->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmom_Last_Updated_Date" class="projectmom_Last_Updated_Date"><?= $Grid->renderFieldHeader($Grid->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Grid->Last_Updated_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projectmom_Last_Updated_By" class="projectmom_Last_Updated_By"><?= $Grid->renderFieldHeader($Grid->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->MomDate->Visible) { // MomDate ?>
        <td data-name="MomDate"<?= $Grid->MomDate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_MomDate" class="el_projectmom_MomDate">
<input type="<?= $Grid->MomDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_MomDate" id="x<?= $Grid->RowIndex ?>_MomDate" data-table="projectmom" data-field="x_MomDate" value="<?= $Grid->MomDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->MomDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->MomDate->formatPattern()) ?>"<?= $Grid->MomDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->MomDate->getErrorMessage() ?></div>
<?php if (!$Grid->MomDate->ReadOnly && !$Grid->MomDate->Disabled && !isset($Grid->MomDate->EditAttrs["readonly"]) && !isset($Grid->MomDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectmomgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectmomgrid", "x<?= $Grid->RowIndex ?>_MomDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="projectmom" data-field="x_MomDate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_MomDate" id="o<?= $Grid->RowIndex ?>_MomDate" value="<?= HtmlEncode($Grid->MomDate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_MomDate" class="el_projectmom_MomDate">
<input type="<?= $Grid->MomDate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_MomDate" id="x<?= $Grid->RowIndex ?>_MomDate" data-table="projectmom" data-field="x_MomDate" value="<?= $Grid->MomDate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->MomDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->MomDate->formatPattern()) ?>"<?= $Grid->MomDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->MomDate->getErrorMessage() ?></div>
<?php if (!$Grid->MomDate->ReadOnly && !$Grid->MomDate->Disabled && !isset($Grid->MomDate->EditAttrs["readonly"]) && !isset($Grid->MomDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectmomgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectmomgrid", "x<?= $Grid->RowIndex ?>_MomDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_MomDate" class="el_projectmom_MomDate">
<span<?= $Grid->MomDate->viewAttributes() ?>>
<?= $Grid->MomDate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmom" data-field="x_MomDate" data-hidden="1" name="fprojectmomgrid$x<?= $Grid->RowIndex ?>_MomDate" id="fprojectmomgrid$x<?= $Grid->RowIndex ?>_MomDate" value="<?= HtmlEncode($Grid->MomDate->FormValue) ?>">
<input type="hidden" data-table="projectmom" data-field="x_MomDate" data-hidden="1" data-old name="fprojectmomgrid$o<?= $Grid->RowIndex ?>_MomDate" id="fprojectmomgrid$o<?= $Grid->RowIndex ?>_MomDate" value="<?= HtmlEncode($Grid->MomDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->MomTitle->Visible) { // MomTitle ?>
        <td data-name="MomTitle"<?= $Grid->MomTitle->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_MomTitle" class="el_projectmom_MomTitle">
<input type="<?= $Grid->MomTitle->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_MomTitle" id="x<?= $Grid->RowIndex ?>_MomTitle" data-table="projectmom" data-field="x_MomTitle" value="<?= $Grid->MomTitle->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Grid->MomTitle->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->MomTitle->formatPattern()) ?>"<?= $Grid->MomTitle->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->MomTitle->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="projectmom" data-field="x_MomTitle" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_MomTitle" id="o<?= $Grid->RowIndex ?>_MomTitle" value="<?= HtmlEncode($Grid->MomTitle->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_MomTitle" class="el_projectmom_MomTitle">
<input type="<?= $Grid->MomTitle->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_MomTitle" id="x<?= $Grid->RowIndex ?>_MomTitle" data-table="projectmom" data-field="x_MomTitle" value="<?= $Grid->MomTitle->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Grid->MomTitle->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->MomTitle->formatPattern()) ?>"<?= $Grid->MomTitle->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->MomTitle->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_MomTitle" class="el_projectmom_MomTitle">
<span<?= $Grid->MomTitle->viewAttributes() ?>>
<?= $Grid->MomTitle->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmom" data-field="x_MomTitle" data-hidden="1" name="fprojectmomgrid$x<?= $Grid->RowIndex ?>_MomTitle" id="fprojectmomgrid$x<?= $Grid->RowIndex ?>_MomTitle" value="<?= HtmlEncode($Grid->MomTitle->FormValue) ?>">
<input type="hidden" data-table="projectmom" data-field="x_MomTitle" data-hidden="1" data-old name="fprojectmomgrid$o<?= $Grid->RowIndex ?>_MomTitle" id="fprojectmomgrid$o<?= $Grid->RowIndex ?>_MomTitle" value="<?= HtmlEncode($Grid->MomTitle->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Internal->Visible) { // Internal ?>
        <td data-name="Internal"<?= $Grid->Internal->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_Internal" class="el_projectmom_Internal">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Grid->Internal->isInvalidClass() ?>" data-table="projectmom" data-field="x_Internal" data-boolean name="x<?= $Grid->RowIndex ?>_Internal" id="x<?= $Grid->RowIndex ?>_Internal" value="1"<?= ConvertToBool($Grid->Internal->CurrentValue) ? " checked" : "" ?><?= $Grid->Internal->editAttributes() ?>>
    <div class="invalid-feedback"><?= $Grid->Internal->getErrorMessage() ?></div>
</div>
</span>
<input type="hidden" data-table="projectmom" data-field="x_Internal" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Internal" id="o<?= $Grid->RowIndex ?>_Internal" value="<?= HtmlEncode($Grid->Internal->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_Internal" class="el_projectmom_Internal">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Grid->Internal->isInvalidClass() ?>" data-table="projectmom" data-field="x_Internal" data-boolean name="x<?= $Grid->RowIndex ?>_Internal" id="x<?= $Grid->RowIndex ?>_Internal" value="1"<?= ConvertToBool($Grid->Internal->CurrentValue) ? " checked" : "" ?><?= $Grid->Internal->editAttributes() ?>>
    <div class="invalid-feedback"><?= $Grid->Internal->getErrorMessage() ?></div>
</div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_Internal" class="el_projectmom_Internal">
<span<?= $Grid->Internal->viewAttributes() ?>>
<i class="fa-regular fa-square<?php if (ConvertToBool($Grid->Internal->CurrentValue)) { ?>-check<?php } ?> ew-icon ew-boolean"></i>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmom" data-field="x_Internal" data-hidden="1" name="fprojectmomgrid$x<?= $Grid->RowIndex ?>_Internal" id="fprojectmomgrid$x<?= $Grid->RowIndex ?>_Internal" value="<?= HtmlEncode($Grid->Internal->FormValue) ?>">
<input type="hidden" data-table="projectmom" data-field="x_Internal" data-hidden="1" data-old name="fprojectmomgrid$o<?= $Grid->RowIndex ?>_Internal" id="fprojectmomgrid$o<?= $Grid->RowIndex ?>_Internal" value="<?= HtmlEncode($Grid->Internal->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_ProjectID->Visible) { // ProjectID ?>
        <td data-name="_ProjectID"<?= $Grid->_ProjectID->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom__ProjectID" class="el_projectmom__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectmomgrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projectmom"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectmomgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojectmomgrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectmomgrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectmomgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectmomgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectmom.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="projectmom" data-field="x__ProjectID" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__ProjectID" id="o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->_ProjectID->getSessionValue() != "") { ?>
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_ProjectID->getDisplayValue($Grid->_ProjectID->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__ProjectID" name="x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom__ProjectID" class="el_projectmom__ProjectID">
    <select
        id="x<?= $Grid->RowIndex ?>__ProjectID"
        name="x<?= $Grid->RowIndex ?>__ProjectID"
        class="form-select ew-select<?= $Grid->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectmomgrid_x<?= $Grid->RowIndex ?>__ProjectID"
        <?php } ?>
        data-table="projectmom"
        data-field="x__ProjectID"
        data-value-separator="<?= $Grid->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_ProjectID->getPlaceHolder()) ?>"
        <?= $Grid->_ProjectID->editAttributes() ?>>
        <?= $Grid->_ProjectID->selectOptionListHtml("x{$Grid->RowIndex}__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_ProjectID->getErrorMessage() ?></div>
<?= $Grid->_ProjectID->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__ProjectID") ?>
<?php if (!$Grid->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectmomgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__ProjectID", selectId: "fprojectmomgrid_x<?= $Grid->RowIndex ?>__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectmomgrid.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectmomgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__ProjectID", form: "fprojectmomgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectmom.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom__ProjectID" class="el_projectmom__ProjectID">
<span<?= $Grid->_ProjectID->viewAttributes() ?>>
<?= $Grid->_ProjectID->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmom" data-field="x__ProjectID" data-hidden="1" name="fprojectmomgrid$x<?= $Grid->RowIndex ?>__ProjectID" id="fprojectmomgrid$x<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->FormValue) ?>">
<input type="hidden" data-table="projectmom" data-field="x__ProjectID" data-hidden="1" data-old name="fprojectmomgrid$o<?= $Grid->RowIndex ?>__ProjectID" id="fprojectmomgrid$o<?= $Grid->RowIndex ?>__ProjectID" value="<?= HtmlEncode($Grid->_ProjectID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Grid->Created_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_Created_Date" class="el_projectmom_Created_Date">
<input type="hidden" data-table="projectmom" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projectmom" data-field="x_Created_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_Date" id="o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_Created_Date" class="el_projectmom_Created_Date">
<input type="hidden" data-table="projectmom" data-field="x_Created_Date" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_Date" id="x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_Created_Date" class="el_projectmom_Created_Date">
<span<?= $Grid->Created_Date->viewAttributes() ?>>
<?= $Grid->Created_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmom" data-field="x_Created_Date" data-hidden="1" name="fprojectmomgrid$x<?= $Grid->RowIndex ?>_Created_Date" id="fprojectmomgrid$x<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->FormValue) ?>">
<input type="hidden" data-table="projectmom" data-field="x_Created_Date" data-hidden="1" data-old name="fprojectmomgrid$o<?= $Grid->RowIndex ?>_Created_Date" id="fprojectmomgrid$o<?= $Grid->RowIndex ?>_Created_Date" value="<?= HtmlEncode($Grid->Created_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Grid->Created_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_Created_By" class="el_projectmom_Created_By">
<input type="hidden" data-table="projectmom" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<input type="hidden" data-table="projectmom" data-field="x_Created_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Created_By" id="o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_Created_By" class="el_projectmom_Created_By">
<input type="hidden" data-table="projectmom" data-field="x_Created_By" data-hidden="1" name="x<?= $Grid->RowIndex ?>_Created_By" id="x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_Created_By" class="el_projectmom_Created_By">
<span<?= $Grid->Created_By->viewAttributes() ?>>
<?= $Grid->Created_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmom" data-field="x_Created_By" data-hidden="1" name="fprojectmomgrid$x<?= $Grid->RowIndex ?>_Created_By" id="fprojectmomgrid$x<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->FormValue) ?>">
<input type="hidden" data-table="projectmom" data-field="x_Created_By" data-hidden="1" data-old name="fprojectmomgrid$o<?= $Grid->RowIndex ?>_Created_By" id="fprojectmomgrid$o<?= $Grid->RowIndex ?>_Created_By" value="<?= HtmlEncode($Grid->Created_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Grid->Last_Updated_Date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projectmom" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_Last_Updated_Date" class="el_projectmom_Last_Updated_Date">
<span<?= $Grid->Last_Updated_Date->viewAttributes() ?>>
<?= $Grid->Last_Updated_Date->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmom" data-field="x_Last_Updated_Date" data-hidden="1" name="fprojectmomgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojectmomgrid$x<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->FormValue) ?>">
<input type="hidden" data-table="projectmom" data-field="x_Last_Updated_Date" data-hidden="1" data-old name="fprojectmomgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" id="fprojectmomgrid$o<?= $Grid->RowIndex ?>_Last_Updated_Date" value="<?= HtmlEncode($Grid->Last_Updated_Date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Grid->Last_Updated_By->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="projectmom" data-field="x_Last_Updated_By" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Last_Updated_By" id="o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_projectmom_Last_Updated_By" class="el_projectmom_Last_Updated_By">
<span<?= $Grid->Last_Updated_By->viewAttributes() ?>>
<?= $Grid->Last_Updated_By->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="projectmom" data-field="x_Last_Updated_By" data-hidden="1" name="fprojectmomgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojectmomgrid$x<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->FormValue) ?>">
<input type="hidden" data-table="projectmom" data-field="x_Last_Updated_By" data-hidden="1" data-old name="fprojectmomgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" id="fprojectmomgrid$o<?= $Grid->RowIndex ?>_Last_Updated_By" value="<?= HtmlEncode($Grid->Last_Updated_By->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fprojectmomgrid","load"], () => fprojectmomgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fprojectmomgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projectmom");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
