<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$ProjectproblemsSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { projectproblems: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprojectproblemssearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprojectproblemssearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ProblemId", [ew.Validators.integer], fields.ProblemId.isInvalid],
            ["ProblemDate", [ew.Validators.datetime(fields.ProblemDate.clientFormatPattern)], fields.ProblemDate.isInvalid],
            ["y_ProblemDate", [ew.Validators.between], false],
            ["ProblemDescription", [], fields.ProblemDescription.isInvalid],
            ["SolutionDescription", [], fields.SolutionDescription.isInvalid],
            ["AriseById", [], fields.AriseById.isInvalid],
            ["SolvedById", [], fields.SolvedById.isInvalid],
            ["_ProjectID", [], fields._ProjectID.isInvalid],
            ["Created_Date", [], fields.Created_Date.isInvalid],
            ["y_Created_Date", [ew.Validators.between], false],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [], fields.Last_Updated_Date.isInvalid],
            ["y_Last_Updated_Date", [ew.Validators.between], false],
            ["Last_Updated_By", [], fields.Last_Updated_By.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "AriseById": <?= $Page->AriseById->toClientList($Page) ?>,
            "SolvedById": <?= $Page->SolvedById->toClientList($Page) ?>,
            "_ProjectID": <?= $Page->_ProjectID->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprojectproblemssearch" id="fprojectproblemssearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="projectproblems">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->ProblemId->Visible) { // ProblemId ?>
    <div id="r_ProblemId" class="row"<?= $Page->ProblemId->rowAttributes() ?>>
        <label for="x_ProblemId" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectproblems_ProblemId"><?= $Page->ProblemId->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ProblemId" id="z_ProblemId" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProblemId->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectproblems_ProblemId" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ProblemId->getInputTextType() ?>" name="x_ProblemId" id="x_ProblemId" data-table="projectproblems" data-field="x_ProblemId" value="<?= $Page->ProblemId->EditValue ?>" placeholder="<?= HtmlEncode($Page->ProblemId->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProblemId->formatPattern()) ?>"<?= $Page->ProblemId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProblemId->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ProblemDate->Visible) { // ProblemDate ?>
    <div id="r_ProblemDate" class="row"<?= $Page->ProblemDate->rowAttributes() ?>>
        <label for="x_ProblemDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectproblems_ProblemDate"><?= $Page->ProblemDate->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProblemDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_ProblemDate" id="z_ProblemDate" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->ProblemDate->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->ProblemDate->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projectproblems_ProblemDate" class="ew-search-field">
<input type="<?= $Page->ProblemDate->getInputTextType() ?>" name="x_ProblemDate" id="x_ProblemDate" data-table="projectproblems" data-field="x_ProblemDate" value="<?= $Page->ProblemDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->ProblemDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProblemDate->formatPattern()) ?>"<?= $Page->ProblemDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProblemDate->getErrorMessage(false) ?></div>
<?php if (!$Page->ProblemDate->ReadOnly && !$Page->ProblemDate->Disabled && !isset($Page->ProblemDate->EditAttrs["readonly"]) && !isset($Page->ProblemDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectproblemssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectproblemssearch", "x_ProblemDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projectproblems_ProblemDate" class="ew-search-field2 d-none">
<input type="<?= $Page->ProblemDate->getInputTextType() ?>" name="y_ProblemDate" id="y_ProblemDate" data-table="projectproblems" data-field="x_ProblemDate" value="<?= $Page->ProblemDate->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->ProblemDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProblemDate->formatPattern()) ?>"<?= $Page->ProblemDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProblemDate->getErrorMessage(false) ?></div>
<?php if (!$Page->ProblemDate->ReadOnly && !$Page->ProblemDate->Disabled && !isset($Page->ProblemDate->EditAttrs["readonly"]) && !isset($Page->ProblemDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectproblemssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectproblemssearch", "y_ProblemDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ProblemDescription->Visible) { // ProblemDescription ?>
    <div id="r_ProblemDescription" class="row"<?= $Page->ProblemDescription->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectproblems_ProblemDescription"><?= $Page->ProblemDescription->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ProblemDescription" id="z_ProblemDescription" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ProblemDescription->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectproblems_ProblemDescription" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ProblemDescription->getInputTextType() ?>" name="x_ProblemDescription" id="x_ProblemDescription" data-table="projectproblems" data-field="x_ProblemDescription" value="<?= $Page->ProblemDescription->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->ProblemDescription->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProblemDescription->formatPattern()) ?>"<?= $Page->ProblemDescription->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ProblemDescription->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SolutionDescription->Visible) { // SolutionDescription ?>
    <div id="r_SolutionDescription" class="row"<?= $Page->SolutionDescription->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectproblems_SolutionDescription"><?= $Page->SolutionDescription->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_SolutionDescription" id="z_SolutionDescription" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SolutionDescription->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectproblems_SolutionDescription" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->SolutionDescription->getInputTextType() ?>" name="x_SolutionDescription" id="x_SolutionDescription" data-table="projectproblems" data-field="x_SolutionDescription" value="<?= $Page->SolutionDescription->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->SolutionDescription->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->SolutionDescription->formatPattern()) ?>"<?= $Page->SolutionDescription->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->SolutionDescription->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->AriseById->Visible) { // AriseById ?>
    <div id="r_AriseById" class="row"<?= $Page->AriseById->rowAttributes() ?>>
        <label for="x_AriseById" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectproblems_AriseById"><?= $Page->AriseById->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_AriseById" id="z_AriseById" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->AriseById->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectproblems_AriseById" class="ew-search-field ew-search-field-single">
    <select
        id="x_AriseById"
        name="x_AriseById"
        class="form-select ew-select<?= $Page->AriseById->isInvalidClass() ?>"
        <?php if (!$Page->AriseById->IsNativeSelect) { ?>
        data-select2-id="fprojectproblemssearch_x_AriseById"
        <?php } ?>
        data-table="projectproblems"
        data-field="x_AriseById"
        data-value-separator="<?= $Page->AriseById->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->AriseById->getPlaceHolder()) ?>"
        <?= $Page->AriseById->editAttributes() ?>>
        <?= $Page->AriseById->selectOptionListHtml("x_AriseById") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->AriseById->getErrorMessage(false) ?></div>
<?= $Page->AriseById->Lookup->getParamTag($Page, "p_x_AriseById") ?>
<?php if (!$Page->AriseById->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectproblemssearch", function() {
    var options = { name: "x_AriseById", selectId: "fprojectproblemssearch_x_AriseById" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectproblemssearch.lists.AriseById?.lookupOptions.length) {
        options.data = { id: "x_AriseById", form: "fprojectproblemssearch" };
    } else {
        options.ajax = { id: "x_AriseById", form: "fprojectproblemssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectproblems.fields.AriseById.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->SolvedById->Visible) { // SolvedById ?>
    <div id="r_SolvedById" class="row"<?= $Page->SolvedById->rowAttributes() ?>>
        <label for="x_SolvedById" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectproblems_SolvedById"><?= $Page->SolvedById->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_SolvedById" id="z_SolvedById" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->SolvedById->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectproblems_SolvedById" class="ew-search-field ew-search-field-single">
    <select
        id="x_SolvedById"
        name="x_SolvedById"
        class="form-select ew-select<?= $Page->SolvedById->isInvalidClass() ?>"
        <?php if (!$Page->SolvedById->IsNativeSelect) { ?>
        data-select2-id="fprojectproblemssearch_x_SolvedById"
        <?php } ?>
        data-table="projectproblems"
        data-field="x_SolvedById"
        data-value-separator="<?= $Page->SolvedById->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SolvedById->getPlaceHolder()) ?>"
        <?= $Page->SolvedById->editAttributes() ?>>
        <?= $Page->SolvedById->selectOptionListHtml("x_SolvedById") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->SolvedById->getErrorMessage(false) ?></div>
<?= $Page->SolvedById->Lookup->getParamTag($Page, "p_x_SolvedById") ?>
<?php if (!$Page->SolvedById->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectproblemssearch", function() {
    var options = { name: "x_SolvedById", selectId: "fprojectproblemssearch_x_SolvedById" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectproblemssearch.lists.SolvedById?.lookupOptions.length) {
        options.data = { id: "x_SolvedById", form: "fprojectproblemssearch" };
    } else {
        options.ajax = { id: "x_SolvedById", form: "fprojectproblemssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectproblems.fields.SolvedById.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_ProjectID->Visible) { // ProjectID ?>
    <div id="r__ProjectID" class="row"<?= $Page->_ProjectID->rowAttributes() ?>>
        <label for="x__ProjectID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectproblems__ProjectID"><?= $Page->_ProjectID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__ProjectID" id="z__ProjectID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_ProjectID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectproblems__ProjectID" class="ew-search-field ew-search-field-single">
    <select
        id="x__ProjectID"
        name="x__ProjectID"
        class="form-select ew-select<?= $Page->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectproblemssearch_x__ProjectID"
        <?php } ?>
        data-table="projectproblems"
        data-field="x__ProjectID"
        data-value-separator="<?= $Page->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_ProjectID->getPlaceHolder()) ?>"
        <?= $Page->_ProjectID->editAttributes() ?>>
        <?= $Page->_ProjectID->selectOptionListHtml("x__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_ProjectID->getErrorMessage(false) ?></div>
<?= $Page->_ProjectID->Lookup->getParamTag($Page, "p_x__ProjectID") ?>
<?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectproblemssearch", function() {
    var options = { name: "x__ProjectID", selectId: "fprojectproblemssearch_x__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectproblemssearch.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x__ProjectID", form: "fprojectproblemssearch" };
    } else {
        options.ajax = { id: "x__ProjectID", form: "fprojectproblemssearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectproblems.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
    <div id="r_Created_Date" class="row"<?= $Page->Created_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectproblems_Created_Date"><?= $Page->Created_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Created_Date" id="z_Created_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Created_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Created_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projectproblems_Created_Date" class="ew-search-field">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="x_Created_Date" id="x_Created_Date" data-table="projectproblems" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectproblemssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectproblemssearch", "x_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projectproblems_Created_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="y_Created_Date" id="y_Created_Date" data-table="projectproblems" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectproblemssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectproblemssearch", "y_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
    <div id="r_Created_By" class="row"<?= $Page->Created_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectproblems_Created_By"><?= $Page->Created_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Created_By" id="z_Created_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectproblems_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="projectproblems" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
    <div id="r_Last_Updated_Date" class="row"<?= $Page->Last_Updated_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectproblems_Last_Updated_Date"><?= $Page->Last_Updated_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Last_Updated_Date" id="z_Last_Updated_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Last_Updated_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Last_Updated_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projectproblems_Last_Updated_Date" class="ew-search-field">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="x_Last_Updated_Date" id="x_Last_Updated_Date" data-table="projectproblems" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectproblemssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectproblemssearch", "x_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projectproblems_Last_Updated_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="y_Last_Updated_Date" id="y_Last_Updated_Date" data-table="projectproblems" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectproblemssearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectproblemssearch", "y_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
    <div id="r_Last_Updated_By" class="row"<?= $Page->Last_Updated_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projectproblems_Last_Updated_By"><?= $Page->Last_Updated_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Last_Updated_By" id="z_Last_Updated_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projectproblems_Last_Updated_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_By->getInputTextType() ?>" name="x_Last_Updated_By" id="x_Last_Updated_By" data-table="projectproblems" data-field="x_Last_Updated_By" value="<?= $Page->Last_Updated_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_By->formatPattern()) ?>"<?= $Page->Last_Updated_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprojectproblemssearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprojectproblemssearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fprojectproblemssearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projectproblems");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
