<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$ProjectresultSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { projectresult: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprojectresultsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprojectresultsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ResultID", [ew.Validators.integer], fields.ResultID.isInvalid],
            ["Activities", [], fields.Activities.isInvalid],
            ["DateDelivered", [ew.Validators.datetime(fields.DateDelivered.clientFormatPattern)], fields.DateDelivered.isInvalid],
            ["y_DateDelivered", [ew.Validators.between], false],
            ["Progress", [ew.Validators.float], fields.Progress.isInvalid],
            ["y_Progress", [ew.Validators.between], false],
            ["Status", [], fields.Status.isInvalid],
            ["Category", [], fields.Category.isInvalid],
            ["Weight", [ew.Validators.integer], fields.Weight.isInvalid],
            ["File", [], fields.File.isInvalid],
            ["Notes", [], fields.Notes.isInvalid],
            ["_ProjectID", [], fields._ProjectID.isInvalid],
            ["Created_Date", [], fields.Created_Date.isInvalid],
            ["y_Created_Date", [ew.Validators.between], false],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [], fields.Last_Updated_Date.isInvalid],
            ["y_Last_Updated_Date", [ew.Validators.between], false],
            ["Last_Updated_By", [], fields.Last_Updated_By.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "Status": <?= $Page->Status->toClientList($Page) ?>,
            "Category": <?= $Page->Category->toClientList($Page) ?>,
            "_ProjectID": <?= $Page->_ProjectID->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprojectresultsearch" id="fprojectresultsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("projectresultlist")) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="projectresult">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_projectresult_ResultID" class="projectresultsearch"><span id="el_projectresult_ResultID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ResultID->getInputTextType() ?>" name="x_ResultID" id="x_ResultID" data-table="projectresult" data-field="x_ResultID" value="<?= $Page->ResultID->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->ResultID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ResultID->formatPattern()) ?>"<?= $Page->ResultID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ResultID->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projectresult_Activities" class="projectresultsearch"><span id="el_projectresult_Activities" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Activities->getInputTextType() ?>" name="x_Activities" id="x_Activities" data-table="projectresult" data-field="x_Activities" value="<?= $Page->Activities->EditValue ?>" data-page="1" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->Activities->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Activities->formatPattern()) ?>"<?= $Page->Activities->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Activities->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projectresult_DateDelivered" class="projectresultsearch"><span id="el_projectresult_DateDelivered" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->DateDelivered->getInputTextType() ?>" name="x_DateDelivered" id="x_DateDelivered" data-table="projectresult" data-field="x_DateDelivered" value="<?= $Page->DateDelivered->EditValue ?>" data-page="1" placeholder="<?= HtmlEncode($Page->DateDelivered->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DateDelivered->formatPattern()) ?>"<?= $Page->DateDelivered->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->DateDelivered->getErrorMessage(false) ?></div>
<?php if (!$Page->DateDelivered->ReadOnly && !$Page->DateDelivered->Disabled && !isset($Page->DateDelivered->EditAttrs["readonly"]) && !isset($Page->DateDelivered->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectresultsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectresultsearch", "x_DateDelivered", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projectresult_Progress" class="projectresultsearch"><span id="el_projectresult_Progress" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Progress->getInputTextType() ?>" name="x_Progress" id="x_Progress" data-table="projectresult" data-field="x_Progress" value="<?= $Page->Progress->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Progress->formatPattern()) ?>"<?= $Page->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Progress->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projectresult_Status" class="projectresultsearch"><span id="el_projectresult_Status" class="ew-search-field ew-search-field-single">
    <select
        id="x_Status"
        name="x_Status"
        class="form-select ew-select<?= $Page->Status->isInvalidClass() ?>"
        <?php if (!$Page->Status->IsNativeSelect) { ?>
        data-select2-id="fprojectresultsearch_x_Status"
        <?php } ?>
        data-table="projectresult"
        data-field="x_Status"
        data-page="1"
        data-value-separator="<?= $Page->Status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Status->getPlaceHolder()) ?>"
        <?= $Page->Status->editAttributes() ?>>
        <?= $Page->Status->selectOptionListHtml("x_Status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Status->getErrorMessage(false) ?></div>
<?= $Page->Status->Lookup->getParamTag($Page, "p_x_Status") ?>
<?php if (!$Page->Status->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultsearch", function() {
    var options = { name: "x_Status", selectId: "fprojectresultsearch_x_Status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultsearch.lists.Status?.lookupOptions.length) {
        options.data = { id: "x_Status", form: "fprojectresultsearch" };
    } else {
        options.ajax = { id: "x_Status", form: "fprojectresultsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields.Status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projectresult_Category" class="projectresultsearch"><span id="el_projectresult_Category" class="ew-search-field ew-search-field-single">
    <select
        id="x_Category"
        name="x_Category"
        class="form-select ew-select<?= $Page->Category->isInvalidClass() ?>"
        <?php if (!$Page->Category->IsNativeSelect) { ?>
        data-select2-id="fprojectresultsearch_x_Category"
        <?php } ?>
        data-table="projectresult"
        data-field="x_Category"
        data-page="2"
        data-value-separator="<?= $Page->Category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Category->getPlaceHolder()) ?>"
        <?= $Page->Category->editAttributes() ?>>
        <?= $Page->Category->selectOptionListHtml("x_Category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Category->getErrorMessage(false) ?></div>
<?= $Page->Category->Lookup->getParamTag($Page, "p_x_Category") ?>
<?php if (!$Page->Category->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultsearch", function() {
    var options = { name: "x_Category", selectId: "fprojectresultsearch_x_Category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultsearch.lists.Category?.lookupOptions.length) {
        options.data = { id: "x_Category", form: "fprojectresultsearch" };
    } else {
        options.ajax = { id: "x_Category", form: "fprojectresultsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields.Category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projectresult_Weight" class="projectresultsearch"><span id="el_projectresult_Weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Weight->getInputTextType() ?>" name="x_Weight" id="x_Weight" data-table="projectresult" data-field="x_Weight" value="<?= $Page->Weight->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->Weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Weight->formatPattern()) ?>"<?= $Page->Weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Weight->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projectresult_File" class="projectresultsearch"><span id="el_projectresult_File" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->File->getInputTextType() ?>" name="x_File" id="x_File" data-table="projectresult" data-field="x_File" value="<?= $Page->File->EditValue ?>" data-page="1" maxlength="1200" placeholder="<?= HtmlEncode($Page->File->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->File->formatPattern()) ?>"<?= $Page->File->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->File->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projectresult_Notes" class="projectresultsearch"><span id="el_projectresult_Notes" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Notes->getInputTextType() ?>" name="x_Notes" id="x_Notes" data-table="projectresult" data-field="x_Notes" value="<?= $Page->Notes->EditValue ?>" data-page="1" maxlength="1200" placeholder="<?= HtmlEncode($Page->Notes->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Notes->formatPattern()) ?>"<?= $Page->Notes->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Notes->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projectresult__ProjectID" class="projectresultsearch"><span id="el_projectresult__ProjectID" class="ew-search-field ew-search-field-single">
    <select
        id="x__ProjectID"
        name="x__ProjectID"
        class="form-select ew-select<?= $Page->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojectresultsearch_x__ProjectID"
        <?php } ?>
        data-table="projectresult"
        data-field="x__ProjectID"
        data-page="2"
        data-value-separator="<?= $Page->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_ProjectID->getPlaceHolder()) ?>"
        <?= $Page->_ProjectID->editAttributes() ?>>
        <?= $Page->_ProjectID->selectOptionListHtml("x__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_ProjectID->getErrorMessage(false) ?></div>
<?= $Page->_ProjectID->Lookup->getParamTag($Page, "p_x__ProjectID") ?>
<?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojectresultsearch", function() {
    var options = { name: "x__ProjectID", selectId: "fprojectresultsearch_x__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojectresultsearch.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x__ProjectID", form: "fprojectresultsearch" };
    } else {
        options.ajax = { id: "x__ProjectID", form: "fprojectresultsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projectresult.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projectresult_Created_Date" class="projectresultsearch"><span id="el_projectresult_Created_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="x_Created_Date" id="x_Created_Date" data-table="projectresult" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectresultsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectresultsearch", "x_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projectresult_Created_By" class="projectresultsearch"><span id="el_projectresult_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="projectresult" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" data-page="3" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projectresult_Last_Updated_Date" class="projectresultsearch"><span id="el_projectresult_Last_Updated_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="x_Last_Updated_Date" id="x_Last_Updated_Date" data-table="projectresult" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue ?>" data-page="3" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojectresultsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojectresultsearch", "x_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projectresult_Last_Updated_By" class="projectresultsearch"><span id="el_projectresult_Last_Updated_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_By->getInputTextType() ?>" name="x_Last_Updated_By" id="x_Last_Updated_By" data-table="projectresult" data-field="x_Last_Updated_By" value="<?= $Page->Last_Updated_By->EditValue ?>" data-page="3" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_By->formatPattern()) ?>"<?= $Page->Last_Updated_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
</span></template>
<div id="projectresult_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "ResultID",
                type: "integer",
                label: currentTable.fields.ResultID.caption,
                operators: currentTable.fields.ResultID.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.ResultID.validators),
                data: {
                    format: currentTable.fields.ResultID.clientFormatPattern
                }
            },
            {
                id: "Activities",
                type: "string",
                label: currentTable.fields.Activities.caption,
                operators: currentTable.fields.Activities.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.Activities.validators),
                data: {
                    format: currentTable.fields.Activities.clientFormatPattern
                }
            },
            {
                id: "DateDelivered",
                type: "datetime",
                label: currentTable.fields.DateDelivered.caption,
                operators: currentTable.fields.DateDelivered.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.DateDelivered.validators),
                data: {
                    format: currentTable.fields.DateDelivered.clientFormatPattern
                }
            },
            {
                id: "Progress",
                type: "double",
                label: currentTable.fields.Progress.caption,
                operators: currentTable.fields.Progress.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.Progress.validators),
                data: {
                    format: currentTable.fields.Progress.clientFormatPattern
                }
            },
            {
                id: "Status",
                type: "string",
                label: currentTable.fields.Status.caption,
                operators: currentTable.fields.Status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.Status.validators),
                data: {
                    format: currentTable.fields.Status.clientFormatPattern
                }
            },
            {
                id: "Category",
                type: "string",
                label: currentTable.fields.Category.caption,
                operators: currentTable.fields.Category.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.Category.validators),
                data: {
                    format: currentTable.fields.Category.clientFormatPattern
                }
            },
            {
                id: "Weight",
                type: "integer",
                label: currentTable.fields.Weight.caption,
                operators: currentTable.fields.Weight.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.Weight.validators),
                data: {
                    format: currentTable.fields.Weight.clientFormatPattern
                }
            },
            {
                id: "File",
                type: "string",
                label: currentTable.fields.File.caption,
                operators: currentTable.fields.File.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.File.validators),
                data: {
                    format: currentTable.fields.File.clientFormatPattern
                }
            },
            {
                id: "Notes",
                type: "string",
                label: currentTable.fields.Notes.caption,
                operators: currentTable.fields.Notes.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.Notes.validators),
                data: {
                    format: currentTable.fields.Notes.clientFormatPattern
                }
            },
            {
                id: "_ProjectID",
                type: "integer",
                label: currentTable.fields._ProjectID.caption,
                operators: currentTable.fields._ProjectID.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields._ProjectID.validators),
                data: {
                    format: currentTable.fields._ProjectID.clientFormatPattern
                }
            },
            {
                id: "Created_Date",
                type: "datetime",
                label: currentTable.fields.Created_Date.caption,
                operators: currentTable.fields.Created_Date.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.Created_Date.validators),
                data: {
                    format: currentTable.fields.Created_Date.clientFormatPattern
                }
            },
            {
                id: "Created_By",
                type: "string",
                label: currentTable.fields.Created_By.caption,
                operators: currentTable.fields.Created_By.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.Created_By.validators),
                data: {
                    format: currentTable.fields.Created_By.clientFormatPattern
                }
            },
            {
                id: "Last_Updated_Date",
                type: "datetime",
                label: currentTable.fields.Last_Updated_Date.caption,
                operators: currentTable.fields.Last_Updated_Date.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.Last_Updated_Date.validators),
                data: {
                    format: currentTable.fields.Last_Updated_Date.clientFormatPattern
                }
            },
            {
                id: "Last_Updated_By",
                type: "string",
                label: currentTable.fields.Last_Updated_By.caption,
                operators: currentTable.fields.Last_Updated_By.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojectresultsearch.fields.Last_Updated_By.validators),
                data: {
                    format: currentTable.fields.Last_Updated_By.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#projectresult_query_builder"),
        args = {},
        rules = ew.parseJson($("#fprojectresultsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fprojectresultsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fprojectresultsearch" formaction="<?= HtmlEncode(GetUrl("projectresultlist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprojectresultsearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fprojectresultsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projectresult");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
