<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$ProjecttaskList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { projecttask: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "TaskName": <?= $Page->TaskName->toClientList($Page) ?>,
            "AssignedTo": <?= $Page->AssignedTo->toClientList($Page) ?>,
            "Progress": <?= $Page->Progress->toClientList($Page) ?>,
            "Complete": <?= $Page->Complete->toClientList($Page) ?>,
            "Target": <?= $Page->Target->toClientList($Page) ?>,
            "Track": <?= $Page->Track->toClientList($Page) ?>,
            "PlanStart": <?= $Page->PlanStart->toClientList($Page) ?>,
            "PlanEnd": <?= $Page->PlanEnd->toClientList($Page) ?>,
            "StartDate": <?= $Page->StartDate->toClientList($Page) ?>,
            "EndDate": <?= $Page->EndDate->toClientList($Page) ?>,
            "Priority": <?= $Page->Priority->toClientList($Page) ?>,
            "Category": <?= $Page->Category->toClientList($Page) ?>,
            "_ProjectID": <?= $Page->_ProjectID->toClientList($Page) ?>,
            "Created_Date": <?= $Page->Created_Date->toClientList($Page) ?>,
            "Created_By": <?= $Page->Created_By->toClientList($Page) ?>,
            "Last_Updated_Date": <?= $Page->Last_Updated_Date->toClientList($Page) ?>,
            "Last_Updated_By": <?= $Page->Last_Updated_By->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.6.2", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.6.4",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.6.4"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "masterproject") {
    if ($Page->MasterRecordExists) {
        include_once "views/MasterprojectMaster.php";
    }
}
?>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fprojecttasksrch" id="fprojecttasksrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fprojecttasksrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { projecttask: currentTable } });
var currentForm;
var fprojecttasksrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprojecttasksrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "TaskName": <?= $Page->TaskName->toClientList($Page) ?>,
            "Description": <?= $Page->Description->toClientList($Page) ?>,
            "AssignedTo": <?= $Page->AssignedTo->toClientList($Page) ?>,
            "Progress": <?= $Page->Progress->toClientList($Page) ?>,
            "Complete": <?= $Page->Complete->toClientList($Page) ?>,
            "Target": <?= $Page->Target->toClientList($Page) ?>,
            "Track": <?= $Page->Track->toClientList($Page) ?>,
            "PlanStart": <?= $Page->PlanStart->toClientList($Page) ?>,
            "PlanEnd": <?= $Page->PlanEnd->toClientList($Page) ?>,
            "StartDate": <?= $Page->StartDate->toClientList($Page) ?>,
            "EndDate": <?= $Page->EndDate->toClientList($Page) ?>,
            "Priority": <?= $Page->Priority->toClientList($Page) ?>,
            "Category": <?= $Page->Category->toClientList($Page) ?>,
            "_ProjectID": <?= $Page->_ProjectID->toClientList($Page) ?>,
            "Created_Date": <?= $Page->Created_Date->toClientList($Page) ?>,
            "Created_By": <?= $Page->Created_By->toClientList($Page) ?>,
            "Last_Updated_Date": <?= $Page->Last_Updated_Date->toClientList($Page) ?>,
            "Last_Updated_By": <?= $Page->Last_Updated_By->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TaskName->Visible) { // TaskName ?>
<?php
if (!$Page->TaskName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_TaskName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->TaskName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_TaskName"
            name="x_TaskName[]"
            class="form-control ew-select<?= $Page->TaskName->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_TaskName"
            data-table="projecttask"
            data-field="x_TaskName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->TaskName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->TaskName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->TaskName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->TaskName->editAttributes() ?>>
            <?= $Page->TaskName->selectOptionListHtml("x_TaskName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->TaskName->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_TaskName",
                selectId: "fprojecttasksrch_x_TaskName",
                ajax: { id: "x_TaskName", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.TaskName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Description->Visible) { // Description ?>
<?php
if (!$Page->Description->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Description" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Description->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Description"
            name="x_Description[]"
            class="form-control ew-select<?= $Page->Description->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_Description"
            data-table="projecttask"
            data-field="x_Description"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Description->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Description->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Description->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Description->editAttributes() ?>>
            <?= $Page->Description->selectOptionListHtml("x_Description", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Description->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_Description",
                selectId: "fprojecttasksrch_x_Description",
                ajax: { id: "x_Description", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.Description.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->AssignedTo->Visible) { // AssignedTo ?>
<?php
if (!$Page->AssignedTo->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_AssignedTo" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->AssignedTo->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_AssignedTo"
            name="x_AssignedTo[]"
            class="form-control ew-select<?= $Page->AssignedTo->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_AssignedTo"
            data-table="projecttask"
            data-field="x_AssignedTo"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->AssignedTo->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->AssignedTo->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->AssignedTo->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->AssignedTo->editAttributes() ?>>
            <?= $Page->AssignedTo->selectOptionListHtml("x_AssignedTo", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->AssignedTo->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_AssignedTo",
                selectId: "fprojecttasksrch_x_AssignedTo",
                ajax: { id: "x_AssignedTo", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.AssignedTo.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Progress->Visible) { // Progress ?>
<?php
if (!$Page->Progress->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Progress" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Progress->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Progress"
            name="x_Progress[]"
            class="form-control ew-select<?= $Page->Progress->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_Progress"
            data-table="projecttask"
            data-field="x_Progress"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Progress->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Progress->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Progress->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Progress->editAttributes() ?>>
            <?= $Page->Progress->selectOptionListHtml("x_Progress", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Progress->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_Progress",
                selectId: "fprojecttasksrch_x_Progress",
                ajax: { id: "x_Progress", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.Progress.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Complete->Visible) { // Complete ?>
<?php
if (!$Page->Complete->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Complete" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Complete->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Complete"
            name="x_Complete[]"
            class="form-control ew-select<?= $Page->Complete->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_Complete"
            data-table="projecttask"
            data-field="x_Complete"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Complete->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Complete->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Complete->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Complete->editAttributes() ?>>
            <?= $Page->Complete->selectOptionListHtml("x_Complete", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Complete->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_Complete",
                selectId: "fprojecttasksrch_x_Complete",
                ajax: { id: "x_Complete", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.Complete.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Target->Visible) { // Target ?>
<?php
if (!$Page->Target->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Target" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Target->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Target"
            name="x_Target[]"
            class="form-control ew-select<?= $Page->Target->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_Target"
            data-table="projecttask"
            data-field="x_Target"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Target->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Target->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Target->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Target->editAttributes() ?>>
            <?= $Page->Target->selectOptionListHtml("x_Target", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Target->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_Target",
                selectId: "fprojecttasksrch_x_Target",
                ajax: { id: "x_Target", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.Target.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Track->Visible) { // Track ?>
<?php
if (!$Page->Track->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Track" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Track->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Track"
            name="x_Track[]"
            class="form-control ew-select<?= $Page->Track->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_Track"
            data-table="projecttask"
            data-field="x_Track"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Track->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Track->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Track->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Track->editAttributes() ?>>
            <?= $Page->Track->selectOptionListHtml("x_Track", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Track->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_Track",
                selectId: "fprojecttasksrch_x_Track",
                ajax: { id: "x_Track", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.Track.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->PlanStart->Visible) { // PlanStart ?>
<?php
if (!$Page->PlanStart->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_PlanStart" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->PlanStart->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_PlanStart"
            name="x_PlanStart[]"
            class="form-control ew-select<?= $Page->PlanStart->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_PlanStart"
            data-table="projecttask"
            data-field="x_PlanStart"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->PlanStart->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->PlanStart->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->PlanStart->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->PlanStart->editAttributes() ?>>
            <?= $Page->PlanStart->selectOptionListHtml("x_PlanStart", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->PlanStart->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_PlanStart",
                selectId: "fprojecttasksrch_x_PlanStart",
                ajax: { id: "x_PlanStart", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.PlanStart.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->PlanEnd->Visible) { // PlanEnd ?>
<?php
if (!$Page->PlanEnd->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_PlanEnd" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->PlanEnd->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_PlanEnd"
            name="x_PlanEnd[]"
            class="form-control ew-select<?= $Page->PlanEnd->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_PlanEnd"
            data-table="projecttask"
            data-field="x_PlanEnd"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->PlanEnd->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->PlanEnd->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->PlanEnd->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->PlanEnd->editAttributes() ?>>
            <?= $Page->PlanEnd->selectOptionListHtml("x_PlanEnd", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->PlanEnd->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_PlanEnd",
                selectId: "fprojecttasksrch_x_PlanEnd",
                ajax: { id: "x_PlanEnd", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.PlanEnd.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->StartDate->Visible) { // StartDate ?>
<?php
if (!$Page->StartDate->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_StartDate" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->StartDate->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_StartDate"
            name="x_StartDate[]"
            class="form-control ew-select<?= $Page->StartDate->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_StartDate"
            data-table="projecttask"
            data-field="x_StartDate"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->StartDate->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->StartDate->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->StartDate->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->StartDate->editAttributes() ?>>
            <?= $Page->StartDate->selectOptionListHtml("x_StartDate", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->StartDate->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_StartDate",
                selectId: "fprojecttasksrch_x_StartDate",
                ajax: { id: "x_StartDate", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.StartDate.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->EndDate->Visible) { // EndDate ?>
<?php
if (!$Page->EndDate->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_EndDate" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->EndDate->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_EndDate"
            name="x_EndDate[]"
            class="form-control ew-select<?= $Page->EndDate->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_EndDate"
            data-table="projecttask"
            data-field="x_EndDate"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->EndDate->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->EndDate->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->EndDate->editAttributes() ?>>
            <?= $Page->EndDate->selectOptionListHtml("x_EndDate", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_EndDate",
                selectId: "fprojecttasksrch_x_EndDate",
                ajax: { id: "x_EndDate", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.EndDate.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Priority->Visible) { // Priority ?>
<?php
if (!$Page->Priority->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Priority" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Priority->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Priority"
            name="x_Priority[]"
            class="form-control ew-select<?= $Page->Priority->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_Priority"
            data-table="projecttask"
            data-field="x_Priority"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Priority->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Priority->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Priority->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Priority->editAttributes() ?>>
            <?= $Page->Priority->selectOptionListHtml("x_Priority", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Priority->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_Priority",
                selectId: "fprojecttasksrch_x_Priority",
                ajax: { id: "x_Priority", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.Priority.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Category->Visible) { // Category ?>
<?php
if (!$Page->Category->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Category" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Category->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Category"
            name="x_Category[]"
            class="form-control ew-select<?= $Page->Category->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_Category"
            data-table="projecttask"
            data-field="x_Category"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Category->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Category->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Category->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Category->editAttributes() ?>>
            <?= $Page->Category->selectOptionListHtml("x_Category", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Category->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_Category",
                selectId: "fprojecttasksrch_x_Category",
                ajax: { id: "x_Category", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.Category.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_ProjectID->Visible) { // ProjectID ?>
<?php
if (!$Page->_ProjectID->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__ProjectID" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_ProjectID->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x__ProjectID"
            name="x__ProjectID[]"
            class="form-control ew-select<?= $Page->_ProjectID->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x__ProjectID"
            data-table="projecttask"
            data-field="x__ProjectID"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->_ProjectID->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->_ProjectID->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->_ProjectID->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->_ProjectID->editAttributes() ?>>
            <?= $Page->_ProjectID->selectOptionListHtml("x__ProjectID", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->_ProjectID->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x__ProjectID",
                selectId: "fprojecttasksrch_x__ProjectID",
                ajax: { id: "x__ProjectID", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields._ProjectID.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
<?php
if (!$Page->Created_Date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Created_Date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Created_Date->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Created_Date"
            name="x_Created_Date[]"
            class="form-control ew-select<?= $Page->Created_Date->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_Created_Date"
            data-table="projecttask"
            data-field="x_Created_Date"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Created_Date->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Created_Date->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Created_Date->editAttributes() ?>>
            <?= $Page->Created_Date->selectOptionListHtml("x_Created_Date", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_Created_Date",
                selectId: "fprojecttasksrch_x_Created_Date",
                ajax: { id: "x_Created_Date", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.Created_Date.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
<?php
if (!$Page->Created_By->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Created_By" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Created_By->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Created_By"
            name="x_Created_By[]"
            class="form-control ew-select<?= $Page->Created_By->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_Created_By"
            data-table="projecttask"
            data-field="x_Created_By"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Created_By->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Created_By->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Created_By->editAttributes() ?>>
            <?= $Page->Created_By->selectOptionListHtml("x_Created_By", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_Created_By",
                selectId: "fprojecttasksrch_x_Created_By",
                ajax: { id: "x_Created_By", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.Created_By.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
<?php
if (!$Page->Last_Updated_Date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Last_Updated_Date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Last_Updated_Date->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Last_Updated_Date"
            name="x_Last_Updated_Date[]"
            class="form-control ew-select<?= $Page->Last_Updated_Date->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_Last_Updated_Date"
            data-table="projecttask"
            data-field="x_Last_Updated_Date"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Last_Updated_Date->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Last_Updated_Date->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Last_Updated_Date->editAttributes() ?>>
            <?= $Page->Last_Updated_Date->selectOptionListHtml("x_Last_Updated_Date", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_Last_Updated_Date",
                selectId: "fprojecttasksrch_x_Last_Updated_Date",
                ajax: { id: "x_Last_Updated_Date", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.Last_Updated_Date.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
<?php
if (!$Page->Last_Updated_By->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Last_Updated_By" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Last_Updated_By->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Last_Updated_By"
            name="x_Last_Updated_By[]"
            class="form-control ew-select<?= $Page->Last_Updated_By->isInvalidClass() ?>"
            data-select2-id="fprojecttasksrch_x_Last_Updated_By"
            data-table="projecttask"
            data-field="x_Last_Updated_By"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Last_Updated_By->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Last_Updated_By->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Last_Updated_By->editAttributes() ?>>
            <?= $Page->Last_Updated_By->selectOptionListHtml("x_Last_Updated_By", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fprojecttasksrch", function() {
            var options = {
                name: "x_Last_Updated_By",
                selectId: "fprojecttasksrch_x_Last_Updated_By",
                ajax: { id: "x_Last_Updated_By", form: "fprojecttasksrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.projecttask.fields.Last_Updated_By.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fprojecttasksrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fprojecttasksrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fprojecttasksrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fprojecttasksrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fprojecttasksrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fprojecttasksrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fprojecttasksrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="projecttask">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "masterproject" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="masterproject">
<input type="hidden" name="fk__ProjectID" value="<?= HtmlEncode($Page->_ProjectID->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_projecttask" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_projecttasklist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->TaskName->Visible) { // TaskName ?>
        <th data-name="TaskName" class="<?= $Page->TaskName->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_TaskName" class="projecttask_TaskName"><?= $Page->renderFieldHeader($Page->TaskName) ?></div></th>
<?php } ?>
<?php if ($Page->AssignedTo->Visible) { // AssignedTo ?>
        <th data-name="AssignedTo" class="<?= $Page->AssignedTo->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_AssignedTo" class="projecttask_AssignedTo"><?= $Page->renderFieldHeader($Page->AssignedTo) ?></div></th>
<?php } ?>
<?php if ($Page->Progress->Visible) { // Progress ?>
        <th data-name="Progress" class="<?= $Page->Progress->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Progress" class="projecttask_Progress"><?= $Page->renderFieldHeader($Page->Progress) ?></div></th>
<?php } ?>
<?php if ($Page->Complete->Visible) { // Complete ?>
        <th data-name="Complete" class="<?= $Page->Complete->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Complete" class="projecttask_Complete"><?= $Page->renderFieldHeader($Page->Complete) ?></div></th>
<?php } ?>
<?php if ($Page->Target->Visible) { // Target ?>
        <th data-name="Target" class="<?= $Page->Target->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Target" class="projecttask_Target"><?= $Page->renderFieldHeader($Page->Target) ?></div></th>
<?php } ?>
<?php if ($Page->Track->Visible) { // Track ?>
        <th data-name="Track" class="<?= $Page->Track->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Track" class="projecttask_Track"><?= $Page->renderFieldHeader($Page->Track) ?></div></th>
<?php } ?>
<?php if ($Page->PlanStart->Visible) { // PlanStart ?>
        <th data-name="PlanStart" class="<?= $Page->PlanStart->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_PlanStart" class="projecttask_PlanStart"><?= $Page->renderFieldHeader($Page->PlanStart) ?></div></th>
<?php } ?>
<?php if ($Page->PlanEnd->Visible) { // PlanEnd ?>
        <th data-name="PlanEnd" class="<?= $Page->PlanEnd->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_PlanEnd" class="projecttask_PlanEnd"><?= $Page->renderFieldHeader($Page->PlanEnd) ?></div></th>
<?php } ?>
<?php if ($Page->StartDate->Visible) { // StartDate ?>
        <th data-name="StartDate" class="<?= $Page->StartDate->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_StartDate" class="projecttask_StartDate"><?= $Page->renderFieldHeader($Page->StartDate) ?></div></th>
<?php } ?>
<?php if ($Page->EndDate->Visible) { // EndDate ?>
        <th data-name="EndDate" class="<?= $Page->EndDate->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_EndDate" class="projecttask_EndDate"><?= $Page->renderFieldHeader($Page->EndDate) ?></div></th>
<?php } ?>
<?php if ($Page->Priority->Visible) { // Priority ?>
        <th data-name="Priority" class="<?= $Page->Priority->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Priority" class="projecttask_Priority"><?= $Page->renderFieldHeader($Page->Priority) ?></div></th>
<?php } ?>
<?php if ($Page->Category->Visible) { // Category ?>
        <th data-name="Category" class="<?= $Page->Category->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Category" class="projecttask_Category"><?= $Page->renderFieldHeader($Page->Category) ?></div></th>
<?php } ?>
<?php if ($Page->_ProjectID->Visible) { // ProjectID ?>
        <th data-name="_ProjectID" class="<?= $Page->_ProjectID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask__ProjectID" class="projecttask__ProjectID"><?= $Page->renderFieldHeader($Page->_ProjectID) ?></div></th>
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
        <th data-name="Created_Date" class="<?= $Page->Created_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Created_Date" class="projecttask_Created_Date"><?= $Page->renderFieldHeader($Page->Created_Date) ?></div></th>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
        <th data-name="Created_By" class="<?= $Page->Created_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Created_By" class="projecttask_Created_By"><?= $Page->renderFieldHeader($Page->Created_By) ?></div></th>
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <th data-name="Last_Updated_Date" class="<?= $Page->Last_Updated_Date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Last_Updated_Date" class="projecttask_Last_Updated_Date"><?= $Page->renderFieldHeader($Page->Last_Updated_Date) ?></div></th>
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <th data-name="Last_Updated_By" class="<?= $Page->Last_Updated_By->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_projecttask_Last_Updated_By" class="projecttask_Last_Updated_By"><?= $Page->renderFieldHeader($Page->Last_Updated_By) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->TaskName->Visible) { // TaskName ?>
        <td data-name="TaskName"<?= $Page->TaskName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_TaskName" class="el_projecttask_TaskName">
<span<?= $Page->TaskName->viewAttributes() ?>>
<?= $Page->TaskName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->AssignedTo->Visible) { // AssignedTo ?>
        <td data-name="AssignedTo"<?= $Page->AssignedTo->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_AssignedTo" class="el_projecttask_AssignedTo">
<span<?= $Page->AssignedTo->viewAttributes() ?>>
<?= $Page->AssignedTo->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Progress->Visible) { // Progress ?>
        <td data-name="Progress"<?= $Page->Progress->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_Progress" class="el_projecttask_Progress">
<span<?= $Page->Progress->viewAttributes() ?>>
<?= $Page->Progress->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Complete->Visible) { // Complete ?>
        <td data-name="Complete"<?= $Page->Complete->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_Complete" class="el_projecttask_Complete">
<span<?= $Page->Complete->viewAttributes() ?>>
<?= $Page->Complete->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Target->Visible) { // Target ?>
        <td data-name="Target"<?= $Page->Target->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_Target" class="el_projecttask_Target">
<span<?= $Page->Target->viewAttributes() ?>>
<?= $Page->Target->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Track->Visible) { // Track ?>
        <td data-name="Track"<?= $Page->Track->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_Track" class="el_projecttask_Track">
<span<?= $Page->Track->viewAttributes() ?>>
<?= $Page->Track->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PlanStart->Visible) { // PlanStart ?>
        <td data-name="PlanStart"<?= $Page->PlanStart->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_PlanStart" class="el_projecttask_PlanStart">
<span<?= $Page->PlanStart->viewAttributes() ?>>
<?= $Page->PlanStart->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->PlanEnd->Visible) { // PlanEnd ?>
        <td data-name="PlanEnd"<?= $Page->PlanEnd->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_PlanEnd" class="el_projecttask_PlanEnd">
<span<?= $Page->PlanEnd->viewAttributes() ?>>
<?= $Page->PlanEnd->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->StartDate->Visible) { // StartDate ?>
        <td data-name="StartDate"<?= $Page->StartDate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_StartDate" class="el_projecttask_StartDate">
<span<?= $Page->StartDate->viewAttributes() ?>>
<?= $Page->StartDate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->EndDate->Visible) { // EndDate ?>
        <td data-name="EndDate"<?= $Page->EndDate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_EndDate" class="el_projecttask_EndDate">
<span<?= $Page->EndDate->viewAttributes() ?>>
<?= $Page->EndDate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Priority->Visible) { // Priority ?>
        <td data-name="Priority"<?= $Page->Priority->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_Priority" class="el_projecttask_Priority">
<span<?= $Page->Priority->viewAttributes() ?>>
<?= $Page->Priority->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Category->Visible) { // Category ?>
        <td data-name="Category"<?= $Page->Category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_Category" class="el_projecttask_Category">
<span<?= $Page->Category->viewAttributes() ?>>
<?= $Page->Category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_ProjectID->Visible) { // ProjectID ?>
        <td data-name="_ProjectID"<?= $Page->_ProjectID->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask__ProjectID" class="el_projecttask__ProjectID">
<span<?= $Page->_ProjectID->viewAttributes() ?>>
<?= $Page->_ProjectID->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date"<?= $Page->Created_Date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_Created_Date" class="el_projecttask_Created_Date">
<span<?= $Page->Created_Date->viewAttributes() ?>>
<?= $Page->Created_Date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By"<?= $Page->Created_By->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_Created_By" class="el_projecttask_Created_By">
<span<?= $Page->Created_By->viewAttributes() ?>>
<?= $Page->Created_By->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date"<?= $Page->Last_Updated_Date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_Last_Updated_Date" class="el_projecttask_Last_Updated_Date">
<span<?= $Page->Last_Updated_Date->viewAttributes() ?>>
<?= $Page->Last_Updated_Date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By"<?= $Page->Last_Updated_By->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_projecttask_Last_Updated_By" class="el_projecttask_Last_Updated_By">
<span<?= $Page->Last_Updated_By->viewAttributes() ?>>
<?= $Page->Last_Updated_By->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->TaskName->Visible) { // TaskName ?>
        <td data-name="TaskName" class="<?= $Page->TaskName->footerCellClass() ?>"><span id="elf_projecttask_TaskName" class="projecttask_TaskName">
        </span></td>
    <?php } ?>
    <?php if ($Page->AssignedTo->Visible) { // AssignedTo ?>
        <td data-name="AssignedTo" class="<?= $Page->AssignedTo->footerCellClass() ?>"><span id="elf_projecttask_AssignedTo" class="projecttask_AssignedTo">
        </span></td>
    <?php } ?>
    <?php if ($Page->Progress->Visible) { // Progress ?>
        <td data-name="Progress" class="<?= $Page->Progress->footerCellClass() ?>"><span id="elf_projecttask_Progress" class="projecttask_Progress">
        <span class="ew-aggregate"><?= $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
        <?= $Page->Progress->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->Complete->Visible) { // Complete ?>
        <td data-name="Complete" class="<?= $Page->Complete->footerCellClass() ?>"><span id="elf_projecttask_Complete" class="projecttask_Complete">
        </span></td>
    <?php } ?>
    <?php if ($Page->Target->Visible) { // Target ?>
        <td data-name="Target" class="<?= $Page->Target->footerCellClass() ?>"><span id="elf_projecttask_Target" class="projecttask_Target">
        </span></td>
    <?php } ?>
    <?php if ($Page->Track->Visible) { // Track ?>
        <td data-name="Track" class="<?= $Page->Track->footerCellClass() ?>"><span id="elf_projecttask_Track" class="projecttask_Track">
        </span></td>
    <?php } ?>
    <?php if ($Page->PlanStart->Visible) { // PlanStart ?>
        <td data-name="PlanStart" class="<?= $Page->PlanStart->footerCellClass() ?>"><span id="elf_projecttask_PlanStart" class="projecttask_PlanStart">
        </span></td>
    <?php } ?>
    <?php if ($Page->PlanEnd->Visible) { // PlanEnd ?>
        <td data-name="PlanEnd" class="<?= $Page->PlanEnd->footerCellClass() ?>"><span id="elf_projecttask_PlanEnd" class="projecttask_PlanEnd">
        </span></td>
    <?php } ?>
    <?php if ($Page->StartDate->Visible) { // StartDate ?>
        <td data-name="StartDate" class="<?= $Page->StartDate->footerCellClass() ?>"><span id="elf_projecttask_StartDate" class="projecttask_StartDate">
        </span></td>
    <?php } ?>
    <?php if ($Page->EndDate->Visible) { // EndDate ?>
        <td data-name="EndDate" class="<?= $Page->EndDate->footerCellClass() ?>"><span id="elf_projecttask_EndDate" class="projecttask_EndDate">
        </span></td>
    <?php } ?>
    <?php if ($Page->Priority->Visible) { // Priority ?>
        <td data-name="Priority" class="<?= $Page->Priority->footerCellClass() ?>"><span id="elf_projecttask_Priority" class="projecttask_Priority">
        </span></td>
    <?php } ?>
    <?php if ($Page->Category->Visible) { // Category ?>
        <td data-name="Category" class="<?= $Page->Category->footerCellClass() ?>"><span id="elf_projecttask_Category" class="projecttask_Category">
        </span></td>
    <?php } ?>
    <?php if ($Page->_ProjectID->Visible) { // ProjectID ?>
        <td data-name="_ProjectID" class="<?= $Page->_ProjectID->footerCellClass() ?>"><span id="elf_projecttask__ProjectID" class="projecttask__ProjectID">
        </span></td>
    <?php } ?>
    <?php if ($Page->Created_Date->Visible) { // Created_Date ?>
        <td data-name="Created_Date" class="<?= $Page->Created_Date->footerCellClass() ?>"><span id="elf_projecttask_Created_Date" class="projecttask_Created_Date">
        </span></td>
    <?php } ?>
    <?php if ($Page->Created_By->Visible) { // Created_By ?>
        <td data-name="Created_By" class="<?= $Page->Created_By->footerCellClass() ?>"><span id="elf_projecttask_Created_By" class="projecttask_Created_By">
        </span></td>
    <?php } ?>
    <?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
        <td data-name="Last_Updated_Date" class="<?= $Page->Last_Updated_Date->footerCellClass() ?>"><span id="elf_projecttask_Last_Updated_Date" class="projecttask_Last_Updated_Date">
        </span></td>
    <?php } ?>
    <?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
        <td data-name="Last_Updated_By" class="<?= $Page->Last_Updated_By->footerCellClass() ?>"><span id="elf_projecttask_Last_Updated_By" class="projecttask_Last_Updated_By">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projecttask");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
