<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$ProjecttaskSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { projecttask: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprojecttasksearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprojecttasksearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["TaskID", [ew.Validators.integer], fields.TaskID.isInvalid],
            ["TaskName", [], fields.TaskName.isInvalid],
            ["Description", [], fields.Description.isInvalid],
            ["AssignedTo", [], fields.AssignedTo.isInvalid],
            ["Progress", [ew.Validators.float], fields.Progress.isInvalid],
            ["Complete", [], fields.Complete.isInvalid],
            ["Target", [ew.Validators.float], fields.Target.isInvalid],
            ["Track", [], fields.Track.isInvalid],
            ["PlanStart", [ew.Validators.datetime(fields.PlanStart.clientFormatPattern)], fields.PlanStart.isInvalid],
            ["y_PlanStart", [ew.Validators.between], false],
            ["PlanEnd", [ew.Validators.datetime(fields.PlanEnd.clientFormatPattern)], fields.PlanEnd.isInvalid],
            ["y_PlanEnd", [ew.Validators.between], false],
            ["StartDate", [ew.Validators.datetime(fields.StartDate.clientFormatPattern)], fields.StartDate.isInvalid],
            ["y_StartDate", [ew.Validators.between], false],
            ["EndDate", [ew.Validators.datetime(fields.EndDate.clientFormatPattern)], fields.EndDate.isInvalid],
            ["y_EndDate", [ew.Validators.between], false],
            ["Priority", [], fields.Priority.isInvalid],
            ["Category", [], fields.Category.isInvalid],
            ["_ProjectID", [], fields._ProjectID.isInvalid],
            ["Created_Date", [], fields.Created_Date.isInvalid],
            ["y_Created_Date", [ew.Validators.between], false],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [], fields.Last_Updated_Date.isInvalid],
            ["y_Last_Updated_Date", [ew.Validators.between], false],
            ["Last_Updated_By", [], fields.Last_Updated_By.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "AssignedTo": <?= $Page->AssignedTo->toClientList($Page) ?>,
            "Priority": <?= $Page->Priority->toClientList($Page) ?>,
            "Category": <?= $Page->Category->toClientList($Page) ?>,
            "_ProjectID": <?= $Page->_ProjectID->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprojecttasksearch" id="fprojecttasksearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("projecttasklist")) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="projecttask">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_projecttask_TaskID" class="projecttasksearch"><span id="el_projecttask_TaskID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TaskID->getInputTextType() ?>" name="x_TaskID" id="x_TaskID" data-table="projecttask" data-field="x_TaskID" value="<?= $Page->TaskID->EditValue ?>" placeholder="<?= HtmlEncode($Page->TaskID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TaskID->formatPattern()) ?>"<?= $Page->TaskID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TaskID->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projecttask_TaskName" class="projecttasksearch"><span id="el_projecttask_TaskName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TaskName->getInputTextType() ?>" name="x_TaskName" id="x_TaskName" data-table="projecttask" data-field="x_TaskName" value="<?= $Page->TaskName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->TaskName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TaskName->formatPattern()) ?>"<?= $Page->TaskName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TaskName->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projecttask_Description" class="projecttasksearch"><span id="el_projecttask_Description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Description->getInputTextType() ?>" name="x_Description" id="x_Description" data-table="projecttask" data-field="x_Description" value="<?= $Page->Description->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->Description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Description->formatPattern()) ?>"<?= $Page->Description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Description->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projecttask_AssignedTo" class="projecttasksearch"><span id="el_projecttask_AssignedTo" class="ew-search-field ew-search-field-single">
    <select
        id="x_AssignedTo"
        name="x_AssignedTo"
        class="form-select ew-select<?= $Page->AssignedTo->isInvalidClass() ?>"
        <?php if (!$Page->AssignedTo->IsNativeSelect) { ?>
        data-select2-id="fprojecttasksearch_x_AssignedTo"
        <?php } ?>
        data-table="projecttask"
        data-field="x_AssignedTo"
        data-value-separator="<?= $Page->AssignedTo->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->AssignedTo->getPlaceHolder()) ?>"
        <?= $Page->AssignedTo->editAttributes() ?>>
        <?= $Page->AssignedTo->selectOptionListHtml("x_AssignedTo") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->AssignedTo->getErrorMessage(false) ?></div>
<?= $Page->AssignedTo->Lookup->getParamTag($Page, "p_x_AssignedTo") ?>
<?php if (!$Page->AssignedTo->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttasksearch", function() {
    var options = { name: "x_AssignedTo", selectId: "fprojecttasksearch_x_AssignedTo" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttasksearch.lists.AssignedTo?.lookupOptions.length) {
        options.data = { id: "x_AssignedTo", form: "fprojecttasksearch" };
    } else {
        options.ajax = { id: "x_AssignedTo", form: "fprojecttasksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.AssignedTo.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projecttask_Progress" class="projecttasksearch"><span id="el_projecttask_Progress" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Progress->getInputTextType() ?>" name="x_Progress" id="x_Progress" data-table="projecttask" data-field="x_Progress" value="<?= $Page->Progress->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Progress->formatPattern()) ?>"<?= $Page->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Progress->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projecttask_Complete" class="projecttasksearch"><span id="el_projecttask_Complete" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Complete->getInputTextType() ?>" name="x_Complete" id="x_Complete" data-table="projecttask" data-field="x_Complete" value="<?= $Page->Complete->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->Complete->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Complete->formatPattern()) ?>"<?= $Page->Complete->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Complete->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projecttask_Target" class="projecttasksearch"><span id="el_projecttask_Target" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Target->getInputTextType() ?>" name="x_Target" id="x_Target" data-table="projecttask" data-field="x_Target" value="<?= $Page->Target->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Target->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Target->formatPattern()) ?>"<?= $Page->Target->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Target->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projecttask_Track" class="projecttasksearch"><span id="el_projecttask_Track" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Track->getInputTextType() ?>" name="x_Track" id="x_Track" data-table="projecttask" data-field="x_Track" value="<?= $Page->Track->EditValue ?>" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->Track->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Track->formatPattern()) ?>"<?= $Page->Track->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Track->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projecttask_PlanStart" class="projecttasksearch"><span id="el_projecttask_PlanStart" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PlanStart->getInputTextType() ?>" name="x_PlanStart" id="x_PlanStart" data-table="projecttask" data-field="x_PlanStart" value="<?= $Page->PlanStart->EditValue ?>" placeholder="<?= HtmlEncode($Page->PlanStart->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanStart->formatPattern()) ?>"<?= $Page->PlanStart->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanStart->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanStart->ReadOnly && !$Page->PlanStart->Disabled && !isset($Page->PlanStart->EditAttrs["readonly"]) && !isset($Page->PlanStart->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_PlanStart", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projecttask_PlanEnd" class="projecttasksearch"><span id="el_projecttask_PlanEnd" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PlanEnd->getInputTextType() ?>" name="x_PlanEnd" id="x_PlanEnd" data-table="projecttask" data-field="x_PlanEnd" value="<?= $Page->PlanEnd->EditValue ?>" placeholder="<?= HtmlEncode($Page->PlanEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanEnd->formatPattern()) ?>"<?= $Page->PlanEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanEnd->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanEnd->ReadOnly && !$Page->PlanEnd->Disabled && !isset($Page->PlanEnd->EditAttrs["readonly"]) && !isset($Page->PlanEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_PlanEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projecttask_StartDate" class="projecttasksearch"><span id="el_projecttask_StartDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->StartDate->getInputTextType() ?>" name="x_StartDate" id="x_StartDate" data-table="projecttask" data-field="x_StartDate" value="<?= $Page->StartDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->StartDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->StartDate->formatPattern()) ?>"<?= $Page->StartDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->StartDate->getErrorMessage(false) ?></div>
<?php if (!$Page->StartDate->ReadOnly && !$Page->StartDate->Disabled && !isset($Page->StartDate->EditAttrs["readonly"]) && !isset($Page->StartDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_StartDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projecttask_EndDate" class="projecttasksearch"><span id="el_projecttask_EndDate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->EndDate->getInputTextType() ?>" name="x_EndDate" id="x_EndDate" data-table="projecttask" data-field="x_EndDate" value="<?= $Page->EndDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EndDate->formatPattern()) ?>"<?= $Page->EndDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage(false) ?></div>
<?php if (!$Page->EndDate->ReadOnly && !$Page->EndDate->Disabled && !isset($Page->EndDate->EditAttrs["readonly"]) && !isset($Page->EndDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projecttask_Priority" class="projecttasksearch"><span id="el_projecttask_Priority" class="ew-search-field ew-search-field-single">
    <select
        id="x_Priority"
        name="x_Priority"
        class="form-select ew-select<?= $Page->Priority->isInvalidClass() ?>"
        <?php if (!$Page->Priority->IsNativeSelect) { ?>
        data-select2-id="fprojecttasksearch_x_Priority"
        <?php } ?>
        data-table="projecttask"
        data-field="x_Priority"
        data-value-separator="<?= $Page->Priority->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Priority->getPlaceHolder()) ?>"
        <?= $Page->Priority->editAttributes() ?>>
        <?= $Page->Priority->selectOptionListHtml("x_Priority") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Priority->getErrorMessage(false) ?></div>
<?php if (!$Page->Priority->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttasksearch", function() {
    var options = { name: "x_Priority", selectId: "fprojecttasksearch_x_Priority" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttasksearch.lists.Priority?.lookupOptions.length) {
        options.data = { id: "x_Priority", form: "fprojecttasksearch" };
    } else {
        options.ajax = { id: "x_Priority", form: "fprojecttasksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.Priority.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projecttask_Category" class="projecttasksearch"><span id="el_projecttask_Category" class="ew-search-field ew-search-field-single">
    <select
        id="x_Category"
        name="x_Category"
        class="form-select ew-select<?= $Page->Category->isInvalidClass() ?>"
        <?php if (!$Page->Category->IsNativeSelect) { ?>
        data-select2-id="fprojecttasksearch_x_Category"
        <?php } ?>
        data-table="projecttask"
        data-field="x_Category"
        data-value-separator="<?= $Page->Category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Category->getPlaceHolder()) ?>"
        <?= $Page->Category->editAttributes() ?>>
        <?= $Page->Category->selectOptionListHtml("x_Category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Category->getErrorMessage(false) ?></div>
<?= $Page->Category->Lookup->getParamTag($Page, "p_x_Category") ?>
<?php if (!$Page->Category->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttasksearch", function() {
    var options = { name: "x_Category", selectId: "fprojecttasksearch_x_Category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttasksearch.lists.Category?.lookupOptions.length) {
        options.data = { id: "x_Category", form: "fprojecttasksearch" };
    } else {
        options.ajax = { id: "x_Category", form: "fprojecttasksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.Category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projecttask__ProjectID" class="projecttasksearch"><span id="el_projecttask__ProjectID" class="ew-search-field ew-search-field-single">
    <select
        id="x__ProjectID"
        name="x__ProjectID"
        class="form-select ew-select<?= $Page->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojecttasksearch_x__ProjectID"
        <?php } ?>
        data-table="projecttask"
        data-field="x__ProjectID"
        data-value-separator="<?= $Page->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_ProjectID->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->_ProjectID->editAttributes() ?>>
        <?= $Page->_ProjectID->selectOptionListHtml("x__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_ProjectID->getErrorMessage(false) ?></div>
<?= $Page->_ProjectID->Lookup->getParamTag($Page, "p_x__ProjectID") ?>
<?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttasksearch", function() {
    var options = { name: "x__ProjectID", selectId: "fprojecttasksearch_x__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttasksearch.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x__ProjectID", form: "fprojecttasksearch" };
    } else {
        options.ajax = { id: "x__ProjectID", form: "fprojecttasksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projecttask_Created_Date" class="projecttasksearch"><span id="el_projecttask_Created_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="x_Created_Date" id="x_Created_Date" data-table="projecttask" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projecttask_Created_By" class="projecttasksearch"><span id="el_projecttask_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="projecttask" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_projecttask_Last_Updated_Date" class="projecttasksearch"><span id="el_projecttask_Last_Updated_Date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="x_Last_Updated_Date" id="x_Last_Updated_Date" data-table="projecttask" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_projecttask_Last_Updated_By" class="projecttasksearch"><span id="el_projecttask_Last_Updated_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_By->getInputTextType() ?>" name="x_Last_Updated_By" id="x_Last_Updated_By" data-table="projecttask" data-field="x_Last_Updated_By" value="<?= $Page->Last_Updated_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_By->formatPattern()) ?>"<?= $Page->Last_Updated_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
</span></template>
<div id="projecttask_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "TaskID",
                type: "integer",
                label: currentTable.fields.TaskID.caption,
                operators: currentTable.fields.TaskID.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.TaskID.validators),
                data: {
                    format: currentTable.fields.TaskID.clientFormatPattern
                }
            },
            {
                id: "TaskName",
                type: "string",
                label: currentTable.fields.TaskName.caption,
                operators: currentTable.fields.TaskName.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.TaskName.validators),
                data: {
                    format: currentTable.fields.TaskName.clientFormatPattern
                }
            },
            {
                id: "Description",
                type: "string",
                label: currentTable.fields.Description.caption,
                operators: currentTable.fields.Description.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.Description.validators),
                data: {
                    format: currentTable.fields.Description.clientFormatPattern
                }
            },
            {
                id: "AssignedTo",
                type: "integer",
                label: currentTable.fields.AssignedTo.caption,
                operators: currentTable.fields.AssignedTo.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.AssignedTo.validators),
                data: {
                    format: currentTable.fields.AssignedTo.clientFormatPattern
                }
            },
            {
                id: "Progress",
                type: "double",
                label: currentTable.fields.Progress.caption,
                operators: currentTable.fields.Progress.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.Progress.validators),
                data: {
                    format: currentTable.fields.Progress.clientFormatPattern
                }
            },
            {
                id: "Complete",
                type: "string",
                label: currentTable.fields.Complete.caption,
                operators: currentTable.fields.Complete.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.Complete.validators),
                data: {
                    format: currentTable.fields.Complete.clientFormatPattern
                }
            },
            {
                id: "Target",
                type: "double",
                label: currentTable.fields.Target.caption,
                operators: currentTable.fields.Target.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.Target.validators),
                data: {
                    format: currentTable.fields.Target.clientFormatPattern
                }
            },
            {
                id: "Track",
                type: "string",
                label: currentTable.fields.Track.caption,
                operators: currentTable.fields.Track.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.Track.validators),
                data: {
                    format: currentTable.fields.Track.clientFormatPattern
                }
            },
            {
                id: "PlanStart",
                type: "datetime",
                label: currentTable.fields.PlanStart.caption,
                operators: currentTable.fields.PlanStart.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.PlanStart.validators),
                data: {
                    format: currentTable.fields.PlanStart.clientFormatPattern
                }
            },
            {
                id: "PlanEnd",
                type: "datetime",
                label: currentTable.fields.PlanEnd.caption,
                operators: currentTable.fields.PlanEnd.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.PlanEnd.validators),
                data: {
                    format: currentTable.fields.PlanEnd.clientFormatPattern
                }
            },
            {
                id: "StartDate",
                type: "datetime",
                label: currentTable.fields.StartDate.caption,
                operators: currentTable.fields.StartDate.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.StartDate.validators),
                data: {
                    format: currentTable.fields.StartDate.clientFormatPattern
                }
            },
            {
                id: "EndDate",
                type: "datetime",
                label: currentTable.fields.EndDate.caption,
                operators: currentTable.fields.EndDate.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.EndDate.validators),
                data: {
                    format: currentTable.fields.EndDate.clientFormatPattern
                }
            },
            {
                id: "Priority",
                type: "integer",
                label: currentTable.fields.Priority.caption,
                operators: currentTable.fields.Priority.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.Priority.validators),
                data: {
                    format: currentTable.fields.Priority.clientFormatPattern
                }
            },
            {
                id: "Category",
                type: "string",
                label: currentTable.fields.Category.caption,
                operators: currentTable.fields.Category.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.Category.validators),
                data: {
                    format: currentTable.fields.Category.clientFormatPattern
                }
            },
            {
                id: "_ProjectID",
                type: "integer",
                label: currentTable.fields._ProjectID.caption,
                operators: currentTable.fields._ProjectID.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields._ProjectID.validators),
                data: {
                    format: currentTable.fields._ProjectID.clientFormatPattern
                }
            },
            {
                id: "Created_Date",
                type: "datetime",
                label: currentTable.fields.Created_Date.caption,
                operators: currentTable.fields.Created_Date.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.Created_Date.validators),
                data: {
                    format: currentTable.fields.Created_Date.clientFormatPattern
                }
            },
            {
                id: "Created_By",
                type: "string",
                label: currentTable.fields.Created_By.caption,
                operators: currentTable.fields.Created_By.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.Created_By.validators),
                data: {
                    format: currentTable.fields.Created_By.clientFormatPattern
                }
            },
            {
                id: "Last_Updated_Date",
                type: "datetime",
                label: currentTable.fields.Last_Updated_Date.caption,
                operators: currentTable.fields.Last_Updated_Date.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.Last_Updated_Date.validators),
                data: {
                    format: currentTable.fields.Last_Updated_Date.clientFormatPattern
                }
            },
            {
                id: "Last_Updated_By",
                type: "string",
                label: currentTable.fields.Last_Updated_By.caption,
                operators: currentTable.fields.Last_Updated_By.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fprojecttasksearch.fields.Last_Updated_By.validators),
                data: {
                    format: currentTable.fields.Last_Updated_By.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#projecttask_query_builder"),
        args = {},
        rules = ew.parseJson($("#fprojecttasksearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fprojecttasksearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fprojecttasksearch" formaction="<?= HtmlEncode(GetUrl("projecttasklist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprojecttasksearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fprojecttasksearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projecttask");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
