<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$ProjecttaskSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { projecttask: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprojecttasksearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprojecttasksearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["TaskID", [ew.Validators.integer], fields.TaskID.isInvalid],
            ["TaskName", [], fields.TaskName.isInvalid],
            ["Description", [], fields.Description.isInvalid],
            ["AssignedTo", [], fields.AssignedTo.isInvalid],
            ["Progress", [ew.Validators.float], fields.Progress.isInvalid],
            ["Complete", [], fields.Complete.isInvalid],
            ["Target", [ew.Validators.float], fields.Target.isInvalid],
            ["Track", [], fields.Track.isInvalid],
            ["PlanStart", [ew.Validators.datetime(fields.PlanStart.clientFormatPattern)], fields.PlanStart.isInvalid],
            ["y_PlanStart", [ew.Validators.between], false],
            ["PlanEnd", [ew.Validators.datetime(fields.PlanEnd.clientFormatPattern)], fields.PlanEnd.isInvalid],
            ["y_PlanEnd", [ew.Validators.between], false],
            ["StartDate", [ew.Validators.datetime(fields.StartDate.clientFormatPattern)], fields.StartDate.isInvalid],
            ["y_StartDate", [ew.Validators.between], false],
            ["EndDate", [ew.Validators.datetime(fields.EndDate.clientFormatPattern)], fields.EndDate.isInvalid],
            ["y_EndDate", [ew.Validators.between], false],
            ["Priority", [], fields.Priority.isInvalid],
            ["Category", [], fields.Category.isInvalid],
            ["_ProjectID", [], fields._ProjectID.isInvalid],
            ["Created_Date", [], fields.Created_Date.isInvalid],
            ["y_Created_Date", [ew.Validators.between], false],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [], fields.Last_Updated_Date.isInvalid],
            ["y_Last_Updated_Date", [ew.Validators.between], false],
            ["Last_Updated_By", [], fields.Last_Updated_By.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "AssignedTo": <?= $Page->AssignedTo->toClientList($Page) ?>,
            "Priority": <?= $Page->Priority->toClientList($Page) ?>,
            "Category": <?= $Page->Category->toClientList($Page) ?>,
            "_ProjectID": <?= $Page->_ProjectID->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprojecttasksearch" id="fprojecttasksearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="projecttask">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->TaskID->Visible) { // TaskID ?>
    <div id="r_TaskID" class="row"<?= $Page->TaskID->rowAttributes() ?>>
        <label for="x_TaskID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_TaskID"><?= $Page->TaskID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_TaskID" id="z_TaskID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->TaskID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_TaskID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TaskID->getInputTextType() ?>" name="x_TaskID" id="x_TaskID" data-table="projecttask" data-field="x_TaskID" value="<?= $Page->TaskID->EditValue ?>" placeholder="<?= HtmlEncode($Page->TaskID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TaskID->formatPattern()) ?>"<?= $Page->TaskID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TaskID->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->TaskName->Visible) { // TaskName ?>
    <div id="r_TaskName" class="row"<?= $Page->TaskName->rowAttributes() ?>>
        <label for="x_TaskName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_TaskName"><?= $Page->TaskName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TaskName" id="z_TaskName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->TaskName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_TaskName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->TaskName->getInputTextType() ?>" name="x_TaskName" id="x_TaskName" data-table="projecttask" data-field="x_TaskName" value="<?= $Page->TaskName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->TaskName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TaskName->formatPattern()) ?>"<?= $Page->TaskName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->TaskName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Description->Visible) { // Description ?>
    <div id="r_Description" class="row"<?= $Page->Description->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_Description"><?= $Page->Description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Description" id="z_Description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_Description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Description->getInputTextType() ?>" name="x_Description" id="x_Description" data-table="projecttask" data-field="x_Description" value="<?= $Page->Description->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->Description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Description->formatPattern()) ?>"<?= $Page->Description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->AssignedTo->Visible) { // AssignedTo ?>
    <div id="r_AssignedTo" class="row"<?= $Page->AssignedTo->rowAttributes() ?>>
        <label for="x_AssignedTo" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_AssignedTo"><?= $Page->AssignedTo->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_AssignedTo" id="z_AssignedTo" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->AssignedTo->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_AssignedTo" class="ew-search-field ew-search-field-single">
    <select
        id="x_AssignedTo"
        name="x_AssignedTo"
        class="form-select ew-select<?= $Page->AssignedTo->isInvalidClass() ?>"
        <?php if (!$Page->AssignedTo->IsNativeSelect) { ?>
        data-select2-id="fprojecttasksearch_x_AssignedTo"
        <?php } ?>
        data-table="projecttask"
        data-field="x_AssignedTo"
        data-value-separator="<?= $Page->AssignedTo->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->AssignedTo->getPlaceHolder()) ?>"
        <?= $Page->AssignedTo->editAttributes() ?>>
        <?= $Page->AssignedTo->selectOptionListHtml("x_AssignedTo") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->AssignedTo->getErrorMessage(false) ?></div>
<?= $Page->AssignedTo->Lookup->getParamTag($Page, "p_x_AssignedTo") ?>
<?php if (!$Page->AssignedTo->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttasksearch", function() {
    var options = { name: "x_AssignedTo", selectId: "fprojecttasksearch_x_AssignedTo" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttasksearch.lists.AssignedTo?.lookupOptions.length) {
        options.data = { id: "x_AssignedTo", form: "fprojecttasksearch" };
    } else {
        options.ajax = { id: "x_AssignedTo", form: "fprojecttasksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.AssignedTo.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Progress->Visible) { // Progress ?>
    <div id="r_Progress" class="row"<?= $Page->Progress->rowAttributes() ?>>
        <label for="x_Progress" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_Progress"><?= $Page->Progress->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Progress" id="z_Progress" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Progress->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_Progress" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Progress->getInputTextType() ?>" name="x_Progress" id="x_Progress" data-table="projecttask" data-field="x_Progress" value="<?= $Page->Progress->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Progress->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Progress->formatPattern()) ?>"<?= $Page->Progress->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Progress->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Complete->Visible) { // Complete ?>
    <div id="r_Complete" class="row"<?= $Page->Complete->rowAttributes() ?>>
        <label for="x_Complete" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_Complete"><?= $Page->Complete->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Complete" id="z_Complete" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Complete->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_Complete" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Complete->getInputTextType() ?>" name="x_Complete" id="x_Complete" data-table="projecttask" data-field="x_Complete" value="<?= $Page->Complete->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->Complete->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Complete->formatPattern()) ?>"<?= $Page->Complete->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Complete->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Target->Visible) { // Target ?>
    <div id="r_Target" class="row"<?= $Page->Target->rowAttributes() ?>>
        <label for="x_Target" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_Target"><?= $Page->Target->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Target" id="z_Target" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Target->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_Target" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Target->getInputTextType() ?>" name="x_Target" id="x_Target" data-table="projecttask" data-field="x_Target" value="<?= $Page->Target->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Target->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Target->formatPattern()) ?>"<?= $Page->Target->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Target->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Track->Visible) { // Track ?>
    <div id="r_Track" class="row"<?= $Page->Track->rowAttributes() ?>>
        <label for="x_Track" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_Track"><?= $Page->Track->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Track" id="z_Track" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Track->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_Track" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Track->getInputTextType() ?>" name="x_Track" id="x_Track" data-table="projecttask" data-field="x_Track" value="<?= $Page->Track->EditValue ?>" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->Track->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Track->formatPattern()) ?>"<?= $Page->Track->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Track->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PlanStart->Visible) { // PlanStart ?>
    <div id="r_PlanStart" class="row"<?= $Page->PlanStart->rowAttributes() ?>>
        <label for="x_PlanStart" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_PlanStart"><?= $Page->PlanStart->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PlanStart->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_PlanStart" id="z_PlanStart" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->PlanStart->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->PlanStart->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projecttask_PlanStart" class="ew-search-field">
<input type="<?= $Page->PlanStart->getInputTextType() ?>" name="x_PlanStart" id="x_PlanStart" data-table="projecttask" data-field="x_PlanStart" value="<?= $Page->PlanStart->EditValue ?>" placeholder="<?= HtmlEncode($Page->PlanStart->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanStart->formatPattern()) ?>"<?= $Page->PlanStart->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanStart->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanStart->ReadOnly && !$Page->PlanStart->Disabled && !isset($Page->PlanStart->EditAttrs["readonly"]) && !isset($Page->PlanStart->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_PlanStart", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projecttask_PlanStart" class="ew-search-field2 d-none">
<input type="<?= $Page->PlanStart->getInputTextType() ?>" name="y_PlanStart" id="y_PlanStart" data-table="projecttask" data-field="x_PlanStart" value="<?= $Page->PlanStart->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->PlanStart->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanStart->formatPattern()) ?>"<?= $Page->PlanStart->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanStart->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanStart->ReadOnly && !$Page->PlanStart->Disabled && !isset($Page->PlanStart->EditAttrs["readonly"]) && !isset($Page->PlanStart->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "y_PlanStart", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PlanEnd->Visible) { // PlanEnd ?>
    <div id="r_PlanEnd" class="row"<?= $Page->PlanEnd->rowAttributes() ?>>
        <label for="x_PlanEnd" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_PlanEnd"><?= $Page->PlanEnd->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PlanEnd->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_PlanEnd" id="z_PlanEnd" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->PlanEnd->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->PlanEnd->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projecttask_PlanEnd" class="ew-search-field">
<input type="<?= $Page->PlanEnd->getInputTextType() ?>" name="x_PlanEnd" id="x_PlanEnd" data-table="projecttask" data-field="x_PlanEnd" value="<?= $Page->PlanEnd->EditValue ?>" placeholder="<?= HtmlEncode($Page->PlanEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanEnd->formatPattern()) ?>"<?= $Page->PlanEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanEnd->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanEnd->ReadOnly && !$Page->PlanEnd->Disabled && !isset($Page->PlanEnd->EditAttrs["readonly"]) && !isset($Page->PlanEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_PlanEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projecttask_PlanEnd" class="ew-search-field2 d-none">
<input type="<?= $Page->PlanEnd->getInputTextType() ?>" name="y_PlanEnd" id="y_PlanEnd" data-table="projecttask" data-field="x_PlanEnd" value="<?= $Page->PlanEnd->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->PlanEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanEnd->formatPattern()) ?>"<?= $Page->PlanEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanEnd->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanEnd->ReadOnly && !$Page->PlanEnd->Disabled && !isset($Page->PlanEnd->EditAttrs["readonly"]) && !isset($Page->PlanEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "y_PlanEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->StartDate->Visible) { // StartDate ?>
    <div id="r_StartDate" class="row"<?= $Page->StartDate->rowAttributes() ?>>
        <label for="x_StartDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_StartDate"><?= $Page->StartDate->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->StartDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_StartDate" id="z_StartDate" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->StartDate->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->StartDate->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projecttask_StartDate" class="ew-search-field">
<input type="<?= $Page->StartDate->getInputTextType() ?>" name="x_StartDate" id="x_StartDate" data-table="projecttask" data-field="x_StartDate" value="<?= $Page->StartDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->StartDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->StartDate->formatPattern()) ?>"<?= $Page->StartDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->StartDate->getErrorMessage(false) ?></div>
<?php if (!$Page->StartDate->ReadOnly && !$Page->StartDate->Disabled && !isset($Page->StartDate->EditAttrs["readonly"]) && !isset($Page->StartDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_StartDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projecttask_StartDate" class="ew-search-field2 d-none">
<input type="<?= $Page->StartDate->getInputTextType() ?>" name="y_StartDate" id="y_StartDate" data-table="projecttask" data-field="x_StartDate" value="<?= $Page->StartDate->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->StartDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->StartDate->formatPattern()) ?>"<?= $Page->StartDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->StartDate->getErrorMessage(false) ?></div>
<?php if (!$Page->StartDate->ReadOnly && !$Page->StartDate->Disabled && !isset($Page->StartDate->EditAttrs["readonly"]) && !isset($Page->StartDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "y_StartDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->EndDate->Visible) { // EndDate ?>
    <div id="r_EndDate" class="row"<?= $Page->EndDate->rowAttributes() ?>>
        <label for="x_EndDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_EndDate"><?= $Page->EndDate->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->EndDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_EndDate" id="z_EndDate" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->EndDate->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->EndDate->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projecttask_EndDate" class="ew-search-field">
<input type="<?= $Page->EndDate->getInputTextType() ?>" name="x_EndDate" id="x_EndDate" data-table="projecttask" data-field="x_EndDate" value="<?= $Page->EndDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EndDate->formatPattern()) ?>"<?= $Page->EndDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage(false) ?></div>
<?php if (!$Page->EndDate->ReadOnly && !$Page->EndDate->Disabled && !isset($Page->EndDate->EditAttrs["readonly"]) && !isset($Page->EndDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projecttask_EndDate" class="ew-search-field2 d-none">
<input type="<?= $Page->EndDate->getInputTextType() ?>" name="y_EndDate" id="y_EndDate" data-table="projecttask" data-field="x_EndDate" value="<?= $Page->EndDate->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EndDate->formatPattern()) ?>"<?= $Page->EndDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage(false) ?></div>
<?php if (!$Page->EndDate->ReadOnly && !$Page->EndDate->Disabled && !isset($Page->EndDate->EditAttrs["readonly"]) && !isset($Page->EndDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "y_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Priority->Visible) { // Priority ?>
    <div id="r_Priority" class="row"<?= $Page->Priority->rowAttributes() ?>>
        <label for="x_Priority" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_Priority"><?= $Page->Priority->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Priority" id="z_Priority" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Priority->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_Priority" class="ew-search-field ew-search-field-single">
    <select
        id="x_Priority"
        name="x_Priority"
        class="form-select ew-select<?= $Page->Priority->isInvalidClass() ?>"
        <?php if (!$Page->Priority->IsNativeSelect) { ?>
        data-select2-id="fprojecttasksearch_x_Priority"
        <?php } ?>
        data-table="projecttask"
        data-field="x_Priority"
        data-value-separator="<?= $Page->Priority->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Priority->getPlaceHolder()) ?>"
        <?= $Page->Priority->editAttributes() ?>>
        <?= $Page->Priority->selectOptionListHtml("x_Priority") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Priority->getErrorMessage(false) ?></div>
<?php if (!$Page->Priority->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttasksearch", function() {
    var options = { name: "x_Priority", selectId: "fprojecttasksearch_x_Priority" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttasksearch.lists.Priority?.lookupOptions.length) {
        options.data = { id: "x_Priority", form: "fprojecttasksearch" };
    } else {
        options.ajax = { id: "x_Priority", form: "fprojecttasksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.Priority.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Category->Visible) { // Category ?>
    <div id="r_Category" class="row"<?= $Page->Category->rowAttributes() ?>>
        <label for="x_Category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_Category"><?= $Page->Category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Category" id="z_Category" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_Category" class="ew-search-field ew-search-field-single">
    <select
        id="x_Category"
        name="x_Category"
        class="form-select ew-select<?= $Page->Category->isInvalidClass() ?>"
        <?php if (!$Page->Category->IsNativeSelect) { ?>
        data-select2-id="fprojecttasksearch_x_Category"
        <?php } ?>
        data-table="projecttask"
        data-field="x_Category"
        data-value-separator="<?= $Page->Category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Category->getPlaceHolder()) ?>"
        <?= $Page->Category->editAttributes() ?>>
        <?= $Page->Category->selectOptionListHtml("x_Category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Category->getErrorMessage(false) ?></div>
<?= $Page->Category->Lookup->getParamTag($Page, "p_x_Category") ?>
<?php if (!$Page->Category->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttasksearch", function() {
    var options = { name: "x_Category", selectId: "fprojecttasksearch_x_Category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttasksearch.lists.Category?.lookupOptions.length) {
        options.data = { id: "x_Category", form: "fprojecttasksearch" };
    } else {
        options.ajax = { id: "x_Category", form: "fprojecttasksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields.Category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_ProjectID->Visible) { // ProjectID ?>
    <div id="r__ProjectID" class="row"<?= $Page->_ProjectID->rowAttributes() ?>>
        <label for="x__ProjectID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask__ProjectID"><?= $Page->_ProjectID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__ProjectID" id="z__ProjectID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_ProjectID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask__ProjectID" class="ew-search-field ew-search-field-single">
    <select
        id="x__ProjectID"
        name="x__ProjectID"
        class="form-select ew-select<?= $Page->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="fprojecttasksearch_x__ProjectID"
        <?php } ?>
        data-table="projecttask"
        data-field="x__ProjectID"
        data-value-separator="<?= $Page->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_ProjectID->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->_ProjectID->editAttributes() ?>>
        <?= $Page->_ProjectID->selectOptionListHtml("x__ProjectID") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_ProjectID->getErrorMessage(false) ?></div>
<?= $Page->_ProjectID->Lookup->getParamTag($Page, "p_x__ProjectID") ?>
<?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
<script>
loadjs.ready("fprojecttasksearch", function() {
    var options = { name: "x__ProjectID", selectId: "fprojecttasksearch_x__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fprojecttasksearch.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x__ProjectID", form: "fprojecttasksearch" };
    } else {
        options.ajax = { id: "x__ProjectID", form: "fprojecttasksearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.projecttask.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
    <div id="r_Created_Date" class="row"<?= $Page->Created_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_Created_Date"><?= $Page->Created_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Created_Date" id="z_Created_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Created_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Created_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projecttask_Created_Date" class="ew-search-field">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="x_Created_Date" id="x_Created_Date" data-table="projecttask" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projecttask_Created_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="y_Created_Date" id="y_Created_Date" data-table="projecttask" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "y_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
    <div id="r_Created_By" class="row"<?= $Page->Created_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_Created_By"><?= $Page->Created_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Created_By" id="z_Created_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="projecttask" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
    <div id="r_Last_Updated_Date" class="row"<?= $Page->Last_Updated_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_Last_Updated_Date"><?= $Page->Last_Updated_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Last_Updated_Date" id="z_Last_Updated_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Last_Updated_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Last_Updated_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projecttask_Last_Updated_Date" class="ew-search-field">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="x_Last_Updated_Date" id="x_Last_Updated_Date" data-table="projecttask" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "x_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projecttask_Last_Updated_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="y_Last_Updated_Date" id="y_Last_Updated_Date" data-table="projecttask" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttasksearch", "y_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
    <div id="r_Last_Updated_By" class="row"<?= $Page->Last_Updated_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttask_Last_Updated_By"><?= $Page->Last_Updated_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Last_Updated_By" id="z_Last_Updated_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttask_Last_Updated_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_By->getInputTextType() ?>" name="x_Last_Updated_By" id="x_Last_Updated_By" data-table="projecttask" data-field="x_Last_Updated_By" value="<?= $Page->Last_Updated_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_By->formatPattern()) ?>"<?= $Page->Last_Updated_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprojecttasksearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprojecttasksearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fprojecttasksearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projecttask");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
