<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$ProjecttemplateSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { projecttemplate: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fprojecttemplatesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fprojecttemplatesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ID", [ew.Validators.integer], fields.ID.isInvalid],
            ["template_name", [], fields.template_name.isInvalid],
            ["description", [], fields.description.isInvalid],
            ["Active", [], fields.Active.isInvalid],
            ["Created_Date", [], fields.Created_Date.isInvalid],
            ["y_Created_Date", [ew.Validators.between], false],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [], fields.Last_Updated_Date.isInvalid],
            ["y_Last_Updated_Date", [ew.Validators.between], false],
            ["Last_Updated_By", [], fields.Last_Updated_By.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Active": <?= $Page->Active->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprojecttemplatesearch" id="fprojecttemplatesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="projecttemplate">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->ID->Visible) { // ID ?>
    <div id="r_ID" class="row"<?= $Page->ID->rowAttributes() ?>>
        <label for="x_ID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttemplate_ID"><?= $Page->ID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ID" id="z_ID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttemplate_ID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ID->getInputTextType() ?>" name="x_ID" id="x_ID" data-table="projecttemplate" data-field="x_ID" value="<?= $Page->ID->EditValue ?>" placeholder="<?= HtmlEncode($Page->ID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ID->formatPattern()) ?>"<?= $Page->ID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ID->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->template_name->Visible) { // template_name ?>
    <div id="r_template_name" class="row"<?= $Page->template_name->rowAttributes() ?>>
        <label for="x_template_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttemplate_template_name"><?= $Page->template_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_template_name" id="z_template_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->template_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttemplate_template_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->template_name->getInputTextType() ?>" name="x_template_name" id="x_template_name" data-table="projecttemplate" data-field="x_template_name" value="<?= $Page->template_name->EditValue ?>" maxlength="150" placeholder="<?= HtmlEncode($Page->template_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->template_name->formatPattern()) ?>"<?= $Page->template_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->template_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description" class="row"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttemplate_description"><?= $Page->description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description" id="z_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttemplate_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="projecttemplate" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Active->Visible) { // Active ?>
    <div id="r_Active" class="row"<?= $Page->Active->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttemplate_Active"><?= $Page->Active->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Active" id="z_Active" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Active->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttemplate_Active" class="ew-search-field ew-search-field-single">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->Active->isInvalidClass() ?>" data-table="projecttemplate" data-field="x_Active" data-boolean name="x_Active" id="x_Active" value="1"<?= ConvertToBool($Page->Active->AdvancedSearch->SearchValue) ? " checked" : "" ?><?= $Page->Active->editAttributes() ?>>
    <div class="invalid-feedback"><?= $Page->Active->getErrorMessage(false) ?></div>
</div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
    <div id="r_Created_Date" class="row"<?= $Page->Created_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttemplate_Created_Date"><?= $Page->Created_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Created_Date" id="z_Created_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Created_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Created_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projecttemplate_Created_Date" class="ew-search-field">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="x_Created_Date" id="x_Created_Date" data-table="projecttemplate" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttemplatesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttemplatesearch", "x_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projecttemplate_Created_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="y_Created_Date" id="y_Created_Date" data-table="projecttemplate" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttemplatesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttemplatesearch", "y_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
    <div id="r_Created_By" class="row"<?= $Page->Created_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttemplate_Created_By"><?= $Page->Created_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Created_By" id="z_Created_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttemplate_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="projecttemplate" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
    <div id="r_Last_Updated_Date" class="row"<?= $Page->Last_Updated_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttemplate_Last_Updated_Date"><?= $Page->Last_Updated_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Last_Updated_Date" id="z_Last_Updated_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Last_Updated_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Last_Updated_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_projecttemplate_Last_Updated_Date" class="ew-search-field">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="x_Last_Updated_Date" id="x_Last_Updated_Date" data-table="projecttemplate" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttemplatesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttemplatesearch", "x_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_projecttemplate_Last_Updated_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="y_Last_Updated_Date" id="y_Last_Updated_Date" data-table="projecttemplate" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fprojecttemplatesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fprojecttemplatesearch", "y_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
    <div id="r_Last_Updated_By" class="row"<?= $Page->Last_Updated_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_projecttemplate_Last_Updated_By"><?= $Page->Last_Updated_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Last_Updated_By" id="z_Last_Updated_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_projecttemplate_Last_Updated_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_By->getInputTextType() ?>" name="x_Last_Updated_By" id="x_Last_Updated_By" data-table="projecttemplate" data-field="x_Last_Updated_By" value="<?= $Page->Last_Updated_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_By->formatPattern()) ?>"<?= $Page->Last_Updated_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprojecttemplatesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprojecttemplatesearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fprojecttemplatesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projecttemplate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
