<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$ProjecttemplateUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { projecttemplate: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fprojecttemplateupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fprojecttemplateupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["template_name", [fields.template_name.visible && fields.template_name.required ? ew.Validators.required(fields.template_name.caption) : null], fields.template_name.isInvalid],
            ["description", [fields.description.visible && fields.description.required ? ew.Validators.required(fields.description.caption) : null], fields.description.isInvalid],
            ["Active", [fields.Active.visible && fields.Active.required ? ew.Validators.required(fields.Active.caption) : null], fields.Active.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Active": <?= $Page->Active->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fprojecttemplateupdate" id="fprojecttemplateupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="projecttemplate">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_projecttemplateupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->template_name->Visible && (!$Page->isConfirm() || $Page->template_name->multiUpdateSelected())) { // template_name ?>
    <div id="r_template_name"<?= $Page->template_name->rowAttributes() ?>>
        <label for="x_template_name" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_template_name" id="u_template_name" class="form-check-input ew-multi-select" value="1"<?= $Page->template_name->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_template_name"><?= $Page->template_name->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->template_name->cellAttributes() ?>>
                <span id="el_projecttemplate_template_name">
                <input type="<?= $Page->template_name->getInputTextType() ?>" name="x_template_name" id="x_template_name" data-table="projecttemplate" data-field="x_template_name" value="<?= $Page->template_name->EditValue ?>" maxlength="150" placeholder="<?= HtmlEncode($Page->template_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->template_name->formatPattern()) ?>"<?= $Page->template_name->editAttributes() ?> aria-describedby="x_template_name_help">
                <?= $Page->template_name->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->template_name->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible && (!$Page->isConfirm() || $Page->description->multiUpdateSelected())) { // description ?>
    <div id="r_description"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_description" id="u_description" class="form-check-input ew-multi-select" value="1"<?= $Page->description->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_description"><?= $Page->description->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <span id="el_projecttemplate_description">
                <textarea data-table="projecttemplate" data-field="x_description" name="x_description" id="x_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>"<?= $Page->description->editAttributes() ?> aria-describedby="x_description_help"><?= $Page->description->EditValue ?></textarea>
                <?= $Page->description->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->description->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Active->Visible && (!$Page->isConfirm() || $Page->Active->multiUpdateSelected())) { // Active ?>
    <div id="r_Active"<?= $Page->Active->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Active" id="u_Active" class="form-check-input ew-multi-select" value="1"<?= $Page->Active->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Active"><?= $Page->Active->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Active->cellAttributes() ?>>
                <span id="el_projecttemplate_Active">
                <div class="form-check d-inline-block">
                    <input type="checkbox" class="form-check-input<?= $Page->Active->isInvalidClass() ?>" data-table="projecttemplate" data-field="x_Active" data-boolean name="x_Active" id="x_Active" value="1"<?= ConvertToBool($Page->Active->CurrentValue) ? " checked" : "" ?><?= $Page->Active->editAttributes() ?> aria-describedby="x_Active_help">
                    <div class="invalid-feedback"><?= $Page->Active->getErrorMessage() ?></div>
                </div>
                <?= $Page->Active->getCustomMessage() ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fprojecttemplateupdate"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fprojecttemplateupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("projecttemplate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
