<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$Register = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masteruser: currentTable } });
var currentPageID = ew.PAGE_ID = "register";
var currentForm;
var fregister;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fregister")
        .setPageId("register")

        // Add fields
        .setFields([
            ["EmployeeID", [fields.EmployeeID.visible && fields.EmployeeID.required ? ew.Validators.required(fields.EmployeeID.caption) : null], fields.EmployeeID.isInvalid],
            ["FirstName", [fields.FirstName.visible && fields.FirstName.required ? ew.Validators.required(fields.FirstName.caption) : null], fields.FirstName.isInvalid],
            ["LastName", [fields.LastName.visible && fields.LastName.required ? ew.Validators.required(fields.LastName.caption) : null], fields.LastName.isInvalid],
            ["FullName", [fields.FullName.visible && fields.FullName.required ? ew.Validators.required(fields.FullName.caption) : null], fields.FullName.isInvalid],
            ["_Username", [fields._Username.visible && fields._Username.required ? ew.Validators.required(fields._Username.caption) : null, ew.Validators.username(fields._Username.raw)], fields._Username.isInvalid],
            ["c_UserPassword", [ew.Validators.required(ew.language.phrase("ConfirmPassword")), ew.Validators.mismatchPassword], fields.UserPassword.isInvalid],
            ["UserPassword", [fields.UserPassword.visible && fields.UserPassword.required ? ew.Validators.required(fields.UserPassword.caption) : null, ew.Validators.password(fields.UserPassword.raw)], fields.UserPassword.isInvalid],
            ["Level", [fields.Level.visible && fields.Level.required ? ew.Validators.required(fields.Level.caption) : null], fields.Level.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null], fields._Email.isInvalid],
            ["Position", [fields.Position.visible && fields.Position.required ? ew.Validators.required(fields.Position.caption) : null], fields.Position.isInvalid],
            ["Department", [fields.Department.visible && fields.Department.required ? ew.Validators.required(fields.Department.caption) : null], fields.Department.isInvalid],
            ["Employee", [fields.Employee.visible && fields.Employee.required ? ew.Validators.required(fields.Employee.caption) : null], fields.Employee.isInvalid],
            ["WhatsAppNumber", [fields.WhatsAppNumber.visible && fields.WhatsAppNumber.required ? ew.Validators.required(fields.WhatsAppNumber.caption) : null], fields.WhatsAppNumber.isInvalid],
            ["Active", [fields.Active.visible && fields.Active.required ? ew.Validators.required(fields.Active.caption) : null], fields.Active.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Level": <?= $Page->Level->toClientList($Page) ?>,
            "Position": <?= $Page->Position->toClientList($Page) ?>,
            "Employee": <?= $Page->Employee->toClientList($Page) ?>,
            "Active": <?= $Page->Active->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fregister" id="fregister" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<input type="hidden" name="t" value="masteruser">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<div class="ew-register-div"><!-- page* -->
<?php if ($Page->FirstName->Visible) { // FirstName ?>
    <div id="r_FirstName"<?= $Page->FirstName->rowAttributes() ?>>
        <label id="elh_masteruser_FirstName" for="x_FirstName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FirstName->caption() ?><?= $Page->FirstName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FirstName->cellAttributes() ?>>
<?php if (!$Page->isConfirm()) { ?>
<span id="el_masteruser_FirstName">
<input type="<?= $Page->FirstName->getInputTextType() ?>" name="x_FirstName" id="x_FirstName" data-table="masteruser" data-field="x_FirstName" value="<?= $Page->FirstName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->FirstName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FirstName->formatPattern()) ?>"<?= $Page->FirstName->editAttributes() ?> aria-describedby="x_FirstName_help">
<?= $Page->FirstName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FirstName->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el_masteruser_FirstName">
<span<?= $Page->FirstName->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->FirstName->getDisplayValue($Page->FirstName->ViewValue))) ?>"></span>
<input type="hidden" data-table="masteruser" data-field="x_FirstName" data-hidden="1" name="x_FirstName" id="x_FirstName" value="<?= HtmlEncode($Page->FirstName->FormValue) ?>">
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->LastName->Visible) { // LastName ?>
    <div id="r_LastName"<?= $Page->LastName->rowAttributes() ?>>
        <label id="elh_masteruser_LastName" for="x_LastName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->LastName->caption() ?><?= $Page->LastName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->LastName->cellAttributes() ?>>
<?php if (!$Page->isConfirm()) { ?>
<span id="el_masteruser_LastName">
<input type="<?= $Page->LastName->getInputTextType() ?>" name="x_LastName" id="x_LastName" data-table="masteruser" data-field="x_LastName" value="<?= $Page->LastName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->LastName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->LastName->formatPattern()) ?>"<?= $Page->LastName->editAttributes() ?> aria-describedby="x_LastName_help">
<?= $Page->LastName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->LastName->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el_masteruser_LastName">
<span<?= $Page->LastName->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->LastName->getDisplayValue($Page->LastName->ViewValue))) ?>"></span>
<input type="hidden" data-table="masteruser" data-field="x_LastName" data-hidden="1" name="x_LastName" id="x_LastName" value="<?= HtmlEncode($Page->LastName->FormValue) ?>">
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FullName->Visible) { // FullName ?>
    <div id="r_FullName"<?= $Page->FullName->rowAttributes() ?>>
        <label id="elh_masteruser_FullName" for="x_FullName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FullName->caption() ?><?= $Page->FullName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FullName->cellAttributes() ?>>
<?php if (!$Page->isConfirm()) { ?>
<span id="el_masteruser_FullName">
<input type="<?= $Page->FullName->getInputTextType() ?>" name="x_FullName" id="x_FullName" data-table="masteruser" data-field="x_FullName" value="<?= $Page->FullName->EditValue ?>" size="30" maxlength="201" placeholder="<?= HtmlEncode($Page->FullName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FullName->formatPattern()) ?>"<?= $Page->FullName->editAttributes() ?> aria-describedby="x_FullName_help">
<?= $Page->FullName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FullName->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el_masteruser_FullName">
<span<?= $Page->FullName->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->FullName->getDisplayValue($Page->FullName->ViewValue))) ?>"></span>
<input type="hidden" data-table="masteruser" data-field="x_FullName" data-hidden="1" name="x_FullName" id="x_FullName" value="<?= HtmlEncode($Page->FullName->FormValue) ?>">
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_Username->Visible) { // Username ?>
    <div id="r__Username"<?= $Page->_Username->rowAttributes() ?>>
        <label id="elh_masteruser__Username" for="x__Username" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Username->caption() ?><?= $Page->_Username->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Username->cellAttributes() ?>>
<?php if (!$Page->isConfirm()) { ?>
<span id="el_masteruser__Username">
<input type="<?= $Page->_Username->getInputTextType() ?>" name="x__Username" id="x__Username" data-table="masteruser" data-field="x__Username" value="<?= $Page->_Username->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_Username->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Username->formatPattern()) ?>"<?= $Page->_Username->editAttributes() ?> aria-describedby="x__Username_help">
<?= $Page->_Username->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Username->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el_masteruser__Username">
<span<?= $Page->_Username->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->_Username->getDisplayValue($Page->_Username->ViewValue))) ?>"></span>
<input type="hidden" data-table="masteruser" data-field="x__Username" data-hidden="1" name="x__Username" id="x__Username" value="<?= HtmlEncode($Page->_Username->FormValue) ?>">
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->UserPassword->Visible) { // UserPassword ?>
    <div id="r_UserPassword"<?= $Page->UserPassword->rowAttributes() ?>>
        <label id="elh_masteruser_UserPassword" for="x_UserPassword" class="<?= $Page->LeftColumnClass ?>"><?= $Page->UserPassword->caption() ?><?= $Page->UserPassword->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->UserPassword->cellAttributes() ?>>
<?php if (!$Page->isConfirm()) { ?>
<span id="el_masteruser_UserPassword">
<div class="input-group">
    <input type="password" name="x_UserPassword" id="x_UserPassword" autocomplete="new-password" data-field="x_UserPassword" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->UserPassword->getPlaceHolder()) ?>"<?= $Page->UserPassword->editAttributes() ?> aria-describedby="x_UserPassword_help">
    <button type="button" class="btn btn-default ew-toggle-password rounded-end" data-ew-action="password"><i class="fa-solid fa-eye"></i></button>
</div>
<?= $Page->UserPassword->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->UserPassword->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el_masteruser_UserPassword">
<span<?= $Page->UserPassword->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->UserPassword->getDisplayValue($Page->UserPassword->ViewValue))) ?>"></span>
<input type="hidden" data-table="masteruser" data-field="x_UserPassword" data-hidden="1" name="x_UserPassword" id="x_UserPassword" value="<?= HtmlEncode($Page->UserPassword->FormValue) ?>">
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->UserPassword->Visible) { // UserPassword ?>
    <div id="r_c_UserPassword" class="row">
        <label id="elh_c_masteruser_UserPassword" for="c_UserPassword" class="<?= $Page->LeftColumnClass ?>"><?= $Language->phrase("Confirm") ?> <?= $Page->UserPassword->caption() ?><?= $Page->UserPassword->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->UserPassword->cellAttributes() ?>>
<?php if (!$Page->isConfirm()) { ?>
<span id="el_c_masteruser_UserPassword">
<div class="input-group">
    <input type="password" name="c_UserPassword" id="c_UserPassword" autocomplete="new-password" data-field="c_UserPassword" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->UserPassword->getPlaceHolder()) ?>"<?= $Page->UserPassword->editAttributes() ?> aria-describedby="x_UserPassword_help">
    <button type="button" class="btn btn-default ew-toggle-password rounded-end" data-ew-action="password"><i class="fa-solid fa-eye"></i></button>
</div>
<?= $Page->UserPassword->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->UserPassword->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el_c_masteruser_UserPassword">
<span<?= $Page->UserPassword->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->UserPassword->getDisplayValue($Page->UserPassword->ViewValue))) ?>"></span>
<input type="hidden" data-table="masteruser" data-field="x_UserPassword" data-hidden="1" name="c_UserPassword" id="c_UserPassword" value="<?= HtmlEncode($Page->UserPassword->FormValue) ?>">
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
    <div id="r__Email"<?= $Page->_Email->rowAttributes() ?>>
        <label id="elh_masteruser__Email" for="x__Email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Email->caption() ?><?= $Page->_Email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Email->cellAttributes() ?>>
<?php if (!$Page->isConfirm()) { ?>
<span id="el_masteruser__Email">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="masteruser" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?> aria-describedby="x__Email_help">
<?= $Page->_Email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el_masteruser__Email">
<span<?= $Page->_Email->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->_Email->getDisplayValue($Page->_Email->ViewValue))) ?>"></span>
<input type="hidden" data-table="masteruser" data-field="x__Email" data-hidden="1" name="x__Email" id="x__Email" value="<?= HtmlEncode($Page->_Email->FormValue) ?>">
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Position->Visible) { // Position ?>
    <div id="r_Position"<?= $Page->Position->rowAttributes() ?>>
        <label id="elh_masteruser_Position" for="x_Position" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Position->caption() ?><?= $Page->Position->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Position->cellAttributes() ?>>
<?php if (!$Page->isConfirm()) { ?>
<span id="el_masteruser_Position">
    <select
        id="x_Position"
        name="x_Position"
        class="form-select ew-select<?= $Page->Position->isInvalidClass() ?>"
        <?php if (!$Page->Position->IsNativeSelect) { ?>
        data-select2-id="fregister_x_Position"
        <?php } ?>
        data-table="masteruser"
        data-field="x_Position"
        data-value-separator="<?= $Page->Position->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Position->getPlaceHolder()) ?>"
        <?= $Page->Position->editAttributes() ?>>
        <?= $Page->Position->selectOptionListHtml("x_Position") ?>
    </select>
    <?= $Page->Position->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Position->getErrorMessage() ?></div>
<?php if (!$Page->Position->IsNativeSelect) { ?>
<script>
loadjs.ready("fregister", function() {
    var options = { name: "x_Position", selectId: "fregister_x_Position" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fregister.lists.Position?.lookupOptions.length) {
        options.data = { id: "x_Position", form: "fregister" };
    } else {
        options.ajax = { id: "x_Position", form: "fregister", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.masteruser.fields.Position.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el_masteruser_Position">
<span<?= $Page->Position->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->Position->getDisplayValue($Page->Position->ViewValue) ?></span></span>
<input type="hidden" data-table="masteruser" data-field="x_Position" data-hidden="1" name="x_Position" id="x_Position" value="<?= HtmlEncode($Page->Position->FormValue) ?>">
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Department->Visible) { // Department ?>
    <div id="r_Department"<?= $Page->Department->rowAttributes() ?>>
        <label id="elh_masteruser_Department" for="x_Department" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Department->caption() ?><?= $Page->Department->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Department->cellAttributes() ?>>
<?php if (!$Page->isConfirm()) { ?>
<span id="el_masteruser_Department">
<input type="<?= $Page->Department->getInputTextType() ?>" name="x_Department" id="x_Department" data-table="masteruser" data-field="x_Department" value="<?= $Page->Department->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Department->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Department->formatPattern()) ?>"<?= $Page->Department->editAttributes() ?> aria-describedby="x_Department_help">
<?= $Page->Department->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Department->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el_masteruser_Department">
<span<?= $Page->Department->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->Department->getDisplayValue($Page->Department->ViewValue))) ?>"></span>
<input type="hidden" data-table="masteruser" data-field="x_Department" data-hidden="1" name="x_Department" id="x_Department" value="<?= HtmlEncode($Page->Department->FormValue) ?>">
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Employee->Visible) { // Employee ?>
    <div id="r_Employee"<?= $Page->Employee->rowAttributes() ?>>
        <label id="elh_masteruser_Employee" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Employee->caption() ?><?= $Page->Employee->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Employee->cellAttributes() ?>>
<?php if (!$Page->isConfirm()) { ?>
<span id="el_masteruser_Employee">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->Employee->isInvalidClass() ?>" data-table="masteruser" data-field="x_Employee" data-boolean name="x_Employee" id="x_Employee" value="1"<?= ConvertToBool($Page->Employee->CurrentValue) ? " checked" : "" ?><?= $Page->Employee->editAttributes() ?> aria-describedby="x_Employee_help">
    <div class="invalid-feedback"><?= $Page->Employee->getErrorMessage() ?></div>
</div>
<?= $Page->Employee->getCustomMessage() ?>
</span>
<?php } else { ?>
<span id="el_masteruser_Employee">
<span<?= $Page->Employee->viewAttributes() ?>>
<i class="fa-regular fa-square<?php if (ConvertToBool($Page->Employee->CurrentValue)) { ?>-check<?php } ?> ew-icon ew-boolean"></i>
</span>
<input type="hidden" data-table="masteruser" data-field="x_Employee" data-hidden="1" name="x_Employee" id="x_Employee" value="<?= HtmlEncode($Page->Employee->FormValue) ?>">
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->WhatsAppNumber->Visible) { // WhatsAppNumber ?>
    <div id="r_WhatsAppNumber"<?= $Page->WhatsAppNumber->rowAttributes() ?>>
        <label id="elh_masteruser_WhatsAppNumber" for="x_WhatsAppNumber" class="<?= $Page->LeftColumnClass ?>"><?= $Page->WhatsAppNumber->caption() ?><?= $Page->WhatsAppNumber->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->WhatsAppNumber->cellAttributes() ?>>
<?php if (!$Page->isConfirm()) { ?>
<span id="el_masteruser_WhatsAppNumber">
<input type="<?= $Page->WhatsAppNumber->getInputTextType() ?>" name="x_WhatsAppNumber" id="x_WhatsAppNumber" data-table="masteruser" data-field="x_WhatsAppNumber" value="<?= $Page->WhatsAppNumber->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->WhatsAppNumber->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WhatsAppNumber->formatPattern()) ?>"<?= $Page->WhatsAppNumber->editAttributes() ?> aria-describedby="x_WhatsAppNumber_help">
<?= $Page->WhatsAppNumber->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->WhatsAppNumber->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el_masteruser_WhatsAppNumber">
<span<?= $Page->WhatsAppNumber->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->WhatsAppNumber->getDisplayValue($Page->WhatsAppNumber->ViewValue))) ?>"></span>
<input type="hidden" data-table="masteruser" data-field="x_WhatsAppNumber" data-hidden="1" name="x_WhatsAppNumber" id="x_WhatsAppNumber" value="<?= HtmlEncode($Page->WhatsAppNumber->FormValue) ?>">
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn disabled enable-on-init" name="btn-action" id="btn-action" type="submit" form="fregister" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("RegisterBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fregister"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="fregister" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masteruser");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your startup script here, no need to add script tags.
});
</script>
