<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$ViewwaitingfortaskSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { viewwaitingfortask: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fviewwaitingfortasksearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fviewwaitingfortasksearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["EmployeeID", [ew.Validators.integer], fields.EmployeeID.isInvalid],
            ["FullName", [], fields.FullName.isInvalid],
            ["WhatsAppNumber", [], fields.WhatsAppNumber.isInvalid],
            ["Position", [], fields.Position.isInvalid],
            ["Department", [], fields.Department.isInvalid],
            ["WaitingTask", [ew.Validators.integer], fields.WaitingTask.isInvalid],
            ["y_WaitingTask", [ew.Validators.between], false],
            ["PlanEnd", [ew.Validators.datetime(fields.PlanEnd.clientFormatPattern)], fields.PlanEnd.isInvalid],
            ["y_PlanEnd", [ew.Validators.between], false],
            ["EndDate", [ew.Validators.datetime(fields.EndDate.clientFormatPattern)], fields.EndDate.isInvalid],
            ["y_EndDate", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fviewwaitingfortasksearch" id="fviewwaitingfortasksearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="viewwaitingfortask">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->EmployeeID->Visible) { // EmployeeID ?>
    <div id="r_EmployeeID" class="row"<?= $Page->EmployeeID->rowAttributes() ?>>
        <label for="x_EmployeeID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_viewwaitingfortask_EmployeeID"><?= $Page->EmployeeID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_EmployeeID" id="z_EmployeeID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->EmployeeID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_viewwaitingfortask_EmployeeID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->EmployeeID->getInputTextType() ?>" name="x_EmployeeID" id="x_EmployeeID" data-table="viewwaitingfortask" data-field="x_EmployeeID" value="<?= $Page->EmployeeID->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->EmployeeID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EmployeeID->formatPattern()) ?>"<?= $Page->EmployeeID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EmployeeID->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FullName->Visible) { // FullName ?>
    <div id="r_FullName" class="row"<?= $Page->FullName->rowAttributes() ?>>
        <label for="x_FullName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_viewwaitingfortask_FullName"><?= $Page->FullName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_FullName" id="z_FullName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FullName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_viewwaitingfortask_FullName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FullName->getInputTextType() ?>" name="x_FullName" id="x_FullName" data-table="viewwaitingfortask" data-field="x_FullName" value="<?= $Page->FullName->EditValue ?>" size="30" maxlength="201" placeholder="<?= HtmlEncode($Page->FullName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FullName->formatPattern()) ?>"<?= $Page->FullName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FullName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->WhatsAppNumber->Visible) { // WhatsAppNumber ?>
    <div id="r_WhatsAppNumber" class="row"<?= $Page->WhatsAppNumber->rowAttributes() ?>>
        <label for="x_WhatsAppNumber" class="<?= $Page->LeftColumnClass ?>"><span id="elh_viewwaitingfortask_WhatsAppNumber"><?= $Page->WhatsAppNumber->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_WhatsAppNumber" id="z_WhatsAppNumber" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->WhatsAppNumber->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_viewwaitingfortask_WhatsAppNumber" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->WhatsAppNumber->getInputTextType() ?>" name="x_WhatsAppNumber" id="x_WhatsAppNumber" data-table="viewwaitingfortask" data-field="x_WhatsAppNumber" value="<?= $Page->WhatsAppNumber->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->WhatsAppNumber->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WhatsAppNumber->formatPattern()) ?>"<?= $Page->WhatsAppNumber->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->WhatsAppNumber->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Position->Visible) { // Position ?>
    <div id="r_Position" class="row"<?= $Page->Position->rowAttributes() ?>>
        <label for="x_Position" class="<?= $Page->LeftColumnClass ?>"><span id="elh_viewwaitingfortask_Position"><?= $Page->Position->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Position" id="z_Position" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Position->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_viewwaitingfortask_Position" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Position->getInputTextType() ?>" name="x_Position" id="x_Position" data-table="viewwaitingfortask" data-field="x_Position" value="<?= $Page->Position->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Position->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Position->formatPattern()) ?>"<?= $Page->Position->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Position->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Department->Visible) { // Department ?>
    <div id="r_Department" class="row"<?= $Page->Department->rowAttributes() ?>>
        <label for="x_Department" class="<?= $Page->LeftColumnClass ?>"><span id="elh_viewwaitingfortask_Department"><?= $Page->Department->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Department" id="z_Department" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Department->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_viewwaitingfortask_Department" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Department->getInputTextType() ?>" name="x_Department" id="x_Department" data-table="viewwaitingfortask" data-field="x_Department" value="<?= $Page->Department->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Department->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Department->formatPattern()) ?>"<?= $Page->Department->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Department->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->WaitingTask->Visible) { // WaitingTask ?>
    <div id="r_WaitingTask" class="row"<?= $Page->WaitingTask->rowAttributes() ?>>
        <label for="x_WaitingTask" class="<?= $Page->LeftColumnClass ?>"><span id="elh_viewwaitingfortask_WaitingTask"><?= $Page->WaitingTask->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->WaitingTask->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_WaitingTask" id="z_WaitingTask" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->WaitingTask->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->WaitingTask->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_viewwaitingfortask_WaitingTask" class="ew-search-field">
<input type="<?= $Page->WaitingTask->getInputTextType() ?>" name="x_WaitingTask" id="x_WaitingTask" data-table="viewwaitingfortask" data-field="x_WaitingTask" value="<?= $Page->WaitingTask->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->WaitingTask->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WaitingTask->formatPattern()) ?>"<?= $Page->WaitingTask->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->WaitingTask->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_viewwaitingfortask_WaitingTask" class="ew-search-field2 d-none">
<input type="<?= $Page->WaitingTask->getInputTextType() ?>" name="y_WaitingTask" id="y_WaitingTask" data-table="viewwaitingfortask" data-field="x_WaitingTask" value="<?= $Page->WaitingTask->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->WaitingTask->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WaitingTask->formatPattern()) ?>"<?= $Page->WaitingTask->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->WaitingTask->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PlanEnd->Visible) { // PlanEnd ?>
    <div id="r_PlanEnd" class="row"<?= $Page->PlanEnd->rowAttributes() ?>>
        <label for="x_PlanEnd" class="<?= $Page->LeftColumnClass ?>"><span id="elh_viewwaitingfortask_PlanEnd"><?= $Page->PlanEnd->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PlanEnd->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_PlanEnd" id="z_PlanEnd" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->PlanEnd->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->PlanEnd->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_viewwaitingfortask_PlanEnd" class="ew-search-field">
<input type="<?= $Page->PlanEnd->getInputTextType() ?>" name="x_PlanEnd" id="x_PlanEnd" data-table="viewwaitingfortask" data-field="x_PlanEnd" value="<?= $Page->PlanEnd->EditValue ?>" placeholder="<?= HtmlEncode($Page->PlanEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanEnd->formatPattern()) ?>"<?= $Page->PlanEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanEnd->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanEnd->ReadOnly && !$Page->PlanEnd->Disabled && !isset($Page->PlanEnd->EditAttrs["readonly"]) && !isset($Page->PlanEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fviewwaitingfortasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fviewwaitingfortasksearch", "x_PlanEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_viewwaitingfortask_PlanEnd" class="ew-search-field2 d-none">
<input type="<?= $Page->PlanEnd->getInputTextType() ?>" name="y_PlanEnd" id="y_PlanEnd" data-table="viewwaitingfortask" data-field="x_PlanEnd" value="<?= $Page->PlanEnd->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->PlanEnd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PlanEnd->formatPattern()) ?>"<?= $Page->PlanEnd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PlanEnd->getErrorMessage(false) ?></div>
<?php if (!$Page->PlanEnd->ReadOnly && !$Page->PlanEnd->Disabled && !isset($Page->PlanEnd->EditAttrs["readonly"]) && !isset($Page->PlanEnd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fviewwaitingfortasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fviewwaitingfortasksearch", "y_PlanEnd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->EndDate->Visible) { // EndDate ?>
    <div id="r_EndDate" class="row"<?= $Page->EndDate->rowAttributes() ?>>
        <label for="x_EndDate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_viewwaitingfortask_EndDate"><?= $Page->EndDate->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->EndDate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_EndDate" id="z_EndDate" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->EndDate->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->EndDate->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_viewwaitingfortask_EndDate" class="ew-search-field">
<input type="<?= $Page->EndDate->getInputTextType() ?>" name="x_EndDate" id="x_EndDate" data-table="viewwaitingfortask" data-field="x_EndDate" value="<?= $Page->EndDate->EditValue ?>" placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EndDate->formatPattern()) ?>"<?= $Page->EndDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage(false) ?></div>
<?php if (!$Page->EndDate->ReadOnly && !$Page->EndDate->Disabled && !isset($Page->EndDate->EditAttrs["readonly"]) && !isset($Page->EndDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fviewwaitingfortasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fviewwaitingfortasksearch", "x_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_viewwaitingfortask_EndDate" class="ew-search-field2 d-none">
<input type="<?= $Page->EndDate->getInputTextType() ?>" name="y_EndDate" id="y_EndDate" data-table="viewwaitingfortask" data-field="x_EndDate" value="<?= $Page->EndDate->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->EndDate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EndDate->formatPattern()) ?>"<?= $Page->EndDate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EndDate->getErrorMessage(false) ?></div>
<?php if (!$Page->EndDate->ReadOnly && !$Page->EndDate->Disabled && !isset($Page->EndDate->EditAttrs["readonly"]) && !isset($Page->EndDate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fviewwaitingfortasksearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(5) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fviewwaitingfortasksearch", "y_EndDate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fviewwaitingfortasksearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fviewwaitingfortasksearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fviewwaitingfortasksearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("viewwaitingfortask");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
