<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$VuserSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { vuser: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fvusersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fvusersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["EmployeeID", [ew.Validators.integer], fields.EmployeeID.isInvalid],
            ["FirstName", [], fields.FirstName.isInvalid],
            ["LastName", [], fields.LastName.isInvalid],
            ["FullName", [], fields.FullName.isInvalid],
            ["_Email", [], fields._Email.isInvalid],
            ["WhatsAppNumber", [], fields.WhatsAppNumber.isInvalid],
            ["Department", [], fields.Department.isInvalid],
            ["Position", [], fields.Position.isInvalid],
            ["_Username", [], fields._Username.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fvusersearch" id="fvusersearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="vuser">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->EmployeeID->Visible) { // EmployeeID ?>
    <div id="r_EmployeeID" class="row"<?= $Page->EmployeeID->rowAttributes() ?>>
        <label for="x_EmployeeID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vuser_EmployeeID"><?= $Page->EmployeeID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_EmployeeID" id="z_EmployeeID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->EmployeeID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vuser_EmployeeID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->EmployeeID->getInputTextType() ?>" name="x_EmployeeID" id="x_EmployeeID" data-table="vuser" data-field="x_EmployeeID" value="<?= $Page->EmployeeID->EditValue ?>" placeholder="<?= HtmlEncode($Page->EmployeeID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->EmployeeID->formatPattern()) ?>"<?= $Page->EmployeeID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->EmployeeID->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FirstName->Visible) { // FirstName ?>
    <div id="r_FirstName" class="row"<?= $Page->FirstName->rowAttributes() ?>>
        <label for="x_FirstName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vuser_FirstName"><?= $Page->FirstName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_FirstName" id="z_FirstName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FirstName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vuser_FirstName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FirstName->getInputTextType() ?>" name="x_FirstName" id="x_FirstName" data-table="vuser" data-field="x_FirstName" value="<?= $Page->FirstName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->FirstName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FirstName->formatPattern()) ?>"<?= $Page->FirstName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FirstName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->LastName->Visible) { // LastName ?>
    <div id="r_LastName" class="row"<?= $Page->LastName->rowAttributes() ?>>
        <label for="x_LastName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vuser_LastName"><?= $Page->LastName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_LastName" id="z_LastName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->LastName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vuser_LastName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->LastName->getInputTextType() ?>" name="x_LastName" id="x_LastName" data-table="vuser" data-field="x_LastName" value="<?= $Page->LastName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->LastName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->LastName->formatPattern()) ?>"<?= $Page->LastName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->LastName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->FullName->Visible) { // FullName ?>
    <div id="r_FullName" class="row"<?= $Page->FullName->rowAttributes() ?>>
        <label for="x_FullName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vuser_FullName"><?= $Page->FullName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_FullName" id="z_FullName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->FullName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vuser_FullName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->FullName->getInputTextType() ?>" name="x_FullName" id="x_FullName" data-table="vuser" data-field="x_FullName" value="<?= $Page->FullName->EditValue ?>" size="30" maxlength="201" placeholder="<?= HtmlEncode($Page->FullName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FullName->formatPattern()) ?>"<?= $Page->FullName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->FullName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
    <div id="r__Email" class="row"<?= $Page->_Email->rowAttributes() ?>>
        <label for="x__Email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vuser__Email"><?= $Page->_Email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__Email" id="z__Email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_Email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vuser__Email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="vuser" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->WhatsAppNumber->Visible) { // WhatsAppNumber ?>
    <div id="r_WhatsAppNumber" class="row"<?= $Page->WhatsAppNumber->rowAttributes() ?>>
        <label for="x_WhatsAppNumber" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vuser_WhatsAppNumber"><?= $Page->WhatsAppNumber->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_WhatsAppNumber" id="z_WhatsAppNumber" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->WhatsAppNumber->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vuser_WhatsAppNumber" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->WhatsAppNumber->getInputTextType() ?>" name="x_WhatsAppNumber" id="x_WhatsAppNumber" data-table="vuser" data-field="x_WhatsAppNumber" value="<?= $Page->WhatsAppNumber->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->WhatsAppNumber->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->WhatsAppNumber->formatPattern()) ?>"<?= $Page->WhatsAppNumber->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->WhatsAppNumber->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Department->Visible) { // Department ?>
    <div id="r_Department" class="row"<?= $Page->Department->rowAttributes() ?>>
        <label for="x_Department" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vuser_Department"><?= $Page->Department->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Department" id="z_Department" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Department->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vuser_Department" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Department->getInputTextType() ?>" name="x_Department" id="x_Department" data-table="vuser" data-field="x_Department" value="<?= $Page->Department->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Department->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Department->formatPattern()) ?>"<?= $Page->Department->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Department->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Position->Visible) { // Position ?>
    <div id="r_Position" class="row"<?= $Page->Position->rowAttributes() ?>>
        <label for="x_Position" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vuser_Position"><?= $Page->Position->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Position" id="z_Position" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Position->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vuser_Position" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Position->getInputTextType() ?>" name="x_Position" id="x_Position" data-table="vuser" data-field="x_Position" value="<?= $Page->Position->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Position->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Position->formatPattern()) ?>"<?= $Page->Position->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Position->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_Username->Visible) { // Username ?>
    <div id="r__Username" class="row"<?= $Page->_Username->rowAttributes() ?>>
        <label for="x__Username" class="<?= $Page->LeftColumnClass ?>"><span id="elh_vuser__Username"><?= $Page->_Username->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__Username" id="z__Username" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_Username->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_vuser__Username" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_Username->getInputTextType() ?>" name="x__Username" id="x__Username" data-table="vuser" data-field="x__Username" value="<?= $Page->_Username->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_Username->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Username->formatPattern()) ?>"<?= $Page->_Username->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_Username->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fvusersearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fvusersearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fvusersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("vuser");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
