<?php
declare(strict_types=1);

namespace PHPMaker2026\Reimbursement;

use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return static function (RoutingConfigurator $routes): void {
    // API
    $routes->add('api_login_check', '/api/login');

    // Login
    $routes->add('login_check', '/login_check');

    // Use PhpCaptcha / Two factor authentication
    $routes->add('login1fa', '/login1fa');

    // Dispatch Route Config event
    $event = new RouteConfigurationEvent($routes);
    DispatchEvent($event, RouteConfigurationEvent::class);
};
