<?php

namespace PHPMaker2026\Reimbursement;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;

/**
 * App controller
 */
class AppController extends BaseController
{
    // Login
    #[Route('/login', methods: ['GET', 'POST', 'OPTIONS'], name: 'login')]
    public function login(): Response
    {
        return $this->runPage('Login');
    }

    // personaldata
    #[Route('/personaldata', methods: ['GET', 'POST', 'OPTIONS'], name: 'personaldata')]
    public function personaldata(PersonalData $page): Response
    {
        return $this->runPage($page);
    }

    // register
    #[Route('/register', methods: ['GET', 'POST', 'OPTIONS'], name: 'register')]
    public function register(Register $page): Response
    {
        return $this->runPage($page);
    }

    // userpriv
    #[Route('/userpriv', methods: ['GET', 'POST', 'OPTIONS'], name: 'userpriv')]
    public function userpriv(Userpriv $page): Response
    {
        // Load UserLevelTables
        $page->UserLevelTables = $this->parameters->get("user.level.tables");
        return $this->runPage($page);
    }

    // Session and JWT refresher
    #[Route('/session', methods: ['GET', 'OPTIONS'], name: 'session')]
    public function session(Request $request): Response
    {
        $jwtRefresher = $this->locator->get(JwtRefresher::class);
        return $jwtRefresher($this->symfonySecurity->getUser());
    }

    // Index
    #[Route('/', methods: 'GET', name: 'index')]
    public function index(Request $request): Response
    {
        $url = '';
        foreach ($this->parameters->get('user.level.tables') as $t) {
            if ($t[0] == 'mtreimbursementtype') { // Check default table
                if ($this->security->allowList($t[4] . $t[0])) {
                    $url = $t[5];
                    break;
                }
            } elseif ($url == '') {
                if ($t[5] && $this->security->allowList($t[4] . $t[0])) {
                    $url = $t[5];
                }
            }
        }
        if ($url === '' && !$this->security->isLoggedIn()) {
            $url = 'login';
        }
        if ($url == '') {
            throw new HttpException(401, DeniedMessage());
        }
        return new RedirectResponse($url, Config('REDIRECT_STATUS_CODE'));
    }
}
