<?php

namespace PHPMaker2026\Reimbursement;

use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Exception;

class CaptchaController
{

    public function __construct(
        protected RequestStack $requestStack,
        protected CaptchaInterface $captcha,
    ) {}

    #[Route('/captcha/{page}', methods: ['GET', 'OPTIONS'], name: 'captcha')]
    public function captcha(): Response
    {
        if ($this->captcha) {
            $sessionName = AddTabId($this->captcha->getSessionName());
            $session = $this->requestStack->getSession();
            $session->set($sessionName, $this->captcha->generateCode());
            return $this->captcha->getStreamedResponse();
        }
        throw new Exception("Missing CAPTCHA service");
    }
}
