<?php

namespace PHPMaker2026\Reimbursement;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\EventStreamResponse;
use Symfony\Component\HttpFoundation\StreamedJsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;
use Symfony\Component\Routing\Requirement\Requirement;
use PHPMaker2026\Reimbursement\Db\Entity;

/**
 * Mtproject controller
 */
#[IsGranted('USER_LEVEL')]
class MtprojectController extends BaseController
{
    // list
    #[Route('/MtprojectList', methods: ['GET', 'POST', 'OPTIONS'], name: 'list.mtproject')]
    public function list(Request $request, MtprojectList $page): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Perform inline/grid actions
        if ($response = $page->action()) {
            return $response;
        }
        $page->TotalRecords = $page->listRecordCount();
        if (!$page->Records) {
            $page->Records = $page->loadRecords($page->StartRecord - 1, $page->DisplayRecords);
        }

        // Run page
        return $this->runPage($page);
    }

    // add
    #[Route('/MtprojectAdd/{projectId:mtproject?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'add.mtproject')]
    public function add(Request $request, MtprojectAdd $page, ?Entity\Mtproject $mtproject = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtproject) {
            $page->CurrentRecord = $mtproject;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // view
    #[Route('/MtprojectView/{projectId:mtproject?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'view.mtproject')]
    public function view(Request $request, MtprojectView $page, ?Entity\Mtproject $mtproject = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtproject) {
            $page->CurrentRecord = $mtproject;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // edit
    #[Route('/MtprojectEdit/{projectId:mtproject?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'edit.mtproject')]
    public function edit(Request $request, MtprojectEdit $page, ?Entity\Mtproject $mtproject = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtproject) {
            $page->CurrentRecord = $mtproject;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // delete
    #[Route('/MtprojectDelete/{projectId:mtproject?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'delete.mtproject')]
    public function delete(Request $request, MtprojectDelete $page, ?Entity\Mtproject $mtproject = null): Response
    {
        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtproject) {
            $page->CurrentRecord = $mtproject;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }
}
