<?php

namespace PHPMaker2026\Reimbursement;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\EventStreamResponse;
use Symfony\Component\HttpFoundation\StreamedJsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;
use Symfony\Component\Routing\Requirement\Requirement;
use PHPMaker2026\Reimbursement\Db\Entity;

/**
 * Mtreimbursementtype controller
 */
#[IsGranted('USER_LEVEL')]
class MtreimbursementtypeController extends BaseController
{
    // list
    #[Route('/MtreimbursementtypeList', methods: ['GET', 'POST', 'OPTIONS'], name: 'list.mtreimbursementtype')]
    public function list(Request $request, MtreimbursementtypeList $page): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Perform inline/grid actions
        if ($response = $page->action()) {
            return $response;
        }
        $page->TotalRecords = $page->listRecordCount();
        if (!$page->Records) {
            $page->Records = $page->loadRecords($page->StartRecord - 1, $page->DisplayRecords);
        }

        // Run page
        return $this->runPage($page);
    }

    // add
    #[Route('/MtreimbursementtypeAdd/{id:mtreimbursementtype?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'add.mtreimbursementtype')]
    public function add(Request $request, MtreimbursementtypeAdd $page, ?Entity\Mtreimbursementtype $mtreimbursementtype = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtreimbursementtype) {
            $page->CurrentRecord = $mtreimbursementtype;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // view
    #[Route('/MtreimbursementtypeView/{id:mtreimbursementtype?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'view.mtreimbursementtype')]
    public function view(Request $request, MtreimbursementtypeView $page, ?Entity\Mtreimbursementtype $mtreimbursementtype = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtreimbursementtype) {
            $page->CurrentRecord = $mtreimbursementtype;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // edit
    #[Route('/MtreimbursementtypeEdit/{id:mtreimbursementtype?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'edit.mtreimbursementtype')]
    public function edit(Request $request, MtreimbursementtypeEdit $page, ?Entity\Mtreimbursementtype $mtreimbursementtype = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtreimbursementtype) {
            $page->CurrentRecord = $mtreimbursementtype;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // delete
    #[Route('/MtreimbursementtypeDelete/{id:mtreimbursementtype?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'delete.mtreimbursementtype')]
    public function delete(Request $request, MtreimbursementtypeDelete $page, ?Entity\Mtreimbursementtype $mtreimbursementtype = null): Response
    {
        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtreimbursementtype) {
            $page->CurrentRecord = $mtreimbursementtype;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }
}
