<?php

namespace PHPMaker2026\Reimbursement;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\EventStreamResponse;
use Symfony\Component\HttpFoundation\StreamedJsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;
use Symfony\Component\Routing\Requirement\Requirement;
use PHPMaker2026\Reimbursement\Db\Entity;

/**
 * Mtuser controller
 */
#[IsGranted('USER_LEVEL')]
class MtuserController extends BaseController
{
    // list
    #[Route('/MtuserList', methods: ['GET', 'POST', 'OPTIONS'], name: 'list.mtuser')]
    public function list(Request $request, MtuserList $page): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Perform inline/grid actions
        if ($response = $page->action()) {
            return $response;
        }
        $page->TotalRecords = $page->listRecordCount();
        if (!$page->Records) {
            $page->Records = $page->loadRecords($page->StartRecord - 1, $page->DisplayRecords);
        }

        // Run page
        return $this->runPage($page);
    }

    // add
    #[Route('/MtuserAdd/{id:mtuser?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'add.mtuser')]
    public function add(Request $request, MtuserAdd $page, ?Entity\Mtuser $mtuser = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuser) {
            if (!$page->isValidUserID('add', $mtuser)) {
                throw new AccessDeniedException(sprintf($this->language->phrase('NoAccessPermission', $mtuser->identifierValuesAsString())));
            }
            $page->CurrentRecord = $mtuser;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // view
    #[Route('/MtuserView/{id:mtuser?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'view.mtuser')]
    public function view(Request $request, MtuserView $page, ?Entity\Mtuser $mtuser = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuser) {
            if (!$page->isValidUserID('view', $mtuser)) {
                throw new AccessDeniedException(sprintf($this->language->phrase('NoAccessPermission', $mtuser->identifierValuesAsString())));
            }
            $page->CurrentRecord = $mtuser;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // edit
    #[Route('/MtuserEdit/{id:mtuser?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'edit.mtuser')]
    public function edit(Request $request, MtuserEdit $page, ?Entity\Mtuser $mtuser = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuser) {
            if (!$page->isValidUserID('edit', $mtuser)) {
                throw new AccessDeniedException(sprintf($this->language->phrase('NoAccessPermission', $mtuser->identifierValuesAsString())));
            }
            $page->CurrentRecord = $mtuser;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // delete
    #[Route('/MtuserDelete/{id:mtuser?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'delete.mtuser')]
    public function delete(Request $request, MtuserDelete $page, ?Entity\Mtuser $mtuser = null): Response
    {
        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuser) {
            if (!$page->isValidUserID('delete', $mtuser)) {
                throw new AccessDeniedException(sprintf($this->language->phrase('NoAccessPermission', $mtuser->identifierValuesAsString())));
            }
            $page->CurrentRecord = $mtuser;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }
}
