<?php

namespace PHPMaker2026\Reimbursement;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\EventStreamResponse;
use Symfony\Component\HttpFoundation\StreamedJsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;
use Symfony\Component\Routing\Requirement\Requirement;
use PHPMaker2026\Reimbursement\Db\Entity;

/**
 * Mtuserlevel controller
 */
#[IsGranted('USER_LEVEL')]
class MtuserlevelController extends BaseController
{
    // list
    #[Route('/MtuserlevelList', methods: ['GET', 'POST', 'OPTIONS'], name: 'list.mtuserlevel')]
    public function list(Request $request, MtuserlevelList $page): Response
    {
        // Load UserLevelTables
        $page->UserLevelTables = $this->parameters->get("user.level.tables");

        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Perform inline/grid actions
        if ($response = $page->action()) {
            return $response;
        }
        $page->TotalRecords = $page->listRecordCount();
        if (!$page->Records) {
            $page->Records = $page->loadRecords($page->StartRecord - 1, $page->DisplayRecords);
        }

        // Run page
        return $this->runPage($page);
    }

    // add
    #[Route('/MtuserlevelAdd/{userLevelId:mtuserlevel?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'add.mtuserlevel')]
    public function add(Request $request, MtuserlevelAdd $page, ?Entity\Mtuserlevel $mtuserlevel = null): Response
    {
        // Load UserLevelTables
        $page->UserLevelTables = $this->parameters->get("user.level.tables");

        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuserlevel) {
            $page->CurrentRecord = $mtuserlevel;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // view
    #[Route('/MtuserlevelView/{userLevelId:mtuserlevel?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'view.mtuserlevel')]
    public function view(Request $request, MtuserlevelView $page, ?Entity\Mtuserlevel $mtuserlevel = null): Response
    {
        // Load UserLevelTables
        $page->UserLevelTables = $this->parameters->get("user.level.tables");

        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuserlevel) {
            $page->CurrentRecord = $mtuserlevel;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // edit
    #[Route('/MtuserlevelEdit/{userLevelId:mtuserlevel?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'edit.mtuserlevel')]
    public function edit(Request $request, MtuserlevelEdit $page, ?Entity\Mtuserlevel $mtuserlevel = null): Response
    {
        // Load UserLevelTables
        $page->UserLevelTables = $this->parameters->get("user.level.tables");

        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuserlevel) {
            $page->CurrentRecord = $mtuserlevel;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // delete
    #[Route('/MtuserlevelDelete/{userLevelId:mtuserlevel?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'delete.mtuserlevel')]
    public function delete(Request $request, MtuserlevelDelete $page, ?Entity\Mtuserlevel $mtuserlevel = null): Response
    {
        // Load UserLevelTables
        $page->UserLevelTables = $this->parameters->get("user.level.tables");

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuserlevel) {
            $page->CurrentRecord = $mtuserlevel;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }
}
