<?php

namespace PHPMaker2026\Reimbursement;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\EventStreamResponse;
use Symfony\Component\HttpFoundation\StreamedJsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;
use Symfony\Component\Routing\Requirement\Requirement;
use PHPMaker2026\Reimbursement\Db\Entity;

/**
 * Mtuserlevelpermissions controller
 */
#[IsGranted('USER_LEVEL')]
class MtuserlevelpermissionsController extends BaseController
{
    // list
    #[Route('/MtuserlevelpermissionsList', methods: ['GET', 'POST', 'OPTIONS'], name: 'list.mtuserlevelpermissions')]
    public function list(Request $request, MtuserlevelpermissionsList $page): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Perform inline/grid actions
        if ($response = $page->action()) {
            return $response;
        }
        $page->TotalRecords = $page->listRecordCount();
        if (!$page->Records) {
            $page->Records = $page->loadRecords($page->StartRecord - 1, $page->DisplayRecords);
        }

        // Run page
        return $this->runPage($page);
    }

    // add
    #[Route('/MtuserlevelpermissionsAdd/{userLevelId:mtuserlevelpermission?}/{tableName:mtuserlevelpermission?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'add.mtuserlevelpermissions')]
    public function add(Request $request, MtuserlevelpermissionsAdd $page, ?Entity\Mtuserlevelpermission $mtuserlevelpermission = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuserlevelpermission) {
            $page->CurrentRecord = $mtuserlevelpermission;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // view
    #[Route('/MtuserlevelpermissionsView/{userLevelId:mtuserlevelpermission?}/{tableName:mtuserlevelpermission?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'view.mtuserlevelpermissions')]
    public function view(Request $request, MtuserlevelpermissionsView $page, ?Entity\Mtuserlevelpermission $mtuserlevelpermission = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuserlevelpermission) {
            $page->CurrentRecord = $mtuserlevelpermission;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // edit
    #[Route('/MtuserlevelpermissionsEdit/{userLevelId:mtuserlevelpermission?}/{tableName:mtuserlevelpermission?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'edit.mtuserlevelpermissions')]
    public function edit(Request $request, MtuserlevelpermissionsEdit $page, ?Entity\Mtuserlevelpermission $mtuserlevelpermission = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuserlevelpermission) {
            $page->CurrentRecord = $mtuserlevelpermission;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // delete
    #[Route('/MtuserlevelpermissionsDelete/{userLevelId:mtuserlevelpermission?}/{tableName:mtuserlevelpermission?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'delete.mtuserlevelpermissions')]
    public function delete(Request $request, MtuserlevelpermissionsDelete $page, ?Entity\Mtuserlevelpermission $mtuserlevelpermission = null): Response
    {
        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($mtuserlevelpermission) {
            $page->CurrentRecord = $mtuserlevelpermission;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }
}
