<?php

namespace PHPMaker2026\Reimbursement;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\EventStreamResponse;
use Symfony\Component\HttpFoundation\StreamedJsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;
use Symfony\Component\Routing\Requirement\Requirement;
use PHPMaker2026\Reimbursement\Db\Entity;

/**
 * Trreimbursement controller
 */
#[IsGranted('USER_LEVEL')]
class TrreimbursementController extends BaseController
{
    // list
    #[Route('/TrreimbursementList', methods: ['GET', 'POST', 'OPTIONS'], name: 'list.trreimbursement')]
    public function list(Request $request, TrreimbursementList $page): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Perform inline/grid actions
        if ($response = $page->action()) {
            return $response;
        }
        $page->TotalRecords = $page->listRecordCount();
        if (!$page->Records) {
            $page->Records = $page->loadRecords($page->StartRecord - 1, $page->DisplayRecords);
        }

        // Run page
        return $this->runPage($page);
    }

    // add
    #[Route('/TrreimbursementAdd/{id:trreimbursement?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'add.trreimbursement')]
    public function add(Request $request, TrreimbursementAdd $page, ?Entity\Trreimbursement $trreimbursement = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($trreimbursement) {
            $page->CurrentRecord = $trreimbursement;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // view
    #[Route('/TrreimbursementView/{id:trreimbursement?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'view.trreimbursement')]
    public function view(Request $request, TrreimbursementView $page, ?Entity\Trreimbursement $trreimbursement = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($trreimbursement) {
            $page->CurrentRecord = $trreimbursement;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // edit
    #[Route('/TrreimbursementEdit/{id:trreimbursement?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'edit.trreimbursement')]
    public function edit(Request $request, TrreimbursementEdit $page, ?Entity\Trreimbursement $trreimbursement = null): Response
    {
        // Init page
        $page->init();

        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($trreimbursement) {
            $page->CurrentRecord = $trreimbursement;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }

    // delete
    #[Route('/TrreimbursementDelete/{id:trreimbursement?}', methods: ['GET', 'POST', 'OPTIONS'], name: 'delete.trreimbursement')]
    public function delete(Request $request, TrreimbursementDelete $page, ?Entity\Trreimbursement $trreimbursement = null): Response
    {
        // Check resolved arguments
        $hasResolved = false;

        // Set current record
        if ($trreimbursement) {
            $page->CurrentRecord = $trreimbursement;
            $hasResolved = true;
        }

        // Run page
        return $this->runPage($page);
    }
}
