<?php

namespace PHPMaker2026\Reimbursement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Result;
use Doctrine\DBAL\Query\QueryBuilder;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Event\OnFlushEventArgs;
use Doctrine\ORM\Event\PostFlushEventArgs;
use Doctrine\ORM\Event\OnClearEventArgs;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Doctrine\ORM\Events;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Doctrine\Persistence\ObjectRepository;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\EventStreamResponse;
use Symfony\Component\HttpFoundation\ServerEvent;
use Symfony\Component\HttpFoundation\HeaderBag;
use Symfony\Component\Filesystem\Exception\IOExceptionInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;
use Symfony\Contracts\EventDispatcher\Event;
use Symfony\Contracts\Cache\CacheInterface;
use Symfony\Contracts\Cache\ItemInterface;
use League\Flysystem\DirectoryListing;
use League\Flysystem\FilesystemException;
use ParagonIE\CSPBuilder\CSPBuilder;
use InvalidArgumentException;
use Exception;
use Throwable;
use DateTimeInterface;
use DateTimeImmutable;
use DateInterval;
use DateTime;
use Closure;
use Traversable;
use Symfony\Bundle\SecurityBundleSecurity;
use PHPMaker2026\Reimbursement\Entity as BaseEntity;
use PHPMaker2026\Reimbursement\Db;
use PHPMaker2026\Reimbursement\Db\Entity;

/**
 * Page class
 */
#[AsAlias("Login", true)]
class Login extends Mtuser implements PageInterface
{
    use MessagesTrait {
        getHtmlMessage as traitGetHtmlMessage; // Alias because we will override it
    }

    // Page result
    public ?Response $Response = null;

    // Headers
    public HeaderBag $Headers;

    // Page ID
    public string $PageID = "login";

    // Project ID
    public string $ProjectID = PROJECT_ID;

    // View file path
    public ?string $View = null;

    // Title
    public ?string $Title = null; // Title for <title> tag

    // CSS class/style
    public string $CurrentPageName = "login"; // Route action

    // Page headings
    public string $Heading = "";
    public string $Subheading = "";
    public string $PageHeader = "";
    public string $PageFooter = "";

    // Page layout
    public bool $UseLayout = true;

    // Page terminated
    private bool $terminated = false;

    // Reset Captcha
    protected function resetCaptcha()
    {
        $captcha = Captcha();
        if ($captcha) {
            $sessionName = AddTabId($captcha->getSessionName());
            Session($sessionName, Random());
        }
    }

    // Properties
    public DbField $_Username;
    public DbField $_Password;
    public bool $IsModal = false;
    public string $OffsetColumnClass = ""; // Override user table

    // Constructor
    public function __construct(
        Language $language,
        AdvancedSecurity $security,
        CSPBuilder $cspBuilder,
        CacheInterface $cache,
        FieldFactory $fieldFactory,
        EventDispatcherInterface $dispatcher,
    ) {
        parent::__construct($language, $security, $cspBuilder, $cache, $fieldFactory, $dispatcher);
        global $httpContext;
        $this->Headers = new HeaderBag();
        $this->TableVar = 'mtuser';
        $this->TableName = 'mtuser';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $httpContext["Page"] = $this;

        // Open connection
        $httpContext["Conn"] ??= $this->getConnection();
    }

    // Page heading
    public function pageHeading(): string
    {
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading(): string
    {
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        return "";
    }

    // Page name
    public function pageName(): string
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl(bool $withArgs = true): string
    {
        if ($withArgs) {
            return CurrentPageUrl();
        } else {
            $route = GetRoute();
            $path = $route?->getPath() ?? "";
            // Remove all placeholders like `{id}`
            $stripped = preg_replace('/\{[^}]+\}/', '', $path);
            // Remove trailing slash unless it's root '/', then replace leading slash with BasePath(true)
            return preg_replace('/^\//', BasePath(true), $stripped !== '/' ? rtrim($stripped, '/') : '/');
        }
    }

    // Get Page Header
    public function getPageHeader(): string
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            $header = '<div id="ew-page-header">' . $header . '</div>';
        }
        return $header;
    }

    // Get Page Footer
    public function getPageFooter(): string
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            $footer = '<div id="ew-page-footer">' . $footer . '</div>';
        }
        return $footer;
    }

    // Is lookup
    public function isLookup(): bool
    {
        return SameText(RouteAction(), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated(): bool
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param ?string $url URL for redirection
     * @return void
     */
    public function terminate(?string $url = null): void
    {
        if ($this->terminated) {
            return;
        }
        global $httpContext;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::class);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            if (!$this->Response) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                $this->Response = new JsonResponse($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (IsJsonResponse($this->Response)) { // Has JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url !== null) {
            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                $this->Response = new JsonResponse($ar);
            } else {
                $this->Response = new RedirectResponse(GetUrl($url), Config("REDIRECT_STATUS_CODE"));
            }
        }
        return; // Return to controller
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run(): void
    {
        global $httpContext;

        // Create _Username/_Password field object (used by validation only)
        $this->_Username = $this->fieldFactory->create("login", "username");
        $this->_Username->EditAttrs->appendClass("form-control ew-form-control");
        $this->_Username->PlaceHolder = $this->language->phrase("Username", true);
        $this->_Username->Raw = true;
        $this->Fields["_Username"] = $this->_Username;
        $this->_Password = $this->fieldFactory->create("login", "password");
        $this->_Password->EditAttrs->appendClass("form-control ew-form-control");
        $this->_Password->PlaceHolder = $this->language->phrase("Password", true);
        $this->_Password->Raw = true;
        $this->Fields["_Password"] = $this->_Password;

        // Is modal
        $this->IsModal = IsModal();
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ParamBool(Config("PAGE_LAYOUT"), true);

        // View
        $this->View = Get(Config("VIEW"));
        $this->CurrentAction = Param("action"); // Set up current action

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::class);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Check modal
        if ($this->IsModal) {
            $httpContext["SkipHeaderFooter"] = true;
        }
        Breadcrumb()->add("login", "LoginPage", CurrentUrl(), "", "", true);
        $this->Heading = $this->language->phrase("LoginPage");

        // Initialize
        $this->_Username->setFormValue("");
        $this->_Password->setFormValue("");

        // Login
        $valid = false;
        if (IsLoggedIn2FA()) { // Logged in via 2FA
            $this->_Username->setFormValue(Session(SESSION_USER_IDENTIFIER) ?? CurrentUserIdentifier());
            Session(SESSION_USER_IDENTIFIER, null);
            $valid = true;
        } else { // Normal login
            if (!$this->security->isLoggedIn()) {
                $this->security->login();
            }
            $this->security->initialize(); // Load user level
            if (Post($this->_Username->FieldVar) !== null) {
                $this->_Username->setFormValue(Post($this->_Username->FieldVar));
                $this->_Password->setFormValue(Post($this->_Password->FieldVar));
                $this->validateForm();
            } else { // Restore settings
                $this->_Username->setFormValue(Session(SESSION_USER_IDENTIFIER) ?? "");
            }
            if (!IsEmpty($this->_Username->CurrentValue)) {
                Session(SESSION_USER_IDENTIFIER, $this->_Username->CurrentValue); // Save user name
            }

            // Check authentication
            if (IsAuthenticated()) {
                $valid = true;
                $this->_Username->setFormValue(CurrentUserIdentifier());
            }

            // CAPTCHA checking
            if (IsPost()) {
                $captcha = Captcha();
                $captcha->Response = Post($captcha->getElementName());
                if (!$captcha->validate()) { // CAPTCHA unmatched
                    if ($captcha->getErrorMessage() == "") {
                        $captcha->setDefaultErrorMessage();
                    }
                    $valid = false;
                }
            }
            if (!$valid) {
                $this->resetCaptcha();
            }

            // Avoid leaking error details in case of invalid user
            if (IsPost() && !$valid) {
                $this->_Username->setFormValue(""); // Clear login name
                $this->_Username->ErrorMessage = $this->language->phrase("InvalidUidPwd"); // Invalid user name or password
                $this->_Password->ErrorMessage = $this->language->phrase("InvalidUidPwd"); // Invalid user name or password
            }
        }

        // Logged in
        if ($valid) {
            // External provider, just redirect
            if (IsAccessTokenUser() || IsOAuthUser()) {
                $this->IsModal = false;
            }
            // Get last URL
            $lastUrl = $this->security->lastUrl() ?? "";
            $this->security->removeLastUrl();
            $this->terminate($lastUrl); // Return to last accessed URL
            return;
        }

        // Set up default error message
        if (IsEmpty($this->_Username->ErrorMessage)) {
            $this->_Username->ErrorMessage = $this->language->phrase("EnterUsername");
        }
        if (IsEmpty($this->_Password->ErrorMessage)) {
            $this->_Password->ErrorMessage = $this->language->phrase("EnterPassword");
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::class);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Validate form
    protected function validateForm(): bool
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if (IsEmpty($this->_Username->CurrentValue)) {
            $this->_Username->addErrorMessage($this->language->phrase("EnterUsername"));
            $validateForm = false;
        }
        if (IsEmpty($this->_Password->CurrentValue) && !Config("OTP_ONLY")) { // Ignore if password checking disabled
            $this->_Password->addErrorMessage($this->language->phrase("EnterPassword"));
            $validateForm = false;
        }

        // Call Form Custom Validate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Get HTML message
    public function getHtmlMessage(): string
    {
        if (($this->peekFailureMessage()[0] ?? "") == $this->language->phrase("InvalidUidPwd", true)) {
            $message = $this->getFailureMessage();
            $this->_Username->setErrorMessage($message);
            $this->_Password->setErrorMessage($message);
        }
        return $this->traitGetHtmlMessage();
    }

    // Page Load event
    public function pageLoad(): void
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload(): void
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(?string &$url): void
    {
        // Example:
        //$url = "your URL";
        $url = "DashboardPanel";
    }

    // Message Showing event
    // $type = ''|'success'|'danger'
    public function messageShowing(string &$message, string $type): void
    {
        // Example:
        //if ($type == "success") $message = "your success message";
    }

    // Page Render event
    public function pageRender(): void
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(string &$header): void
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(string &$footer): void
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(string &$customError): bool
    {
        // Return error message in $customError
        return true;
    }
}
