<?php

namespace PHPMaker2026\Reimbursement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Result;
use Doctrine\DBAL\Query\QueryBuilder;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Event\OnFlushEventArgs;
use Doctrine\ORM\Event\PostFlushEventArgs;
use Doctrine\ORM\Event\OnClearEventArgs;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Doctrine\ORM\Events;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Doctrine\Persistence\ObjectRepository;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\EventStreamResponse;
use Symfony\Component\HttpFoundation\ServerEvent;
use Symfony\Component\HttpFoundation\HeaderBag;
use Symfony\Component\Filesystem\Exception\IOExceptionInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;
use Symfony\Contracts\EventDispatcher\Event;
use Symfony\Contracts\Cache\CacheInterface;
use Symfony\Contracts\Cache\ItemInterface;
use League\Flysystem\DirectoryListing;
use League\Flysystem\FilesystemException;
use ParagonIE\CSPBuilder\CSPBuilder;
use InvalidArgumentException;
use Exception;
use Throwable;
use DateTimeInterface;
use DateTimeImmutable;
use DateInterval;
use DateTime;
use Closure;
use Traversable;
use Symfony\Bundle\SecurityBundleSecurity;
use PHPMaker2026\Reimbursement\Entity as BaseEntity;
use PHPMaker2026\Reimbursement\Db;
use PHPMaker2026\Reimbursement\Db\Entity;

/**
 * Page class
 */
#[AsAlias("Register", true)]
class Register extends Mtuser implements PageInterface
{
    use MessagesTrait;
    use FormTrait;

    // Page result
    public ?Response $Response = null;

    // Headers
    public HeaderBag $Headers;

    // Page ID
    public string $PageID = "register";

    // Project ID
    public string $ProjectID = PROJECT_ID;

    // View file path
    public ?string $View = null;

    // Title
    public ?string $Title = null; // Title for <title> tag

    // CSS class/style
    public string $CurrentPageName = "register"; // Route action

    // Page headings
    public string $Heading = "";
    public string $Subheading = "";
    public string $PageHeader = "";
    public string $PageFooter = "";

    // Page layout
    public bool $UseLayout = true;

    // Page terminated
    private bool $terminated = false;
    public string $FormClassName = "ew-form ew-register-form";
    public bool $IsModal = false;
    public bool $IsMobileOrModal = false;

    // Reset Captcha
    protected function resetCaptcha()
    {
        $captcha = Captcha();
        if ($captcha) {
            $sessionName = AddTabId($captcha->getSessionName());
            Session($sessionName, Random());
        }
    }

    // Constructor
    public function __construct(
        Language $language,
        AdvancedSecurity $security,
        CSPBuilder $cspBuilder,
        CacheInterface $cache,
        FieldFactory $fieldFactory,
        EventDispatcherInterface $dispatcher,
    ) {
        parent::__construct($language, $security, $cspBuilder, $cache, $fieldFactory, $dispatcher);
        global $httpContext;
        $this->Headers = new HeaderBag();
        $this->TableVar = 'mtuser';
        $this->TableName = 'mtuser';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-register-table";

        // Initialize
        $httpContext["Page"] = $this;

        // Open connection
        $httpContext["Conn"] ??= $this->getConnection();
    }

    // Page heading
    public function pageHeading(): string
    {
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading(): string
    {
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        return "";
    }

    // Page name
    public function pageName(): string
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl(bool $withArgs = true): string
    {
        if ($withArgs) {
            return CurrentPageUrl();
        } else {
            $route = GetRoute();
            $path = $route?->getPath() ?? "";
            // Remove all placeholders like `{id}`
            $stripped = preg_replace('/\{[^}]+\}/', '', $path);
            // Remove trailing slash unless it's root '/', then replace leading slash with BasePath(true)
            return preg_replace('/^\//', BasePath(true), $stripped !== '/' ? rtrim($stripped, '/') : '/');
        }
    }

    // Get Page Header
    public function getPageHeader(): string
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            $header = '<div id="ew-page-header">' . $header . '</div>';
        }
        return $header;
    }

    // Get Page Footer
    public function getPageFooter(): string
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            $footer = '<div id="ew-page-footer">' . $footer . '</div>';
        }
        return $footer;
    }

    // Is lookup
    public function isLookup(): bool
    {
        return SameText(RouteAction(), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated(): bool
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param ?string $url URL for redirection
     * @return void
     */
    public function terminate(?string $url = null): void
    {
        if ($this->terminated) {
            return;
        }
        global $httpContext;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::class);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            if (!$this->Response) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                $this->Response = new JsonResponse($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (IsJsonResponse($this->Response)) { // Has JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url !== null) {
            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                $this->Response = new JsonResponse($ar);
            } else {
                $this->Response = new RedirectResponse(GetUrl($url), Config("REDIRECT_STATUS_CODE"));
            }
        }
        return; // Return to controller
    }

    // Get row(s) from array of entities
    protected function getRowsFromEntities(array $entities, bool $first = false): array
    {
        $rows = [];
        if (array_is_list($entities)) {
            foreach ($entities as $entity) {
                $row = $this->getRowFromEntity($entity);
                if ($first) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get row from entity
    protected function getRowFromEntity(BaseEntity $entity): array
    {
        $row = [];
        foreach ($entity as $fldname => $val) {
            if ($this->TableName == Config("USER_TABLE_NAME") && $fldname == Config("PASSWORD_FIELD_NAME")) { // Skip user password field
                continue;
            }
            if (isset($this->Fields[$fldname]) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                $fld = $this->Fields[$fldname];
                if ($fld->HtmlTag == "FILE") { // Upload field
                    if (IsEmpty($val)) {
                        $row[$fldname] = null;
                    } else {
                        $key = SessionId() . ServerVar("ENCRYPTION_KEY");
                        if ($fld->DataType == DataType::BLOB) {
                            $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                "/" . $fld->TableVar . "/" . $fld->Param . "/" . $this->getKeyAsString($entity, Config("ROUTE_COMPOSITE_KEY_SEPARATOR"))));
                            $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                        } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                            $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                "/" . $fld->TableVar . "/" . Encrypt($fld->uploadPath() . $val, $key)));
                            $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                        } else { // Multiple files
                            $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                            $ar = [];
                            foreach ($files as $file) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->uploadPath() . $file, $key)));
                                if (!IsEmpty($file)) {
                                    $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                }
                            }
                            $row[$fldname] = $ar;
                        }
                    }
                } else {
                    if ($val instanceof DateTimeInterface) {
                        $val = $val->format(DATE_ATOM);
                    }
                    $row[$fldname] = $val;
                }
            }
        }
        return $row;
    }

    // Hide fields for add/edit
    protected function hideFieldsForAddEdit(): void
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->ID->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = []): array
    {
        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this); // Use settings from current page
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run(): void
    {
        global $httpContext;

        // Is modal
        $this->IsModal = IsModal();
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ParamBool(Config("PAGE_LAYOUT"), true);

        // View
        $this->View = Get(Config("VIEW"));
        $this->CurrentAction = Param("action"); // Set up current action

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::class);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $httpContext["SkipHeaderFooter"] = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Set up Breadcrumb
        Breadcrumb()->add("register", "RegisterPage", CurrentUrl(), "", "", true);
        $this->Heading = $this->language->phrase("RegisterPage");

        // Load default values
        $this->loadRowValues();

        // Get action
        $action = "";
        if (IsApi()) {
            $action = "insert";
        } elseif (Post("action") != "") {
            $action = Post("action");
        }

        // Check action
        if ($action != "") {
            // Get action
            $this->CurrentAction = $action;
            $this->loadFormValues(); // Get form values

            // Validate form
            if (!$this->validateForm()) {
                if (IsApi()) {
                    $this->Response = new JsonResponse([
                        "success" => false,
                        "validation" => $this->getValidationErrors(),
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        } else {
            $this->CurrentAction = "show"; // Display blank record
        }

        // CAPTCHA checking
        if ($this->isShow() || $this->isCopy()) {
            $this->resetCaptcha();
        } elseif (IsPost() && !IsApi()) {
            $captcha = Captcha();
            $captcha->Response = Post($captcha->getElementName());
            if (!$captcha->validate()) { // CAPTCHA unmatched
                if ($captcha->getErrorMessage() == "") {
                    $captcha->setDefaultErrorMessage();
                }
                $this->CurrentAction = "show"; // Reset action, do not insert
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
            } else {
                if ($this->CurrentAction == "add")
                    $this->resetCaptcha();
            }
        }

        // Insert record
        if ($this->CurrentAction == "insert") {
            // Check for duplicate User ID
            $user = LoadUserByIdentifier($this->_Email->CurrentValue);
            if ($user) {
                $this->restoreFormValues(); // Restore form values
                $this->setFailureMessage($this->language->phrase("UserExists")); // Set user exist message
            }
            if (!$user) {
                if ($this->addRow()) { // Add record
                    CleanUploadTempPaths(SessionId());

                    // Get new user
                    $user = LoadUserByIdentifier($this->_Email->CurrentValue);
                    $returnPage = "";
                    if (IsEmpty($returnPage)) {
                        $returnPage = Config("REGISTER_AUTO_LOGIN") ? "" : "login";
                    }
                    if (Config("REGISTER_ACTIVATE") && !IsEmpty(Config("USER_ACTIVATED_FIELD_NAME"))) {
                        if (!$this->peekSuccessMessage()) {
                            $this->setSuccessMessage($this->language->phrase("RegisterSuccessActivate")); // Activate success
                        }
                    } else {
                        if (!$this->peekSuccessMessage()) {
                            $this->setSuccessMessage($this->language->phrase("RegisterSuccess")); // Register success
                        }

                        // Auto login user after registration
                        if (Config("REGISTER_AUTO_LOGIN")) {
                            try {
                                SecurityHelper()->login(
                                    $user,
                                    Config("FORCE_TWO_FACTOR_AUTHENTICATION") ? FormLogin1faAuthenticator::class : "form_login"
                                );
                                $this->security->login();
                                $this->terminate($returnPage);
                                return;
                            } catch (\Exception $e) {
                                $this->setFailureMessage($e->getMessage()); // Set auto login failure message
                            }
                        }
                    }
                    if (
                        Config("REGISTER_AUTO_LOGIN")
                        && Config("USE_TWO_FACTOR_AUTHENTICATION")
                        && Config("FORCE_TWO_FACTOR_AUTHENTICATION")
                    ) { // Force 2fa
                        Session(SESSION_STATUS, "loggingin2fa");
                        $returnPage = "login2fa"; // Go to two factor authentication
                    } else { // Clear status
                        Session()->remove(SESSION_STATUS);
                        Session()->remove(SESSION_USER_IDENTIFIER);
                    }
                    if (IsApi()) { // Return to caller
                        $this->terminate();
                        return;
                    } else {
                        $this->terminate($returnPage); // Return
                        return;
                    }
                } else {
                    $this->restoreFormValues(); // Restore form values
                }
            }
        }

        // API request, return
        if (IsApi()) {
            $this->terminate();
            return;
        }

        // Render row
        $this->resetAttributes();
        $this->renderRow(
            RowType::ADD
        );

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::class);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles(): void
    {
    }

    // Load default values
    protected function loadDefaultValues(): void
    {
    }

    // Load form values
    protected function loadFormValues(): void
    {
        $validate = !Config("SERVER_VALIDATE");

        // ID
        if (!$this->ID->IsDetailKey && $this->hasInputValue($this->ID)) {
            $val = $this->getInputValue($this->ID);
        }

        // Email
        if (!$this->_Email->IsDetailKey && $this->hasInputValue($this->_Email)) {
            $val = $this->getInputValue($this->_Email);
            $this->_Email->setFormValue($val);
        }

        // Password
        if (!$this->Password->IsDetailKey && $this->hasInputValue($this->Password)) {
            $val = $this->getInputValue($this->Password);
            $this->Password->setFormValue($val);

            // Note: ConfirmValue will be compared with FormValue
            $this->Password->ConfirmValue = $this->getFormValue("c_Password");
        }

        // FullName
        if (!$this->FullName->IsDetailKey && $this->hasInputValue($this->FullName)) {
            $val = $this->getInputValue($this->FullName);
            $this->FullName->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues(): void
    {
        $this->_Email->CurrentValue = $this->_Email->FormValue;
        $this->Password->CurrentValue = $this->Password->FormValue;
        $this->FullName->CurrentValue = $this->FullName->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return bool
     */
    public function loadRow(): bool
    {
        $result = $this->CurrentRecord !== null;
        if ($result) {
            $this->loadRowValues($this->CurrentRecord); // Load row values
        }
        return $result;
    }

    /**
     * Load row values from result set or record
     *
     * @param ?BaseEntity $row Record
     * @return void
     */
    public function loadRowValues(?BaseEntity $row = null): void
    {
        if ($row instanceof BaseEntity) { // Get array from entity
        }
        $row ??= $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ID->setDbValue($row['ID']);
        $this->_Email->setDbValue($row['Email']);
        $this->Password->setDbValue($row['Password']);
        $this->FullName->setDbValue($row['FullName']);
        $this->MTUserLevelID->setDbValue($row['MTUserLevelID']);
    }

    /**
     * Return a row with default values
     *
     * @return BaseEntity
     */
    protected function newRow(): BaseEntity
    {
        $row = new $this->EntityClass();
        if (!IsEmpty($this->ID->DefaultValue)) {
            $row['ID'] = intval($this->ID->DefaultValue);
        }
        if (!IsEmpty($this->_Email->DefaultValue)) {
            $row['Email'] = strval($this->_Email->DefaultValue);
        }
        if (!IsEmpty($this->Password->DefaultValue)) {
            $row['Password'] = strval($this->Password->DefaultValue);
        }
        if (!IsEmpty($this->FullName->DefaultValue)) {
            $row['FullName'] = strval($this->FullName->DefaultValue);
        }
        if (!IsEmpty($this->MTUserLevelID->DefaultValue)) {
            $row['MTUserLevelID'] = intval($this->MTUserLevelID->DefaultValue);
        }
        return $row;
    }

    /**
     * Render row
     *
     * @param RowType $rowType Row type
     * @param bool $resetAttributes Reset attributes
     * @return void
     */
    public function renderRow(RowType $rowType = RowType::VIEW, bool $resetAttributes = true): void
    {
        global $httpContext;

        // Set up row type
        $this->RowType = $rowType;

        // Reset attributes
        if ($resetAttributes) {
            $this->resetAttributes();
        }

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ID
        $this->ID->RowCssClass = "row";

        // Email
        $this->_Email->RowCssClass = "row";

        // Password
        $this->Password->RowCssClass = "row";

        // FullName
        $this->FullName->RowCssClass = "row";

        // MTUserLevelID
        $this->MTUserLevelID->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ID
            $this->ID->ViewValue = $this->ID->CurrentValue;

            // Email
            $this->_Email->ViewValue = $this->_Email->CurrentValue;

            // Password
            $this->Password->ViewValue = $this->language->phrase("PasswordMask");

            // FullName
            $this->FullName->ViewValue = $this->FullName->CurrentValue;

            // MTUserLevelID
            if ($this->security->canAdmin()) { // System admin
                $curVal = strval($this->MTUserLevelID->CurrentValue);
                if ($curVal != "") {
                    $this->MTUserLevelID->ViewValue = $this->MTUserLevelID->lookupCacheOption($curVal);
                    if ($this->MTUserLevelID->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->MTUserLevelID->Lookup->getTable()->Fields["UserLevelID"]->searchExpression(), "=", $curVal, $this->MTUserLevelID->Lookup->getTable()->Fields["UserLevelID"]->searchDataType(), "DB");
                        $sqlWrk = $this->MTUserLevelID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = $this->getConnection();
                        $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $rows = [];
                            foreach ($rswrk as $row) {
                                $rows[] = $this->MTUserLevelID->Lookup->renderViewRow($row);
                            }
                            $this->MTUserLevelID->ViewValue = $this->MTUserLevelID->displayValue($rows[0]);
                        } else {
                            $this->MTUserLevelID->ViewValue = FormatNumber($this->MTUserLevelID->CurrentValue, $this->MTUserLevelID->formatPattern());
                        }
                    }
                } else {
                    $this->MTUserLevelID->ViewValue = null;
                }
            } else {
                $this->MTUserLevelID->ViewValue = $this->language->phrase("PasswordMask");
            }

            // ID
            $this->ID->HrefValue = "";
            $this->ID->TooltipValue = "";

            // Email
            $this->_Email->HrefValue = "";
            $this->_Email->TooltipValue = "";

            // Password
            $this->Password->HrefValue = "";
            $this->Password->TooltipValue = "";

            // FullName
            $this->FullName->HrefValue = "";
            $this->FullName->TooltipValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // ID
            $this->ID->EditValue = $this->ID->CurrentValue;

            // Email
            $this->_Email->setupEditAttributes();
            $this->_Email->EditValue = !$this->_Email->Raw ? HtmlDecode($this->_Email->CurrentValue) : $this->_Email->CurrentValue;
            $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

            // Password
            $this->Password->setupEditAttributes();
            $this->Password->PlaceHolder = RemoveHtml($this->Password->caption());

            // FullName
            $this->FullName->setupEditAttributes();
            $this->FullName->EditValue = !$this->FullName->Raw ? HtmlDecode($this->FullName->CurrentValue) : $this->FullName->CurrentValue;
            $this->FullName->PlaceHolder = RemoveHtml($this->FullName->caption());

            // Add refer script

            // ID
            $this->ID->HrefValue = "";

            // Email
            $this->_Email->HrefValue = "";

            // Password
            $this->Password->HrefValue = "";

            // FullName
            $this->FullName->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm(): bool
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->ID->Visible) {
            if ($this->ID->Required) {
                if (!$this->ID->IsDetailKey && IsEmpty($this->ID->FormValue)) {
                    $this->ID->addErrorMessage(str_replace("%s", $this->ID->caption(), $this->ID->RequiredErrorMessage));
                }
            }
        }
        if ($this->_Email->Visible) {
            if ($this->_Email->Required) {
                if (!$this->_Email->IsDetailKey && IsEmpty($this->_Email->FormValue)) {
                    $this->_Email->addErrorMessage($this->language->phrase("EnterUsername"));
                }
            }
            if (!$this->_Email->Raw && Config("REMOVE_XSS") && CheckUsername($this->_Email->FormValue)) {
                $this->_Email->addErrorMessage($this->language->phrase("InvalidUsernameChars"));
            }
        }
        if ($this->Password->Visible) {
            if ($this->Password->Required) {
                if (!$this->Password->IsDetailKey && IsEmpty($this->Password->FormValue)) {
                    $this->Password->addErrorMessage($this->language->phrase("EnterPassword"));
                }
            }
            if (!$this->Password->Raw && Config("REMOVE_XSS") && CheckPassword($this->Password->FormValue)) {
                $this->Password->addErrorMessage($this->language->phrase("InvalidPasswordChars"));
            }
        }
        if ($this->FullName->Visible) {
            if ($this->FullName->Required) {
                if (!$this->FullName->IsDetailKey && IsEmpty($this->FullName->FormValue)) {
                    $this->FullName->addErrorMessage(str_replace("%s", $this->FullName->caption(), $this->FullName->RequiredErrorMessage));
                }
            }
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow(?BaseEntity $oldRow = null): BaseEntity|false|null
    {
        // Get new row
        $newRow = $this->getAddRow();

        // Validate constraints
        $errors = Validate($newRow);
        if (count($errors) > 0) {
            foreach ($errors as $error) {
                $this->fieldByPropertyName($error->getPropertyPath())?->addErrorMessage($error->getMessage());
            }
            return false;
        }

        // Update current values
        $this->Fields->setCurrentValues($newRow);

        // Check if valid User ID
        if (
            !IsEmpty($this->security->currentUserID())
            && !$this->security->canAccess() // No access permission
            && !$this->security->isValidUserID($this->ID->CurrentValue)
        ) {
            $userIdError = sprintf($this->language->phrase("UnauthorizedUserID"), CurrentUserID(), strval($this->ID->CurrentValue));
            $this->setFailureMessage($userIdError);
            return false;
        }

        // Get Entity Manager
        $em = $this->getEntityManager();

        // Load db values from old row
        $this->loadDbValues($oldRow);

        // Call Row Inserting event
        $insertRow = method_exists($this, "rowInserting") ? $this->rowInserting($oldRow, $newRow) : true;
        if ($insertRow) {
            try {
                $updateTableRow = null;
                if (!$this->UpdateTable || $this->UpdateTable == $this->TableName) { // Update table is the same as current table
                    $em->persist($newRow); // Persist the new row
                } else { // Update table is different from current table
                    $updateTableRow = $this->UpdateTableEntityClass::createFromArray($newRow->toArray());
                    $em->detach($newRow);
                    $em->persist($updateTableRow);
                }
                $em->flush();
                $this->ID->CurrentValue = $newRow->getId();
                $addRow = true;
            } catch (Exception $e) {
                $this->dispatcher->dispatch(new RowInsertFailedEvent($updateTableRow ?? $newRow, $e));
                $this->setFailureMessage($e->getMessage());
                $addRow = false;
            }
            if ($addRow) {
            }
        } else {
            if ($insertRow === false) { // Insert failed
                if ($this->peekSuccessMessage() || $this->peekFailureMessage()) {
                    // Use the message, do nothing
                } elseif ($this->CancelMessage != "") {
                    $this->setFailureMessage($this->CancelMessage);
                    $this->CancelMessage = "";
                } else {
                    $this->setFailureMessage($this->language->phrase("InsertCancelled"));
                }
            }
            $addRow = $insertRow;
        }
        if ($addRow) {
            // Call Row Inserted event
            if (method_exists($this, "rowInserted")) {
                $this->rowInserted($oldRow, $newRow);
            }

            // Call User Registered event
            $this->userRegistered($newRow);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRowsFromEntities([$newRow], true);
            $table = $this->TableVar;
            $this->Response = new JsonResponse(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow ? $newRow : $addRow;
    }

    /**
     * Get add row
     *
     * @return object
     */
    protected function getAddRow(): object
    {
        $newRow = new $this->EntityClass();

        // Email
        $newRow->setEmail($this->_Email->setDbValueDef($this->_Email->CurrentValue));

        // Password
        if (!IsMaskedPassword($this->Password->CurrentValue)) {
            $this->Password->CurrentValue = HashPassword($this->Password->CurrentValue);
            $newRow->setPassword($this->Password->setDbValueDef($this->Password->CurrentValue));
        }

        // FullName
        $newRow->setFullName($this->FullName->setDbValueDef($this->FullName->CurrentValue));
        return $newRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb(): void
    {
        $breadcrumb = Breadcrumb();
    }

    // Setup lookup options
    public function setupLookupOptions(DbField $fld): void
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_MTUserLevelID":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $qb = $fld->Lookup->getSqlBuilder(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $qb != null && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($qb, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }

                // Define a structured and consistent cache key prefix
                $cachePrefix = "lookup.result." . Container($fld->Lookup->LinkTable)->TableVar . ".";

                // Generate a unique cache key using SQL and parameters
                $sqlHash = hash("sha256", $qb->getSQL() . serialize($qb->getParameters()));
                $cacheKey = $cachePrefix . $sqlHash;

                // Fetch rows from cache or database
                $rows = $this->cache->get($cacheKey, fn (ItemInterface $item) => $qb->executeQuery()->fetchAllAssociative());
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad(): void
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload(): void
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(?string &$url): void
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'danger'
    public function messageShowing(string &$message, string $type): void
    {
        // Example:
        //if ($type == "success") $message = "your success message";
    }

    // Page Render event
    public function pageRender(): void
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(string &$header): void
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(string &$footer): void
    {
        // Example:
        //$footer = "your footer";
    }

    // Email Sending event
    public function emailSending(Email $email, array $args): bool
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Form Custom Validate event
    public function formCustomValidate(string &$customError): bool
    {
        // Return error message in $customError
        return true;
    }

    // User Registered event
    public function userRegistered(BaseEntity $row): void
    {
        //Log("User Registered");
    }
}
