<?php

namespace PHPMaker2026\Reimbursement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Result;
use Doctrine\DBAL\Query\QueryBuilder;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Event\OnFlushEventArgs;
use Doctrine\ORM\Event\PostFlushEventArgs;
use Doctrine\ORM\Event\OnClearEventArgs;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Doctrine\ORM\Events;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Doctrine\Persistence\ObjectRepository;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\EventStreamResponse;
use Symfony\Component\HttpFoundation\ServerEvent;
use Symfony\Component\HttpFoundation\HeaderBag;
use Symfony\Component\Filesystem\Exception\IOExceptionInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;
use Symfony\Contracts\EventDispatcher\Event;
use Symfony\Contracts\Cache\CacheInterface;
use Symfony\Contracts\Cache\ItemInterface;
use League\Flysystem\DirectoryListing;
use League\Flysystem\FilesystemException;
use ParagonIE\CSPBuilder\CSPBuilder;
use InvalidArgumentException;
use Exception;
use Throwable;
use DateTimeInterface;
use DateTimeImmutable;
use DateInterval;
use DateTime;
use Closure;
use Traversable;
use Symfony\Bundle\SecurityBundleSecurity;
use PHPMaker2026\Reimbursement\Entity as BaseEntity;
use PHPMaker2026\Reimbursement\Db;
use PHPMaker2026\Reimbursement\Db\Entity;

/**
 * Table class for trreimbursement
 */
#[AsAlias("Trreimbursement", true)]
#[AsAlias("trreimbursement", true)]
#[AsEntityListener(event: Events::postPersist, method: 'clearCache', entity: Entity\Trreimbursement::class)]
#[AsEntityListener(event: Events::postUpdate, method: 'clearCache', entity: Entity\Trreimbursement::class)]
#[AsEntityListener(event: Events::postRemove, method: 'clearCache', entity: Entity\Trreimbursement::class)]
#[AsEntityListener(event: Events::postPersist, method: 'updateLastInsertId', entity: Entity\Trreimbursement::class)]
#[AsEntityListener(event: Events::preUpdate, method: 'preUpdate', entity: Entity\Trreimbursement::class)]
class Trreimbursement extends DbTable implements LookupTableInterface
{
    protected array $changeSets = [];
    protected array $snapshots = [];
    protected ?string $sqlSelectFields = null;
    protected ?string $sqlFromDerived = null;
    protected ?string $sqlFrom = null;
    protected ?string $sqlWhere = null;
    protected ?string $sqlGroupBy = null;
    protected ?string $sqlHaving = null;
    protected ?string $sqlOrderBy = null;
    public bool $UseSessionForListSql = true;

    // Entity alias (Use first character of table variable name)
    public string $Alias = 't';

    // Column CSS classes
    public string $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public string $RightColumnClass = "col-sm-10";
    public string $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public string $TableLeftColumnClass = "w-col-2";

    // Ajax/Modal
    public bool $UseAjaxActions = false;
    public bool $ModalSearch = false;
    public bool $ModalView = false;
    public bool $ModalAdd = false;
    public bool $ModalEdit = false;
    public bool $ModalUpdate = false;
    public bool $InlineDelete = false;
    public bool $ModalGridAdd = false;
    public bool $ModalGridEdit = false;
    public bool $ModalMultiEdit = false;

    // Fields
    public DbField $ID;
    public DbField $MTReimbursementTypeID;
    public DbField $MTUserRequesterID;
    public DbField $MTUserApproverID;
    public DbField $RequestDateTime;
    public DbField $ApprovedDateTime;
    public DbField $RejectedDateTime;
    public DbField $MTUserRejectorID;
    public DbField $_Title;
    public DbField $Description;
    public DbField $Amount;
    public DbField $Attachment;
    public DbField $Notes;
    public DbField $CreatedByUserID;
    public DbField $CreatedDateTime;
    public DbField $LastUpdatedByUserID;
    public DbField $LastUpdatedDateTime;
    public DbField $_ProjectID;

    // Page ID
    public string $PageID = ""; // To be set by subclass

    // Constructor
    public function __construct(
        Language $language,
        AdvancedSecurity $security,
        CSPBuilder $cspBuilder,
        CacheInterface $cache,
        FieldFactory $fieldFactory,
        EventDispatcherInterface $dispatcher,
    ) {
        global $httpContext;
        parent::__construct($language, $security, $cspBuilder, $cache, $fieldFactory, $dispatcher);
        $this->TableVar = "trreimbursement";
        $this->TableName = 'trreimbursement';
        $this->TableType = "TABLE";
        $this->SortType = 1; // Sort Type
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");
        $this->EntityClass = Entity\Trreimbursement::class;
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = null; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = null; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = ""; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = ""; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDPermission = Config("DEFAULT_USER_ID_PERMISSION"); // Default User ID permission
        $this->BasicSearch = new BasicSearch($this, Session(), $this->language);

        // Create fields
        $this->Fields = $this->fieldFactory->createAll($this);

        // ID
        $this->ID = $this->Fields['ID'];
        $this->ID->DefaultErrorMessage = $this->language->phrase("IncorrectInteger");

        // MTReimbursementTypeID
        $this->MTReimbursementTypeID = $this->Fields['MTReimbursementTypeID'];
        $this->MTReimbursementTypeID->setSelectMultiple(false); // Select one
        $this->MTReimbursementTypeID->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->MTReimbursementTypeID->PleaseSelectText = $this->language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->MTReimbursementTypeID->Lookup = new Lookup($this->MTReimbursementTypeID, 'mtreimbursementtype', false, 'ID', ["Code","","",""], '', "", [], [], [], [], [], [], false, '', '', "`Code`");
        $this->MTReimbursementTypeID->DefaultErrorMessage = $this->language->phrase("IncorrectInteger");

        // MTUserRequesterID
        $this->MTUserRequesterID = $this->Fields['MTUserRequesterID'];
        $this->MTUserRequesterID->Lookup = new Lookup($this->MTUserRequesterID, 'mtuser', false, 'ID', ["FullName","","",""], '', "", [], [], [], [], [], [], false, '', '', "`FullName`");
        $this->MTUserRequesterID->DefaultErrorMessage = $this->language->phrase("IncorrectInteger");

        // MTUserApproverID
        $this->MTUserApproverID = $this->Fields['MTUserApproverID'];
        $this->MTUserApproverID->Lookup = new Lookup($this->MTUserApproverID, 'mtuser', false, 'ID', ["FullName","","",""], '', "", [], [], [], [], [], [], false, '', '', "`FullName`");
        $this->MTUserApproverID->DefaultErrorMessage = $this->language->phrase("IncorrectInteger");

        // RequestDateTime
        $this->RequestDateTime = $this->Fields['RequestDateTime'];
        $this->RequestDateTime->DefaultErrorMessage = str_replace("%s", $httpContext["DATE_FORMAT"], $this->language->phrase("IncorrectDate"));

        // ApprovedDateTime
        $this->ApprovedDateTime = $this->Fields['ApprovedDateTime'];
        $this->ApprovedDateTime->DefaultErrorMessage = str_replace("%s", $httpContext["DATE_FORMAT"], $this->language->phrase("IncorrectDate"));

        // RejectedDateTime
        $this->RejectedDateTime = $this->Fields['RejectedDateTime'];
        $this->RejectedDateTime->DefaultErrorMessage = str_replace("%s", $httpContext["DATE_FORMAT"], $this->language->phrase("IncorrectDate"));

        // MTUserRejectorID
        $this->MTUserRejectorID = $this->Fields['MTUserRejectorID'];
        $this->MTUserRejectorID->DefaultErrorMessage = $this->language->phrase("IncorrectInteger");

        // Title
        $this->_Title = $this->Fields['Title'];

        // Description
        $this->Description = $this->Fields['Description'];

        // Amount
        $this->Amount = $this->Fields['Amount'];
        $this->Amount->DefaultErrorMessage = $this->language->phrase("IncorrectFloat");

        // Attachment
        $this->Attachment = $this->Fields['Attachment'];

        // Notes
        $this->Notes = $this->Fields['Notes'];

        // CreatedByUserID
        $this->CreatedByUserID = $this->Fields['CreatedByUserID'];
        $this->CreatedByUserID->DefaultErrorMessage = $this->language->phrase("IncorrectInteger");

        // CreatedDateTime
        $this->CreatedDateTime = $this->Fields['CreatedDateTime'];
        $this->CreatedDateTime->DefaultErrorMessage = str_replace("%s", $httpContext["DATE_FORMAT"], $this->language->phrase("IncorrectDate"));

        // LastUpdatedByUserID
        $this->LastUpdatedByUserID = $this->Fields['LastUpdatedByUserID'];
        $this->LastUpdatedByUserID->DefaultErrorMessage = $this->language->phrase("IncorrectInteger");

        // LastUpdatedDateTime
        $this->LastUpdatedDateTime = $this->Fields['LastUpdatedDateTime'];
        $this->LastUpdatedDateTime->DefaultErrorMessage = str_replace("%s", $httpContext["DATE_FORMAT"], $this->language->phrase("IncorrectDate"));

        // ProjectID
        $this->_ProjectID = $this->Fields['ProjectID'];
        $this->_ProjectID->addMethod("getSelectFilter", fn() => "`IsActive` = '1'");
        $this->_ProjectID->setSelectMultiple(false); // Select one
        $this->_ProjectID->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->_ProjectID->PleaseSelectText = $this->language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->_ProjectID->Lookup = new Lookup($this->_ProjectID, 'mtproject', false, 'ProjectID', ["ProjectName","","",""], '', "", [], [], [], [], [], [], false, '', '', "`ProjectName`");
        $this->_ProjectID->DefaultErrorMessage = $this->language->phrase("IncorrectInteger");

        // Call Table Load event
        $this->tableLoad();
    }

    // Get field settings
    public function getFieldDefinitions(): array
    {
        return [
            'ID' => [
                'FieldVar' => 'x_ID', // Field variable name
                'Param' => 'ID', // Field parameter name (Table class property name)
                'PropertyName' => 'id', // Field entity property name
                'Expression' => '`ID`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`ID`', // Field expression (used in basic search SQL)
                'Type' => 3, // Field type
                'DataType' => DataType::NUMBER, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::INTEGER, // Field Doctrine parameter type
                'Size' => 11, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`ID`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'NO', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,
                'IsAutoIncrement' => true,
                'IsPrimaryKey' => true,
                'Nullable' => false,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"],
            ],
            'MTReimbursementTypeID' => [
                'FieldVar' => 'x_MTReimbursementTypeID', // Field variable name
                'Param' => 'MTReimbursementTypeID', // Field parameter name (Table class property name)
                'PropertyName' => 'mtreimbursementTypeId', // Field entity property name
                'Expression' => '`MTReimbursementTypeID`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`MTReimbursementTypeID`', // Field expression (used in basic search SQL)
                'Type' => 3, // Field type
                'DataType' => DataType::NUMBER, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::INTEGER, // Field Doctrine parameter type
                'Size' => 11, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`MTReimbursementTypeID`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'SELECT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,
                'Nullable' => false,
                'Required' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"],
            ],
            'MTUserRequesterID' => [
                'FieldVar' => 'x_MTUserRequesterID', // Field variable name
                'Param' => 'MTUserRequesterID', // Field parameter name (Table class property name)
                'PropertyName' => 'mtuserRequesterId', // Field entity property name
                'Expression' => '`MTUserRequesterID`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`MTUserRequesterID`', // Field expression (used in basic search SQL)
                'Type' => 3, // Field type
                'DataType' => DataType::NUMBER, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::INTEGER, // Field Doctrine parameter type
                'Size' => 11, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`MTUserRequesterID`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,
                'Nullable' => false,
                'Required' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"],
            ],
            'MTUserApproverID' => [
                'FieldVar' => 'x_MTUserApproverID', // Field variable name
                'Param' => 'MTUserApproverID', // Field parameter name (Table class property name)
                'PropertyName' => 'mtuserApproverId', // Field entity property name
                'Expression' => '`MTUserApproverID`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`MTUserApproverID`', // Field expression (used in basic search SQL)
                'Type' => 3, // Field type
                'DataType' => DataType::NUMBER, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::INTEGER, // Field Doctrine parameter type
                'Size' => 11, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`MTUserApproverID`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"],
            ],
            'RequestDateTime' => [
                'FieldVar' => 'x_RequestDateTime', // Field variable name
                'Param' => 'RequestDateTime', // Field parameter name (Table class property name)
                'PropertyName' => 'requestDateTime', // Field entity property name
                'Expression' => '`RequestDateTime`', // Field expression (used in SQL)
                'BasicSearchExpression' => CastDateFieldForLike("`RequestDateTime`", 0, "DB"), // Field expression (used in basic search SQL)
                'Type' => 135, // Field type
                'DataType' => DataType::DATE, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::STRING, // Field Doctrine parameter type
                'Size' => 19, // Field size
                'DateTimeFormat' => 0, // Date time format
                'VirtualExpression' => '`RequestDateTime`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"],
            ],
            'ApprovedDateTime' => [
                'FieldVar' => 'x_ApprovedDateTime', // Field variable name
                'Param' => 'ApprovedDateTime', // Field parameter name (Table class property name)
                'PropertyName' => 'approvedDateTime', // Field entity property name
                'Expression' => '`ApprovedDateTime`', // Field expression (used in SQL)
                'BasicSearchExpression' => CastDateFieldForLike("`ApprovedDateTime`", 0, "DB"), // Field expression (used in basic search SQL)
                'Type' => 135, // Field type
                'DataType' => DataType::DATE, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::STRING, // Field Doctrine parameter type
                'Size' => 19, // Field size
                'DateTimeFormat' => 0, // Date time format
                'VirtualExpression' => '`ApprovedDateTime`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"],
            ],
            'RejectedDateTime' => [
                'FieldVar' => 'x_RejectedDateTime', // Field variable name
                'Param' => 'RejectedDateTime', // Field parameter name (Table class property name)
                'PropertyName' => 'rejectedDateTime', // Field entity property name
                'Expression' => '`RejectedDateTime`', // Field expression (used in SQL)
                'BasicSearchExpression' => CastDateFieldForLike("`RejectedDateTime`", 0, "DB"), // Field expression (used in basic search SQL)
                'Type' => 135, // Field type
                'DataType' => DataType::DATE, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::STRING, // Field Doctrine parameter type
                'Size' => 19, // Field size
                'DateTimeFormat' => 0, // Date time format
                'VirtualExpression' => '`RejectedDateTime`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"],
            ],
            'MTUserRejectorID' => [
                'FieldVar' => 'x_MTUserRejectorID', // Field variable name
                'Param' => 'MTUserRejectorID', // Field parameter name (Table class property name)
                'PropertyName' => 'mtuserRejectorId', // Field entity property name
                'Expression' => '`MTUserRejectorID`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`MTUserRejectorID`', // Field expression (used in basic search SQL)
                'Type' => 3, // Field type
                'DataType' => DataType::NUMBER, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::INTEGER, // Field Doctrine parameter type
                'Size' => 11, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`MTUserRejectorID`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"],
            ],
            'Title' => [
                'FieldVar' => 'x__Title', // Field variable name
                'Param' => '_Title', // Field parameter name (Table class property name)
                'PropertyName' => 'title', // Field entity property name
                'Expression' => '`Title`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`Title`', // Field expression (used in basic search SQL)
                'Type' => 200, // Field type
                'DataType' => DataType::STRING, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::STRING, // Field Doctrine parameter type
                'Size' => 100, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`Title`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Nullable' => false,
                'Required' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"],
            ],
            'Description' => [
                'FieldVar' => 'x_Description', // Field variable name
                'Param' => 'Description', // Field parameter name (Table class property name)
                'PropertyName' => 'description', // Field entity property name
                'Expression' => '`Description`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`Description`', // Field expression (used in basic search SQL)
                'Type' => 200, // Field type
                'DataType' => DataType::STRING, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::STRING, // Field Doctrine parameter type
                'Size' => 500, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`Description`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXTAREA', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"],
            ],
            'Amount' => [
                'FieldVar' => 'x_Amount', // Field variable name
                'Param' => 'Amount', // Field parameter name (Table class property name)
                'PropertyName' => 'amount', // Field entity property name
                'Expression' => '`Amount`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`Amount`', // Field expression (used in basic search SQL)
                'Type' => 131, // Field type
                'DataType' => DataType::NUMBER, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::STRING, // Field Doctrine parameter type
                'Size' => 20, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`Amount`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,
                'Nullable' => false,
                'Required' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"],
            ],
            'Attachment' => [
                'FieldVar' => 'x_Attachment', // Field variable name
                'Param' => 'Attachment', // Field parameter name (Table class property name)
                'PropertyName' => 'attachment', // Field entity property name
                'Expression' => '`Attachment`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`Attachment`', // Field expression (used in basic search SQL)
                'Type' => 200, // Field type
                'DataType' => DataType::STRING, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::STRING, // Field Doctrine parameter type
                'Size' => 200, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`Attachment`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'IMAGE', // View Tag
                'HtmlTag' => 'FILE', // HTML Tag
                'IsUpload' => true, // Is upload field
                'InputTextType' => 'text',

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"],
            ],
            'Notes' => [
                'FieldVar' => 'x_Notes', // Field variable name
                'Param' => 'Notes', // Field parameter name (Table class property name)
                'PropertyName' => 'notes', // Field entity property name
                'Expression' => '`Notes`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`Notes`', // Field expression (used in basic search SQL)
                'Type' => 200, // Field type
                'DataType' => DataType::STRING, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::STRING, // Field Doctrine parameter type
                'Size' => 200, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`Notes`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"],
            ],
            'CreatedByUserID' => [
                'FieldVar' => 'x_CreatedByUserID', // Field variable name
                'Param' => 'CreatedByUserID', // Field parameter name (Table class property name)
                'PropertyName' => 'createdByUserId', // Field entity property name
                'Expression' => '`CreatedByUserID`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`CreatedByUserID`', // Field expression (used in basic search SQL)
                'Type' => 3, // Field type
                'DataType' => DataType::NUMBER, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::INTEGER, // Field Doctrine parameter type
                'Size' => 11, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`CreatedByUserID`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"],
            ],
            'CreatedDateTime' => [
                'FieldVar' => 'x_CreatedDateTime', // Field variable name
                'Param' => 'CreatedDateTime', // Field parameter name (Table class property name)
                'PropertyName' => 'createdDateTime', // Field entity property name
                'Expression' => '`CreatedDateTime`', // Field expression (used in SQL)
                'BasicSearchExpression' => CastDateFieldForLike("`CreatedDateTime`", 0, "DB"), // Field expression (used in basic search SQL)
                'Type' => 135, // Field type
                'DataType' => DataType::DATE, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::STRING, // Field Doctrine parameter type
                'Size' => 19, // Field size
                'DateTimeFormat' => 0, // Date time format
                'VirtualExpression' => '`CreatedDateTime`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"],
            ],
            'LastUpdatedByUserID' => [
                'FieldVar' => 'x_LastUpdatedByUserID', // Field variable name
                'Param' => 'LastUpdatedByUserID', // Field parameter name (Table class property name)
                'PropertyName' => 'lastUpdatedByUserId', // Field entity property name
                'Expression' => '`LastUpdatedByUserID`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`LastUpdatedByUserID`', // Field expression (used in basic search SQL)
                'Type' => 3, // Field type
                'DataType' => DataType::NUMBER, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::INTEGER, // Field Doctrine parameter type
                'Size' => 11, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`LastUpdatedByUserID`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"],
            ],
            'LastUpdatedDateTime' => [
                'FieldVar' => 'x_LastUpdatedDateTime', // Field variable name
                'Param' => 'LastUpdatedDateTime', // Field parameter name (Table class property name)
                'PropertyName' => 'lastUpdatedDateTime', // Field entity property name
                'Expression' => '`LastUpdatedDateTime`', // Field expression (used in SQL)
                'BasicSearchExpression' => CastDateFieldForLike("`LastUpdatedDateTime`", 0, "DB"), // Field expression (used in basic search SQL)
                'Type' => 135, // Field type
                'DataType' => DataType::DATE, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::STRING, // Field Doctrine parameter type
                'Size' => 19, // Field size
                'DateTimeFormat' => 0, // Date time format
                'VirtualExpression' => '`LastUpdatedDateTime`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'TEXT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"],
            ],
            'ProjectID' => [
                'FieldVar' => 'x__ProjectID', // Field variable name
                'Param' => '_ProjectID', // Field parameter name (Table class property name)
                'PropertyName' => 'projectId', // Field entity property name
                'Expression' => '`ProjectID`', // Field expression (used in SQL)
                'BasicSearchExpression' => '`ProjectID`', // Field expression (used in basic search SQL)
                'Type' => 3, // Field type
                'DataType' => DataType::NUMBER, // Field data type (DataType::XXX)
                'ParameterType' => ParameterType::INTEGER, // Field Doctrine parameter type
                'Size' => 11, // Field size
                'DateTimeFormat' => -1, // Date time format
                'VirtualExpression' => '`ProjectID`', // Virtual field expression (used in ListSQL)
                'IsVirtual' => false, // Virtual field
                'ForceSelection' => false, // Autosuggest force selection
                'VirtualSearch' => false, // Search as virtual field
                'ViewTag' => 'FORMATTED TEXT', // View Tag
                'HtmlTag' => 'SELECT', // HTML Tag
                'IsUpload' => false, // Is upload field
                'InputTextType' => 'text',
                'Raw' => true,
                'Required' => true,

                // 'UseAdvancedSearch' => true,
                'SearchOperators' => ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"],
            ],
        ];
    }

    // Field Visibility
    public function getFieldVisibility(string $fldParm): bool
    {
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass(string $class): void
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(DbField $fld): void
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort(): void
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis(string $chartVar, array $chartRow): array
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom(): string
    {
        return $this->sqlFrom ?? "trreimbursement";
    }

    // Set FROM clause
    public function setSqlFrom(string $v): void
    {
        $this->sqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect(): QueryBuilder // Select
    {
        return $this->getQueryBuilder()->select($this->getSqlSelectFields());
    }

    // Get list of fields
    public function getSqlSelectFields(): string
    {
        if ($this->sqlSelectFields) {
            return $this->sqlSelectFields;
        }
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
            } else {
                $fieldNames[] = $expr;
            }
        }
        return implode(", ", $fieldNames);
    }

    // Set list of fields
    public function setSqlSelectFields(string $v): void
    {
        $this->sqlSelectFields = $v;
    }

    // Get default filter
    public function getDefaultFilter(): string
    {
        return "";
    }

    // Get WHERE clause
    public function getSqlWhere(bool $delete = false): string
    {
        $where = $this->sqlWhere ?? "";
        AddFilter($where, $this->getDefaultFilter());
        if (!$delete && !IsEmpty($this->SoftDeleteFieldName) && $this->UseSoftDeleteFilter) { // Add soft delete filter
            AddFilter($where, $this->Fields[$this->SoftDeleteFieldName]->Expression . " IS NULL");
            if ($this->TimeAware) { // Add time aware filter
                AddFilter($where, $this->Fields[$this->SoftDeleteFieldName]->Expression . " > " . $this->getConnection()->getDatabasePlatform()->getCurrentTimestampSQL(), "OR");
            }
        }
        return $where;
    }

    // Set WHERE clause
    public function setSqlWhere(string $v): void
    {
        $this->sqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy(): string
    {
        return $this->sqlGroupBy ?? "";
    }

    // set GROUP BY clause
    public function setSqlGroupBy(string $v): void
    {
        $this->sqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving(): string // Having
    {
        return $this->sqlHaving ?? "";
    }

    // Set HAVING clause
    public function setSqlHaving(string $v): void
    {
        $this->sqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy(): string
    {
        return $this->sqlOrderBy ?? "";
    }

    // set ORDER BY clause
    public function setSqlOrderBy(string $v): void
    {
        $this->sqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters(string $filter = "", string $id = ""): string
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow(string $id = ""): bool
    {
        $allow = $this->UserIDPermission;
        return match ($id) {
            "add", "copy", "gridadd", "register", "addopt" => ($allow & Allow::ADD->value) == Allow::ADD->value,
            "edit", "gridedit", "update", "changepassword", "resetpassword" => ($allow & Allow::EDIT->value) == Allow::EDIT->value,
            "delete" => ($allow & Allow::DELETE->value) == Allow::DELETE->value,
            "view" => ($allow & Allow::VIEW->value) == Allow::VIEW->value,
            "search" => ($allow & Allow::SEARCH->value) == Allow::SEARCH->value,
            "lookup" => ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value,
            default => ($allow & Allow::LIST->value) == Allow::LIST->value
        };
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param Connection $c Connection
     * @return int
     */
    public function getRecordCount(string|QueryBuilder $sql, ?Connection $c = null): int
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetOrderBy()->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+?)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"])
            && preg_match($pattern, $sqlwrk)
            && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk)
            && !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk)
            && !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetchAssociative()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get QueryBuilder
    public function getSqlBuilder(string $where, string $orderBy = "", bool $delete = false): QueryBuilder
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere($delete),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Get QueryBuilder (alias)
    public function getSql(string $where, string $orderBy = "", bool $delete = false): QueryBuilder
    {
        return $this->getSqlBuilder($where, $orderBy, $delete);
    }

    // Table SQL
    public function getCurrentSql(bool $delete = false): QueryBuilder
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort, $delete);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql(): QueryBuilder
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy(): string
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter
    public function loadRecordCount($filter, $delete = false): int
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        if ($delete == false) {
            $this->recordsSelecting($this->CurrentFilter);
        }
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere($delete), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount(): int
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * Inserts a table row with specified data
     *
     * Table expression and columns are not escaped and are not safe for user-input.
     *
     * @param array<string, mixed> $data (unquoted column name as key)
     * @param array<string, ParameterType> $types (quoted column name as key)
     *
     * @return int|numeric-string The number of affected rows.
     *
     * @throws Exception
     */
    public function insert(array $data, array $types = []): int|string
    {
        $conn = $this->getConnection();
        $table = $conn->quoteSingleIdentifier($this->TableName);

        // Quote the key of $data and set up $types
        $quotedData = [];
        foreach ($data as $key => $value) {
            $quotedKey = $conn->quoteSingleIdentifier($key);
            $quotedData[$quotedKey] = $value instanceof DateTimeInterface ? ConvertToString($value) : $value;
            $types[$quotedKey] ??= $this->Fields[$key]->getParameterType();
        }
        return $conn->insert($table, $quotedData, $types);
    }

    /**
     * Executes an SQL UPDATE statement on a table
     *
     * Table expression and columns are not escaped and are not safe for user-input.
     *
     * @param array<string, mixed> $data (unquoted column name as key)
     * @param array<string, mixed> $criteria (unquoted column name as key)
     * @param array<string, ParameterType> $types (quoted column name as key)
     *
     * @return int|numeric-string The number of affected rows.
     *
     * @throws Exception
     */
    public function update(array $data, array $criteria = [], array $types = []): int|string
    {
        $conn = $this->getConnection();
        $table = $conn->quoteSingleIdentifier($this->TableName);

        // Quote the key of $data and set up $types
        $quotedData = [];
        foreach ($data as $key => $value) {
            $quotedKey = $conn->quoteSingleIdentifier($key);
            $quotedData[$quotedKey] = $value instanceof DateTimeInterface ? ConvertToString($value) : $value;
            $types[$quotedKey] ??= $this->Fields[$key]->getParameterType();
        }

        // Quote the key of $criteria and set up $types
        $quotedCriteria = [];
        foreach ($criteria as $key => $value) {
            $quotedKey = $conn->quoteSingleIdentifier($key);
            $quotedCriteria[$quotedKey] = $value instanceof DateTimeInterface ? ConvertToString($value) : $value;
            $types[$quotedKey] ??= $this->Fields[$key]->getParameterType();
        }
        return $conn->update($table, $quotedData, $quotedCriteria, $types);
    }

    /**
     * Executes an SQL DELETE statement on a table.
     *
     * Table expression and columns are not escaped and are not safe for user-input.
     *
     * @param array<string, mixed> $criteria (unquoted column name as key)
     * @param array<string, ParameterType> $types (quoted column name as key)
     *
     * @return int|numeric-string The number of affected rows.
     *
     * @throws Exception
     */
    public function delete(array $criteria = [], array $types = []): int|string
    {
        $conn = $this->getConnection();
        $table = $conn->quoteSingleIdentifier($this->TableName);

        // Quote the key of $criteria and set up $types
        $quotedCriteria = [];
        foreach ($criteria as $key => $value) {
            $quotedKey = $conn->quoteSingleIdentifier($key);
            $quotedCriteria[$quotedKey] = $value instanceof DateTimeInterface ? ConvertToString($value) : $value;
            $types[$quotedKey] ??= $this->Fields[$key]->getParameterType();
        }
        return $conn->delete($table, $quotedCriteria, $types);
    }

    /**
     * Clear cache for this table
     */
    public function clearCache(Entity\Trreimbursement $row, LifecycleEventArgs $args): void
    {
        // Clear lookup cache
        $this->cache->clear("lookup.result." . $this->TableVar . ".");

        // Optionally prune expired entries if supported
        if ($this->cache instanceof PruneableInterface) {
            $this->cache->prune();
        }
    }

    // Load DbValue from result set or array
    protected function loadDbValues(?BaseEntity $row)
    {
        if ($row === null) {
            return;
        }
        $this->ID->DbValue = $row->getId();
        $this->MTReimbursementTypeID->DbValue = $row->getMtreimbursementTypeId();
        $this->MTUserRequesterID->DbValue = $row->getMtuserRequesterId();
        $this->MTUserApproverID->DbValue = $row->getMtuserApproverId();
        $this->RequestDateTime->DbValue = $row->getRequestDateTime();
        $this->ApprovedDateTime->DbValue = $row->getApprovedDateTime();
        $this->RejectedDateTime->DbValue = $row->getRejectedDateTime();
        $this->MTUserRejectorID->DbValue = $row->getMtuserRejectorId();
        $this->_Title->DbValue = $row->getTitle();
        $this->Description->DbValue = $row->getDescription();
        $this->Amount->DbValue = $row->getAmount();
        $this->Attachment->Upload->DbValue = $row->getAttachment();
        $this->Notes->DbValue = $row->getNotes();
        $this->CreatedByUserID->DbValue = $row->getCreatedByUserId();
        $this->CreatedDateTime->DbValue = $row->getCreatedDateTime();
        $this->LastUpdatedByUserID->DbValue = $row->getLastUpdatedByUserId();
        $this->LastUpdatedDateTime->DbValue = $row->getLastUpdatedDateTime();
        $this->_ProjectID->DbValue = $row->getProjectId();
    }

    // Delete uploaded files
    public function deleteUploadedFiles(BaseEntity $row)
    {
        $this->loadDbValues($row);
        $value = $row->getAttachment();
        $oldFiles = IsEmpty($value) ? [] : [$value];
        foreach ($oldFiles as $oldFile) {
            $file = PathJoin($this->Attachment->OldUploadPath, $oldFile);
            if (FileExists($file)) {
                DeleteFile($file);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter(): string
    {
        return "`ID` = @ID@";
    }

    /**
     * Get key from CurrentValue/OldValue
     *
     * @param bool $current Current value
     * @return array
     */
    public function getKey(bool $current = false): array
    {
        $keys = [];
        $val = $current ? $this->ID->CurrentValue : $this->ID->OldValue;
        if (IsEmpty($val)) {
            return [];
        } else {
            // Explicitly convert DateTime objects to string format
            $val = $val instanceof DateTimeInterface ? ConvertToString($val) : $val;
            $keys["ID"] = $val;
        }
        return $keys;
    }

    /**
     * Get key as array for use with UrlFor()
     *
     * @param bool $current Current value
     * @return string
     */
    public function getUrlKey(bool $current = false): array
    {
        $keys = ["id"];
        $values = array_values($this->getKey($current));
        return count($keys) == count($values) ? array_combine($keys, $values) : [];
    }

    /**
     * Set key
     *
     * @param array|string $key Key
     * @param bool $current Current value
     * @param ?string $keySeparator Key separator
     */
    public function setKey(array|string $key, bool $current = false, ?string $keySeparator = null): void
    {
        $recordKey = [];
        if (is_string($key)) {
            $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
            $ar = explode($keySeparator, $key);
            if (count($ar) == 1) {
                $recordKey["ID"] = $ar[0];
            }
        } else {
            $recordKey = $key;
        }
        if (count($recordKey) == 1) {
            foreach ($recordKey as $name => $value) {
                if (isset($this->Fields[$name])) {
                    if ($current) {
                        $this->Fields[$name]->CurrentValue = $value;
                    } else {
                        $this->Fields[$name]->OldValue = $value;
                    }
                }
            }
            $this->OldKey = $recordKey;
        }
    }

    /**
     * Get record key as array
     *
     * @param array|BaseEntity|null $row Row
     * @param bool $current Use current value
     * @return array
     */
    public function getKeyAsArray(array|BaseEntity|null $row = null, bool $current = false): array
    {
        $recordKey = [];
        if (is_array($row) || $row instanceof BaseEntity) {
            $val = $row['ID'] ?? null;
        } else {
            $val = !IsEmpty($this->ID->OldValue) && !$current ? $this->ID->OldValue : $this->ID->CurrentValue;
        }
        if (!is_numeric($val)) {
            return []; // Invalid value
        }
        if ($val === null) {
            return []; // Invalid value
        }
        $recordKey["ID"] = $val;
        return $recordKey;
    }

    /**
     * Get Key from row as string
     *
     * @param array|BaseEntity|null $row Row
     * @param bool $current Use current value
     * @param ?string $separator Separator
     * @return string
     */
    public function getKeyAsString(array|BaseEntity|null $row = null, bool $current = false, ?string $separator = null): string
    {
        $keys = array_values($this->getKeyAsArray($row, $current)); // DateTime fields are already formatted
        $separator ??= Config("COMPOSITE_KEY_SEPARATOR"); // Use COMPOSITE_KEY_SEPARATOR as default separator
        if ($separator == Config("ROUTE_COMPOSITE_KEY_SEPARATOR")) { // Key as route parameter
            $keys = array_map(fn ($key) => rawurlencode($key), $keys); // URL-encode the values
        }
        return implode($separator, $keys);
    }

    /**
     * Get record filter (as string)
     *
     * @param array|BaseEntity|null $row Row
     * @param bool $current Use current value
     * @return string
     */
    public function getRecordFilter(array|BaseEntity|null $row = null, bool $current = false): string
    {
        $filter = $this->arrayToFilter($this->getKeyAsArray($row, $current));
        return IsEmpty($filter) ? "0=1" : $filter;
    }

    // Return page URL
    public function getReturnUrl(): string
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = AddTabId(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL"));
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            Session($name, $referUrl); // Save to Session
        }
        return Session($name) ?? GetUrl("TrreimbursementList");
    }

    // Set return page URL
    public function setReturnUrl(string $v): void
    {
        Session(AddTabId(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")), $v);
    }

    // Get modal caption
    public function getModalCaption(string $pageName): string
    {
        return match ($pageName) {
            "TrreimbursementView" => $this->language->phrase("View"),
            "TrreimbursementEdit" => $this->language->phrase("Edit"),
            "TrreimbursementAdd" => $this->language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl(): string
    {
        return "TrreimbursementList";
    }

    // Current URL
    public function getCurrentUrl(string $param = ""): string
    {
        $url = CurrentPageUrl(false);
        if ($param != "") {
            $url = $this->keyUrl($url, $param);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl(): string
    {
        return "TrreimbursementList";
    }

    // View URL
    public function getViewUrl(string $param = ""): string
    {
        $params = [];
        if ($param != "") {
            $params[] = $param;
        }
        $url = $this->keyUrl("TrreimbursementView", $params);
        return $this->addMasterUrl($url);
    }

    // Detail view URL
    public function getDetailViewUrl(string $param = ""): string
    {
        $url = $this->keyUrl("TrreimbursementView", [$param]);
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl(string $param = ""): string
    {
        $url = BuildUrl("TrreimbursementAdd", $param);
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl(string $param = ""): string
    {
        $params = [];
        if ($param != "") {
            $params[] = $param;
        }
        $url = $this->keyUrl("TrreimbursementEdit", $params);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl(): string
    {
        $url = $this->keyUrl("TrreimbursementList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Detail edit URL
    public function getDetailEditUrl(string $param = ""): string
    {
        $url = $this->keyUrl("TrreimbursementEdit", [$param]);
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl(string $param = ""): string
    {
        $params = [];
        if ($param != "") {
            $params[] = $param;
        }
        $url = $this->keyUrl("TrreimbursementAdd", $params);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl(): string
    {
        $url = $this->keyUrl("TrreimbursementList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl(string $param = ""): string
    {
        if ($this->UseAjaxActions && IsInfiniteScroll() && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("TrreimbursementDelete", $param);
        }
    }

    // Add master url
    public function addMasterUrl(string $url): string
    {
        if ($url == "") {
            return "";
        }
        return $url;
    }

    public function keyToJson(bool $htmlEncode = false): string
    {
        $json = "";
        $json .= "\"ID\":" . VarToJson($this->ID->CurrentValue, "number");
        $json = "{" . $json . "}";
        return $htmlEncode ? HtmlEncode($json) : $json;
    }

    // Add key value to URL
    public function keyUrl(string $url, string|array $params = ""): string
    {
        if ($this->ID->CurrentValue !== null) {
            $url .= "/" . $this->rawUrlEncode($this->ID->CurrentValue);
        } else {
            return AllowInlineScript() ? "javascript:ew.alert(ew.language.phrase('InvalidRecord'));" : "";
        }
        return BuildUrl($url, $params);
    }

    /**
     * Get record keys from Post/Get/Route
     *
     * @return array
     */
    public function getRecordKeys(): array
    {
        $keys = [];
        if (Param("key_m") !== null) {
            $keys = Param("key_m");
            $cnt = count($keys);
            for ($i = 0; $i < $cnt; $i++) {
                $keys[$i] = [$keys[$i]];
            }
        } else {
            $isApi = IsApi();
            if (($keyValue = Param("ID") ?? Route("id")) !== null) {
                $keys[] = [$keyValue];
            } elseif ($isApi && ($keyValue = Key(0)) !== null) {
                $keys[] = [$keyValue];
            }
        }

        // Check and set up keys
        $recordKeys = [];
        foreach ($keys as $key) {
            if (count($key) != 1) {
                continue; // Just skip so other keys will still work
            }
            $recordKey = [];
            if (!is_numeric($key[0])) { // ID
                continue;
            }
            $recordKey["ID"] = $key[0];
            $recordKeys[] = $recordKey;
        }
        return $recordKeys;
    }

    // Get filter from records
    public function getFilterFromRecords(array $rows): string
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys(): string
    {
        return $this->getFilterFromRecords($this->getRecordKeys());
    }

    /**
     * Load entity by filter
     *
     * @param string|array $filter Filter
     * @return Entity
     */
    public function loadEntity(string|array $filter): BaseEntity
    {
        return $this->loadEntitiesFromFilter($filter)[0] ?? null;
    }

    /**
     * Load entities from filter/sort
     *
     * @param string|array $filter Filter
     * @param string $sort Order By
     * @return array of entities
     */
    public function loadEntitiesFromFilter(string|array $filter, string $sort = ""): array
    {
        if (is_array($filter)) {
            $filter = $this->arrayToFilter($filter);
        }
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        return $this->loadEntities($sql);
    }

    /**
     * Load entities from DBAL query builder
     *
     * @param QueryBuilder $sql
     * @return array of entities
     */
    public function loadEntities(QueryBuilder $sql): array
    {
        $em = $this->getEntityManager();
        $meta = $em->getClassMetadata($this->EntityClass);
        $rsm = new ResultSetMappingBuilder($em);
        $rsm->addRootEntityFromClassMetadata($this->EntityClass, $this->Alias);
        $customFields = [];
        foreach ($this->getFieldDefinitions() as $column => $def) {
            if (($def["IsCustom"] ?? false) && isset($def["Expression"])) {
                $property = GetFieldName($meta, $column);
                $rsm->addScalarResult($column, $property);
                $customFields[] = $column;
            }
        }
        $query = $em->createNativeQuery($sql, $rsm);
        $results = $query->getResult();

        // Unable to get results, use DBAL
        if (IsEmpty($results)) {
            $rows = $sql->fetchAllAssociative();
            return array_map([$this->EntityClass, "createFromArray"], $rows);
        }

        // Skip post-processing if no custom fields
        if (!$customFields) {
            return $results;
        }
        $entities = [];
        foreach ($results as $row) {
            if (is_array($row)) {
                $entity = $row[0];
                foreach ($customFields as $field) {
                    if (array_key_exists($field, $row)) {
                        $entity[$field] = $row[$field];
                    }
                }
            } else {
                $entity = $row;
            }
            $entities[] = $entity;
        }
        return $entities;
    }

    // Load row values from record
    public function loadListRowValues(array|BaseEntity $row): void
    {
        $this->ID->setDbValue($row['ID']);
        $this->MTReimbursementTypeID->setDbValue($row['MTReimbursementTypeID']);
        $this->MTUserRequesterID->setDbValue($row['MTUserRequesterID']);
        $this->MTUserApproverID->setDbValue($row['MTUserApproverID']);
        $this->RequestDateTime->setDbValue($row['RequestDateTime']);
        $this->ApprovedDateTime->setDbValue($row['ApprovedDateTime']);
        $this->RejectedDateTime->setDbValue($row['RejectedDateTime']);
        $this->MTUserRejectorID->setDbValue($row['MTUserRejectorID']);
        $this->_Title->setDbValue($row['Title']);
        $this->Description->setDbValue($row['Description']);
        $this->Amount->setDbValue($row['Amount']);
        $this->Attachment->Upload->DbValue = $row['Attachment'];
        $this->Notes->setDbValue($row['Notes']);
        $this->CreatedByUserID->setDbValue($row['CreatedByUserID']);
        $this->CreatedDateTime->setDbValue($row['CreatedDateTime']);
        $this->LastUpdatedByUserID->setDbValue($row['LastUpdatedByUserID']);
        $this->LastUpdatedDateTime->setDbValue($row['LastUpdatedDateTime']);
        $this->_ProjectID->setDbValue($row['ProjectID']);
    }

    // Render list content
    public function renderListContent(array|BaseEntity $data, int $totalRecords)
    {
        global $httpContext;
        $container = Container();
        $page = $container->get("TrreimbursementList");
        if (is_array($data)) {
            $page->loadRecordsFromArray($data, $totalRecords);
        } else {
            $page->loadRecordsFromArray([$data], $totalRecords);
        }
        $view = $container->get("app.view");
        $template = GetClassShortName($page) . ".php"; // View
        $TokenName = Config('CSRF_TOKEN.id'); // Token id/name, e.g. 'submit', 'authenticate'
        $TokenValue = CsrfToken($TokenName); // Cookie name, e.g. 'csrf-token'
        $viewData = [
            'Page' => $page,
            'Title' => $page->Title, // Title
            'Language' => $this->language,
            'Security' => $this->security,
            'TokenNameKey' => Config('CSRF_TOKEN.id_key'), // '_csrf_id', reuse $TokenNameKey for backward compatibility
            'TokenName' => $TokenName, // 'submit' or 'authenticate', reuse $TokenName for backward compatibility
            'TokenValueKey' => Config('CSRF_TOKEN.value_key'), // '_csrf_token'
            'TokenValue' => $TokenValue, // Cookie name, e.g. 'csrf-token'
            'DashboardReport' => $httpContext["DashboardReport"], // Dashboard report
            'SkipHeaderFooter' => $httpContext["SkipHeaderFooter"],
        ];
        try {
            $this->Response = $view->render(new Response(), $template, $viewData);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $httpContext;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ID

        // MTReimbursementTypeID

        // MTUserRequesterID

        // MTUserApproverID

        // RequestDateTime

        // ApprovedDateTime

        // RejectedDateTime

        // MTUserRejectorID

        // Title

        // Description

        // Amount

        // Attachment

        // Notes

        // CreatedByUserID

        // CreatedDateTime

        // LastUpdatedByUserID

        // LastUpdatedDateTime

        // ProjectID

        // ID
        $this->ID->ViewValue = $this->ID->CurrentValue;

        // MTReimbursementTypeID
        $curVal = strval($this->MTReimbursementTypeID->CurrentValue);
        if ($curVal != "") {
            $this->MTReimbursementTypeID->ViewValue = $this->MTReimbursementTypeID->lookupCacheOption($curVal);
            if ($this->MTReimbursementTypeID->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->MTReimbursementTypeID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->MTReimbursementTypeID->Lookup->getTable()->Fields["ID"]->searchDataType(), "DB");
                $sqlWrk = $this->MTReimbursementTypeID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = $this->getConnection();
                $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $rows = [];
                    foreach ($rswrk as $row) {
                        $rows[] = $this->MTReimbursementTypeID->Lookup->renderViewRow($row);
                    }
                    $this->MTReimbursementTypeID->ViewValue = $this->MTReimbursementTypeID->displayValue($rows[0]);
                } else {
                    $this->MTReimbursementTypeID->ViewValue = FormatNumber($this->MTReimbursementTypeID->CurrentValue, $this->MTReimbursementTypeID->formatPattern());
                }
            }
        } else {
            $this->MTReimbursementTypeID->ViewValue = null;
        }

        // MTUserRequesterID
        $this->MTUserRequesterID->ViewValue = $this->MTUserRequesterID->CurrentValue;
        $curVal = strval($this->MTUserRequesterID->CurrentValue);
        if ($curVal != "") {
            $this->MTUserRequesterID->ViewValue = $this->MTUserRequesterID->lookupCacheOption($curVal);
            if ($this->MTUserRequesterID->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->MTUserRequesterID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->MTUserRequesterID->Lookup->getTable()->Fields["ID"]->searchDataType(), "DB");
                $sqlWrk = $this->MTUserRequesterID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = $this->getConnection();
                $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $rows = [];
                    foreach ($rswrk as $row) {
                        $rows[] = $this->MTUserRequesterID->Lookup->renderViewRow($row);
                    }
                    $this->MTUserRequesterID->ViewValue = $this->MTUserRequesterID->displayValue($rows[0]);
                } else {
                    $this->MTUserRequesterID->ViewValue = FormatNumber($this->MTUserRequesterID->CurrentValue, $this->MTUserRequesterID->formatPattern());
                }
            }
        } else {
            $this->MTUserRequesterID->ViewValue = null;
        }

        // MTUserApproverID
        $this->MTUserApproverID->ViewValue = $this->MTUserApproverID->CurrentValue;
        $curVal = strval($this->MTUserApproverID->CurrentValue);
        if ($curVal != "") {
            $this->MTUserApproverID->ViewValue = $this->MTUserApproverID->lookupCacheOption($curVal);
            if ($this->MTUserApproverID->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->MTUserApproverID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->MTUserApproverID->Lookup->getTable()->Fields["ID"]->searchDataType(), "DB");
                $sqlWrk = $this->MTUserApproverID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = $this->getConnection();
                $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $rows = [];
                    foreach ($rswrk as $row) {
                        $rows[] = $this->MTUserApproverID->Lookup->renderViewRow($row);
                    }
                    $this->MTUserApproverID->ViewValue = $this->MTUserApproverID->displayValue($rows[0]);
                } else {
                    $this->MTUserApproverID->ViewValue = FormatNumber($this->MTUserApproverID->CurrentValue, $this->MTUserApproverID->formatPattern());
                }
            }
        } else {
            $this->MTUserApproverID->ViewValue = null;
        }

        // RequestDateTime
        $this->RequestDateTime->ViewValue = $this->RequestDateTime->CurrentValue;
        $this->RequestDateTime->ViewValue = FormatDateTime($this->RequestDateTime->ViewValue, $this->RequestDateTime->formatPattern());

        // ApprovedDateTime
        $this->ApprovedDateTime->ViewValue = $this->ApprovedDateTime->CurrentValue;
        $this->ApprovedDateTime->ViewValue = FormatDateTime($this->ApprovedDateTime->ViewValue, $this->ApprovedDateTime->formatPattern());

        // RejectedDateTime
        $this->RejectedDateTime->ViewValue = $this->RejectedDateTime->CurrentValue;
        $this->RejectedDateTime->ViewValue = FormatDateTime($this->RejectedDateTime->ViewValue, $this->RejectedDateTime->formatPattern());

        // MTUserRejectorID
        $this->MTUserRejectorID->ViewValue = $this->MTUserRejectorID->CurrentValue;
        $this->MTUserRejectorID->ViewValue = FormatNumber($this->MTUserRejectorID->ViewValue, $this->MTUserRejectorID->formatPattern());

        // Title
        $this->_Title->ViewValue = $this->_Title->CurrentValue;

        // Description
        $this->Description->ViewValue = $this->Description->CurrentValue;

        // Amount
        $this->Amount->ViewValue = $this->Amount->CurrentValue;
        $this->Amount->ViewValue = FormatNumber($this->Amount->ViewValue, $this->Amount->formatPattern());

        // Attachment
        if (!IsEmpty($this->Attachment->Upload->DbValue)) {
            $this->Attachment->ImageAlt = $this->Attachment->alt();
            $this->Attachment->ImageCssClass = "ew-image";
            $this->Attachment->ViewValue = $this->Attachment->Upload->DbValue;
        } else {
            $this->Attachment->ViewValue = "";
        }

        // Notes
        $this->Notes->ViewValue = $this->Notes->CurrentValue;

        // CreatedByUserID
        $this->CreatedByUserID->ViewValue = $this->CreatedByUserID->CurrentValue;
        $this->CreatedByUserID->ViewValue = FormatNumber($this->CreatedByUserID->ViewValue, $this->CreatedByUserID->formatPattern());

        // CreatedDateTime
        $this->CreatedDateTime->ViewValue = $this->CreatedDateTime->CurrentValue;
        $this->CreatedDateTime->ViewValue = FormatDateTime($this->CreatedDateTime->ViewValue, $this->CreatedDateTime->formatPattern());

        // LastUpdatedByUserID
        $this->LastUpdatedByUserID->ViewValue = $this->LastUpdatedByUserID->CurrentValue;
        $this->LastUpdatedByUserID->ViewValue = FormatNumber($this->LastUpdatedByUserID->ViewValue, $this->LastUpdatedByUserID->formatPattern());

        // LastUpdatedDateTime
        $this->LastUpdatedDateTime->ViewValue = $this->LastUpdatedDateTime->CurrentValue;
        $this->LastUpdatedDateTime->ViewValue = FormatDateTime($this->LastUpdatedDateTime->ViewValue, $this->LastUpdatedDateTime->formatPattern());

        // ProjectID
        $curVal = strval($this->_ProjectID->CurrentValue);
        if ($curVal != "") {
            $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
            if ($this->_ProjectID->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "DB");
                $lookupFilter = $this->_ProjectID->getSelectFilter($this); // PHP
                $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = $this->getConnection();
                $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $rows = [];
                    foreach ($rswrk as $row) {
                        $rows[] = $this->_ProjectID->Lookup->renderViewRow($row);
                    }
                    $this->_ProjectID->ViewValue = $this->_ProjectID->displayValue($rows[0]);
                } else {
                    $this->_ProjectID->ViewValue = FormatNumber($this->_ProjectID->CurrentValue, $this->_ProjectID->formatPattern());
                }
            }
        } else {
            $this->_ProjectID->ViewValue = null;
        }

        // ID
        $this->ID->HrefValue = "";
        $this->ID->TooltipValue = "";

        // MTReimbursementTypeID
        $this->MTReimbursementTypeID->HrefValue = "";
        $this->MTReimbursementTypeID->TooltipValue = "";

        // MTUserRequesterID
        $this->MTUserRequesterID->HrefValue = "";
        $this->MTUserRequesterID->TooltipValue = "";

        // MTUserApproverID
        $this->MTUserApproverID->HrefValue = "";
        $this->MTUserApproverID->TooltipValue = "";

        // RequestDateTime
        $this->RequestDateTime->HrefValue = "";
        $this->RequestDateTime->TooltipValue = "";

        // ApprovedDateTime
        $this->ApprovedDateTime->HrefValue = "";
        $this->ApprovedDateTime->TooltipValue = "";

        // RejectedDateTime
        $this->RejectedDateTime->HrefValue = "";
        $this->RejectedDateTime->TooltipValue = "";

        // MTUserRejectorID
        $this->MTUserRejectorID->HrefValue = "";
        $this->MTUserRejectorID->TooltipValue = "";

        // Title
        $this->_Title->HrefValue = "";
        $this->_Title->TooltipValue = "";

        // Description
        $this->Description->HrefValue = "";
        $this->Description->TooltipValue = "";

        // Amount
        $this->Amount->HrefValue = "";
        $this->Amount->TooltipValue = "";

        // Attachment
        if (!IsEmpty($this->Attachment->Upload->DbValue)) {
            $this->Attachment->HrefValue = GetFileUploadUrl($this->Attachment, $this->Attachment->htmlDecode($this->Attachment->Upload->DbValue)); // Add prefix/suffix
            $this->Attachment->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->Attachment->HrefValue = FullUrl($this->Attachment->HrefValue, "href");
            }
        } else {
            $this->Attachment->HrefValue = "";
        }
        $this->Attachment->ExportHrefValue = $this->Attachment->UploadPath . $this->Attachment->Upload->DbValue;
        $this->Attachment->TooltipValue = "";
        if ($this->Attachment->UseColorbox) {
            if (IsEmpty($this->Attachment->TooltipValue)) {
                $this->Attachment->LinkAttrs["title"] = $this->language->phrase("ViewImageGallery");
            }
            $this->Attachment->LinkAttrs["data-rel"] = "trreimbursement_x_Attachment";
            $this->Attachment->LinkAttrs->appendClass("ew-lightbox");
        }

        // Notes
        $this->Notes->HrefValue = "";
        $this->Notes->TooltipValue = "";

        // CreatedByUserID
        $this->CreatedByUserID->HrefValue = "";
        $this->CreatedByUserID->TooltipValue = "";

        // CreatedDateTime
        $this->CreatedDateTime->HrefValue = "";
        $this->CreatedDateTime->TooltipValue = "";

        // LastUpdatedByUserID
        $this->LastUpdatedByUserID->HrefValue = "";
        $this->LastUpdatedByUserID->TooltipValue = "";

        // LastUpdatedDateTime
        $this->LastUpdatedDateTime->HrefValue = "";
        $this->LastUpdatedDateTime->TooltipValue = "";

        // ProjectID
        $this->_ProjectID->HrefValue = "";
        $this->_ProjectID->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->CurrentRecord;
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument(BaseAbstractExport $doc, array $records, int $startRec = 1, int $stopRec = 1, string $exportPageType = "")
    {
        if (count($records) == 0 || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->ID);
                    $doc->exportCaption($this->MTReimbursementTypeID);
                    $doc->exportCaption($this->MTUserRequesterID);
                    $doc->exportCaption($this->MTUserApproverID);
                    $doc->exportCaption($this->RequestDateTime);
                    $doc->exportCaption($this->ApprovedDateTime);
                    $doc->exportCaption($this->RejectedDateTime);
                    $doc->exportCaption($this->MTUserRejectorID);
                    $doc->exportCaption($this->_Title);
                    $doc->exportCaption($this->Description);
                    $doc->exportCaption($this->Amount);
                    $doc->exportCaption($this->Attachment);
                    $doc->exportCaption($this->Notes);
                    $doc->exportCaption($this->CreatedByUserID);
                    $doc->exportCaption($this->CreatedDateTime);
                    $doc->exportCaption($this->LastUpdatedByUserID);
                    $doc->exportCaption($this->LastUpdatedDateTime);
                    $doc->exportCaption($this->_ProjectID);
                } else {
                    $doc->exportCaption($this->ID);
                    $doc->exportCaption($this->MTReimbursementTypeID);
                    $doc->exportCaption($this->MTUserRequesterID);
                    $doc->exportCaption($this->MTUserApproverID);
                    $doc->exportCaption($this->RequestDateTime);
                    $doc->exportCaption($this->ApprovedDateTime);
                    $doc->exportCaption($this->RejectedDateTime);
                    $doc->exportCaption($this->MTUserRejectorID);
                    $doc->exportCaption($this->_Title);
                    $doc->exportCaption($this->Description);
                    $doc->exportCaption($this->Amount);
                    $doc->exportCaption($this->Attachment);
                    $doc->exportCaption($this->Notes);
                    $doc->exportCaption($this->CreatedByUserID);
                    $doc->exportCaption($this->CreatedDateTime);
                    $doc->exportCaption($this->LastUpdatedByUserID);
                    $doc->exportCaption($this->LastUpdatedDateTime);
                    $doc->exportCaption($this->_ProjectID);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        $recordIndex = 0;
        while ($recordIndex < count($records) && $recCnt < $stopRec) {
            $row = $records[$recordIndex];
            $recordIndex++;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->ID);
                        $doc->exportField($this->MTReimbursementTypeID);
                        $doc->exportField($this->MTUserRequesterID);
                        $doc->exportField($this->MTUserApproverID);
                        $doc->exportField($this->RequestDateTime);
                        $doc->exportField($this->ApprovedDateTime);
                        $doc->exportField($this->RejectedDateTime);
                        $doc->exportField($this->MTUserRejectorID);
                        $doc->exportField($this->_Title);
                        $doc->exportField($this->Description);
                        $doc->exportField($this->Amount);
                        $doc->exportField($this->Attachment);
                        $doc->exportField($this->Notes);
                        $doc->exportField($this->CreatedByUserID);
                        $doc->exportField($this->CreatedDateTime);
                        $doc->exportField($this->LastUpdatedByUserID);
                        $doc->exportField($this->LastUpdatedDateTime);
                        $doc->exportField($this->_ProjectID);
                    } else {
                        $doc->exportField($this->ID);
                        $doc->exportField($this->MTReimbursementTypeID);
                        $doc->exportField($this->MTUserRequesterID);
                        $doc->exportField($this->MTUserApproverID);
                        $doc->exportField($this->RequestDateTime);
                        $doc->exportField($this->ApprovedDateTime);
                        $doc->exportField($this->RejectedDateTime);
                        $doc->exportField($this->MTUserRejectorID);
                        $doc->exportField($this->_Title);
                        $doc->exportField($this->Description);
                        $doc->exportField($this->Amount);
                        $doc->exportField($this->Attachment);
                        $doc->exportField($this->Notes);
                        $doc->exportField($this->CreatedByUserID);
                        $doc->exportField($this->CreatedDateTime);
                        $doc->exportField($this->LastUpdatedByUserID);
                        $doc->exportField($this->LastUpdatedDateTime);
                        $doc->exportField($this->_ProjectID);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Render lookup field for view
    public function renderLookupForView(string $name, mixed $value): mixed
    {
        $this->RowType = RowType::VIEW;
        return $value;
    }

    // Render lookup field for edit
    public function renderLookupForEdit(string $name, mixed $value): mixed
    {
        $this->RowType = RowType::EDIT;
        return $value;
    }

    // Add master User ID filter
    public function addMasterUserIDFilter(string $filter, string $currentMasterTable): string
    {
        $filterWrk = $filter;
        return $filterWrk;
    }

    // Add detail User ID filter
    public function addDetailUserIDFilter(string $filter, string $currentMasterTable): string
    {
        $filterWrk = $filter;
        return $filterWrk;
    }

    // Get file data
    public function getFileData(string $fldparm, string $key, bool $resize, int $width = 0, int $height = 0, ?callable $callback = null): Response
    {
        global $httpContext;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'Attachment') {
            $fldName = "Attachment";
        } else {
            throw new InvalidArgumentException("Incorrect field '" . $fldparm . "'"); // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("ROUTE_COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->ID->CurrentValue = $ar[0];
        } else {
            throw new InvalidArgumentException("Incorrect key '" . $key . "'"); // Incorrect key
        }

        // Collect only non-empty fields
        $fields = array_filter([$fldName, $fileNameFld, $fileTypeFld]);

        // Apply QuotedName() to each field
        $selectFields = array_map(fn($f) => QuotedName($f, $this->Dbid), $fields);

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($filter);
        $select = $this->getQueryBuilder()->select(...$selectFields);
        $qb = $this->buildSelectSql($select, $this->getSqlFrom(), $filter);
        $response = new Response();
        if ($row = $qb->executeQuery()->fetchAssociative()) {
            $val = $row[$fldName];
            if (!IsEmpty($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if (is_resource($val) && get_resource_type($val) == "stream") {
                        $val = stream_get_contents($val);
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $callback);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !IsEmpty($row[$fileTypeFld])) {
                        $response->headers->set("Content-type", $row[$fileTypeFld]);
                    } else {
                        $response->headers->set("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !IsEmpty($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            $response->headers->set("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            $response->headers->set("Content-Disposition", "attachment" . ($httpContext["DownloadFileName"] ? "; filename=\"" . $httpContext["DownloadFileName"] . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val)
                        && ContainsString($val, "[Content_Types].xml")
                        && ContainsString($val, "_rels")
                        && ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Write binary data
                    $response->setContent($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    $key = SessionId() . ServerVar("ENCRYPTION_KEY");
                    foreach ($files as $file) {
                        if (!IsEmpty($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->uploadPath() . $file, $key)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    $response = new JsonResponse($data);
                }
            }
        }
        return $response;
    }

    // Update last insert ID
    public function updateLastInsertId(Entity\Trreimbursement $row, LifecycleEventArgs $args)
    {
        $this->ID->setDbValue($row['ID']);
    }

    // Save entity change set
    public function preUpdate(Entity\Trreimbursement $row, PreUpdateEventArgs $args): void
    {
        $oid = spl_object_id($row);
        $this->changeSets[$oid] = $args->getEntityChangeSet();
    }

    // Store identifiers before removal
    public function preRemove(Entity\Trreimbursement $row, LifecycleEventArgs $args): void
    {
        $this->snapshots[spl_object_id($row)] = $row->identifierValues();
    }

    // Table level events

    // Table Load event
    public function tableLoad(): void
    {
        // Enter your code here
    }

    // Records Selecting event
    public function recordsSelecting(string &$filter): void
    {
        // Enter your code here
    }

    // Records Selected event
    public function recordsSelected(array $rows): void
    {
        //Log("Records Selected");
    }

    // Records Search Validated event
    public function recordsSearchValidated(): void
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Records Searching event
    public function recordsSearching(string &$filter): void
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(BaseEntity $row): void
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting(?BaseEntity $oldRow, BaseEntity $newRow): ?bool
    {
        // Enter your code here
        // To cancel, set return value to false
        // To skip for grid insert/update, set return value to null
        $userId = CurrentUserID();
        if (empty($userId)) $userId = 0; 
        $userId = (int)$userId;
        $now = new DateTime();
        try {
            $newRow->setCreatedByUserID($userId);
            $newRow->setCreatedDateTime($now);
            $newRow->setMTUserRequesterID($userId);
            $newRow->setRequestDateTime($now);
            $newRow->setLastUpdatedByUserID($userId);
            $newRow->setLastUpdatedDateTime($now);
        } catch (Throwable $e) {
            Log("Error di Row_Inserting: " . $e->getMessage());
            return false;
        }
        return true;
    }

    // Row Inserted event
    public function rowInserted(?BaseEntity $oldRow, BaseEntity $newRow): void
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating(BaseEntity $oldRow, BaseEntity $newRow): ?bool
    {
        // Enter your code here
        // To cancel, set return value to false
        // To skip for grid insert/update, set return value to null
        $userId = CurrentUserID();
        if (empty($userId)) $userId = 0; 
        $userId = (int)$userId;
        $now = new DateTime();
        try {        
            $newRow->setLastUpdatedByUserID($userId);
            $newRow->setLastUpdatedDateTime($now);
        } catch (Throwable $e) {
            Log("Error di Row_Updating: " . $e->getMessage());
            return false;
        }
        return true;
    }

    // Row Updated event
    public function rowUpdated(BaseEntity $oldRow, BaseEntity $newRow): void
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict(BaseEntity $oldRow, BaseEntity $newRow): bool
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting(): bool
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted(array $rows): void
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating(array $rows): bool
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated(array $oldRows, array $newRows): void
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(BaseEntity $row): ?bool
    {
        // Enter your code here
        // To cancel, set return value to false
        // To skip for grid insert/update, set return value to null
        return true;
    }

    // Row Deleted event
    public function rowDeleted(BaseEntity $row): void
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending(Email $email, array $args): bool
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting(DbField $field, string &$filter): void
    {
        //var_dump($field->Name, $field->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering(): void
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered(): void
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(string &$filter): void
    {
        // Enter your code here
    }
}
